# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class AppLibProfile(Base):
    """This object specifies the properties of the particular application traffic profile.
    The AppLibProfile class encapsulates a list of appLibProfile resources that is be managed by the user.
    A list of resources can be retrieved from the server using the AppLibProfile.find() method.
    The list can be managed by the user by using the AppLibProfile.add() and AppLibProfile.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'appLibProfile'

    def __init__(self, parent):
        super(AppLibProfile, self).__init__(parent)

    @property
    def AppLibFlow(self):
        """An instance of the AppLibFlow class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.traffic.trafficitem.applibprofile.applibflow.applibflow.AppLibFlow)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.traffic.trafficitem.applibprofile.applibflow.applibflow import AppLibFlow
        return AppLibFlow(self)

    @property
    def AvailableFlows(self):
        """(Read only) All available application library flows.

        Returns:
            list(str[])
        """
        return self._get_attribute('availableFlows')

    @property
    def ConfiguredFlows(self):
        """Configured application library flows within profile.

        Returns:
            list(str[])
        """
        return self._get_attribute('configuredFlows')
    @ConfiguredFlows.setter
    def ConfiguredFlows(self, value):
        self._set_attribute('configuredFlows', value)

    @property
    def EnablePerIPStats(self):
        """Enable Per IP Stats. When true then Per IP statistic drilldown is available.

        Returns:
            bool
        """
        return self._get_attribute('enablePerIPStats')
    @EnablePerIPStats.setter
    def EnablePerIPStats(self, value):
        self._set_attribute('enablePerIPStats', value)

    @property
    def ObjectiveDistribution(self):
        """Objective distribution value.

        Returns:
            str(applyFullObjectiveToEachPort|splitObjectiveEvenlyAmongPorts)
        """
        return self._get_attribute('objectiveDistribution')
    @ObjectiveDistribution.setter
    def ObjectiveDistribution(self, value):
        self._set_attribute('objectiveDistribution', value)

    @property
    def ObjectiveType(self):
        """The objective type of the test.A Test Objective is the way the user sets the actual rate of the Application Library Traffic transmission.

        Returns:
            str(simulatedUsers|throughputGbps|throughputKbps|throughputMbps)
        """
        return self._get_attribute('objectiveType')
    @ObjectiveType.setter
    def ObjectiveType(self, value):
        self._set_attribute('objectiveType', value)

    @property
    def ObjectiveValue(self):
        """The absolute value of either simulated users or throughput in its measure unit.

        Returns:
            number
        """
        return self._get_attribute('objectiveValue')
    @ObjectiveValue.setter
    def ObjectiveValue(self, value):
        self._set_attribute('objectiveValue', value)

    @property
    def TrafficState(self):
        """(Read only) A read-only field which indicates the current state of the traffic item.

        Returns:
            str(Configured|Interim|Running|Unconfigured)
        """
        return self._get_attribute('trafficState')

    def update(self, ConfiguredFlows=None, EnablePerIPStats=None, ObjectiveDistribution=None, ObjectiveType=None, ObjectiveValue=None):
        """Updates a child instance of appLibProfile on the server.

        Args:
            ConfiguredFlows (list(str[])): Configured application library flows within profile.
            EnablePerIPStats (bool): Enable Per IP Stats. When true then Per IP statistic drilldown is available.
            ObjectiveDistribution (str(applyFullObjectiveToEachPort|splitObjectiveEvenlyAmongPorts)): Objective distribution value.
            ObjectiveType (str(simulatedUsers|throughputGbps|throughputKbps|throughputMbps)): The objective type of the test.A Test Objective is the way the user sets the actual rate of the Application Library Traffic transmission.
            ObjectiveValue (number): The absolute value of either simulated users or throughput in its measure unit.

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, ConfiguredFlows=None, EnablePerIPStats=None, ObjectiveDistribution=None, ObjectiveType=None, ObjectiveValue=None):
        """Adds a new appLibProfile node on the server and retrieves it in this instance.

        Args:
            ConfiguredFlows (list(str[])): Configured application library flows within profile.
            EnablePerIPStats (bool): Enable Per IP Stats. When true then Per IP statistic drilldown is available.
            ObjectiveDistribution (str(applyFullObjectiveToEachPort|splitObjectiveEvenlyAmongPorts)): Objective distribution value.
            ObjectiveType (str(simulatedUsers|throughputGbps|throughputKbps|throughputMbps)): The objective type of the test.A Test Objective is the way the user sets the actual rate of the Application Library Traffic transmission.
            ObjectiveValue (number): The absolute value of either simulated users or throughput in its measure unit.

        Returns:
            self: This instance with all currently retrieved appLibProfile data using find and the newly added appLibProfile data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the appLibProfile data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, AvailableFlows=None, ConfiguredFlows=None, EnablePerIPStats=None, ObjectiveDistribution=None, ObjectiveType=None, ObjectiveValue=None, TrafficState=None):
        """Finds and retrieves appLibProfile data from the server.

        All named parameters support regex and can be used to selectively retrieve appLibProfile data from the server.
        By default the find method takes no parameters and will retrieve all appLibProfile data from the server.

        Args:
            AvailableFlows (list(str[])): (Read only) All available application library flows.
            ConfiguredFlows (list(str[])): Configured application library flows within profile.
            EnablePerIPStats (bool): Enable Per IP Stats. When true then Per IP statistic drilldown is available.
            ObjectiveDistribution (str(applyFullObjectiveToEachPort|splitObjectiveEvenlyAmongPorts)): Objective distribution value.
            ObjectiveType (str(simulatedUsers|throughputGbps|throughputKbps|throughputMbps)): The objective type of the test.A Test Objective is the way the user sets the actual rate of the Application Library Traffic transmission.
            ObjectiveValue (number): The absolute value of either simulated users or throughput in its measure unit.
            TrafficState (str(Configured|Interim|Running|Unconfigured)): (Read only) A read-only field which indicates the current state of the traffic item.

        Returns:
            self: This instance with matching appLibProfile data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of appLibProfile data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the appLibProfile data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)

    def AddAppLibraryFlow(self, *args, **kwargs):
        """Executes the addAppLibraryFlow operation on the server.

        This exec adds a flow to an application traffic profile.

        addAppLibraryFlow(Arg2:list)
            Args:
                args[0] is Arg2 (list(str[])): This object specifies the flow(s) to be added.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('addAppLibraryFlow', payload=payload, response_object=None)

    def DistributeFlowsEvenly(self):
        """Executes the distributeFlowsEvenly operation on the server.

        This exec distributes the percentage for each flow evenly.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        return self._execute('distributeFlowsEvenly', payload=payload, response_object=None)

    def RemoveAppLibraryFlow(self, *args, **kwargs):
        """Executes the removeAppLibraryFlow operation on the server.

        This exec removes a flow from an application traffic profile.

        removeAppLibraryFlow(Arg2:list)
            Args:
                args[0] is Arg2 (list(str[])): This object specifies the flow(s) to be removed.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('removeAppLibraryFlow', payload=payload, response_object=None)

    def Start(self):
        """Executes the start operation on the server.

        This exec starts running the configured application traffic.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        return self._execute('start', payload=payload, response_object=None)

    def Stop(self):
        """Executes the stop operation on the server.

        This exec stops the configured application traffic from running.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        return self._execute('stop', payload=payload, response_object=None)
