# coding: utf-8

"""
    FAX.PLUS REST API

    OpenAPI spec version: 1.2.0
    Contact: info@fax.plus
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from faxplus.api_client import ApiClient
from faxplus.models import *
from multiprocessing.pool import ApplyResult
from urllib3._collections import HTTPHeaderDict


class OutboxApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_outbox_fax(self, outbox_fax_id, **kwargs):  # noqa: E501
        """Delete a fax from outbox  # noqa: E501

        Delete a fax that is being sent and is still in your outbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_outbox_fax(outbox_fax_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str outbox_fax_id: ID of the outgoing fax to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None | ApplyResult[None]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_outbox_fax_with_http_info(outbox_fax_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_outbox_fax_with_http_info(outbox_fax_id, **kwargs)  # noqa: E501
            return data

    def delete_outbox_fax_with_http_info(self, outbox_fax_id, **kwargs):  # noqa: E501
        """Delete a fax from outbox  # noqa: E501

        The difference between this method and `delete_outbox_fax` is that this method may return not only the data,
        but also HTTP status and headers.

        Delete a fax that is being sent and is still in your outbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_outbox_fax_with_http_info(outbox_fax_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str outbox_fax_id: ID of the outgoing fax to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None | tuple[None, int, HTTPHeaderDict] | ApplyResult[None] | ApplyResult[tuple[None, int, HTTPHeaderDict]]
        """

        all_params = ['outbox_fax_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbox_fax" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'outbox_fax_id' is set
        if ('outbox_fax_id' not in params or
                params['outbox_fax_id'] is None):
            raise ValueError("Missing the required parameter `outbox_fax_id` when calling `delete_outbox_fax`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'outbox_fax_id' in params:
            path_params['outbox_fax_id'] = params['outbox_fax_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/outbox/{outbox_fax_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_outbox_fax(self, outbox_fax_id, **kwargs):  # noqa: E501
        """Get an outbox record  # noqa: E501

        Get an outbox fax record information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_outbox_fax(outbox_fax_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str outbox_fax_id: ID of the outgoing fax to get (required)
        :return: Outbox
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Outbox | ApplyResult[Outbox]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_outbox_fax_with_http_info(outbox_fax_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_outbox_fax_with_http_info(outbox_fax_id, **kwargs)  # noqa: E501
            return data

    def get_outbox_fax_with_http_info(self, outbox_fax_id, **kwargs):  # noqa: E501
        """Get an outbox record  # noqa: E501

        The difference between this method and `get_outbox_fax` is that this method may return not only the data,
        but also HTTP status and headers.

        Get an outbox fax record information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_outbox_fax_with_http_info(outbox_fax_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str outbox_fax_id: ID of the outgoing fax to get (required)
        :return: Outbox
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Outbox | tuple[Outbox, int, HTTPHeaderDict] | ApplyResult[Outbox] | ApplyResult[tuple[Outbox, int, HTTPHeaderDict]]
        """

        all_params = ['outbox_fax_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbox_fax" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'outbox_fax_id' is set
        if ('outbox_fax_id' not in params or
                params['outbox_fax_id'] is None):
            raise ValueError("Missing the required parameter `outbox_fax_id` when calling `get_outbox_fax`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'outbox_fax_id' in params:
            path_params['outbox_fax_id'] = params['outbox_fax_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/outbox/{outbox_fax_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Outbox',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_outbox_faxes(self, **kwargs):  # noqa: E501
        """Get list of faxes in the outbox  # noqa: E501

        Get list of the faxes in the outbox which were not yet sent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_outbox_faxes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: OutboxList
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OutboxList | ApplyResult[OutboxList]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_outbox_faxes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_outbox_faxes_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_outbox_faxes_with_http_info(self, **kwargs):  # noqa: E501
        """Get list of faxes in the outbox  # noqa: E501

        The difference between this method and `list_outbox_faxes` is that this method may return not only the data,
        but also HTTP status and headers.

        Get list of the faxes in the outbox which were not yet sent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_outbox_faxes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: OutboxList
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OutboxList | tuple[OutboxList, int, HTTPHeaderDict] | ApplyResult[OutboxList] | ApplyResult[tuple[OutboxList, int, HTTPHeaderDict]]
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_outbox_faxes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/outbox', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OutboxList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_fax(self, body, **kwargs):  # noqa: E501
        """Send a fax  # noqa: E501

        With this API call you will be able to send a fax (one or more files) to one or more destinations. If you are a corporate member and you don't have a fax number set your **from** parameter to **NO_NUMBER**  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_fax(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PayloadOutbox body: Request to send new outbound fax
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None | ApplyResult[None]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_fax_with_http_info(body=body, **kwargs)  # noqa: E501
        else:
            (data) = self.send_fax_with_http_info(body=body, **kwargs)  # noqa: E501
            return data

    def send_fax_with_http_info(self, body, **kwargs):  # noqa: E501
        """Send a fax  # noqa: E501

        The difference between this method and `send_fax` is that this method may return not only the data,
        but also HTTP status and headers.

        With this API call you will be able to send a fax (one or more files) to one or more destinations. If you are a corporate member and you don't have a fax number set your **from** parameter to **NO_NUMBER**  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_fax_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PayloadOutbox body: Request to send new outbound fax
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None | tuple[None, int, HTTPHeaderDict] | ApplyResult[None] | ApplyResult[tuple[None, int, HTTPHeaderDict]]
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_fax" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/outbox', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_outbox_fax(self, outbox_fax_id, body, **kwargs):  # noqa: E501
        """Modify a fax record in outbox  # noqa: E501

        Modify outbox record's comment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_outbox_fax(outbox_fax_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str outbox_fax_id: ID of the outgoing fax to update (required)
        :param PayloadOutboxModification body: Request object for making changes in an outbox object
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None | ApplyResult[None]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_outbox_fax_with_http_info(outbox_fax_id, body=body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_outbox_fax_with_http_info(outbox_fax_id, body=body, **kwargs)  # noqa: E501
            return data

    def update_outbox_fax_with_http_info(self, outbox_fax_id, body, **kwargs):  # noqa: E501
        """Modify a fax record in outbox  # noqa: E501

        The difference between this method and `update_outbox_fax` is that this method may return not only the data,
        but also HTTP status and headers.

        Modify outbox record's comment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_outbox_fax_with_http_info(outbox_fax_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str outbox_fax_id: ID of the outgoing fax to update (required)
        :param PayloadOutboxModification body: Request object for making changes in an outbox object
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None | tuple[None, int, HTTPHeaderDict] | ApplyResult[None] | ApplyResult[tuple[None, int, HTTPHeaderDict]]
        """

        all_params = ['outbox_fax_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_outbox_fax" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'outbox_fax_id' is set
        if ('outbox_fax_id' not in params or
                params['outbox_fax_id'] is None):
            raise ValueError("Missing the required parameter `outbox_fax_id` when calling `update_outbox_fax`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'outbox_fax_id' in params:
            path_params['outbox_fax_id'] = params['outbox_fax_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/outbox/{outbox_fax_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
