# coding: utf-8

"""
    FAX.PLUS REST API

    OpenAPI spec version: 1.2.0
    Contact: info@fax.plus
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from faxplus.api_client import ApiClient
from faxplus.models import *
from multiprocessing.pool import ApplyResult
from urllib3._collections import HTTPHeaderDict


class NumbersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_number(self, number, **kwargs):  # noqa: E501
        """Get number information  # noqa: E501

        Get info of a single number  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_number(number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str number: Phone number to get information about (required)
        :return: Number
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Number | ApplyResult[Number]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_number_with_http_info(number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_number_with_http_info(number, **kwargs)  # noqa: E501
            return data

    def get_number_with_http_info(self, number, **kwargs):  # noqa: E501
        """Get number information  # noqa: E501

        The difference between this method and `get_number` is that this method may return not only the data,
        but also HTTP status and headers.

        Get info of a single number  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_number_with_http_info(number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str number: Phone number to get information about (required)
        :return: Number
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Number | tuple[Number, int, HTTPHeaderDict] | ApplyResult[Number] | ApplyResult[tuple[Number, int, HTTPHeaderDict]]
        """

        all_params = ['number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `get_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/numbers/{number}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Number',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_numbers(self, **kwargs):  # noqa: E501
        """Get your numbers  # noqa: E501

        List all your purchased numbers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_numbers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NumberList
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: NumberList | ApplyResult[NumberList]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_numbers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_numbers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_numbers_with_http_info(self, **kwargs):  # noqa: E501
        """Get your numbers  # noqa: E501

        The difference between this method and `list_numbers` is that this method may return not only the data,
        but also HTTP status and headers.

        List all your purchased numbers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_numbers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NumberList
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: NumberList | tuple[NumberList, int, HTTPHeaderDict] | ApplyResult[NumberList] | ApplyResult[tuple[NumberList, int, HTTPHeaderDict]]
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_numbers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/numbers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NumberList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revoke_number(self, number, user_id, **kwargs):  # noqa: E501
        """Revoke number  # noqa: E501

        Revoke a specific number from a member<br />**In case you want to revoke your own number please use *`self`* as an alias for your user_id.**  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revoke_number(number, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str number: Phone number to remove members from (required)
        :param str user_id: ID of the user to revoke the number from. Number can not be removed from the admin (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None | ApplyResult[None]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.revoke_number_with_http_info(number, user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.revoke_number_with_http_info(number, user_id, **kwargs)  # noqa: E501
            return data

    def revoke_number_with_http_info(self, number, user_id, **kwargs):  # noqa: E501
        """Revoke number  # noqa: E501

        The difference between this method and `revoke_number` is that this method may return not only the data,
        but also HTTP status and headers.

        Revoke a specific number from a member<br />**In case you want to revoke your own number please use *`self`* as an alias for your user_id.**  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revoke_number_with_http_info(number, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str number: Phone number to remove members from (required)
        :param str user_id: ID of the user to revoke the number from. Number can not be removed from the admin (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None | tuple[None, int, HTTPHeaderDict] | ApplyResult[None] | ApplyResult[tuple[None, int, HTTPHeaderDict]]
        """

        all_params = ['number', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revoke_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `revoke_number`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `revoke_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/{user_id}/numbers/{number}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_number(self, number, body, **kwargs):  # noqa: E501
        """Assign number  # noqa: E501

        With this API call you will be able to assign a specific number to a specific account (one of your members).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_number(number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str number: Phone number to update (required)
        :param PayloadNumberModification body: Request object for making changes in number object
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None | ApplyResult[None]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_number_with_http_info(number, body=body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_number_with_http_info(number, body=body, **kwargs)  # noqa: E501
            return data

    def update_number_with_http_info(self, number, body, **kwargs):  # noqa: E501
        """Assign number  # noqa: E501

        The difference between this method and `update_number` is that this method may return not only the data,
        but also HTTP status and headers.

        With this API call you will be able to assign a specific number to a specific account (one of your members).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_number_with_http_info(number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str number: Phone number to update (required)
        :param PayloadNumberModification body: Request object for making changes in number object
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None | tuple[None, int, HTTPHeaderDict] | ApplyResult[None] | ApplyResult[tuple[None, int, HTTPHeaderDict]]
        """

        all_params = ['number', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `update_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/numbers/{number}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
