# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.20.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class MunicipalityFinancial(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'fiscal_year': 'float',
        'current_assets': 'float',
        'non_current_assets': 'float',
        'deferred_outflows': 'float',
        'total_assets': 'float',
        'total_assets_plus_deferred_outflows': 'float',
        'current_liabilities': 'float',
        'current_portion_of_long_term_debt': 'float',
        'net_pension_liability': 'float',
        'net_opeb_liability': 'float',
        'all_other_long_term_debt': 'float',
        'total_liabilities': 'float',
        'deferred_inflows': 'float',
        'total_liabilities_plus_deferred_inflows': 'float',
        'total_net_position': 'float',
        'total_unrestricted_net_position': 'float',
        'total_expenses': 'float',
        'charges_for_services': 'float',
        'operating_grants_and_contributions': 'float',
        'capital_grants_and_contributions': 'float',
        'general_revenues': 'float',
        'other_revenues': 'float',
        'total_revenues': 'float',
        'change_in_net_assets': 'float',
        'non_spendable_general_fund_balance': 'float',
        'restricted_general_fund_balance': 'float',
        'committed_general_fund_balance': 'float',
        'unassigned_general_fund_balance': 'float',
        'assigned_general_fund_balance': 'float',
        'total_general_fund_balance': 'float',
        'non_spendable_governmental_fund_balance': 'float',
        'restricted_governmental_fund_balance': 'float',
        'committed_governmental_fund_balance': 'float',
        'unassigned_governmental_fund_balance': 'float',
        'assigned_governmental_fund_balance': 'float',
        'total_governmental_fund_balance': 'float',
        'general_fund_revenues': 'float',
        'general_fund_expenditures': 'float',
        'general_fund_revenues_over_under_expenditure': 'float',
        'governmental_fund_revenues': 'float',
        'governmental_fund_expenditures': 'float',
        'governmental_fund_revenues_over_under_expenditure': 'float'
    }

    attribute_map = {
        'fiscal_year': 'fiscal_year',
        'current_assets': 'current_assets',
        'non_current_assets': 'non_current_assets',
        'deferred_outflows': 'deferred_outflows',
        'total_assets': 'total_assets',
        'total_assets_plus_deferred_outflows': 'total_assets_plus_deferred_outflows',
        'current_liabilities': 'current_liabilities',
        'current_portion_of_long_term_debt': 'current_portion_of_long_term_debt',
        'net_pension_liability': 'net_pension_liability',
        'net_opeb_liability': 'net_opeb_liability',
        'all_other_long_term_debt': 'all_other_long_term_debt',
        'total_liabilities': 'total_liabilities',
        'deferred_inflows': 'deferred_inflows',
        'total_liabilities_plus_deferred_inflows': 'total_liabilities_plus_deferred_inflows',
        'total_net_position': 'total_net_position',
        'total_unrestricted_net_position': 'total_unrestricted_net_position',
        'total_expenses': 'total_expenses',
        'charges_for_services': 'charges_for_services',
        'operating_grants_and_contributions': 'operating_grants_and_contributions',
        'capital_grants_and_contributions': 'capital_grants_and_contributions',
        'general_revenues': 'general_revenues',
        'other_revenues': 'other_revenues',
        'total_revenues': 'total_revenues',
        'change_in_net_assets': 'change_in_net_assets',
        'non_spendable_general_fund_balance': 'non_spendable_general_fund_balance',
        'restricted_general_fund_balance': 'restricted_general_fund_balance',
        'committed_general_fund_balance': 'committed_general_fund_balance',
        'unassigned_general_fund_balance': 'unassigned_general_fund_balance',
        'assigned_general_fund_balance': 'assigned_general_fund_balance',
        'total_general_fund_balance': 'total_general_fund_balance',
        'non_spendable_governmental_fund_balance': 'non_spendable_governmental_fund_balance',
        'restricted_governmental_fund_balance': 'restricted_governmental_fund_balance',
        'committed_governmental_fund_balance': 'committed_governmental_fund_balance',
        'unassigned_governmental_fund_balance': 'unassigned_governmental_fund_balance',
        'assigned_governmental_fund_balance': 'assigned_governmental_fund_balance',
        'total_governmental_fund_balance': 'total_governmental_fund_balance',
        'general_fund_revenues': 'general_fund_revenues',
        'general_fund_expenditures': 'general_fund_expenditures',
        'general_fund_revenues_over_under_expenditure': 'general_fund_revenues_over_under_expenditure',
        'governmental_fund_revenues': 'governmental_fund_revenues',
        'governmental_fund_expenditures': 'governmental_fund_expenditures',
        'governmental_fund_revenues_over_under_expenditure': 'governmental_fund_revenues_over_under_expenditure'
    }

    def __init__(self, fiscal_year=None, current_assets=None, non_current_assets=None, deferred_outflows=None, total_assets=None, total_assets_plus_deferred_outflows=None, current_liabilities=None, current_portion_of_long_term_debt=None, net_pension_liability=None, net_opeb_liability=None, all_other_long_term_debt=None, total_liabilities=None, deferred_inflows=None, total_liabilities_plus_deferred_inflows=None, total_net_position=None, total_unrestricted_net_position=None, total_expenses=None, charges_for_services=None, operating_grants_and_contributions=None, capital_grants_and_contributions=None, general_revenues=None, other_revenues=None, total_revenues=None, change_in_net_assets=None, non_spendable_general_fund_balance=None, restricted_general_fund_balance=None, committed_general_fund_balance=None, unassigned_general_fund_balance=None, assigned_general_fund_balance=None, total_general_fund_balance=None, non_spendable_governmental_fund_balance=None, restricted_governmental_fund_balance=None, committed_governmental_fund_balance=None, unassigned_governmental_fund_balance=None, assigned_governmental_fund_balance=None, total_governmental_fund_balance=None, general_fund_revenues=None, general_fund_expenditures=None, general_fund_revenues_over_under_expenditure=None, governmental_fund_revenues=None, governmental_fund_expenditures=None, governmental_fund_revenues_over_under_expenditure=None):  # noqa: E501
        """MunicipalityFinancial - a model defined in Swagger"""  # noqa: E501

        self._fiscal_year = None
        self._current_assets = None
        self._non_current_assets = None
        self._deferred_outflows = None
        self._total_assets = None
        self._total_assets_plus_deferred_outflows = None
        self._current_liabilities = None
        self._current_portion_of_long_term_debt = None
        self._net_pension_liability = None
        self._net_opeb_liability = None
        self._all_other_long_term_debt = None
        self._total_liabilities = None
        self._deferred_inflows = None
        self._total_liabilities_plus_deferred_inflows = None
        self._total_net_position = None
        self._total_unrestricted_net_position = None
        self._total_expenses = None
        self._charges_for_services = None
        self._operating_grants_and_contributions = None
        self._capital_grants_and_contributions = None
        self._general_revenues = None
        self._other_revenues = None
        self._total_revenues = None
        self._change_in_net_assets = None
        self._non_spendable_general_fund_balance = None
        self._restricted_general_fund_balance = None
        self._committed_general_fund_balance = None
        self._unassigned_general_fund_balance = None
        self._assigned_general_fund_balance = None
        self._total_general_fund_balance = None
        self._non_spendable_governmental_fund_balance = None
        self._restricted_governmental_fund_balance = None
        self._committed_governmental_fund_balance = None
        self._unassigned_governmental_fund_balance = None
        self._assigned_governmental_fund_balance = None
        self._total_governmental_fund_balance = None
        self._general_fund_revenues = None
        self._general_fund_expenditures = None
        self._general_fund_revenues_over_under_expenditure = None
        self._governmental_fund_revenues = None
        self._governmental_fund_expenditures = None
        self._governmental_fund_revenues_over_under_expenditure = None
        self.discriminator = None

        if fiscal_year is not None:
            self.fiscal_year = fiscal_year
        if current_assets is not None:
            self.current_assets = current_assets
        if non_current_assets is not None:
            self.non_current_assets = non_current_assets
        if deferred_outflows is not None:
            self.deferred_outflows = deferred_outflows
        if total_assets is not None:
            self.total_assets = total_assets
        if total_assets_plus_deferred_outflows is not None:
            self.total_assets_plus_deferred_outflows = total_assets_plus_deferred_outflows
        if current_liabilities is not None:
            self.current_liabilities = current_liabilities
        if current_portion_of_long_term_debt is not None:
            self.current_portion_of_long_term_debt = current_portion_of_long_term_debt
        if net_pension_liability is not None:
            self.net_pension_liability = net_pension_liability
        if net_opeb_liability is not None:
            self.net_opeb_liability = net_opeb_liability
        if all_other_long_term_debt is not None:
            self.all_other_long_term_debt = all_other_long_term_debt
        if total_liabilities is not None:
            self.total_liabilities = total_liabilities
        if deferred_inflows is not None:
            self.deferred_inflows = deferred_inflows
        if total_liabilities_plus_deferred_inflows is not None:
            self.total_liabilities_plus_deferred_inflows = total_liabilities_plus_deferred_inflows
        if total_net_position is not None:
            self.total_net_position = total_net_position
        if total_unrestricted_net_position is not None:
            self.total_unrestricted_net_position = total_unrestricted_net_position
        if total_expenses is not None:
            self.total_expenses = total_expenses
        if charges_for_services is not None:
            self.charges_for_services = charges_for_services
        if operating_grants_and_contributions is not None:
            self.operating_grants_and_contributions = operating_grants_and_contributions
        if capital_grants_and_contributions is not None:
            self.capital_grants_and_contributions = capital_grants_and_contributions
        if general_revenues is not None:
            self.general_revenues = general_revenues
        if other_revenues is not None:
            self.other_revenues = other_revenues
        if total_revenues is not None:
            self.total_revenues = total_revenues
        if change_in_net_assets is not None:
            self.change_in_net_assets = change_in_net_assets
        if non_spendable_general_fund_balance is not None:
            self.non_spendable_general_fund_balance = non_spendable_general_fund_balance
        if restricted_general_fund_balance is not None:
            self.restricted_general_fund_balance = restricted_general_fund_balance
        if committed_general_fund_balance is not None:
            self.committed_general_fund_balance = committed_general_fund_balance
        if unassigned_general_fund_balance is not None:
            self.unassigned_general_fund_balance = unassigned_general_fund_balance
        if assigned_general_fund_balance is not None:
            self.assigned_general_fund_balance = assigned_general_fund_balance
        if total_general_fund_balance is not None:
            self.total_general_fund_balance = total_general_fund_balance
        if non_spendable_governmental_fund_balance is not None:
            self.non_spendable_governmental_fund_balance = non_spendable_governmental_fund_balance
        if restricted_governmental_fund_balance is not None:
            self.restricted_governmental_fund_balance = restricted_governmental_fund_balance
        if committed_governmental_fund_balance is not None:
            self.committed_governmental_fund_balance = committed_governmental_fund_balance
        if unassigned_governmental_fund_balance is not None:
            self.unassigned_governmental_fund_balance = unassigned_governmental_fund_balance
        if assigned_governmental_fund_balance is not None:
            self.assigned_governmental_fund_balance = assigned_governmental_fund_balance
        if total_governmental_fund_balance is not None:
            self.total_governmental_fund_balance = total_governmental_fund_balance
        if general_fund_revenues is not None:
            self.general_fund_revenues = general_fund_revenues
        if general_fund_expenditures is not None:
            self.general_fund_expenditures = general_fund_expenditures
        if general_fund_revenues_over_under_expenditure is not None:
            self.general_fund_revenues_over_under_expenditure = general_fund_revenues_over_under_expenditure
        if governmental_fund_revenues is not None:
            self.governmental_fund_revenues = governmental_fund_revenues
        if governmental_fund_expenditures is not None:
            self.governmental_fund_expenditures = governmental_fund_expenditures
        if governmental_fund_revenues_over_under_expenditure is not None:
            self.governmental_fund_revenues_over_under_expenditure = governmental_fund_revenues_over_under_expenditure

    @property
    def fiscal_year(self):
        """Gets the fiscal_year of this MunicipalityFinancial.  # noqa: E501

        The fiscal year from which the financial data came from  # noqa: E501

        :return: The fiscal_year of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._fiscal_year
        
    @property
    def fiscal_year_dict(self):
        """Gets the fiscal_year of this MunicipalityFinancial.  # noqa: E501

        The fiscal year from which the financial data came from as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The fiscal_year of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.fiscal_year
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'fiscal_year': value }

        
        return result
        

    @fiscal_year.setter
    def fiscal_year(self, fiscal_year):
        """Sets the fiscal_year of this MunicipalityFinancial.

        The fiscal year from which the financial data came from  # noqa: E501

        :param fiscal_year: The fiscal_year of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._fiscal_year = fiscal_year

    @property
    def current_assets(self):
        """Gets the current_assets of this MunicipalityFinancial.  # noqa: E501

        Government-wide holdings that can be liquidated on short notice  # noqa: E501

        :return: The current_assets of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._current_assets
        
    @property
    def current_assets_dict(self):
        """Gets the current_assets of this MunicipalityFinancial.  # noqa: E501

        Government-wide holdings that can be liquidated on short notice as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The current_assets of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.current_assets
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'current_assets': value }

        
        return result
        

    @current_assets.setter
    def current_assets(self, current_assets):
        """Sets the current_assets of this MunicipalityFinancial.

        Government-wide holdings that can be liquidated on short notice  # noqa: E501

        :param current_assets: The current_assets of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._current_assets = current_assets

    @property
    def non_current_assets(self):
        """Gets the non_current_assets of this MunicipalityFinancial.  # noqa: E501

        Government-wide holdings not intended for near-term liquidation  # noqa: E501

        :return: The non_current_assets of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._non_current_assets
        
    @property
    def non_current_assets_dict(self):
        """Gets the non_current_assets of this MunicipalityFinancial.  # noqa: E501

        Government-wide holdings not intended for near-term liquidation as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The non_current_assets of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.non_current_assets
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'non_current_assets': value }

        
        return result
        

    @non_current_assets.setter
    def non_current_assets(self, non_current_assets):
        """Sets the non_current_assets of this MunicipalityFinancial.

        Government-wide holdings not intended for near-term liquidation  # noqa: E501

        :param non_current_assets: The non_current_assets of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._non_current_assets = non_current_assets

    @property
    def deferred_outflows(self):
        """Gets the deferred_outflows of this MunicipalityFinancial.  # noqa: E501

        Government-wide consumptions of net position applicable to a future year  # noqa: E501

        :return: The deferred_outflows of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._deferred_outflows
        
    @property
    def deferred_outflows_dict(self):
        """Gets the deferred_outflows of this MunicipalityFinancial.  # noqa: E501

        Government-wide consumptions of net position applicable to a future year as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The deferred_outflows of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.deferred_outflows
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'deferred_outflows': value }

        
        return result
        

    @deferred_outflows.setter
    def deferred_outflows(self, deferred_outflows):
        """Sets the deferred_outflows of this MunicipalityFinancial.

        Government-wide consumptions of net position applicable to a future year  # noqa: E501

        :param deferred_outflows: The deferred_outflows of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._deferred_outflows = deferred_outflows

    @property
    def total_assets(self):
        """Gets the total_assets of this MunicipalityFinancial.  # noqa: E501

        Government-wide holdings  # noqa: E501

        :return: The total_assets of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._total_assets
        
    @property
    def total_assets_dict(self):
        """Gets the total_assets of this MunicipalityFinancial.  # noqa: E501

        Government-wide holdings as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_assets of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_assets
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_assets': value }

        
        return result
        

    @total_assets.setter
    def total_assets(self, total_assets):
        """Sets the total_assets of this MunicipalityFinancial.

        Government-wide holdings  # noqa: E501

        :param total_assets: The total_assets of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._total_assets = total_assets

    @property
    def total_assets_plus_deferred_outflows(self):
        """Gets the total_assets_plus_deferred_outflows of this MunicipalityFinancial.  # noqa: E501

        Sum of government-wide total assets and deferred outflows of resources  # noqa: E501

        :return: The total_assets_plus_deferred_outflows of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._total_assets_plus_deferred_outflows
        
    @property
    def total_assets_plus_deferred_outflows_dict(self):
        """Gets the total_assets_plus_deferred_outflows of this MunicipalityFinancial.  # noqa: E501

        Sum of government-wide total assets and deferred outflows of resources as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_assets_plus_deferred_outflows of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_assets_plus_deferred_outflows
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_assets_plus_deferred_outflows': value }

        
        return result
        

    @total_assets_plus_deferred_outflows.setter
    def total_assets_plus_deferred_outflows(self, total_assets_plus_deferred_outflows):
        """Sets the total_assets_plus_deferred_outflows of this MunicipalityFinancial.

        Sum of government-wide total assets and deferred outflows of resources  # noqa: E501

        :param total_assets_plus_deferred_outflows: The total_assets_plus_deferred_outflows of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._total_assets_plus_deferred_outflows = total_assets_plus_deferred_outflows

    @property
    def current_liabilities(self):
        """Gets the current_liabilities of this MunicipalityFinancial.  # noqa: E501

        Government-wide liabilities that typically become due within one year  # noqa: E501

        :return: The current_liabilities of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._current_liabilities
        
    @property
    def current_liabilities_dict(self):
        """Gets the current_liabilities of this MunicipalityFinancial.  # noqa: E501

        Government-wide liabilities that typically become due within one year as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The current_liabilities of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.current_liabilities
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'current_liabilities': value }

        
        return result
        

    @current_liabilities.setter
    def current_liabilities(self, current_liabilities):
        """Sets the current_liabilities of this MunicipalityFinancial.

        Government-wide liabilities that typically become due within one year  # noqa: E501

        :param current_liabilities: The current_liabilities of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._current_liabilities = current_liabilities

    @property
    def current_portion_of_long_term_debt(self):
        """Gets the current_portion_of_long_term_debt of this MunicipalityFinancial.  # noqa: E501

        Government-wide portion of long term obligations, such as bond and loan debt coming due within the next year  # noqa: E501

        :return: The current_portion_of_long_term_debt of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._current_portion_of_long_term_debt
        
    @property
    def current_portion_of_long_term_debt_dict(self):
        """Gets the current_portion_of_long_term_debt of this MunicipalityFinancial.  # noqa: E501

        Government-wide portion of long term obligations, such as bond and loan debt coming due within the next year as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The current_portion_of_long_term_debt of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.current_portion_of_long_term_debt
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'current_portion_of_long_term_debt': value }

        
        return result
        

    @current_portion_of_long_term_debt.setter
    def current_portion_of_long_term_debt(self, current_portion_of_long_term_debt):
        """Sets the current_portion_of_long_term_debt of this MunicipalityFinancial.

        Government-wide portion of long term obligations, such as bond and loan debt coming due within the next year  # noqa: E501

        :param current_portion_of_long_term_debt: The current_portion_of_long_term_debt of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._current_portion_of_long_term_debt = current_portion_of_long_term_debt

    @property
    def net_pension_liability(self):
        """Gets the net_pension_liability of this MunicipalityFinancial.  # noqa: E501

        Government-wide liability for employee pensions net of the fiduciary net position of pension plans in which the government has an interest  # noqa: E501

        :return: The net_pension_liability of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._net_pension_liability
        
    @property
    def net_pension_liability_dict(self):
        """Gets the net_pension_liability of this MunicipalityFinancial.  # noqa: E501

        Government-wide liability for employee pensions net of the fiduciary net position of pension plans in which the government has an interest as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The net_pension_liability of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.net_pension_liability
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'net_pension_liability': value }

        
        return result
        

    @net_pension_liability.setter
    def net_pension_liability(self, net_pension_liability):
        """Sets the net_pension_liability of this MunicipalityFinancial.

        Government-wide liability for employee pensions net of the fiduciary net position of pension plans in which the government has an interest  # noqa: E501

        :param net_pension_liability: The net_pension_liability of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._net_pension_liability = net_pension_liability

    @property
    def net_opeb_liability(self):
        """Gets the net_opeb_liability of this MunicipalityFinancial.  # noqa: E501

        Government-wide liability for other postemployment benefits (OPEB). These are benefits (such as death benefits, life insurance, disability, and long-term care) that are paid in the period after employment and that are provided separately from a pension plan, as well as healthcare benefits paid in the period after employment, regardless of the manner in which they are provided. OPEB does not include termination benefits or termination payments for sick leave. Liability is reported net of any OPEB assets the government may control.  # noqa: E501

        :return: The net_opeb_liability of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._net_opeb_liability
        
    @property
    def net_opeb_liability_dict(self):
        """Gets the net_opeb_liability of this MunicipalityFinancial.  # noqa: E501

        Government-wide liability for other postemployment benefits (OPEB). These are benefits (such as death benefits, life insurance, disability, and long-term care) that are paid in the period after employment and that are provided separately from a pension plan, as well as healthcare benefits paid in the period after employment, regardless of the manner in which they are provided. OPEB does not include termination benefits or termination payments for sick leave. Liability is reported net of any OPEB assets the government may control. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The net_opeb_liability of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.net_opeb_liability
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'net_opeb_liability': value }

        
        return result
        

    @net_opeb_liability.setter
    def net_opeb_liability(self, net_opeb_liability):
        """Sets the net_opeb_liability of this MunicipalityFinancial.

        Government-wide liability for other postemployment benefits (OPEB). These are benefits (such as death benefits, life insurance, disability, and long-term care) that are paid in the period after employment and that are provided separately from a pension plan, as well as healthcare benefits paid in the period after employment, regardless of the manner in which they are provided. OPEB does not include termination benefits or termination payments for sick leave. Liability is reported net of any OPEB assets the government may control.  # noqa: E501

        :param net_opeb_liability: The net_opeb_liability of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._net_opeb_liability = net_opeb_liability

    @property
    def all_other_long_term_debt(self):
        """Gets the all_other_long_term_debt of this MunicipalityFinancial.  # noqa: E501

        Government-wide liabilities not elsewhere classified  # noqa: E501

        :return: The all_other_long_term_debt of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._all_other_long_term_debt
        
    @property
    def all_other_long_term_debt_dict(self):
        """Gets the all_other_long_term_debt of this MunicipalityFinancial.  # noqa: E501

        Government-wide liabilities not elsewhere classified as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The all_other_long_term_debt of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.all_other_long_term_debt
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'all_other_long_term_debt': value }

        
        return result
        

    @all_other_long_term_debt.setter
    def all_other_long_term_debt(self, all_other_long_term_debt):
        """Sets the all_other_long_term_debt of this MunicipalityFinancial.

        Government-wide liabilities not elsewhere classified  # noqa: E501

        :param all_other_long_term_debt: The all_other_long_term_debt of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._all_other_long_term_debt = all_other_long_term_debt

    @property
    def total_liabilities(self):
        """Gets the total_liabilities of this MunicipalityFinancial.  # noqa: E501

        The sum of the Municipality's all other long term debt, net open liability, net pension liability, and current portion of long term debt  # noqa: E501

        :return: The total_liabilities of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._total_liabilities
        
    @property
    def total_liabilities_dict(self):
        """Gets the total_liabilities of this MunicipalityFinancial.  # noqa: E501

        The sum of the Municipality's all other long term debt, net open liability, net pension liability, and current portion of long term debt as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_liabilities of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_liabilities
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_liabilities': value }

        
        return result
        

    @total_liabilities.setter
    def total_liabilities(self, total_liabilities):
        """Sets the total_liabilities of this MunicipalityFinancial.

        The sum of the Municipality's all other long term debt, net open liability, net pension liability, and current portion of long term debt  # noqa: E501

        :param total_liabilities: The total_liabilities of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._total_liabilities = total_liabilities

    @property
    def deferred_inflows(self):
        """Gets the deferred_inflows of this MunicipalityFinancial.  # noqa: E501

        Government-wide acquisitions of net position applicable to a future year  # noqa: E501

        :return: The deferred_inflows of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._deferred_inflows
        
    @property
    def deferred_inflows_dict(self):
        """Gets the deferred_inflows of this MunicipalityFinancial.  # noqa: E501

        Government-wide acquisitions of net position applicable to a future year as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The deferred_inflows of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.deferred_inflows
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'deferred_inflows': value }

        
        return result
        

    @deferred_inflows.setter
    def deferred_inflows(self, deferred_inflows):
        """Sets the deferred_inflows of this MunicipalityFinancial.

        Government-wide acquisitions of net position applicable to a future year  # noqa: E501

        :param deferred_inflows: The deferred_inflows of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._deferred_inflows = deferred_inflows

    @property
    def total_liabilities_plus_deferred_inflows(self):
        """Gets the total_liabilities_plus_deferred_inflows of this MunicipalityFinancial.  # noqa: E501

        Sum of government-wide liabilities and deferred inflows of resources  # noqa: E501

        :return: The total_liabilities_plus_deferred_inflows of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._total_liabilities_plus_deferred_inflows
        
    @property
    def total_liabilities_plus_deferred_inflows_dict(self):
        """Gets the total_liabilities_plus_deferred_inflows of this MunicipalityFinancial.  # noqa: E501

        Sum of government-wide liabilities and deferred inflows of resources as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_liabilities_plus_deferred_inflows of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_liabilities_plus_deferred_inflows
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_liabilities_plus_deferred_inflows': value }

        
        return result
        

    @total_liabilities_plus_deferred_inflows.setter
    def total_liabilities_plus_deferred_inflows(self, total_liabilities_plus_deferred_inflows):
        """Sets the total_liabilities_plus_deferred_inflows of this MunicipalityFinancial.

        Sum of government-wide liabilities and deferred inflows of resources  # noqa: E501

        :param total_liabilities_plus_deferred_inflows: The total_liabilities_plus_deferred_inflows of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._total_liabilities_plus_deferred_inflows = total_liabilities_plus_deferred_inflows

    @property
    def total_net_position(self):
        """Gets the total_net_position of this MunicipalityFinancial.  # noqa: E501

        Government-wide assets and deferred outflows less government-wide liabilities and deferred inflows  # noqa: E501

        :return: The total_net_position of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._total_net_position
        
    @property
    def total_net_position_dict(self):
        """Gets the total_net_position of this MunicipalityFinancial.  # noqa: E501

        Government-wide assets and deferred outflows less government-wide liabilities and deferred inflows as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_net_position of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_net_position
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_net_position': value }

        
        return result
        

    @total_net_position.setter
    def total_net_position(self, total_net_position):
        """Sets the total_net_position of this MunicipalityFinancial.

        Government-wide assets and deferred outflows less government-wide liabilities and deferred inflows  # noqa: E501

        :param total_net_position: The total_net_position of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._total_net_position = total_net_position

    @property
    def total_unrestricted_net_position(self):
        """Gets the total_unrestricted_net_position of this MunicipalityFinancial.  # noqa: E501

        Net amount of government-wide assets, deferred outflows of resources, liabilities, and deferred inflows of resources that are not included in the determination of net investment in capital assets or the restricted components of net position  # noqa: E501

        :return: The total_unrestricted_net_position of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._total_unrestricted_net_position
        
    @property
    def total_unrestricted_net_position_dict(self):
        """Gets the total_unrestricted_net_position of this MunicipalityFinancial.  # noqa: E501

        Net amount of government-wide assets, deferred outflows of resources, liabilities, and deferred inflows of resources that are not included in the determination of net investment in capital assets or the restricted components of net position as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_unrestricted_net_position of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_unrestricted_net_position
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_unrestricted_net_position': value }

        
        return result
        

    @total_unrestricted_net_position.setter
    def total_unrestricted_net_position(self, total_unrestricted_net_position):
        """Sets the total_unrestricted_net_position of this MunicipalityFinancial.

        Net amount of government-wide assets, deferred outflows of resources, liabilities, and deferred inflows of resources that are not included in the determination of net investment in capital assets or the restricted components of net position  # noqa: E501

        :param total_unrestricted_net_position: The total_unrestricted_net_position of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._total_unrestricted_net_position = total_unrestricted_net_position

    @property
    def total_expenses(self):
        """Gets the total_expenses of this MunicipalityFinancial.  # noqa: E501

        Decreases in net position that occurred during the past year, government-wide  # noqa: E501

        :return: The total_expenses of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._total_expenses
        
    @property
    def total_expenses_dict(self):
        """Gets the total_expenses of this MunicipalityFinancial.  # noqa: E501

        Decreases in net position that occurred during the past year, government-wide as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_expenses of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_expenses
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_expenses': value }

        
        return result
        

    @total_expenses.setter
    def total_expenses(self, total_expenses):
        """Sets the total_expenses of this MunicipalityFinancial.

        Decreases in net position that occurred during the past year, government-wide  # noqa: E501

        :param total_expenses: The total_expenses of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._total_expenses = total_expenses

    @property
    def charges_for_services(self):
        """Gets the charges_for_services of this MunicipalityFinancial.  # noqa: E501

        Charges for services is the term used for a broad category of program revenues that arise from charges to customers, applicants, or others who purchase, use, or directly benefit from the goods, services, or privileges provided, or are otherwise directly affected by the services. Revenues in this category include fees charged for specific services, such as water use or garbage collection; licenses and permits, such as dog licenses, liquor licenses, and building permits; operating special assessments, such as for street cleaning or special street lighting; and any other amounts charged to service recipients. Fines and forfeitures are also included in this category because they result from direct charges to those who are otherwise directly affected by a program or service, even though they receive no benefit. Payments from other governments for goods or services should be reported in this category.  # noqa: E501

        :return: The charges_for_services of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._charges_for_services
        
    @property
    def charges_for_services_dict(self):
        """Gets the charges_for_services of this MunicipalityFinancial.  # noqa: E501

        Charges for services is the term used for a broad category of program revenues that arise from charges to customers, applicants, or others who purchase, use, or directly benefit from the goods, services, or privileges provided, or are otherwise directly affected by the services. Revenues in this category include fees charged for specific services, such as water use or garbage collection; licenses and permits, such as dog licenses, liquor licenses, and building permits; operating special assessments, such as for street cleaning or special street lighting; and any other amounts charged to service recipients. Fines and forfeitures are also included in this category because they result from direct charges to those who are otherwise directly affected by a program or service, even though they receive no benefit. Payments from other governments for goods or services should be reported in this category. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The charges_for_services of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.charges_for_services
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'charges_for_services': value }

        
        return result
        

    @charges_for_services.setter
    def charges_for_services(self, charges_for_services):
        """Sets the charges_for_services of this MunicipalityFinancial.

        Charges for services is the term used for a broad category of program revenues that arise from charges to customers, applicants, or others who purchase, use, or directly benefit from the goods, services, or privileges provided, or are otherwise directly affected by the services. Revenues in this category include fees charged for specific services, such as water use or garbage collection; licenses and permits, such as dog licenses, liquor licenses, and building permits; operating special assessments, such as for street cleaning or special street lighting; and any other amounts charged to service recipients. Fines and forfeitures are also included in this category because they result from direct charges to those who are otherwise directly affected by a program or service, even though they receive no benefit. Payments from other governments for goods or services should be reported in this category.  # noqa: E501

        :param charges_for_services: The charges_for_services of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._charges_for_services = charges_for_services

    @property
    def operating_grants_and_contributions(self):
        """Gets the operating_grants_and_contributions of this MunicipalityFinancial.  # noqa: E501

        Program-specific grants and contributions - includes revenues arising from mandatory and voluntary nonexchange transactions with other governments, organizations, or individuals that are restricted for use in a particular program. Some grants and contributions consist of capital assets or resources that are restricted for capital purposes—to purchase, construct, or renovate capital assets associated with a specific program. These should be reported separately from grants and contributions that may be used either for operating expenses or for capital expenditures of the program at the discretion of the reporting government. These categories of program revenue are specifically attributable to a program and reduce the net expense of that program to the reporting government. For example, a state may provide an operating grant to a county sheriff's department for a drug-awareness-and-enforcement program.  # noqa: E501

        :return: The operating_grants_and_contributions of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._operating_grants_and_contributions
        
    @property
    def operating_grants_and_contributions_dict(self):
        """Gets the operating_grants_and_contributions of this MunicipalityFinancial.  # noqa: E501

        Program-specific grants and contributions - includes revenues arising from mandatory and voluntary nonexchange transactions with other governments, organizations, or individuals that are restricted for use in a particular program. Some grants and contributions consist of capital assets or resources that are restricted for capital purposes—to purchase, construct, or renovate capital assets associated with a specific program. These should be reported separately from grants and contributions that may be used either for operating expenses or for capital expenditures of the program at the discretion of the reporting government. These categories of program revenue are specifically attributable to a program and reduce the net expense of that program to the reporting government. For example, a state may provide an operating grant to a county sheriff's department for a drug-awareness-and-enforcement program. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The operating_grants_and_contributions of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.operating_grants_and_contributions
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'operating_grants_and_contributions': value }

        
        return result
        

    @operating_grants_and_contributions.setter
    def operating_grants_and_contributions(self, operating_grants_and_contributions):
        """Sets the operating_grants_and_contributions of this MunicipalityFinancial.

        Program-specific grants and contributions - includes revenues arising from mandatory and voluntary nonexchange transactions with other governments, organizations, or individuals that are restricted for use in a particular program. Some grants and contributions consist of capital assets or resources that are restricted for capital purposes—to purchase, construct, or renovate capital assets associated with a specific program. These should be reported separately from grants and contributions that may be used either for operating expenses or for capital expenditures of the program at the discretion of the reporting government. These categories of program revenue are specifically attributable to a program and reduce the net expense of that program to the reporting government. For example, a state may provide an operating grant to a county sheriff's department for a drug-awareness-and-enforcement program.  # noqa: E501

        :param operating_grants_and_contributions: The operating_grants_and_contributions of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._operating_grants_and_contributions = operating_grants_and_contributions

    @property
    def capital_grants_and_contributions(self):
        """Gets the capital_grants_and_contributions of this MunicipalityFinancial.  # noqa: E501

        Program-specific grants and contributions - includes revenues arising from mandatory and voluntary nonexchange transactions with other governments, organizations, or individuals that are restricted for use in a particular program. Some grants and contributions consist of capital assets or resources that are restricted for capital purposes—to purchase, construct, or renovate capital assets associated with a specific program. These should be reported separately from grants and contributions that may be used either for operating expenses or for capital expenditures of the program at the discretion of the reporting government. These categories of program revenue are specifically attributable to a program and reduce the net expense of that program to the reporting government. For example, a state may provide a capital grant to finance construction of a new jail.  # noqa: E501

        :return: The capital_grants_and_contributions of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._capital_grants_and_contributions
        
    @property
    def capital_grants_and_contributions_dict(self):
        """Gets the capital_grants_and_contributions of this MunicipalityFinancial.  # noqa: E501

        Program-specific grants and contributions - includes revenues arising from mandatory and voluntary nonexchange transactions with other governments, organizations, or individuals that are restricted for use in a particular program. Some grants and contributions consist of capital assets or resources that are restricted for capital purposes—to purchase, construct, or renovate capital assets associated with a specific program. These should be reported separately from grants and contributions that may be used either for operating expenses or for capital expenditures of the program at the discretion of the reporting government. These categories of program revenue are specifically attributable to a program and reduce the net expense of that program to the reporting government. For example, a state may provide a capital grant to finance construction of a new jail. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The capital_grants_and_contributions of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.capital_grants_and_contributions
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'capital_grants_and_contributions': value }

        
        return result
        

    @capital_grants_and_contributions.setter
    def capital_grants_and_contributions(self, capital_grants_and_contributions):
        """Sets the capital_grants_and_contributions of this MunicipalityFinancial.

        Program-specific grants and contributions - includes revenues arising from mandatory and voluntary nonexchange transactions with other governments, organizations, or individuals that are restricted for use in a particular program. Some grants and contributions consist of capital assets or resources that are restricted for capital purposes—to purchase, construct, or renovate capital assets associated with a specific program. These should be reported separately from grants and contributions that may be used either for operating expenses or for capital expenditures of the program at the discretion of the reporting government. These categories of program revenue are specifically attributable to a program and reduce the net expense of that program to the reporting government. For example, a state may provide a capital grant to finance construction of a new jail.  # noqa: E501

        :param capital_grants_and_contributions: The capital_grants_and_contributions of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._capital_grants_and_contributions = capital_grants_and_contributions

    @property
    def general_revenues(self):
        """Gets the general_revenues of this MunicipalityFinancial.  # noqa: E501

        All revenues are general revenues unless they are required to be reported as program revenues. All taxes, even those that are levied for a specific purpose, are general revenues and should be reported by type of tax—for example, sales tax, property tax, franchise tax, income tax. All other nontax revenues (including interest, grants, and contributions) that do not meet the criteria to be reported as program revenues should also be reported as general revenues. General revenues should be reported after total net expense of the government's functions.  # noqa: E501

        :return: The general_revenues of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._general_revenues
        
    @property
    def general_revenues_dict(self):
        """Gets the general_revenues of this MunicipalityFinancial.  # noqa: E501

        All revenues are general revenues unless they are required to be reported as program revenues. All taxes, even those that are levied for a specific purpose, are general revenues and should be reported by type of tax—for example, sales tax, property tax, franchise tax, income tax. All other nontax revenues (including interest, grants, and contributions) that do not meet the criteria to be reported as program revenues should also be reported as general revenues. General revenues should be reported after total net expense of the government's functions. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The general_revenues of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.general_revenues
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'general_revenues': value }

        
        return result
        

    @general_revenues.setter
    def general_revenues(self, general_revenues):
        """Sets the general_revenues of this MunicipalityFinancial.

        All revenues are general revenues unless they are required to be reported as program revenues. All taxes, even those that are levied for a specific purpose, are general revenues and should be reported by type of tax—for example, sales tax, property tax, franchise tax, income tax. All other nontax revenues (including interest, grants, and contributions) that do not meet the criteria to be reported as program revenues should also be reported as general revenues. General revenues should be reported after total net expense of the government's functions.  # noqa: E501

        :param general_revenues: The general_revenues of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._general_revenues = general_revenues

    @property
    def other_revenues(self):
        """Gets the other_revenues of this MunicipalityFinancial.  # noqa: E501

        Government-wide revenues not elsewhere classified  # noqa: E501

        :return: The other_revenues of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._other_revenues
        
    @property
    def other_revenues_dict(self):
        """Gets the other_revenues of this MunicipalityFinancial.  # noqa: E501

        Government-wide revenues not elsewhere classified as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The other_revenues of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.other_revenues
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'other_revenues': value }

        
        return result
        

    @other_revenues.setter
    def other_revenues(self, other_revenues):
        """Sets the other_revenues of this MunicipalityFinancial.

        Government-wide revenues not elsewhere classified  # noqa: E501

        :param other_revenues: The other_revenues of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._other_revenues = other_revenues

    @property
    def total_revenues(self):
        """Gets the total_revenues of this MunicipalityFinancial.  # noqa: E501

        Increases in net position that occurred during the past year, government-wide  # noqa: E501

        :return: The total_revenues of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._total_revenues
        
    @property
    def total_revenues_dict(self):
        """Gets the total_revenues of this MunicipalityFinancial.  # noqa: E501

        Increases in net position that occurred during the past year, government-wide as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_revenues of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_revenues
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_revenues': value }

        
        return result
        

    @total_revenues.setter
    def total_revenues(self, total_revenues):
        """Sets the total_revenues of this MunicipalityFinancial.

        Increases in net position that occurred during the past year, government-wide  # noqa: E501

        :param total_revenues: The total_revenues of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._total_revenues = total_revenues

    @property
    def change_in_net_assets(self):
        """Gets the change_in_net_assets of this MunicipalityFinancial.  # noqa: E501

        Difference between the government's net position at the end of the fiscal year and the government's net position at the beginning of the fiscal year  # noqa: E501

        :return: The change_in_net_assets of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._change_in_net_assets
        
    @property
    def change_in_net_assets_dict(self):
        """Gets the change_in_net_assets of this MunicipalityFinancial.  # noqa: E501

        Difference between the government's net position at the end of the fiscal year and the government's net position at the beginning of the fiscal year as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The change_in_net_assets of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.change_in_net_assets
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'change_in_net_assets': value }

        
        return result
        

    @change_in_net_assets.setter
    def change_in_net_assets(self, change_in_net_assets):
        """Sets the change_in_net_assets of this MunicipalityFinancial.

        Difference between the government's net position at the end of the fiscal year and the government's net position at the beginning of the fiscal year  # noqa: E501

        :param change_in_net_assets: The change_in_net_assets of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._change_in_net_assets = change_in_net_assets

    @property
    def non_spendable_general_fund_balance(self):
        """Gets the non_spendable_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        The portion of general fund balance classified as nonspendable. The nonspendable fund balance classification includes amounts that cannot be spent because they are either (a) not in spendable form or (b) legally or contractually required to be maintained intact. The “not in spendable form” criterion includes items that are not expected to be converted to cash, for example, inventories and prepaid amounts. It also includes the long-term amount of loans and notes receivable, as well as property acquired for resale. However, if the use of the proceeds from the collection of those receivables or from the sale of those properties is restricted, committed, or assigned, then they should be included in the appropriate fund balance classification (restricted, committed, or assigned), rather than nonspendable fund balance. The corpus (or principal) of a permanent fund is an example of an amount that is legally or contractually required to be maintained intact.  # noqa: E501

        :return: The non_spendable_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._non_spendable_general_fund_balance
        
    @property
    def non_spendable_general_fund_balance_dict(self):
        """Gets the non_spendable_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        The portion of general fund balance classified as nonspendable. The nonspendable fund balance classification includes amounts that cannot be spent because they are either (a) not in spendable form or (b) legally or contractually required to be maintained intact. The “not in spendable form” criterion includes items that are not expected to be converted to cash, for example, inventories and prepaid amounts. It also includes the long-term amount of loans and notes receivable, as well as property acquired for resale. However, if the use of the proceeds from the collection of those receivables or from the sale of those properties is restricted, committed, or assigned, then they should be included in the appropriate fund balance classification (restricted, committed, or assigned), rather than nonspendable fund balance. The corpus (or principal) of a permanent fund is an example of an amount that is legally or contractually required to be maintained intact. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The non_spendable_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.non_spendable_general_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'non_spendable_general_fund_balance': value }

        
        return result
        

    @non_spendable_general_fund_balance.setter
    def non_spendable_general_fund_balance(self, non_spendable_general_fund_balance):
        """Sets the non_spendable_general_fund_balance of this MunicipalityFinancial.

        The portion of general fund balance classified as nonspendable. The nonspendable fund balance classification includes amounts that cannot be spent because they are either (a) not in spendable form or (b) legally or contractually required to be maintained intact. The “not in spendable form” criterion includes items that are not expected to be converted to cash, for example, inventories and prepaid amounts. It also includes the long-term amount of loans and notes receivable, as well as property acquired for resale. However, if the use of the proceeds from the collection of those receivables or from the sale of those properties is restricted, committed, or assigned, then they should be included in the appropriate fund balance classification (restricted, committed, or assigned), rather than nonspendable fund balance. The corpus (or principal) of a permanent fund is an example of an amount that is legally or contractually required to be maintained intact.  # noqa: E501

        :param non_spendable_general_fund_balance: The non_spendable_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._non_spendable_general_fund_balance = non_spendable_general_fund_balance

    @property
    def restricted_general_fund_balance(self):
        """Gets the restricted_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        The portion of general fund balance classified as restricted. Fund balance should be reported as restricted when constraints placed on the use of resources are either (a) Externally imposed by creditors (such as through debt covenants), grantors, contributors, or laws or regulations of other governments or (b) Imposed by law through constitutional provisions or enabling legislation.  # noqa: E501

        :return: The restricted_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._restricted_general_fund_balance
        
    @property
    def restricted_general_fund_balance_dict(self):
        """Gets the restricted_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        The portion of general fund balance classified as restricted. Fund balance should be reported as restricted when constraints placed on the use of resources are either (a) Externally imposed by creditors (such as through debt covenants), grantors, contributors, or laws or regulations of other governments or (b) Imposed by law through constitutional provisions or enabling legislation. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The restricted_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.restricted_general_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'restricted_general_fund_balance': value }

        
        return result
        

    @restricted_general_fund_balance.setter
    def restricted_general_fund_balance(self, restricted_general_fund_balance):
        """Sets the restricted_general_fund_balance of this MunicipalityFinancial.

        The portion of general fund balance classified as restricted. Fund balance should be reported as restricted when constraints placed on the use of resources are either (a) Externally imposed by creditors (such as through debt covenants), grantors, contributors, or laws or regulations of other governments or (b) Imposed by law through constitutional provisions or enabling legislation.  # noqa: E501

        :param restricted_general_fund_balance: The restricted_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._restricted_general_fund_balance = restricted_general_fund_balance

    @property
    def committed_general_fund_balance(self):
        """Gets the committed_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        The portion of general fund balance classified as committed. Amounts that can only be used for specific purposes pursuant to constraints imposed by formal action of the government’s highest level of decision-making authority should be reported as committed fund balance. Those committed amounts cannot be used for any other purpose unless the government removes or changes the specified use by taking the same type of action (for example, legislation, resolution, ordinance) it employed to previously commit those amounts. The authorization specifying the purposes for which amounts can be used should have the consent of both the legislative and executive branches of the government, if applicable. Committed fund balance also should incorporate contractual obligations to the extent that existing resources in the fund have been specifically committed for use in satisfying those contractual requirements.  # noqa: E501

        :return: The committed_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._committed_general_fund_balance
        
    @property
    def committed_general_fund_balance_dict(self):
        """Gets the committed_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        The portion of general fund balance classified as committed. Amounts that can only be used for specific purposes pursuant to constraints imposed by formal action of the government’s highest level of decision-making authority should be reported as committed fund balance. Those committed amounts cannot be used for any other purpose unless the government removes or changes the specified use by taking the same type of action (for example, legislation, resolution, ordinance) it employed to previously commit those amounts. The authorization specifying the purposes for which amounts can be used should have the consent of both the legislative and executive branches of the government, if applicable. Committed fund balance also should incorporate contractual obligations to the extent that existing resources in the fund have been specifically committed for use in satisfying those contractual requirements. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The committed_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.committed_general_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'committed_general_fund_balance': value }

        
        return result
        

    @committed_general_fund_balance.setter
    def committed_general_fund_balance(self, committed_general_fund_balance):
        """Sets the committed_general_fund_balance of this MunicipalityFinancial.

        The portion of general fund balance classified as committed. Amounts that can only be used for specific purposes pursuant to constraints imposed by formal action of the government’s highest level of decision-making authority should be reported as committed fund balance. Those committed amounts cannot be used for any other purpose unless the government removes or changes the specified use by taking the same type of action (for example, legislation, resolution, ordinance) it employed to previously commit those amounts. The authorization specifying the purposes for which amounts can be used should have the consent of both the legislative and executive branches of the government, if applicable. Committed fund balance also should incorporate contractual obligations to the extent that existing resources in the fund have been specifically committed for use in satisfying those contractual requirements.  # noqa: E501

        :param committed_general_fund_balance: The committed_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._committed_general_fund_balance = committed_general_fund_balance

    @property
    def unassigned_general_fund_balance(self):
        """Gets the unassigned_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        The portion of general fund balance classified as unassigned. Unassigned fund balance is the residual classification for the general fund. This classification represents fund balance that has not been assigned to other funds and that has not been restricted, committed, or assigned to specific purposes within the general fund. The general fund should be the only fund that reports a positive unassigned fund balance amount. In other governmental funds, if expenditures incurred for specific purposes exceeded the amounts restricted, committed, or assigned to those purposes, it may be necessary to report a negative unassigned fund balance.  # noqa: E501

        :return: The unassigned_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._unassigned_general_fund_balance
        
    @property
    def unassigned_general_fund_balance_dict(self):
        """Gets the unassigned_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        The portion of general fund balance classified as unassigned. Unassigned fund balance is the residual classification for the general fund. This classification represents fund balance that has not been assigned to other funds and that has not been restricted, committed, or assigned to specific purposes within the general fund. The general fund should be the only fund that reports a positive unassigned fund balance amount. In other governmental funds, if expenditures incurred for specific purposes exceeded the amounts restricted, committed, or assigned to those purposes, it may be necessary to report a negative unassigned fund balance. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The unassigned_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.unassigned_general_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'unassigned_general_fund_balance': value }

        
        return result
        

    @unassigned_general_fund_balance.setter
    def unassigned_general_fund_balance(self, unassigned_general_fund_balance):
        """Sets the unassigned_general_fund_balance of this MunicipalityFinancial.

        The portion of general fund balance classified as unassigned. Unassigned fund balance is the residual classification for the general fund. This classification represents fund balance that has not been assigned to other funds and that has not been restricted, committed, or assigned to specific purposes within the general fund. The general fund should be the only fund that reports a positive unassigned fund balance amount. In other governmental funds, if expenditures incurred for specific purposes exceeded the amounts restricted, committed, or assigned to those purposes, it may be necessary to report a negative unassigned fund balance.  # noqa: E501

        :param unassigned_general_fund_balance: The unassigned_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._unassigned_general_fund_balance = unassigned_general_fund_balance

    @property
    def assigned_general_fund_balance(self):
        """Gets the assigned_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        The portion of general fund balance classified as assigned. Amounts that are constrained by the government’s intent to be used for specific purposes, but are neither restricted nor committed, should be reported as assigned fund balance, except for stabilization arrangements.. Intent should be expressed by (a) the governing body itself or (b) a body (a budget or finance committee, for example) or official to which the governing body has delegated the authority to assign amounts to be used for specific purposes.  # noqa: E501

        :return: The assigned_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._assigned_general_fund_balance
        
    @property
    def assigned_general_fund_balance_dict(self):
        """Gets the assigned_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        The portion of general fund balance classified as assigned. Amounts that are constrained by the government’s intent to be used for specific purposes, but are neither restricted nor committed, should be reported as assigned fund balance, except for stabilization arrangements.. Intent should be expressed by (a) the governing body itself or (b) a body (a budget or finance committee, for example) or official to which the governing body has delegated the authority to assign amounts to be used for specific purposes. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The assigned_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.assigned_general_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'assigned_general_fund_balance': value }

        
        return result
        

    @assigned_general_fund_balance.setter
    def assigned_general_fund_balance(self, assigned_general_fund_balance):
        """Sets the assigned_general_fund_balance of this MunicipalityFinancial.

        The portion of general fund balance classified as assigned. Amounts that are constrained by the government’s intent to be used for specific purposes, but are neither restricted nor committed, should be reported as assigned fund balance, except for stabilization arrangements.. Intent should be expressed by (a) the governing body itself or (b) a body (a budget or finance committee, for example) or official to which the governing body has delegated the authority to assign amounts to be used for specific purposes.  # noqa: E501

        :param assigned_general_fund_balance: The assigned_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._assigned_general_fund_balance = assigned_general_fund_balance

    @property
    def total_general_fund_balance(self):
        """Gets the total_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        General fund balance in all classifications. Fund balance is the difference between governmental fund assets and deferred outflows of resources, and liabilities and deferred inflows of resources. It is sometimes referred to as fund equity. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund.  # noqa: E501

        :return: The total_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._total_general_fund_balance
        
    @property
    def total_general_fund_balance_dict(self):
        """Gets the total_general_fund_balance of this MunicipalityFinancial.  # noqa: E501

        General fund balance in all classifications. Fund balance is the difference between governmental fund assets and deferred outflows of resources, and liabilities and deferred inflows of resources. It is sometimes referred to as fund equity. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_general_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_general_fund_balance': value }

        
        return result
        

    @total_general_fund_balance.setter
    def total_general_fund_balance(self, total_general_fund_balance):
        """Sets the total_general_fund_balance of this MunicipalityFinancial.

        General fund balance in all classifications. Fund balance is the difference between governmental fund assets and deferred outflows of resources, and liabilities and deferred inflows of resources. It is sometimes referred to as fund equity. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund.  # noqa: E501

        :param total_general_fund_balance: The total_general_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._total_general_fund_balance = total_general_fund_balance

    @property
    def non_spendable_governmental_fund_balance(self):
        """Gets the non_spendable_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of fund balances that are classified as nonspendable. The nonspendable fund balance classification includes amounts that cannot be spent because they are either (a) not in spendable form or (b) legally or contractually required to be maintained intact. The “not in spendable form” criterion includes items that are not expected to be converted to cash, for example, inventories and prepaid amounts. It also includes the long-term amount of loans and notes receivable, as well as property acquired for resale. However, if the use of the proceeds from the collection of those receivables or from the sale of those properties is restricted, committed, or assigned, then they should be included in the appropriate fund balance classification (restricted, committed, or assigned), rather than nonspendable fund balance.  # noqa: E501

        :return: The non_spendable_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._non_spendable_governmental_fund_balance
        
    @property
    def non_spendable_governmental_fund_balance_dict(self):
        """Gets the non_spendable_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of fund balances that are classified as nonspendable. The nonspendable fund balance classification includes amounts that cannot be spent because they are either (a) not in spendable form or (b) legally or contractually required to be maintained intact. The “not in spendable form” criterion includes items that are not expected to be converted to cash, for example, inventories and prepaid amounts. It also includes the long-term amount of loans and notes receivable, as well as property acquired for resale. However, if the use of the proceeds from the collection of those receivables or from the sale of those properties is restricted, committed, or assigned, then they should be included in the appropriate fund balance classification (restricted, committed, or assigned), rather than nonspendable fund balance. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The non_spendable_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.non_spendable_governmental_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'non_spendable_governmental_fund_balance': value }

        
        return result
        

    @non_spendable_governmental_fund_balance.setter
    def non_spendable_governmental_fund_balance(self, non_spendable_governmental_fund_balance):
        """Sets the non_spendable_governmental_fund_balance of this MunicipalityFinancial.

        For all governmental funds, the aggregate of fund balances that are classified as nonspendable. The nonspendable fund balance classification includes amounts that cannot be spent because they are either (a) not in spendable form or (b) legally or contractually required to be maintained intact. The “not in spendable form” criterion includes items that are not expected to be converted to cash, for example, inventories and prepaid amounts. It also includes the long-term amount of loans and notes receivable, as well as property acquired for resale. However, if the use of the proceeds from the collection of those receivables or from the sale of those properties is restricted, committed, or assigned, then they should be included in the appropriate fund balance classification (restricted, committed, or assigned), rather than nonspendable fund balance.  # noqa: E501

        :param non_spendable_governmental_fund_balance: The non_spendable_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._non_spendable_governmental_fund_balance = non_spendable_governmental_fund_balance

    @property
    def restricted_governmental_fund_balance(self):
        """Gets the restricted_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of fund balances that are classified as restricted. Fund balance should be reported as restricted when constraints placed on the use of resources are either (a) Externally imposed by creditors (such as through debt covenants), grantors, contributors, or laws or regulations of other governments; or (b) Imposed by law through constitutional provisions or enabling legislation.  # noqa: E501

        :return: The restricted_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._restricted_governmental_fund_balance
        
    @property
    def restricted_governmental_fund_balance_dict(self):
        """Gets the restricted_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of fund balances that are classified as restricted. Fund balance should be reported as restricted when constraints placed on the use of resources are either (a) Externally imposed by creditors (such as through debt covenants), grantors, contributors, or laws or regulations of other governments; or (b) Imposed by law through constitutional provisions or enabling legislation. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The restricted_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.restricted_governmental_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'restricted_governmental_fund_balance': value }

        
        return result
        

    @restricted_governmental_fund_balance.setter
    def restricted_governmental_fund_balance(self, restricted_governmental_fund_balance):
        """Sets the restricted_governmental_fund_balance of this MunicipalityFinancial.

        For all governmental funds, the aggregate of fund balances that are classified as restricted. Fund balance should be reported as restricted when constraints placed on the use of resources are either (a) Externally imposed by creditors (such as through debt covenants), grantors, contributors, or laws or regulations of other governments; or (b) Imposed by law through constitutional provisions or enabling legislation.  # noqa: E501

        :param restricted_governmental_fund_balance: The restricted_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._restricted_governmental_fund_balance = restricted_governmental_fund_balance

    @property
    def committed_governmental_fund_balance(self):
        """Gets the committed_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of fund balances that are classified as committed. Amounts that can only be used for specific purposes pursuant to constraints imposed by formal action of the government’s highest level of decision-making authority should be reported as committed fund balance. Those committed amounts cannot be used for any other purpose unless the government removes or changes the specified use by taking the same type of action (for example, legislation, resolution, ordinance) it employed to previously commit those amounts. The authorization specifying the purposes for which amounts can be used should have the consent of both the legislative and executive branches of the government, if applicable. Committed fund balance also should incorporate contractual obligations to the extent that existing resources in the fund have been specifically committed for use in satisfying those contractual requirements.  # noqa: E501

        :return: The committed_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._committed_governmental_fund_balance
        
    @property
    def committed_governmental_fund_balance_dict(self):
        """Gets the committed_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of fund balances that are classified as committed. Amounts that can only be used for specific purposes pursuant to constraints imposed by formal action of the government’s highest level of decision-making authority should be reported as committed fund balance. Those committed amounts cannot be used for any other purpose unless the government removes or changes the specified use by taking the same type of action (for example, legislation, resolution, ordinance) it employed to previously commit those amounts. The authorization specifying the purposes for which amounts can be used should have the consent of both the legislative and executive branches of the government, if applicable. Committed fund balance also should incorporate contractual obligations to the extent that existing resources in the fund have been specifically committed for use in satisfying those contractual requirements. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The committed_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.committed_governmental_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'committed_governmental_fund_balance': value }

        
        return result
        

    @committed_governmental_fund_balance.setter
    def committed_governmental_fund_balance(self, committed_governmental_fund_balance):
        """Sets the committed_governmental_fund_balance of this MunicipalityFinancial.

        For all governmental funds, the aggregate of fund balances that are classified as committed. Amounts that can only be used for specific purposes pursuant to constraints imposed by formal action of the government’s highest level of decision-making authority should be reported as committed fund balance. Those committed amounts cannot be used for any other purpose unless the government removes or changes the specified use by taking the same type of action (for example, legislation, resolution, ordinance) it employed to previously commit those amounts. The authorization specifying the purposes for which amounts can be used should have the consent of both the legislative and executive branches of the government, if applicable. Committed fund balance also should incorporate contractual obligations to the extent that existing resources in the fund have been specifically committed for use in satisfying those contractual requirements.  # noqa: E501

        :param committed_governmental_fund_balance: The committed_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._committed_governmental_fund_balance = committed_governmental_fund_balance

    @property
    def unassigned_governmental_fund_balance(self):
        """Gets the unassigned_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of fund balances that are classified as unassigned. Unassigned fund balance is the residual classification for the general fund. This classification represents fund balance that has not been assigned to other funds and that has not been restricted, committed, or assigned to specific purposes within the general fund. The general fund should be the only fund that reports a positive unassigned fund balance amount. In other governmental funds, if expenditures incurred for specific purposes exceeded the amounts restricted, committed, or assigned to those purposes, it may be necessary to report a negative unassigned fund balance.  # noqa: E501

        :return: The unassigned_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._unassigned_governmental_fund_balance
        
    @property
    def unassigned_governmental_fund_balance_dict(self):
        """Gets the unassigned_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of fund balances that are classified as unassigned. Unassigned fund balance is the residual classification for the general fund. This classification represents fund balance that has not been assigned to other funds and that has not been restricted, committed, or assigned to specific purposes within the general fund. The general fund should be the only fund that reports a positive unassigned fund balance amount. In other governmental funds, if expenditures incurred for specific purposes exceeded the amounts restricted, committed, or assigned to those purposes, it may be necessary to report a negative unassigned fund balance. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The unassigned_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.unassigned_governmental_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'unassigned_governmental_fund_balance': value }

        
        return result
        

    @unassigned_governmental_fund_balance.setter
    def unassigned_governmental_fund_balance(self, unassigned_governmental_fund_balance):
        """Sets the unassigned_governmental_fund_balance of this MunicipalityFinancial.

        For all governmental funds, the aggregate of fund balances that are classified as unassigned. Unassigned fund balance is the residual classification for the general fund. This classification represents fund balance that has not been assigned to other funds and that has not been restricted, committed, or assigned to specific purposes within the general fund. The general fund should be the only fund that reports a positive unassigned fund balance amount. In other governmental funds, if expenditures incurred for specific purposes exceeded the amounts restricted, committed, or assigned to those purposes, it may be necessary to report a negative unassigned fund balance.  # noqa: E501

        :param unassigned_governmental_fund_balance: The unassigned_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._unassigned_governmental_fund_balance = unassigned_governmental_fund_balance

    @property
    def assigned_governmental_fund_balance(self):
        """Gets the assigned_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of fund balances that are classified as assigned. Amounts that are constrained by the government’s intent to be used for specific purposes, but are neither restricted nor committed, should be reported as assigned fund balance, except for stabilization arrangements.. Intent should be expressed by (a) the governing body itself or (b) a body (a budget or finance committee, for example) or official to which the governing body has delegated the authority to assign amounts to be used for specific purposes.  # noqa: E501

        :return: The assigned_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._assigned_governmental_fund_balance
        
    @property
    def assigned_governmental_fund_balance_dict(self):
        """Gets the assigned_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of fund balances that are classified as assigned. Amounts that are constrained by the government’s intent to be used for specific purposes, but are neither restricted nor committed, should be reported as assigned fund balance, except for stabilization arrangements.. Intent should be expressed by (a) the governing body itself or (b) a body (a budget or finance committee, for example) or official to which the governing body has delegated the authority to assign amounts to be used for specific purposes. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The assigned_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.assigned_governmental_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'assigned_governmental_fund_balance': value }

        
        return result
        

    @assigned_governmental_fund_balance.setter
    def assigned_governmental_fund_balance(self, assigned_governmental_fund_balance):
        """Sets the assigned_governmental_fund_balance of this MunicipalityFinancial.

        For all governmental funds, the aggregate of fund balances that are classified as assigned. Amounts that are constrained by the government’s intent to be used for specific purposes, but are neither restricted nor committed, should be reported as assigned fund balance, except for stabilization arrangements.. Intent should be expressed by (a) the governing body itself or (b) a body (a budget or finance committee, for example) or official to which the governing body has delegated the authority to assign amounts to be used for specific purposes.  # noqa: E501

        :param assigned_governmental_fund_balance: The assigned_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._assigned_governmental_fund_balance = assigned_governmental_fund_balance

    @property
    def total_governmental_fund_balance(self):
        """Gets the total_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of all fund balances in any classification. Fund balance is the difference between governmental fund assets and deferred outflows of resources, and liabilities and deferred inflows of resources. It is sometimes referred to as fund equity. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues.  # noqa: E501

        :return: The total_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._total_governmental_fund_balance
        
    @property
    def total_governmental_fund_balance_dict(self):
        """Gets the total_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501

        For all governmental funds, the aggregate of all fund balances in any classification. Fund balance is the difference between governmental fund assets and deferred outflows of resources, and liabilities and deferred inflows of resources. It is sometimes referred to as fund equity. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_governmental_fund_balance
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_governmental_fund_balance': value }

        
        return result
        

    @total_governmental_fund_balance.setter
    def total_governmental_fund_balance(self, total_governmental_fund_balance):
        """Sets the total_governmental_fund_balance of this MunicipalityFinancial.

        For all governmental funds, the aggregate of all fund balances in any classification. Fund balance is the difference between governmental fund assets and deferred outflows of resources, and liabilities and deferred inflows of resources. It is sometimes referred to as fund equity. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues.  # noqa: E501

        :param total_governmental_fund_balance: The total_governmental_fund_balance of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._total_governmental_fund_balance = total_governmental_fund_balance

    @property
    def general_fund_revenues(self):
        """Gets the general_fund_revenues of this MunicipalityFinancial.  # noqa: E501

        Increases in financial resources attributable to the general fund. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund.  # noqa: E501

        :return: The general_fund_revenues of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._general_fund_revenues
        
    @property
    def general_fund_revenues_dict(self):
        """Gets the general_fund_revenues of this MunicipalityFinancial.  # noqa: E501

        Increases in financial resources attributable to the general fund. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The general_fund_revenues of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.general_fund_revenues
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'general_fund_revenues': value }

        
        return result
        

    @general_fund_revenues.setter
    def general_fund_revenues(self, general_fund_revenues):
        """Sets the general_fund_revenues of this MunicipalityFinancial.

        Increases in financial resources attributable to the general fund. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund.  # noqa: E501

        :param general_fund_revenues: The general_fund_revenues of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._general_fund_revenues = general_fund_revenues

    @property
    def general_fund_expenditures(self):
        """Gets the general_fund_expenditures of this MunicipalityFinancial.  # noqa: E501

        Decreases in financial resources attributable to the general fund. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund.  # noqa: E501

        :return: The general_fund_expenditures of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._general_fund_expenditures
        
    @property
    def general_fund_expenditures_dict(self):
        """Gets the general_fund_expenditures of this MunicipalityFinancial.  # noqa: E501

        Decreases in financial resources attributable to the general fund. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The general_fund_expenditures of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.general_fund_expenditures
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'general_fund_expenditures': value }

        
        return result
        

    @general_fund_expenditures.setter
    def general_fund_expenditures(self, general_fund_expenditures):
        """Sets the general_fund_expenditures of this MunicipalityFinancial.

        Decreases in financial resources attributable to the general fund. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund.  # noqa: E501

        :param general_fund_expenditures: The general_fund_expenditures of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._general_fund_expenditures = general_fund_expenditures

    @property
    def general_fund_revenues_over_under_expenditure(self):
        """Gets the general_fund_revenues_over_under_expenditure of this MunicipalityFinancial.  # noqa: E501

        Difference between general fund revenues and expenditures.  If positive, this amount is called a surplus.  If negative, it represents a deficit. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund.  # noqa: E501

        :return: The general_fund_revenues_over_under_expenditure of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._general_fund_revenues_over_under_expenditure
        
    @property
    def general_fund_revenues_over_under_expenditure_dict(self):
        """Gets the general_fund_revenues_over_under_expenditure of this MunicipalityFinancial.  # noqa: E501

        Difference between general fund revenues and expenditures.  If positive, this amount is called a surplus.  If negative, it represents a deficit. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The general_fund_revenues_over_under_expenditure of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.general_fund_revenues_over_under_expenditure
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'general_fund_revenues_over_under_expenditure': value }

        
        return result
        

    @general_fund_revenues_over_under_expenditure.setter
    def general_fund_revenues_over_under_expenditure(self, general_fund_revenues_over_under_expenditure):
        """Sets the general_fund_revenues_over_under_expenditure of this MunicipalityFinancial.

        Difference between general fund revenues and expenditures.  If positive, this amount is called a surplus.  If negative, it represents a deficit. The general fund is used to account for and report all financial resources not accounted for and reported in another governmental fund.  # noqa: E501

        :param general_fund_revenues_over_under_expenditure: The general_fund_revenues_over_under_expenditure of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._general_fund_revenues_over_under_expenditure = general_fund_revenues_over_under_expenditure

    @property
    def governmental_fund_revenues(self):
        """Gets the governmental_fund_revenues of this MunicipalityFinancial.  # noqa: E501

        Increases in financial resources attributable to any governmental fund. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues.  # noqa: E501

        :return: The governmental_fund_revenues of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._governmental_fund_revenues
        
    @property
    def governmental_fund_revenues_dict(self):
        """Gets the governmental_fund_revenues of this MunicipalityFinancial.  # noqa: E501

        Increases in financial resources attributable to any governmental fund. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The governmental_fund_revenues of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.governmental_fund_revenues
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'governmental_fund_revenues': value }

        
        return result
        

    @governmental_fund_revenues.setter
    def governmental_fund_revenues(self, governmental_fund_revenues):
        """Sets the governmental_fund_revenues of this MunicipalityFinancial.

        Increases in financial resources attributable to any governmental fund. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues.  # noqa: E501

        :param governmental_fund_revenues: The governmental_fund_revenues of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._governmental_fund_revenues = governmental_fund_revenues

    @property
    def governmental_fund_expenditures(self):
        """Gets the governmental_fund_expenditures of this MunicipalityFinancial.  # noqa: E501

        Decreases in financial resources attributable to any governmental fund. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues.  # noqa: E501

        :return: The governmental_fund_expenditures of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._governmental_fund_expenditures
        
    @property
    def governmental_fund_expenditures_dict(self):
        """Gets the governmental_fund_expenditures of this MunicipalityFinancial.  # noqa: E501

        Decreases in financial resources attributable to any governmental fund. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The governmental_fund_expenditures of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.governmental_fund_expenditures
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'governmental_fund_expenditures': value }

        
        return result
        

    @governmental_fund_expenditures.setter
    def governmental_fund_expenditures(self, governmental_fund_expenditures):
        """Sets the governmental_fund_expenditures of this MunicipalityFinancial.

        Decreases in financial resources attributable to any governmental fund. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues.  # noqa: E501

        :param governmental_fund_expenditures: The governmental_fund_expenditures of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._governmental_fund_expenditures = governmental_fund_expenditures

    @property
    def governmental_fund_revenues_over_under_expenditure(self):
        """Gets the governmental_fund_revenues_over_under_expenditure of this MunicipalityFinancial.  # noqa: E501

        Difference between revenues and expenditures attributable to all governmental funds.  If positive, this amount is called a surplus.  If negative, it represents a deficit. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues.  # noqa: E501

        :return: The governmental_fund_revenues_over_under_expenditure of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """
        return self._governmental_fund_revenues_over_under_expenditure
        
    @property
    def governmental_fund_revenues_over_under_expenditure_dict(self):
        """Gets the governmental_fund_revenues_over_under_expenditure of this MunicipalityFinancial.  # noqa: E501

        Difference between revenues and expenditures attributable to all governmental funds.  If positive, this amount is called a surplus.  If negative, it represents a deficit. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The governmental_fund_revenues_over_under_expenditure of this MunicipalityFinancial.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.governmental_fund_revenues_over_under_expenditure
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'governmental_fund_revenues_over_under_expenditure': value }

        
        return result
        

    @governmental_fund_revenues_over_under_expenditure.setter
    def governmental_fund_revenues_over_under_expenditure(self, governmental_fund_revenues_over_under_expenditure):
        """Sets the governmental_fund_revenues_over_under_expenditure of this MunicipalityFinancial.

        Difference between revenues and expenditures attributable to all governmental funds.  If positive, this amount is called a surplus.  If negative, it represents a deficit. Governmental funds are used to account for general government activities that are financed primarily through taxes, intergovernmental revenues, and other nonexchange revenues.  # noqa: E501

        :param governmental_fund_revenues_over_under_expenditure: The governmental_fund_revenues_over_under_expenditure of this MunicipalityFinancial.  # noqa: E501
        :type: float
        """

        self._governmental_fund_revenues_over_under_expenditure = governmental_fund_revenues_over_under_expenditure

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MunicipalityFinancial):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
