# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fuzzy_couscous', 'fuzzy_couscous.commands']

package_data = \
{'': ['*']}

install_requires = \
['dict-deep>=4.1.2,<5.0.0',
 'python-dotenv>=0.21.0,<0.22.0',
 'rich>=12.6.0,<13.0.0',
 'tomli-w>=1.0.0,<2.0.0',
 'tomli>=2.0.1,<3.0.0',
 'typer>=0.7.0,<0.8.0']

entry_points = \
{'console_scripts': ['cuzzy = fuzzy_couscous.main:cli',
                     'fuzzy-couscous = fuzzy_couscous.main:cli']}

setup_kwargs = {
    'name': 'fuzzy-couscous',
    'version': '2.0.0',
    'description': 'Generate a django project from the fuzzy-couscous template.',
    'long_description': '# fuzzy-couscous\n\n[![pypi](https://badge.fury.io/py/fuzzy-couscous.svg)](https://pypi.org/project/fuzzy-couscous/)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![MIT License](https://img.shields.io/apm/l/atomic-design-ui.svg?)](https://github.com/Tobi-De/fuzzy-couscous/blob/master/LICENSE)\n[![Code style: djlint](https://img.shields.io/badge/html%20style-djlint-blue.svg)](https://www.djlint.com)\n[![linting: pylint](https://img.shields.io/badge/linting-pylint-yellowgreen)](https://github.com/PyCQA/pylint)\n\nMy highly opinionated django project template based on [django\'s startproject --template](https://docs.djangoproject.com/en/stable/ref/django-admin/#startproject). This project is heavily inspired by [cookiecutter-django](https://github.com/cookiecutter/cookiecutter-django) but is meant to be a lighter version.\n\n## Features\n\n- Django 4+\n- Python 3.10+\n- Frontend: [htmx](https://htmx.org/) with [editor support](https://oluwatobi.dev/blog/posts/htmx-support-in-pycharm/) using [web-types](https://github.com/JetBrains/web-types#web-types)\n- Template fragment with [django-render-block](https://github.com/clokep/django-render-block)\n- Secure production settings, https only.\n- Settings using [django-environ](https://github.com/joke2k/django-environ)\n- Login / signup via [django-allauth](https://github.com/pennersr/django-allauth)\n- Custom user model based on [django-improved-user](https://github.com/jambonsw/django-improved-user)\n- Login using email instead of username\n- Automatically reload your browser in development via [django-browser-reload](https://github.com/adamchainz/django-browser-reload)\n- Better development experience with [django-fastdev](https://github.com/boxed/django-fastdev)\n- [Amazon SES](https://aws.amazon.com/ses/?nc1=h_ls) for production email via [Anymail](https://github.com/anymail/django-anymail)\n- [Docker](https://www.docker.com/) ready for production\n- Optional production cache settings using the `CACHE_URL` or `REDIS_URL` environment variables.\n- `captain-definition` for deploying to [caprover](https://caprover.com/)\n- [Sentry](https://sentry.io/welcome/) for performance/error monitoring\n- Serve static files with [Whitenoise](https://whitenoise.evans.io/en/latest/)\n- Default integration with [pre-commit](https://github.com/pre-commit/pre-commit) for identifying simple issues before submission to code review\n- Integrated task runner with [poethepoet](https://github.com/nat-n/poethepoet)\n- Dependency management using [poetry](https://github.com/python-poetry/poetry)\n\n## Templates\n\nI use github branches to create variations of the base template.\n\n- [main](https://github.com/Tobi-De/fuzzy-couscous): The base template\n- [tailwind](https://github.com/Tobi-De/fuzzy-couscous/tree/tailwind): The base template + [tailwindcss](https://github.com/timonweb/pytailwindcss)  via [pytailwindcss](https://github.com/timonweb/pytailwindcss)\n- [bootstrap](https://github.com/Tobi-De/fuzzy-couscous/tree/bootstrap): The base template + [bootstrap5](https://getbootstrap.com/) via [django-bootstrap5](https://github.com/zostera/django-bootstrap5)\n\n## Usage\n\n>**Note**: `fuzzy-couscous` is a bit long to type each time, so there is an alias `cuzzy` that you can use instead.\n\nSince this template uses [django\'s startproject --template](https://docs.djangoproject.com/en/stable/ref/django-admin/#startproject), you can\neasily clone the project on your computer and generate a django project by using the command `django-admin` and specifying the `fuzzy-couscous/project_name` folder as the template.\nThe final command is a bit long so I made a simple [cli](https://en.wikipedia.org/wiki/Command-line_interface) to simplify the process, install it with the command below:\n\n```shell\npip install fuzzy-couscous==2.0.0\n```\n\nnow initialize a new django project with the command below:\n\n```shell\nfuzzy-couscous make my_new_project\n```\nor\n\n```shell\ncuzzy make my_new_project\n```\n\n> **NOTE**: You probably want to update the **authors** key in the `pyproject.toml` file in the `[tool.poetry]` section.\n\nThis command may take two optional arguments:\n\n`--repo (-r)`: This template makes a lot of assumptions, if you like it but want to make some slight adjustments, make your own couscous by [forking this repo](https://github.com/Tobi-De/fuzzy-couscous/fork). \nYou can then use this option to specify your github repository with the format `username/repo`.\n\nExample:\n\n```python\nfuzzy-couscous make my_new_site --repo "Tobi-De/fuzzy-couscous"\n```\n\n`--branch (-b)`: Specify the branch from which you want to create the template (e.g. **tailwind**), the default value being **main**.\n\nExample:\n\n```python\nfuzzy-couscous make my_new_site -b tailwind\n```\n\nIf you\'ve read this far and still think this template doesn\'t work for you, feel free to [create your own template](https://www.valentinog.com/blog/django-project/)\nand copy and paste what you want from other similar projects like I did.\n\nSome examples of templates you can use as inspiration:\n\n- [cookiecutter-django](https://github.com/cookiecutter/cookiecutter-django)\n- [wemake-django-template](https://github.com/wemake-services/wemake-django-template)\n- [django-startproject-templates](https://github.com/adamchainz/django-startproject-templates)\n\n### Additional commands\n\nSome additional commands I added to automate some boring stuff. These commands should be run at the root of\nyour projects, most will work even in projects that have not been generated with this template.\n\nUsage\n```shell\nfuzzy-couscous command\n```\n\n`write-env`: Running this will create a new `.env` by filling the file with the keys and values from the following options:\n\n1. a `env.template` file, used if it exists\n2. a `DEFAULT_VALUES` dictionary, internal to the `fuzzy-couscous` package, contains some default for common keys, `DJANGO_DEBUG`, `DJANGO_SECRET_KEY`, etc.\n3. a `.env` file, used if it exists\n\n> **Note**: The order defines the priority of the values that are used, which means that the values contained in your original `.env` file are preserved if the file exists.\n\nThis command defines two additional optional options:\n\n- `--fill-missing (-f)`: Prompt for missing values before the final `.env` file is generated\n- `--output-file (-o)`: The output filename, default to `.env`\n\n`work`: run multiple command in parallel. When working with tailwind, I usually have to run the django `runserver` command and \nthe tailwind `compile` command, so I made this to run both in one command. This command use the python [subprocess](https://docs.python.org/3/library/subprocess.html) module to \nrun the commands in the same shell. By default it will try to run the two commands below:\n\n- `poe r`: run the django development server\n- `poe t`: Compile tailwind in watch mode, available if you create your project using the `tailwind` branch\n\nTo specify your own commands, use the `-c` option, example:\n\n```shell\nfuzzy-coucsous work -c "python manage.py runserver" -c "python -m http.server 9000"\n```\n\n## Tips\n\nThis section gathers tips, **copy and paste** configurations and package recommendations that I use quite often in my projects to solve specific problems.\n\n### Settings\n\nIf there is a setting in `settings.py` or elsewhere that you don\'t understand, go to the [official django settings reference page](https://docs.djangoproject.com/en/dev/ref/settings/)\nand press <kbd>Ctrl</kbd> + <kbd>F</kbd> to search for it. I used the [django-production](https://github.com/lincolnloop/django-production) package to configure the production settings which I then customized.\nI have removed the package as a dependency but I advise you to go and check for yourself what is available.\n\n### Dynamic web pages\n\n[HTMX](https://htmx.org/) for simple interactive elements, [django-unicorn](https://github.com/adamghill/django-unicorn) if I need something more integrated with django.\nIt\'s not a binary choice, you can use both, the main advantage for me is the simplicity compared to a frontend javascript framework.\n\n> **Note**: If you use [htmx boost](https://htmx.org/docs/#boosting) + [debug toolbar](https://github.com/jazzband/django-debug-toolbar) (already included in the template), you will need [this](https://django-debug-toolbar.readthedocs.io/en/latest/installation.html#htmx).\n\n### Task queues and schedulers\n\nTask queues are used to offload tasks to a dedicated worker process when the processing of those tasks does not fit into a traditional request-response cycle.\nBasically, if you need to do something that might take too long to process and whose result does not need to be shown immediately to the user, you use a queue manager.\nSchedulers are used to periodically run tasks.\nThere are many options available in the [django third-party ecosystem](https://djangopackages.org/grids/g/workers-queues-tasks/), some focus solely on providing a task queue, \nothers are just schedulers and many of them provide both in one package. You can also search for purely python solutions and \nintegrate them into your django project yourself.\n\nI prefer options that do not require additional infrastructure (redis, rabbitmq, etc.) for simple tasks.\nFor more complex tasks, I tend to choose a solution that supports redis as a task broker.\n\n**Doesn\'t require setup of external tools, redis, rabbitmq, etc..**\n\n- [django-chard](https://github.com/drpancake/chard): Task queue \n- [django-pgpubsub](https://github.com/Opus10/django-pgpubsub): Task queue \n- [procrastinate](https://github.com/procrastinate-org/procrastinate): Task queue + scheduler\n- [django-q2](https://github.com/GDay/django-q2): Task queue + scheduler\n- [rocketry](https://github.com/Miksus/rocketry): Scheduler\n\n**Require the setup of external tools, redis, rabbitmq, etc.**\n\n- [django-dramatiq](https://github.com/Bogdanp/django_dramatiq): Task queue \n- [django-rq](https://github.com/rq/django-rq): Task queue + scheduler via [django-rq-scheduler](https://github.com/dsoftwareinc/django-rq-scheduler)\n- [wakaq](https://github.com/wakatime/wakaq): Task queue + scheduler\n\n> **Note**: The order matters, that\'s the order in which I would choose one of these packages.\n\n### Media storage\n\nMedia files in django usually refer to files uploaded by users, profile pictures, product images, etc.\nI usually manage my media files using [django-storages](https://github.com/jschneier/django-storages).\nHere is how I set it up.\n\n```python\n# core/storages.py\nfrom storages.backends.s3boto3 import S3Boto3Storage\n\nclass MediaRootS3Boto3Storage(S3Boto3Storage):\n    location = "media"\n    file_overwrite = False\n\n    \n# settings.py - production settings\nAWS_ACCESS_KEY_ID = env("DJANGO_AWS_ACCESS_KEY_ID")\nAWS_SECRET_ACCESS_KEY = env("DJANGO_AWS_SECRET_ACCESS_KEY")\nAWS_STORAGE_BUCKET_NAME = env("DJANGO_AWS_STORAGE_BUCKET_NAME")\nDEFAULT_FILE_STORAGE = "project_name.core.storages.MediaRootS3Boto3Storage"\nMEDIA_URL = f"https://{AWS_STORAGE_BUCKET_NAME}.s3.amazonaws.com/media/"\n```\n\n### Database backup\n\nWhenever possible, take advantage of a fully managed database solution, they usually offer automatic backup of your databases.\nIn my opinion, this is the best option if you don\'t want to deal with the hassle of managing your own database.\n\n- [Amazon RDS](https://aws.amazon.com/rds/)\n- [Linode Managed Databases](https://www.linode.com/products/databases/)\n- [DigitalOcean Managed Databases](https://www.digitalocean.com/products/managed-databases)\n- [Heroku postgres](https://www.heroku.com/postgres)\n\nFor specific postgresql options, see their [hosting support page](https://www.postgresql.org/support/professional_hosting/).\n\nHowever, if for some reason you want / need to manage your database yourself and just want an automatic backup solution\nthen [django-dbbackup](https://github.com/jazzband/django-dbbackup) is what you need. You can use one of the scheduling \npackages discussed above to periodically run the backup command.\n\n### Health check your django project\n\n**Health check** is about making sure that your django application and related services are always available / running. \nMy go-to package for this is [django-health-check](https://github.com/revsys/django-health-check).\nAfter installing and configuring **django-health-check**, you need to associate it with an uptime monitoring service, this\nis the service that will periodically call your **health-check** endpoint to make sure everything is fine.\nHere is a list of available options.\n\n- [upptime](https://github.com/upptime/upptime)\n- [uptime-kuma](https://github.com/louislam/uptime-kuma)\n- [uptimerobot](https://uptimerobot.com/)\n- [glitchtip](https://glitchtip.com/)\n\nRead more on the health check pattern [here](https://learn.microsoft.com/en-us/azure/architecture/patterns/health-endpoint-monitoring). \n\n### Extra that I haven\'t tried myself yet\n\n- [django-linear-migrations](https://github.com/adamchainz/django-linear-migrations): Read [introduction post](https://adamj.eu/tech/2020/12/10/introducing-django-linear-migrations/)\n- [django-read-only](https://github.com/adamchainz/django-read-only): Disable Django database writes.\n\n## Documentation\n\nThis template does not include a documentation setup, but it is very important for most projects (at least it should be) \nto have a documentation site, especially if you are not working alone. Here are the options I would suggest for setting \nup a documentation, recently I tend to favor the first one.\n\n- [Mkdocs](https://www.mkdocs.org/) with the [Material theme](https://squidfunk.github.io/mkdocs-material/getting-started/)\n- [Sphinx](https://www.sphinx-doc.org/en/master/) with the [Furo theme](https://github.com/pradyunsg/furo)\n\nThere is a chance that in the future I will include the docs directly in the template but for now here is a quick guide to \nconfigure mkdocs with the material theme:\n\n### Installation and configurations\n\nCopy the configuration below into your `pyproject.toml` file under the `[tool.poetry.dependencies]` section.\n\n```toml\n[tool.poetry.group.docs]\noptional = true\n\n[tool.poetry.group.docs.dependencies]\nmkdocs = "^1.4.2"\nmkdocs-material = "^8.5.10"\nmkdocs-material-extensions = "^1.1.1"\nmkdocs-include-markdown-plugin = "^3.9.1"\n```\n\nInstall the new dependencies.\n\n```shell\npoetry install --with docs\n```\n\nCreate your new **mkdocs** site.\n\n```shell\nmkdocs new .\n```\n\nUpdate the `mkdocs.yml` file to specify the **material** theme, your configuration should look like this:\n\n```yaml\nsite_name: My Docs # change this to the name of your project\ntheme:\n  name: material\n```\n\nIf you noticed, the dependencies added above via the section `[tool.poetry.group.docs.dependencies]` include more than just \nmkdocs and the material theme, specifically :\n\n- [mkdocs-material-extensions](https://github.com/facelessuser/mkdocs-material-extensions): Markdown extension resources for MkDocs for Material\n- [mkdocs-include-markdown-plugin](https://github.com/mondeja/mkdocs-include-markdown-plugin):  Include other markdown files in your mkdocs site \n\nFor a complete example of how I configure them in projects, see this [configuration file](https://github.com/Tobi-De/dj-shop-cart/blob/master/mkdocs.yml).\n\n### Deploy your documentation\n\n**Mkdocs** can turn your documentation into a static site that you can host anywhere, [netlify](https://www.netlify.com/), [github pages](https://pages.github.com/), etc.\nTo build your site, run the command below and you will have a new `site` directory at the root of your project:\n\n```shell\nmkdocs build\n```\n\nThis folder contains everything that is necessary to deploy your static site.\n\nIf you choose the **github pages** route, you can automate the process with [github actions](https://github.com/features/actions), \nthe official **mkdocs-material** documentation explains [how to do it](https://squidfunk.github.io/mkdocs-material/publishing-your-site/).\nTo use github actions, you will probably need a `requirements.txt` file, you can generate one with only what is needed\nto build the docs with the command below.\n\n```shell\npoetry export -f requirements.txt --output docs/requirements.txt --without-hashes --only docs\n```\n\nRead the [mkdocs](https://www.mkdocs.org/) and [mkdocs-material](https://squidfunk.github.io/mkdocs-material/getting-started/) docs for more advanced configurations and details on what is possible.\n\n## Deployment\n\nThis template was configured to simplify deployment on [caprover](https://caprover.com/), since that is what I use 99% of the time.\n\n> CapRover is an extremely easy to use app/database deployment & web server manager for your NodeJS, Python, PHP, ASP.NET, Ruby, MySQL, MongoDB, Postgres, WordPress (and etc...) applications!\n> **Official site**\n\nCapRover is a self-hosted [PaaS](https://en.wikipedia.org/wiki/Platform_as_a_service) solution, think [heroku](https://www.heroku.com/) but on your own servers. \nNowadays, I tend to prefer PaaS solutions over manual deployment and configuration, as they are easy to use with little configuration to deploy most apps.\nSoftware is usually quite a pain to deploy and even though I\'ve gotten better at it over time, I\'ll always choose a managed solution over manual deployment. \nSome other options than **CapRover** are:\n\n- [Dokku](https://dokku.com/) (self hosted)\n- [Fly](https://fly.io/) (hosted)\n- [Render](https://render.com/) (hosted)\n- [Coolify](https://github.com/coollabsio/coolify) (self hosted)\n- [DigitalOcean App Platform](https://www.digitalocean.com/products/app-platform) (hosted)\n- [AWS Elastic Beanstalk](https://aws.amazon.com/elasticbeanstalk/) (hosted)\n- [Btn](https://btn.dev/) (hosted and not ready yet)\n\nI find that self-hosted solutions are generally cheaper than managed/hosted solutions, but I don\'t have much experience with managed solutions, \nso I could be wrong, do your own research and if you can afford it, try them out to see what works best for you.\n\nAfter installing CaProver with the [getting started guide](https://caprover.com/docs/get-started.html), there is not much left to do, create a new application and in the section `deployment`.\nconfigure your application using the third method `Method 3: Deploy from Github/Bitbucket/Gitlab`.\n\n> **Note**: If you use github, instead of entering your password directly into the `password` field, you can use a [personal access token](https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token),\n> which is a more secure option.\n\n> **Tip**: Checkout [caprover automatic deploy](https://caprover.com/docs/deployment-methods.html#automatic-deploy-using-github-bitbucket-and-etc) to automate the deployment of your applications.\n',
    'author': 'Tobi-De',
    'author_email': 'tobidegnon@proton.me',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/Tobi-De/fuzzy-couscous',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
