# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class TranscriptTopic(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TranscriptTopic - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'topic_phrase': 'str',
            'transcript_phrase': 'str',
            'confidence': 'int',
            'start_time_milliseconds': 'int',
            'duration': 'TopicDuration',
            'offset': 'TopicOffset',
            'recording_location': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'topic_phrase': 'topicPhrase',
            'transcript_phrase': 'transcriptPhrase',
            'confidence': 'confidence',
            'start_time_milliseconds': 'startTimeMilliseconds',
            'duration': 'duration',
            'offset': 'offset',
            'recording_location': 'recordingLocation'
        }

        self._id = None
        self._name = None
        self._topic_phrase = None
        self._transcript_phrase = None
        self._confidence = None
        self._start_time_milliseconds = None
        self._duration = None
        self._offset = None
        self._recording_location = None

    @property
    def id(self):
        """
        Gets the id of this TranscriptTopic.
        The globally unique identifier for the object.

        :return: The id of this TranscriptTopic.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TranscriptTopic.
        The globally unique identifier for the object.

        :param id: The id of this TranscriptTopic.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this TranscriptTopic.
        The name of the object.

        :return: The name of this TranscriptTopic.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this TranscriptTopic.
        The name of the object.

        :param name: The name of this TranscriptTopic.
        :type: str
        """
        

        self._name = name

    @property
    def topic_phrase(self):
        """
        Gets the topic_phrase of this TranscriptTopic.
        The phrase which detected the topic. 

        :return: The topic_phrase of this TranscriptTopic.
        :rtype: str
        """
        return self._topic_phrase

    @topic_phrase.setter
    def topic_phrase(self, topic_phrase):
        """
        Sets the topic_phrase of this TranscriptTopic.
        The phrase which detected the topic. 

        :param topic_phrase: The topic_phrase of this TranscriptTopic.
        :type: str
        """
        

        self._topic_phrase = topic_phrase

    @property
    def transcript_phrase(self):
        """
        Gets the transcript_phrase of this TranscriptTopic.
        The transcript phrase which detected the topic.

        :return: The transcript_phrase of this TranscriptTopic.
        :rtype: str
        """
        return self._transcript_phrase

    @transcript_phrase.setter
    def transcript_phrase(self, transcript_phrase):
        """
        Sets the transcript_phrase of this TranscriptTopic.
        The transcript phrase which detected the topic.

        :param transcript_phrase: The transcript_phrase of this TranscriptTopic.
        :type: str
        """
        

        self._transcript_phrase = transcript_phrase

    @property
    def confidence(self):
        """
        Gets the confidence of this TranscriptTopic.
        The detection confidence of the topic.

        :return: The confidence of this TranscriptTopic.
        :rtype: int
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence):
        """
        Sets the confidence of this TranscriptTopic.
        The detection confidence of the topic.

        :param confidence: The confidence of this TranscriptTopic.
        :type: int
        """
        

        self._confidence = confidence

    @property
    def start_time_milliseconds(self):
        """
        Gets the start_time_milliseconds of this TranscriptTopic.
        The start time of the topic phrase.

        :return: The start_time_milliseconds of this TranscriptTopic.
        :rtype: int
        """
        return self._start_time_milliseconds

    @start_time_milliseconds.setter
    def start_time_milliseconds(self, start_time_milliseconds):
        """
        Sets the start_time_milliseconds of this TranscriptTopic.
        The start time of the topic phrase.

        :param start_time_milliseconds: The start_time_milliseconds of this TranscriptTopic.
        :type: int
        """
        

        self._start_time_milliseconds = start_time_milliseconds

    @property
    def duration(self):
        """
        Gets the duration of this TranscriptTopic.


        :return: The duration of this TranscriptTopic.
        :rtype: TopicDuration
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """
        Sets the duration of this TranscriptTopic.


        :param duration: The duration of this TranscriptTopic.
        :type: TopicDuration
        """
        

        self._duration = duration

    @property
    def offset(self):
        """
        Gets the offset of this TranscriptTopic.
        Location of the phrase

        :return: The offset of this TranscriptTopic.
        :rtype: TopicOffset
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """
        Sets the offset of this TranscriptTopic.
        Location of the phrase

        :param offset: The offset of this TranscriptTopic.
        :type: TopicOffset
        """
        

        self._offset = offset

    @property
    def recording_location(self):
        """
        Gets the recording_location of this TranscriptTopic.
        Location of the phrase in the recording in milliseconds

        :return: The recording_location of this TranscriptTopic.
        :rtype: int
        """
        return self._recording_location

    @recording_location.setter
    def recording_location(self, recording_location):
        """
        Sets the recording_location of this TranscriptTopic.
        Location of the phrase in the recording in milliseconds

        :param recording_location: The recording_location of this TranscriptTopic.
        :type: int
        """
        

        self._recording_location = recording_location

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

