# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ReportingTurnIntentSlot(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ReportingTurnIntentSlot - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'value': 'str',
            'type': 'str',
            'confidence': 'float'
        }

        self.attribute_map = {
            'name': 'name',
            'value': 'value',
            'type': 'type',
            'confidence': 'confidence'
        }

        self._name = None
        self._value = None
        self._type = None
        self._confidence = None

    @property
    def name(self):
        """
        Gets the name of this ReportingTurnIntentSlot.
        The name of the slot.

        :return: The name of this ReportingTurnIntentSlot.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ReportingTurnIntentSlot.
        The name of the slot.

        :param name: The name of this ReportingTurnIntentSlot.
        :type: str
        """
        

        self._name = name

    @property
    def value(self):
        """
        Gets the value of this ReportingTurnIntentSlot.
        The value of the slot.

        :return: The value of this ReportingTurnIntentSlot.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this ReportingTurnIntentSlot.
        The value of the slot.

        :param value: The value of this ReportingTurnIntentSlot.
        :type: str
        """
        

        self._value = value

    @property
    def type(self):
        """
        Gets the type of this ReportingTurnIntentSlot.
        The NLU entity type of the slot (either builtin or user defined)

        :return: The type of this ReportingTurnIntentSlot.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ReportingTurnIntentSlot.
        The NLU entity type of the slot (either builtin or user defined)

        :param type: The type of this ReportingTurnIntentSlot.
        :type: str
        """
        

        self._type = type

    @property
    def confidence(self):
        """
        Gets the confidence of this ReportingTurnIntentSlot.
        The confidence score this slot received during detection.

        :return: The confidence of this ReportingTurnIntentSlot.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence):
        """
        Sets the confidence of this ReportingTurnIntentSlot.
        The confidence score this slot received during detection.

        :param confidence: The confidence of this ReportingTurnIntentSlot.
        :type: float
        """
        

        self._confidence = confidence

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

