# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class MessageContent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        MessageContent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'content_type': 'str',
            'location': 'ContentLocation',
            'attachment': 'ContentAttachment',
            'quick_reply': 'ContentQuickReply',
            'button_response': 'ContentButtonResponse',
            'generic': 'ContentGeneric',
            'list': 'ContentList',
            'template': 'ContentNotificationTemplate',
            'reactions': 'list[ContentReaction]',
            'mention': 'MessagingRecipient',
            'postback': 'ContentPostback',
            'story': 'ContentStory',
            'card': 'ContentCard',
            'carousel': 'ContentCarousel'
        }

        self.attribute_map = {
            'content_type': 'contentType',
            'location': 'location',
            'attachment': 'attachment',
            'quick_reply': 'quickReply',
            'button_response': 'buttonResponse',
            'generic': 'generic',
            'list': 'list',
            'template': 'template',
            'reactions': 'reactions',
            'mention': 'mention',
            'postback': 'postback',
            'story': 'story',
            'card': 'card',
            'carousel': 'carousel'
        }

        self._content_type = None
        self._location = None
        self._attachment = None
        self._quick_reply = None
        self._button_response = None
        self._generic = None
        self._list = None
        self._template = None
        self._reactions = None
        self._mention = None
        self._postback = None
        self._story = None
        self._card = None
        self._carousel = None

    @property
    def content_type(self):
        """
        Gets the content_type of this MessageContent.
        Type of this content element.

        :return: The content_type of this MessageContent.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this MessageContent.
        Type of this content element.

        :param content_type: The content_type of this MessageContent.
        :type: str
        """
        allowed_values = ["Attachment", "Location", "QuickReply", "Notification", "GenericTemplate", "ListTemplate", "Postback", "Reactions", "Mention", "ButtonResponse", "Story", "Card", "Carousel"]
        if content_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for content_type -> " + content_type)
            self._content_type = "outdated_sdk_version"
        else:
            self._content_type = content_type

    @property
    def location(self):
        """
        Gets the location of this MessageContent.
        Location content.

        :return: The location of this MessageContent.
        :rtype: ContentLocation
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this MessageContent.
        Location content.

        :param location: The location of this MessageContent.
        :type: ContentLocation
        """
        

        self._location = location

    @property
    def attachment(self):
        """
        Gets the attachment of this MessageContent.
        Attachment content.

        :return: The attachment of this MessageContent.
        :rtype: ContentAttachment
        """
        return self._attachment

    @attachment.setter
    def attachment(self, attachment):
        """
        Sets the attachment of this MessageContent.
        Attachment content.

        :param attachment: The attachment of this MessageContent.
        :type: ContentAttachment
        """
        

        self._attachment = attachment

    @property
    def quick_reply(self):
        """
        Gets the quick_reply of this MessageContent.
        Quick reply content.

        :return: The quick_reply of this MessageContent.
        :rtype: ContentQuickReply
        """
        return self._quick_reply

    @quick_reply.setter
    def quick_reply(self, quick_reply):
        """
        Sets the quick_reply of this MessageContent.
        Quick reply content.

        :param quick_reply: The quick_reply of this MessageContent.
        :type: ContentQuickReply
        """
        

        self._quick_reply = quick_reply

    @property
    def button_response(self):
        """
        Gets the button_response of this MessageContent.
        Button response content.

        :return: The button_response of this MessageContent.
        :rtype: ContentButtonResponse
        """
        return self._button_response

    @button_response.setter
    def button_response(self, button_response):
        """
        Sets the button_response of this MessageContent.
        Button response content.

        :param button_response: The button_response of this MessageContent.
        :type: ContentButtonResponse
        """
        

        self._button_response = button_response

    @property
    def generic(self):
        """
        Gets the generic of this MessageContent.
        Generic content (Deprecated).

        :return: The generic of this MessageContent.
        :rtype: ContentGeneric
        """
        return self._generic

    @generic.setter
    def generic(self, generic):
        """
        Sets the generic of this MessageContent.
        Generic content (Deprecated).

        :param generic: The generic of this MessageContent.
        :type: ContentGeneric
        """
        

        self._generic = generic

    @property
    def list(self):
        """
        Gets the list of this MessageContent.
        List content (Deprecated).

        :return: The list of this MessageContent.
        :rtype: ContentList
        """
        return self._list

    @list.setter
    def list(self, list):
        """
        Sets the list of this MessageContent.
        List content (Deprecated).

        :param list: The list of this MessageContent.
        :type: ContentList
        """
        

        self._list = list

    @property
    def template(self):
        """
        Gets the template of this MessageContent.
        Template notification content.

        :return: The template of this MessageContent.
        :rtype: ContentNotificationTemplate
        """
        return self._template

    @template.setter
    def template(self, template):
        """
        Sets the template of this MessageContent.
        Template notification content.

        :param template: The template of this MessageContent.
        :type: ContentNotificationTemplate
        """
        

        self._template = template

    @property
    def reactions(self):
        """
        Gets the reactions of this MessageContent.
        A set of reactions to a message.

        :return: The reactions of this MessageContent.
        :rtype: list[ContentReaction]
        """
        return self._reactions

    @reactions.setter
    def reactions(self, reactions):
        """
        Sets the reactions of this MessageContent.
        A set of reactions to a message.

        :param reactions: The reactions of this MessageContent.
        :type: list[ContentReaction]
        """
        

        self._reactions = reactions

    @property
    def mention(self):
        """
        Gets the mention of this MessageContent.
        Mention content.

        :return: The mention of this MessageContent.
        :rtype: MessagingRecipient
        """
        return self._mention

    @mention.setter
    def mention(self, mention):
        """
        Sets the mention of this MessageContent.
        Mention content.

        :param mention: The mention of this MessageContent.
        :type: MessagingRecipient
        """
        

        self._mention = mention

    @property
    def postback(self):
        """
        Gets the postback of this MessageContent.
        Structured message postback (Deprecated).

        :return: The postback of this MessageContent.
        :rtype: ContentPostback
        """
        return self._postback

    @postback.setter
    def postback(self, postback):
        """
        Sets the postback of this MessageContent.
        Structured message postback (Deprecated).

        :param postback: The postback of this MessageContent.
        :type: ContentPostback
        """
        

        self._postback = postback

    @property
    def story(self):
        """
        Gets the story of this MessageContent.
        Ephemeral story content.

        :return: The story of this MessageContent.
        :rtype: ContentStory
        """
        return self._story

    @story.setter
    def story(self, story):
        """
        Sets the story of this MessageContent.
        Ephemeral story content.

        :param story: The story of this MessageContent.
        :type: ContentStory
        """
        

        self._story = story

    @property
    def card(self):
        """
        Gets the card of this MessageContent.
        Card content

        :return: The card of this MessageContent.
        :rtype: ContentCard
        """
        return self._card

    @card.setter
    def card(self, card):
        """
        Sets the card of this MessageContent.
        Card content

        :param card: The card of this MessageContent.
        :type: ContentCard
        """
        

        self._card = card

    @property
    def carousel(self):
        """
        Gets the carousel of this MessageContent.
        Carousel content

        :return: The carousel of this MessageContent.
        :rtype: ContentCarousel
        """
        return self._carousel

    @carousel.setter
    def carousel(self, carousel):
        """
        Sets the carousel of this MessageContent.
        Carousel content

        :param carousel: The carousel of this MessageContent.
        :type: ContentCarousel
        """
        

        self._carousel = carousel

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

