# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class LastAttemptByColumnConditionSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        LastAttemptByColumnConditionSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'email_column_name': 'str',
            'sms_column_name': 'str',
            'operator': 'str',
            'value': 'str'
        }

        self.attribute_map = {
            'email_column_name': 'emailColumnName',
            'sms_column_name': 'smsColumnName',
            'operator': 'operator',
            'value': 'value'
        }

        self._email_column_name = None
        self._sms_column_name = None
        self._operator = None
        self._value = None

    @property
    def email_column_name(self):
        """
        Gets the email_column_name of this LastAttemptByColumnConditionSettings.
        The name of the contact column to evaluate for Email.

        :return: The email_column_name of this LastAttemptByColumnConditionSettings.
        :rtype: str
        """
        return self._email_column_name

    @email_column_name.setter
    def email_column_name(self, email_column_name):
        """
        Sets the email_column_name of this LastAttemptByColumnConditionSettings.
        The name of the contact column to evaluate for Email.

        :param email_column_name: The email_column_name of this LastAttemptByColumnConditionSettings.
        :type: str
        """
        

        self._email_column_name = email_column_name

    @property
    def sms_column_name(self):
        """
        Gets the sms_column_name of this LastAttemptByColumnConditionSettings.
        The name of the contact column to evaluate for SMS.

        :return: The sms_column_name of this LastAttemptByColumnConditionSettings.
        :rtype: str
        """
        return self._sms_column_name

    @sms_column_name.setter
    def sms_column_name(self, sms_column_name):
        """
        Sets the sms_column_name of this LastAttemptByColumnConditionSettings.
        The name of the contact column to evaluate for SMS.

        :param sms_column_name: The sms_column_name of this LastAttemptByColumnConditionSettings.
        :type: str
        """
        

        self._sms_column_name = sms_column_name

    @property
    def operator(self):
        """
        Gets the operator of this LastAttemptByColumnConditionSettings.
        The operator to use when comparing values.

        :return: The operator of this LastAttemptByColumnConditionSettings.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this LastAttemptByColumnConditionSettings.
        The operator to use when comparing values.

        :param operator: The operator of this LastAttemptByColumnConditionSettings.
        :type: str
        """
        allowed_values = ["Before", "After"]
        if operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operator -> " + operator)
            self._operator = "outdated_sdk_version"
        else:
            self._operator = operator

    @property
    def value(self):
        """
        Gets the value of this LastAttemptByColumnConditionSettings.
        The period value to compare against the contact's data.

        :return: The value of this LastAttemptByColumnConditionSettings.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this LastAttemptByColumnConditionSettings.
        The period value to compare against the contact's data.

        :param value: The value of this LastAttemptByColumnConditionSettings.
        :type: str
        """
        

        self._value = value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

