# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class KnowledgeImportJobSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        KnowledgeImportJobSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'import_as_new': 'bool',
            'visible': 'bool',
            'category_id': 'str',
            'label_ids': 'list[str]'
        }

        self.attribute_map = {
            'import_as_new': 'importAsNew',
            'visible': 'visible',
            'category_id': 'categoryId',
            'label_ids': 'labelIds'
        }

        self._import_as_new = None
        self._visible = None
        self._category_id = None
        self._label_ids = None

    @property
    def import_as_new(self):
        """
        Gets the import_as_new of this KnowledgeImportJobSettings.
        If enabled import creates a new document even if update is available.

        :return: The import_as_new of this KnowledgeImportJobSettings.
        :rtype: bool
        """
        return self._import_as_new

    @import_as_new.setter
    def import_as_new(self, import_as_new):
        """
        Sets the import_as_new of this KnowledgeImportJobSettings.
        If enabled import creates a new document even if update is available.

        :param import_as_new: The import_as_new of this KnowledgeImportJobSettings.
        :type: bool
        """
        

        self._import_as_new = import_as_new

    @property
    def visible(self):
        """
        Gets the visible of this KnowledgeImportJobSettings.
        If specified, import will override the visibility of the imported documents.

        :return: The visible of this KnowledgeImportJobSettings.
        :rtype: bool
        """
        return self._visible

    @visible.setter
    def visible(self, visible):
        """
        Sets the visible of this KnowledgeImportJobSettings.
        If specified, import will override the visibility of the imported documents.

        :param visible: The visible of this KnowledgeImportJobSettings.
        :type: bool
        """
        

        self._visible = visible

    @property
    def category_id(self):
        """
        Gets the category_id of this KnowledgeImportJobSettings.
        If specified, import will override the category of the imported documents.

        :return: The category_id of this KnowledgeImportJobSettings.
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """
        Sets the category_id of this KnowledgeImportJobSettings.
        If specified, import will override the category of the imported documents.

        :param category_id: The category_id of this KnowledgeImportJobSettings.
        :type: str
        """
        

        self._category_id = category_id

    @property
    def label_ids(self):
        """
        Gets the label_ids of this KnowledgeImportJobSettings.
        If specified, import will add this labels to the imported documents.

        :return: The label_ids of this KnowledgeImportJobSettings.
        :rtype: list[str]
        """
        return self._label_ids

    @label_ids.setter
    def label_ids(self, label_ids):
        """
        Sets the label_ids of this KnowledgeImportJobSettings.
        If specified, import will add this labels to the imported documents.

        :param label_ids: The label_ids of this KnowledgeImportJobSettings.
        :type: list[str]
        """
        

        self._label_ids = label_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

