# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AddWorkPlanRotationRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AddWorkPlanRotationRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'date_range': 'DateRangeWithOptionalEnd',
            'agents': 'list[AddWorkPlanRotationAgentRequest]',
            'pattern': 'WorkPlanPatternRequest'
        }

        self.attribute_map = {
            'name': 'name',
            'date_range': 'dateRange',
            'agents': 'agents',
            'pattern': 'pattern'
        }

        self._name = None
        self._date_range = None
        self._agents = None
        self._pattern = None

    @property
    def name(self):
        """
        Gets the name of this AddWorkPlanRotationRequest.
        Name of this work plan rotation

        :return: The name of this AddWorkPlanRotationRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AddWorkPlanRotationRequest.
        Name of this work plan rotation

        :param name: The name of this AddWorkPlanRotationRequest.
        :type: str
        """
        

        self._name = name

    @property
    def date_range(self):
        """
        Gets the date_range of this AddWorkPlanRotationRequest.
        The date range to which this work plan rotation applies

        :return: The date_range of this AddWorkPlanRotationRequest.
        :rtype: DateRangeWithOptionalEnd
        """
        return self._date_range

    @date_range.setter
    def date_range(self, date_range):
        """
        Sets the date_range of this AddWorkPlanRotationRequest.
        The date range to which this work plan rotation applies

        :param date_range: The date_range of this AddWorkPlanRotationRequest.
        :type: DateRangeWithOptionalEnd
        """
        

        self._date_range = date_range

    @property
    def agents(self):
        """
        Gets the agents of this AddWorkPlanRotationRequest.
        Agents in this work plan rotation

        :return: The agents of this AddWorkPlanRotationRequest.
        :rtype: list[AddWorkPlanRotationAgentRequest]
        """
        return self._agents

    @agents.setter
    def agents(self, agents):
        """
        Sets the agents of this AddWorkPlanRotationRequest.
        Agents in this work plan rotation

        :param agents: The agents of this AddWorkPlanRotationRequest.
        :type: list[AddWorkPlanRotationAgentRequest]
        """
        

        self._agents = agents

    @property
    def pattern(self):
        """
        Gets the pattern of this AddWorkPlanRotationRequest.
        Pattern with list of work plan IDs that rotate on a weekly basis

        :return: The pattern of this AddWorkPlanRotationRequest.
        :rtype: WorkPlanPatternRequest
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern):
        """
        Sets the pattern of this AddWorkPlanRotationRequest.
        Pattern with list of work plan IDs that rotate on a weekly basis

        :param pattern: The pattern of this AddWorkPlanRotationRequest.
        :type: WorkPlanPatternRequest
        """
        

        self._pattern = pattern

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

