# coding: utf-8

"""
WorkforceManagementApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class WorkforceManagementApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_workforcemanagement_businessunit(self, business_unit_id, **kwargs):
        """
        Delete business unit
        A business unit cannot be deleted if it contains one or more management units

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_businessunit(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit, or 'mine' for the business unit of the logged-in user. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_businessunit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `delete_workforcemanagement_businessunit`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_businessunit_activitycode(self, business_unit_id, activity_code_id, **kwargs):
        """
        Deletes an activity code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_businessunit_activitycode(business_unit_id, activity_code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit, or 'mine' for the business unit of the logged-in user. (required)
        :param str activity_code_id: The ID of the activity code to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'activity_code_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_businessunit_activitycode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `delete_workforcemanagement_businessunit_activitycode`")
        # verify the required parameter 'activity_code_id' is set
        if ('activity_code_id' not in params) or (params['activity_code_id'] is None):
            raise ValueError("Missing the required parameter `activity_code_id` when calling `delete_workforcemanagement_businessunit_activitycode`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/activitycodes/{activityCodeId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'activity_code_id' in params:
            path_params['activityCodeId'] = params['activity_code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_businessunit_planninggroup(self, business_unit_id, planning_group_id, **kwargs):
        """
        Deletes the planning group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_businessunit_planninggroup(business_unit_id, planning_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit. (required)
        :param str planning_group_id: The ID of a planning group to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'planning_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_businessunit_planninggroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `delete_workforcemanagement_businessunit_planninggroup`")
        # verify the required parameter 'planning_group_id' is set
        if ('planning_group_id' not in params) or (params['planning_group_id'] is None):
            raise ValueError("Missing the required parameter `planning_group_id` when calling `delete_workforcemanagement_businessunit_planninggroup`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups/{planningGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'planning_group_id' in params:
            path_params['planningGroupId'] = params['planning_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_businessunit_scheduling_run(self, business_unit_id, run_id, **kwargs):
        """
        Cancel a scheduling run
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_businessunit_scheduling_run(business_unit_id, run_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param str run_id: The ID of the schedule run (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'run_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_businessunit_scheduling_run" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `delete_workforcemanagement_businessunit_scheduling_run`")
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params) or (params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `delete_workforcemanagement_businessunit_scheduling_run`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'run_id' in params:
            path_params['runId'] = params['run_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_businessunit_servicegoaltemplate(self, business_unit_id, service_goal_template_id, **kwargs):
        """
        Delete a service goal template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_businessunit_servicegoaltemplate(business_unit_id, service_goal_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit. (required)
        :param str service_goal_template_id: The ID of the service goal template to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'service_goal_template_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_businessunit_servicegoaltemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `delete_workforcemanagement_businessunit_servicegoaltemplate`")
        # verify the required parameter 'service_goal_template_id' is set
        if ('service_goal_template_id' not in params) or (params['service_goal_template_id'] is None):
            raise ValueError("Missing the required parameter `service_goal_template_id` when calling `delete_workforcemanagement_businessunit_servicegoaltemplate`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates/{serviceGoalTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'service_goal_template_id' in params:
            path_params['serviceGoalTemplateId'] = params['service_goal_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_businessunit_week_schedule(self, business_unit_id, week_id, schedule_id, **kwargs):
        """
        Delete a schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_businessunit_week_schedule(business_unit_id, week_id, schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str schedule_id: The ID of the schedule (required)
        :return: BuAsyncScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'schedule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_businessunit_week_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `delete_workforcemanagement_businessunit_week_schedule`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `delete_workforcemanagement_businessunit_week_schedule`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `delete_workforcemanagement_businessunit_week_schedule`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuAsyncScheduleResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_businessunit_week_shorttermforecast(self, business_unit_id, week_date_id, forecast_id, **kwargs):
        """
        Delete a short term forecast
        Must not be tied to any schedules

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_businessunit_week_shorttermforecast(business_unit_id, week_date_id, forecast_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit to which the forecast belongs (required)
        :param date week_date_id: The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str forecast_id: The ID of the forecast (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_date_id', 'forecast_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_businessunit_week_shorttermforecast" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `delete_workforcemanagement_businessunit_week_shorttermforecast`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `delete_workforcemanagement_businessunit_week_shorttermforecast`")
        # verify the required parameter 'forecast_id' is set
        if ('forecast_id' not in params) or (params['forecast_id'] is None):
            raise ValueError("Missing the required parameter `forecast_id` when calling `delete_workforcemanagement_businessunit_week_shorttermforecast`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'forecast_id' in params:
            path_params['forecastId'] = params['forecast_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_calendar_url_ics(self, **kwargs):
        """
        Disable generated calendar link for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_calendar_url_ics(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_calendar_url_ics" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/calendar/url/ics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_managementunit(self, management_unit_id, **kwargs):
        """
        Delete management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `delete_workforcemanagement_managementunit`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_managementunit_timeofflimit(self, management_unit_id, time_off_limit_id, **kwargs):
        """
        Deletes a time off limit object
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit_timeofflimit(management_unit_id, time_off_limit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param str time_off_limit_id: The ID of the time off limit object to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'time_off_limit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit_timeofflimit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `delete_workforcemanagement_managementunit_timeofflimit`")
        # verify the required parameter 'time_off_limit_id' is set
        if ('time_off_limit_id' not in params) or (params['time_off_limit_id'] is None):
            raise ValueError("Missing the required parameter `time_off_limit_id` when calling `delete_workforcemanagement_managementunit_timeofflimit`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeofflimits/{timeOffLimitId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'time_off_limit_id' in params:
            path_params['timeOffLimitId'] = params['time_off_limit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_managementunit_timeoffplan(self, management_unit_id, time_off_plan_id, **kwargs):
        """
        Deletes a time off plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit_timeoffplan(management_unit_id, time_off_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit (required)
        :param str time_off_plan_id: The ID of the time off plan to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'time_off_plan_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit_timeoffplan" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `delete_workforcemanagement_managementunit_timeoffplan`")
        # verify the required parameter 'time_off_plan_id' is set
        if ('time_off_plan_id' not in params) or (params['time_off_plan_id'] is None):
            raise ValueError("Missing the required parameter `time_off_plan_id` when calling `delete_workforcemanagement_managementunit_timeoffplan`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeoffplans/{timeOffPlanId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'time_off_plan_id' in params:
            path_params['timeOffPlanId'] = params['time_off_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_managementunit_workplan(self, management_unit_id, work_plan_id, **kwargs):
        """
        Delete a work plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit_workplan(management_unit_id, work_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_id: The ID of the work plan to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit_workplan" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `delete_workforcemanagement_managementunit_workplan`")
        # verify the required parameter 'work_plan_id' is set
        if ('work_plan_id' not in params) or (params['work_plan_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_id` when calling `delete_workforcemanagement_managementunit_workplan`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_id' in params:
            path_params['workPlanId'] = params['work_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_managementunit_workplanrotation(self, management_unit_id, work_plan_rotation_id, **kwargs):
        """
        Delete a work plan rotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit_workplanrotation(management_unit_id, work_plan_rotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_rotation_id: The ID of the work plan rotation to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_rotation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit_workplanrotation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `delete_workforcemanagement_managementunit_workplanrotation`")
        # verify the required parameter 'work_plan_rotation_id' is set
        if ('work_plan_rotation_id' not in params) or (params['work_plan_rotation_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_rotation_id` when calling `delete_workforcemanagement_managementunit_workplanrotation`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplanrotations/{workPlanRotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_rotation_id' in params:
            path_params['workPlanRotationId'] = params['work_plan_rotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_adherence(self, user_id, **kwargs):
        """
        Get a list of UserScheduleAdherence records for the requested users
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_adherence(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] user_id: User Id(s) for which to fetch current schedule adherence information.  Min 1, Max of 100 userIds per request (required)
        :return: list[UserScheduleAdherence]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_adherence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_workforcemanagement_adherence`")


        resource_path = '/api/v2/workforcemanagement/adherence'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'user_id' in params:
            query_params['userId'] = params['user_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[UserScheduleAdherence]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_adherence_historical_job(self, job_id, **kwargs):
        """
        Query the status of a historical adherence request operation. Only the user who started the operation can query the status
        Job details are only retained if the initial request returned a 202 ACCEPTED response

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_adherence_historical_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :return: WfmHistoricalAdherenceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_adherence_historical_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_workforcemanagement_adherence_historical_job`")


        resource_path = '/api/v2/workforcemanagement/adherence/historical/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmHistoricalAdherenceResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_adhocmodelingjob(self, job_id, **kwargs):
        """
        Get status of the modeling job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_adhocmodelingjob(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The id of the modeling job (required)
        :return: ModelingStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_adhocmodelingjob" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_workforcemanagement_adhocmodelingjob`")


        resource_path = '/api/v2/workforcemanagement/adhocmodelingjobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ModelingStatusResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_agent_managementunit(self, agent_id, **kwargs):
        """
        Get the management unit to which the agent belongs
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_agent_managementunit(agent_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_id: The ID of the agent to look up (required)
        :return: AgentManagementUnitReference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_agent_managementunit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'agent_id' is set
        if ('agent_id' not in params) or (params['agent_id'] is None):
            raise ValueError("Missing the required parameter `agent_id` when calling `get_workforcemanagement_agent_managementunit`")


        resource_path = '/api/v2/workforcemanagement/agents/{agentId}/managementunit'.replace('{format}', 'json')
        path_params = {}
        if 'agent_id' in params:
            path_params['agentId'] = params['agent_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AgentManagementUnitReference',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_agents_me_managementunit(self, **kwargs):
        """
        Get the management unit to which the currently logged in agent belongs
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_agents_me_managementunit(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: AgentManagementUnitReference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_agents_me_managementunit" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/agents/me/managementunit'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AgentManagementUnitReference',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit(self, business_unit_id, **kwargs):
        """
        Get business unit
        Expanding \"settings\" will retrieve all settings.  All other expands will retrieve only the requested settings field(s).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit, or 'mine' for the business unit of the logged-in user. (required)
        :param list[str] expand: 
        :return: BusinessUnit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BusinessUnit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_activitycode(self, business_unit_id, activity_code_id, **kwargs):
        """
        Get an activity code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_activitycode(business_unit_id, activity_code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit, or 'mine' for the business unit of the logged-in user. (required)
        :param str activity_code_id: The ID of the activity code to fetch (required)
        :return: BusinessUnitActivityCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'activity_code_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_activitycode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_activitycode`")
        # verify the required parameter 'activity_code_id' is set
        if ('activity_code_id' not in params) or (params['activity_code_id'] is None):
            raise ValueError("Missing the required parameter `activity_code_id` when calling `get_workforcemanagement_businessunit_activitycode`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/activitycodes/{activityCodeId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'activity_code_id' in params:
            path_params['activityCodeId'] = params['activity_code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BusinessUnitActivityCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_activitycodes(self, business_unit_id, **kwargs):
        """
        Get activity codes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_activitycodes(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit, or 'mine' for the business unit of the logged-in user. (required)
        :return: BusinessUnitActivityCodeListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_activitycodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_activitycodes`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/activitycodes'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BusinessUnitActivityCodeListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_intraday_planninggroups(self, business_unit_id, date, **kwargs):
        """
        Get intraday planning groups for the given date
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_intraday_planninggroups(business_unit_id, date, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date date: yyyy-MM-dd date string interpreted in the configured business unit time zone. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :return: WfmIntradayPlanningGroupListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'date']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_intraday_planninggroups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_intraday_planninggroups`")
        # verify the required parameter 'date' is set
        if ('date' not in params) or (params['date'] is None):
            raise ValueError("Missing the required parameter `date` when calling `get_workforcemanagement_businessunit_intraday_planninggroups`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/intraday/planninggroups'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}
        if 'date' in params:
            query_params['date'] = params['date']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmIntradayPlanningGroupListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_managementunits(self, business_unit_id, **kwargs):
        """
        Get all authorized management units in the business unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_managementunits(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit, or 'mine' for the business unit of the logged-in user. (required)
        :param str feature: 
        :param str division_id: 
        :return: ManagementUnitListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'feature', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_managementunits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_managementunits`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/managementunits'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}
        if 'feature' in params:
            query_params['feature'] = params['feature']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnitListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_planninggroup(self, business_unit_id, planning_group_id, **kwargs):
        """
        Get a planning group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_planninggroup(business_unit_id, planning_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit. (required)
        :param str planning_group_id: The ID of a planning group to fetch (required)
        :return: PlanningGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'planning_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_planninggroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_planninggroup`")
        # verify the required parameter 'planning_group_id' is set
        if ('planning_group_id' not in params) or (params['planning_group_id'] is None):
            raise ValueError("Missing the required parameter `planning_group_id` when calling `get_workforcemanagement_businessunit_planninggroup`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups/{planningGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'planning_group_id' in params:
            path_params['planningGroupId'] = params['planning_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PlanningGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_planninggroups(self, business_unit_id, **kwargs):
        """
        Gets list of planning groups
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_planninggroups(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit. (required)
        :return: PlanningGroupList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_planninggroups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_planninggroups`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PlanningGroupList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_scheduling_run(self, business_unit_id, run_id, **kwargs):
        """
        Get a scheduling run
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_scheduling_run(business_unit_id, run_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param str run_id: The ID of the schedule run (required)
        :return: BuScheduleRun
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'run_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_scheduling_run" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_scheduling_run`")
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params) or (params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `get_workforcemanagement_businessunit_scheduling_run`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'run_id' in params:
            path_params['runId'] = params['run_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuScheduleRun',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_scheduling_run_result(self, business_unit_id, run_id, management_unit_ids, expand, **kwargs):
        """
        Get the result of a rescheduling operation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_scheduling_run_result(business_unit_id, run_id, management_unit_ids, expand, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param str run_id: The ID of the schedule run (required)
        :param list[str] management_unit_ids: The IDs of the management units for which to fetch the reschedule results (required)
        :param list[str] expand: The fields to expand. Omitting will return an empty response (required)
        :return: BuRescheduleResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'run_id', 'management_unit_ids', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_scheduling_run_result" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_scheduling_run_result`")
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params) or (params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `get_workforcemanagement_businessunit_scheduling_run_result`")
        # verify the required parameter 'management_unit_ids' is set
        if ('management_unit_ids' not in params) or (params['management_unit_ids'] is None):
            raise ValueError("Missing the required parameter `management_unit_ids` when calling `get_workforcemanagement_businessunit_scheduling_run_result`")
        # verify the required parameter 'expand' is set
        if ('expand' not in params) or (params['expand'] is None):
            raise ValueError("Missing the required parameter `expand` when calling `get_workforcemanagement_businessunit_scheduling_run_result`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}/result'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'run_id' in params:
            path_params['runId'] = params['run_id']

        query_params = {}
        if 'management_unit_ids' in params:
            query_params['managementUnitIds'] = params['management_unit_ids']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuRescheduleResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_scheduling_runs(self, business_unit_id, **kwargs):
        """
        Get the list of scheduling runs
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_scheduling_runs(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :return: BuScheduleRunListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_scheduling_runs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_scheduling_runs`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuScheduleRunListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_servicegoaltemplate(self, business_unit_id, service_goal_template_id, **kwargs):
        """
        Get a service goal template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_servicegoaltemplate(business_unit_id, service_goal_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit. (required)
        :param str service_goal_template_id: The ID of a service goal template to fetch (required)
        :return: ServiceGoalTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'service_goal_template_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_servicegoaltemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_servicegoaltemplate`")
        # verify the required parameter 'service_goal_template_id' is set
        if ('service_goal_template_id' not in params) or (params['service_goal_template_id'] is None):
            raise ValueError("Missing the required parameter `service_goal_template_id` when calling `get_workforcemanagement_businessunit_servicegoaltemplate`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates/{serviceGoalTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'service_goal_template_id' in params:
            path_params['serviceGoalTemplateId'] = params['service_goal_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ServiceGoalTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_servicegoaltemplates(self, business_unit_id, **kwargs):
        """
        Gets list of service goal templates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_servicegoaltemplates(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit. (required)
        :return: ServiceGoalTemplateList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_servicegoaltemplates" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_servicegoaltemplates`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ServiceGoalTemplateList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_week_schedule(self, business_unit_id, week_id, schedule_id, **kwargs):
        """
        Get the metadata for the schedule, describing which management units and agents are in the scheduleSchedule data can then be loaded with the query route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_week_schedule(business_unit_id, week_id, schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str schedule_id: The ID of the schedule (required)
        :param str expand: expand
        :return: BuScheduleMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'schedule_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_week_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_week_schedule`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `get_workforcemanagement_businessunit_week_schedule`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `get_workforcemanagement_businessunit_week_schedule`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuScheduleMetadata',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_week_schedule_generationresults(self, business_unit_id, week_id, schedule_id, **kwargs):
        """
        Get the generation results for a generated schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_week_schedule_generationresults(business_unit_id, week_id, schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str schedule_id: The ID of the schedule (required)
        :return: ScheduleGenerationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'schedule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_week_schedule_generationresults" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_week_schedule_generationresults`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `get_workforcemanagement_businessunit_week_schedule_generationresults`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `get_workforcemanagement_businessunit_week_schedule_generationresults`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/generationresults'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleGenerationResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_week_schedule_headcountforecast(self, business_unit_id, week_id, schedule_id, **kwargs):
        """
        Get the headcount forecast by planning group for the schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_week_schedule_headcountforecast(business_unit_id, week_id, schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str schedule_id: The ID of the schedule (required)
        :param bool force_download: Whether to force the result to come via download url.  For testing purposes only
        :return: BuHeadcountForecastResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'schedule_id', 'force_download']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_week_schedule_headcountforecast" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_week_schedule_headcountforecast`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `get_workforcemanagement_businessunit_week_schedule_headcountforecast`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `get_workforcemanagement_businessunit_week_schedule_headcountforecast`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/headcountforecast'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}
        if 'force_download' in params:
            query_params['forceDownload'] = params['force_download']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuHeadcountForecastResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_week_schedule_history_agent(self, business_unit_id, week_id, schedule_id, agent_id, **kwargs):
        """
        Loads agent's schedule history.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_week_schedule_history_agent(business_unit_id, week_id, schedule_id, agent_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str schedule_id: The ID of the schedule (required)
        :param str agent_id: THe ID of the agent (required)
        :return: BuAgentScheduleHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'schedule_id', 'agent_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_week_schedule_history_agent" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_week_schedule_history_agent`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `get_workforcemanagement_businessunit_week_schedule_history_agent`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `get_workforcemanagement_businessunit_week_schedule_history_agent`")
        # verify the required parameter 'agent_id' is set
        if ('agent_id' not in params) or (params['agent_id'] is None):
            raise ValueError("Missing the required parameter `agent_id` when calling `get_workforcemanagement_businessunit_week_schedule_history_agent`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/history/agents/{agentId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']
        if 'agent_id' in params:
            path_params['agentId'] = params['agent_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuAgentScheduleHistoryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_week_schedules(self, business_unit_id, week_id, **kwargs):
        """
        Get the list of week schedules for the specified week
        Use \"recent\" (without quotes) for the `weekId` path parameter to fetch all forecasts for +/- 26 weeks from the current date. Response will include any schedule which spans the specified week

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_week_schedules(business_unit_id, week_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format, or 'recent' (without quotes) to get recent schedules (required)
        :param bool include_only_published: includeOnlyPublished
        :param str expand: expand
        :return: BuScheduleListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'include_only_published', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_week_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_week_schedules`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `get_workforcemanagement_businessunit_week_schedules`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']

        query_params = {}
        if 'include_only_published' in params:
            query_params['includeOnlyPublished'] = params['include_only_published']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuScheduleListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_week_shorttermforecast(self, business_unit_id, week_date_id, forecast_id, **kwargs):
        """
        Get a short term forecast
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_week_shorttermforecast(business_unit_id, week_date_id, forecast_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit to which the forecast belongs (required)
        :param date week_date_id: The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str forecast_id: The ID of the forecast (required)
        :param list[str] expand: 
        :return: BuShortTermForecast
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_date_id', 'forecast_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_week_shorttermforecast" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast`")
        # verify the required parameter 'forecast_id' is set
        if ('forecast_id' not in params) or (params['forecast_id'] is None):
            raise ValueError("Missing the required parameter `forecast_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'forecast_id' in params:
            path_params['forecastId'] = params['forecast_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuShortTermForecast',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_week_shorttermforecast_data(self, business_unit_id, week_date_id, forecast_id, **kwargs):
        """
        Get the result of a short term forecast calculation
        Includes modifications unless you pass the doNotApplyModifications query parameter

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_week_shorttermforecast_data(business_unit_id, week_date_id, forecast_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit to which the forecast belongs (required)
        :param date week_date_id: The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str forecast_id: The ID of the forecast (required)
        :param int week_number: The week number to fetch (for multi-week forecasts)
        :param bool force_download_service: Force the result of this operation to be sent via download service.  For testing/app development purposes
        :return: BuForecastResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_date_id', 'forecast_id', 'week_number', 'force_download_service']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_week_shorttermforecast_data" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_data`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_data`")
        # verify the required parameter 'forecast_id' is set
        if ('forecast_id' not in params) or (params['forecast_id'] is None):
            raise ValueError("Missing the required parameter `forecast_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_data`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/data'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'forecast_id' in params:
            path_params['forecastId'] = params['forecast_id']

        query_params = {}
        if 'week_number' in params:
            query_params['weekNumber'] = params['week_number']
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuForecastResultResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_week_shorttermforecast_generationresults(self, business_unit_id, week_date_id, forecast_id, **kwargs):
        """
        Gets the forecast generation results
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_week_shorttermforecast_generationresults(business_unit_id, week_date_id, forecast_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit to which the forecast belongs (required)
        :param date week_date_id: The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str forecast_id: The ID of the forecast (required)
        :return: BuForecastGenerationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_date_id', 'forecast_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_week_shorttermforecast_generationresults" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_generationresults`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_generationresults`")
        # verify the required parameter 'forecast_id' is set
        if ('forecast_id' not in params) or (params['forecast_id'] is None):
            raise ValueError("Missing the required parameter `forecast_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_generationresults`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/generationresults'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'forecast_id' in params:
            path_params['forecastId'] = params['forecast_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuForecastGenerationResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_week_shorttermforecast_longtermforecastdata(self, business_unit_id, week_date_id, forecast_id, **kwargs):
        """
        Get the result of a long term forecast calculation
        Includes modifications unless you pass the doNotApplyModifications query parameter

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_week_shorttermforecast_longtermforecastdata(business_unit_id, week_date_id, forecast_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit to which the forecast belongs (required)
        :param date week_date_id: The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str forecast_id: The ID of the forecast (required)
        :param bool force_download_service: Force the result of this operation to be sent via download service.  For testing/app development purposes
        :return: LongTermForecastResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_date_id', 'forecast_id', 'force_download_service']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_week_shorttermforecast_longtermforecastdata" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_longtermforecastdata`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_longtermforecastdata`")
        # verify the required parameter 'forecast_id' is set
        if ('forecast_id' not in params) or (params['forecast_id'] is None):
            raise ValueError("Missing the required parameter `forecast_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_longtermforecastdata`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/longtermforecastdata'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'forecast_id' in params:
            path_params['forecastId'] = params['forecast_id']

        query_params = {}
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LongTermForecastResultResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_week_shorttermforecast_planninggroups(self, business_unit_id, week_date_id, forecast_id, **kwargs):
        """
        Gets the forecast planning group snapshot
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_week_shorttermforecast_planninggroups(business_unit_id, week_date_id, forecast_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit to which the forecast belongs (required)
        :param date week_date_id: The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str forecast_id: The ID of the forecast (required)
        :return: ForecastPlanningGroupsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_date_id', 'forecast_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_week_shorttermforecast_planninggroups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_planninggroups`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_planninggroups`")
        # verify the required parameter 'forecast_id' is set
        if ('forecast_id' not in params) or (params['forecast_id'] is None):
            raise ValueError("Missing the required parameter `forecast_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecast_planninggroups`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/planninggroups'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'forecast_id' in params:
            path_params['forecastId'] = params['forecast_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ForecastPlanningGroupsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunit_week_shorttermforecasts(self, business_unit_id, week_date_id, **kwargs):
        """
        Get short term forecasts
        Use \"recent\" (without quotes) for the `weekDateId` path parameter to fetch all forecasts for +/- 26 weeks from the current date. Response will include any forecast which spans the specified week

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunit_week_shorttermforecasts(business_unit_id, week_date_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit to which the forecast belongs (required)
        :param str week_date_id: The week start date of the forecast in yyyy-MM-dd format or 'recent' (without quotes) to fetch recent forecasts (required)
        :return: BuShortTermForecastListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_date_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunit_week_shorttermforecasts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecasts`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `get_workforcemanagement_businessunit_week_shorttermforecasts`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuShortTermForecastListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunits(self, **kwargs):
        """
        Get business units
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str feature: 
        :param str division_id: 
        :return: BusinessUnitListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['feature', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/businessunits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'feature' in params:
            query_params['feature'] = params['feature']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BusinessUnitListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_businessunits_divisionviews(self, **kwargs):
        """
        Get business units across divisions
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_businessunits_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] division_id: The divisionIds to filter by. If omitted, will return business units in all divisions
        :return: BusinessUnitListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_businessunits_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/businessunits/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BusinessUnitListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_calendar_data_ics(self, calendar_id, **kwargs):
        """
        Get ics formatted calendar based on shareable link
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_calendar_data_ics(calendar_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str calendar_id: The id of the ics-formatted calendar (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['calendar_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_calendar_data_ics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'calendar_id' is set
        if ('calendar_id' not in params) or (params['calendar_id'] is None):
            raise ValueError("Missing the required parameter `calendar_id` when calling `get_workforcemanagement_calendar_data_ics`")


        resource_path = '/api/v2/workforcemanagement/calendar/data/ics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'calendar_id' in params:
            query_params['calendarId'] = params['calendar_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/calendar'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_calendar_url_ics(self, **kwargs):
        """
        Get existing calendar link for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_calendar_url_ics(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: CalendarUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_calendar_url_ics" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/calendar/url/ics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CalendarUrlResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_historicaldata_deletejob(self, **kwargs):
        """
        Retrieves delete job status for historical data imports of the organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_historicaldata_deletejob(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: HistoricalImportDeleteJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_historicaldata_deletejob" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/historicaldata/deletejob'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HistoricalImportDeleteJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_historicaldata_importstatus(self, **kwargs):
        """
        Retrieves status of the historical data imports of the organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_historicaldata_importstatus(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: HistoricalImportStatusListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_historicaldata_importstatus" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/historicaldata/importstatus'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HistoricalImportStatusListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit(self, management_unit_id, **kwargs):
        """
        Get management unit
        settings.shortTermForecasting is deprecated and now lives on the business unit

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param list[str] expand: 
        :return: ManagementUnit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_activitycodes(self, management_unit_id, **kwargs):
        """
        Get activity codes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_activitycodes(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: ActivityCodeContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_activitycodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_activitycodes`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/activitycodes'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActivityCodeContainer',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_adherence(self, management_unit_id, **kwargs):
        """
        Get a list of user schedule adherence records for the requested management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_adherence(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit (required)
        :param bool force_download_service: Force the result of this operation to be sent via download service.  For testing/app development purposes
        :return: UserScheduleAdherenceListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'force_download_service']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_adherence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_adherence`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/adherence'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserScheduleAdherenceListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_agent(self, management_unit_id, agent_id, **kwargs):
        """
        Get data for agent in the management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_agent(management_unit_id, agent_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str agent_id: The agent id (required)
        :param bool exclude_capabilities: Excludes all capabilities of the agent such as queues, languages, and skills
        :return: WfmAgent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'agent_id', 'exclude_capabilities']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_agent" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_agent`")
        # verify the required parameter 'agent_id' is set
        if ('agent_id' not in params) or (params['agent_id'] is None):
            raise ValueError("Missing the required parameter `agent_id` when calling `get_workforcemanagement_managementunit_agent`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/agents/{agentId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'agent_id' in params:
            path_params['agentId'] = params['agent_id']

        query_params = {}
        if 'exclude_capabilities' in params:
            query_params['excludeCapabilities'] = params['exclude_capabilities']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmAgent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_agent_shifttrades(self, management_unit_id, agent_id, **kwargs):
        """
        Gets all the shift trades for a given agent
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_agent_shifttrades(management_unit_id, agent_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str agent_id: The agent id (required)
        :return: ShiftTradeListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'agent_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_agent_shifttrades" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_agent_shifttrades`")
        # verify the required parameter 'agent_id' is set
        if ('agent_id' not in params) or (params['agent_id'] is None):
            raise ValueError("Missing the required parameter `agent_id` when calling `get_workforcemanagement_managementunit_agent_shifttrades`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/agents/{agentId}/shifttrades'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'agent_id' in params:
            path_params['agentId'] = params['agent_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShiftTradeListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_shifttrades_matched(self, management_unit_id, **kwargs):
        """
        Gets a summary of all shift trades in the matched state
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_shifttrades_matched(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: ShiftTradeMatchesSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_shifttrades_matched" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_shifttrades_matched`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/shifttrades/matched'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShiftTradeMatchesSummaryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_shifttrades_users(self, management_unit_id, **kwargs):
        """
        Gets list of users available for whom you can send direct shift trade requests
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_shifttrades_users(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: WfmUserEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_shifttrades_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_shifttrades_users`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/shifttrades/users'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmUserEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_timeofflimit(self, management_unit_id, time_off_limit_id, **kwargs):
        """
        Gets a time off limit object
        Returns properties of time off limit object, but not daily values.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_timeofflimit(management_unit_id, time_off_limit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param str time_off_limit_id: The ID of the time off limit to fetch (required)
        :return: TimeOffLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'time_off_limit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_timeofflimit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_timeofflimit`")
        # verify the required parameter 'time_off_limit_id' is set
        if ('time_off_limit_id' not in params) or (params['time_off_limit_id'] is None):
            raise ValueError("Missing the required parameter `time_off_limit_id` when calling `get_workforcemanagement_managementunit_timeofflimit`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeofflimits/{timeOffLimitId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'time_off_limit_id' in params:
            path_params['timeOffLimitId'] = params['time_off_limit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffLimit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_timeofflimits(self, management_unit_id, **kwargs):
        """
        Gets a list of time off limit objects under management unit.
        Currently only one time off limit object is allowed under management unit, so the list contains either 0 or 1 element.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_timeofflimits(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :return: TimeOffLimitListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_timeofflimits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_timeofflimits`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeofflimits'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffLimitListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_timeoffplan(self, management_unit_id, time_off_plan_id, **kwargs):
        """
        Gets a time off plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_timeoffplan(management_unit_id, time_off_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit (required)
        :param str time_off_plan_id: The ID of the time off plan to fetch (required)
        :return: TimeOffPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'time_off_plan_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_timeoffplan" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_timeoffplan`")
        # verify the required parameter 'time_off_plan_id' is set
        if ('time_off_plan_id' not in params) or (params['time_off_plan_id'] is None):
            raise ValueError("Missing the required parameter `time_off_plan_id` when calling `get_workforcemanagement_managementunit_timeoffplan`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeoffplans/{timeOffPlanId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'time_off_plan_id' in params:
            path_params['timeOffPlanId'] = params['time_off_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_timeoffplans(self, management_unit_id, **kwargs):
        """
        Gets a list of time off plans
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_timeoffplans(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit (required)
        :return: TimeOffPlanListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_timeoffplans" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_timeoffplans`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeoffplans'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffPlanListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_user_timeoffrequest(self, management_unit_id, user_id, time_off_request_id, **kwargs):
        """
        Get a time off request
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_user_timeoffrequest(management_unit_id, user_id, time_off_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str user_id: The userId to whom the Time Off Request applies. (required)
        :param str time_off_request_id: Time Off Request Id (required)
        :return: TimeOffRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'user_id', 'time_off_request_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_user_timeoffrequest" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequest`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequest`")
        # verify the required parameter 'time_off_request_id' is set
        if ('time_off_request_id' not in params) or (params['time_off_request_id'] is None):
            raise ValueError("Missing the required parameter `time_off_request_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequest`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/users/{userId}/timeoffrequests/{timeOffRequestId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'time_off_request_id' in params:
            path_params['timeOffRequestId'] = params['time_off_request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_user_timeoffrequest_timeofflimits(self, management_unit_id, user_id, time_off_request_id, **kwargs):
        """
        Retrieves time off limit, allocated and waitlisted values according to specific time off request
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_user_timeoffrequest_timeofflimits(management_unit_id, user_id, time_off_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param str user_id: The userId to whom the time off request applies. (required)
        :param str time_off_request_id: The ID of the time off request, which dates and activityCodeId determine limit values to retrieve (required)
        :return: QueryTimeOffLimitValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'user_id', 'time_off_request_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_user_timeoffrequest_timeofflimits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequest_timeofflimits`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequest_timeofflimits`")
        # verify the required parameter 'time_off_request_id' is set
        if ('time_off_request_id' not in params) or (params['time_off_request_id'] is None):
            raise ValueError("Missing the required parameter `time_off_request_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequest_timeofflimits`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/users/{userId}/timeoffrequests/{timeOffRequestId}/timeofflimits'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'time_off_request_id' in params:
            path_params['timeOffRequestId'] = params['time_off_request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueryTimeOffLimitValuesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_user_timeoffrequests(self, management_unit_id, user_id, **kwargs):
        """
        Get a list of time off requests for a given user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_user_timeoffrequests(management_unit_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str user_id: The userId to whom the Time Off Request applies. (required)
        :param bool recently_reviewed: Limit results to requests that have been reviewed within the preceding 30 days
        :return: TimeOffRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'user_id', 'recently_reviewed']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_user_timeoffrequests" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequests`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequests`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/users/{userId}/timeoffrequests'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'recently_reviewed' in params:
            query_params['recentlyReviewed'] = params['recently_reviewed']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_users(self, management_unit_id, **kwargs):
        """
        Get users in the management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_users(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: WfmUserEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_users`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmUserEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_week_schedule(self, management_unit_id, week_id, schedule_id, **kwargs):
        """
        Deprecated.  Use the equivalent business unit resource instead. Get a week schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_week_schedule(management_unit_id, week_id, schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param str schedule_id: The ID of the schedule to fetch (required)
        :param str expand: Which fields, if any, to expand
        :param bool force_download_service: Force the result of this operation to be sent via download service.  For testing/app development purposes
        :return: WeekScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'schedule_id', 'expand', 'force_download_service']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_week_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_week_schedule`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `get_workforcemanagement_managementunit_week_schedule`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `get_workforcemanagement_managementunit_week_schedule`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WeekScheduleResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_week_schedules(self, management_unit_id, week_id, **kwargs):
        """
        Deprecated.  Use the equivalent business unit resource instead. Get the list of schedules in a week in management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_week_schedules(management_unit_id, week_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param bool include_only_published: Return only published schedules
        :param str earliest_week_date: The start date of the earliest week to query in yyyy-MM-dd format
        :param str latest_week_date: The start date of the latest week to query in yyyy-MM-dd format
        :return: WeekScheduleListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'include_only_published', 'earliest_week_date', 'latest_week_date']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_week_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_week_schedules`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `get_workforcemanagement_managementunit_week_schedules`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']

        query_params = {}
        if 'include_only_published' in params:
            query_params['includeOnlyPublished'] = params['include_only_published']
        if 'earliest_week_date' in params:
            query_params['earliestWeekDate'] = params['earliest_week_date']
        if 'latest_week_date' in params:
            query_params['latestWeekDate'] = params['latest_week_date']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WeekScheduleListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_week_shifttrades(self, management_unit_id, week_date_id, **kwargs):
        """
        Gets all the shift trades for a given week
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_week_shifttrades(management_unit_id, week_date_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param date week_date_id: The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param bool evaluate_matches: Whether to evaluate the matches for violations
        :return: WeekShiftTradeListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'evaluate_matches']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_week_shifttrades" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_week_shifttrades`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `get_workforcemanagement_managementunit_week_shifttrades`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}
        if 'evaluate_matches' in params:
            query_params['evaluateMatches'] = params['evaluate_matches']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WeekShiftTradeListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_workplan(self, management_unit_id, work_plan_id, **kwargs):
        """
        Get a work plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_workplan(management_unit_id, work_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_id: The ID of the work plan to fetch (required)
        :param list[str] include_only: limit response to the specified fields
        :return: WorkPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_id', 'include_only']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_workplan" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_workplan`")
        # verify the required parameter 'work_plan_id' is set
        if ('work_plan_id' not in params) or (params['work_plan_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_id` when calling `get_workforcemanagement_managementunit_workplan`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_id' in params:
            path_params['workPlanId'] = params['work_plan_id']

        query_params = {}
        if 'include_only' in params:
            query_params['includeOnly'] = params['include_only']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_workplanrotation(self, management_unit_id, work_plan_rotation_id, **kwargs):
        """
        Get a work plan rotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_workplanrotation(management_unit_id, work_plan_rotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_rotation_id: The ID of the work plan rotation to fetch (required)
        :return: WorkPlanRotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_rotation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_workplanrotation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_workplanrotation`")
        # verify the required parameter 'work_plan_rotation_id' is set
        if ('work_plan_rotation_id' not in params) or (params['work_plan_rotation_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_rotation_id` when calling `get_workforcemanagement_managementunit_workplanrotation`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplanrotations/{workPlanRotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_rotation_id' in params:
            path_params['workPlanRotationId'] = params['work_plan_rotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlanRotationResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_workplanrotations(self, management_unit_id, **kwargs):
        """
        Get work plan rotations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_workplanrotations(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param list[str] expand: 
        :return: WorkPlanRotationListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_workplanrotations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_workplanrotations`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplanrotations'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlanRotationListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_workplans(self, management_unit_id, **kwargs):
        """
        Get work plans
        \"expand=details\" is deprecated

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_workplans(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param list[str] expand: 
        :return: WorkPlanListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_workplans" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_workplans`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlanListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunits(self, **kwargs):
        """
        Get management units
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Deprecated, paging is not supported
        :param int page_number: Deprecated, paging is not supported
        :param str expand: Deprecated, expand settings on the single MU route
        :param str feature: 
        :param str division_id: 
        :return: ManagementUnitListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'expand', 'feature', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/managementunits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'feature' in params:
            query_params['feature'] = params['feature']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnitListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunits_divisionviews(self, **kwargs):
        """
        Get management units across divisions
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunits_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] division_id: The divisionIds to filter by. If omitted, will return all divisions
        :return: ManagementUnitListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunits_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/managementunits/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnitListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_notifications(self, **kwargs):
        """
        Get a list of notifications for the current user
        Notifications are only initially sent if you have the relevant Notify and Edit permissions

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_notifications(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: NotificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_notifications" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/notifications'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NotificationsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_schedulingjob(self, job_id, **kwargs):
        """
        Get status of the scheduling job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_schedulingjob(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The id of the scheduling job (required)
        :return: SchedulingStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_schedulingjob" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_workforcemanagement_schedulingjob`")


        resource_path = '/api/v2/workforcemanagement/schedulingjobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SchedulingStatusResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_shifttrades(self, **kwargs):
        """
        Gets all of my shift trades
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_shifttrades(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ShiftTradeListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_shifttrades" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/shifttrades'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShiftTradeListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_timeoffrequest(self, time_off_request_id, **kwargs):
        """
        Get a time off request for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_timeoffrequest(time_off_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str time_off_request_id: The ID of the time off request (required)
        :return: TimeOffRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['time_off_request_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_timeoffrequest" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'time_off_request_id' is set
        if ('time_off_request_id' not in params) or (params['time_off_request_id'] is None):
            raise ValueError("Missing the required parameter `time_off_request_id` when calling `get_workforcemanagement_timeoffrequest`")


        resource_path = '/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}'.replace('{format}', 'json')
        path_params = {}
        if 'time_off_request_id' in params:
            path_params['timeOffRequestId'] = params['time_off_request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_timeoffrequest_waitlistpositions(self, time_off_request_id, **kwargs):
        """
        Get the daily waitlist positions of a time off request for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_timeoffrequest_waitlistpositions(time_off_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str time_off_request_id: The ID of the time off request (required)
        :return: WaitlistPositionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['time_off_request_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_timeoffrequest_waitlistpositions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'time_off_request_id' is set
        if ('time_off_request_id' not in params) or (params['time_off_request_id'] is None):
            raise ValueError("Missing the required parameter `time_off_request_id` when calling `get_workforcemanagement_timeoffrequest_waitlistpositions`")


        resource_path = '/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}/waitlistpositions'.replace('{format}', 'json')
        path_params = {}
        if 'time_off_request_id' in params:
            path_params['timeOffRequestId'] = params['time_off_request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WaitlistPositionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_timeoffrequests(self, **kwargs):
        """
        Get a list of time off requests for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_timeoffrequests(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool recently_reviewed: Limit results to requests that have been reviewed within the preceding 30 days
        :return: TimeOffRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['recently_reviewed']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_timeoffrequests" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/timeoffrequests'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'recently_reviewed' in params:
            query_params['recentlyReviewed'] = params['recently_reviewed']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_businessunit(self, business_unit_id, **kwargs):
        """
        Update business unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_businessunit(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit, or 'mine' for the business unit of the logged-in user. (required)
        :param UpdateBusinessUnitRequest body: body
        :return: BusinessUnit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_businessunit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `patch_workforcemanagement_businessunit`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BusinessUnit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_businessunit_activitycode(self, business_unit_id, activity_code_id, **kwargs):
        """
        Update an activity code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_businessunit_activitycode(business_unit_id, activity_code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit, or 'mine' for the business unit of the logged-in user. (required)
        :param str activity_code_id: The ID of the activity code to update (required)
        :param UpdateActivityCodeRequest body: body
        :return: BusinessUnitActivityCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'activity_code_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_businessunit_activitycode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `patch_workforcemanagement_businessunit_activitycode`")
        # verify the required parameter 'activity_code_id' is set
        if ('activity_code_id' not in params) or (params['activity_code_id'] is None):
            raise ValueError("Missing the required parameter `activity_code_id` when calling `patch_workforcemanagement_businessunit_activitycode`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/activitycodes/{activityCodeId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'activity_code_id' in params:
            path_params['activityCodeId'] = params['activity_code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BusinessUnitActivityCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_businessunit_planninggroup(self, business_unit_id, planning_group_id, **kwargs):
        """
        Updates the planning group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_businessunit_planninggroup(business_unit_id, planning_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit. (required)
        :param str planning_group_id: The ID of a planning group to update (required)
        :param UpdatePlanningGroupRequest body: body
        :return: PlanningGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'planning_group_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_businessunit_planninggroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `patch_workforcemanagement_businessunit_planninggroup`")
        # verify the required parameter 'planning_group_id' is set
        if ('planning_group_id' not in params) or (params['planning_group_id'] is None):
            raise ValueError("Missing the required parameter `planning_group_id` when calling `patch_workforcemanagement_businessunit_planninggroup`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups/{planningGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'planning_group_id' in params:
            path_params['planningGroupId'] = params['planning_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PlanningGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_businessunit_scheduling_run(self, business_unit_id, run_id, **kwargs):
        """
        Mark a schedule run as applied
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_businessunit_scheduling_run(business_unit_id, run_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param str run_id: The ID of the schedule run (required)
        :param PatchBuScheduleRunRequest body: body
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'run_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_businessunit_scheduling_run" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `patch_workforcemanagement_businessunit_scheduling_run`")
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params) or (params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `patch_workforcemanagement_businessunit_scheduling_run`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'run_id' in params:
            path_params['runId'] = params['run_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_businessunit_servicegoaltemplate(self, business_unit_id, service_goal_template_id, **kwargs):
        """
        Updates a service goal template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_businessunit_servicegoaltemplate(business_unit_id, service_goal_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit. (required)
        :param str service_goal_template_id: The ID of a service goal template to update (required)
        :param UpdateServiceGoalTemplate body: body
        :return: ServiceGoalTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'service_goal_template_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_businessunit_servicegoaltemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `patch_workforcemanagement_businessunit_servicegoaltemplate`")
        # verify the required parameter 'service_goal_template_id' is set
        if ('service_goal_template_id' not in params) or (params['service_goal_template_id'] is None):
            raise ValueError("Missing the required parameter `service_goal_template_id` when calling `patch_workforcemanagement_businessunit_servicegoaltemplate`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates/{serviceGoalTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'service_goal_template_id' in params:
            path_params['serviceGoalTemplateId'] = params['service_goal_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ServiceGoalTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit(self, management_unit_id, **kwargs):
        """
        Update the requested management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param UpdateManagementUnitRequest body: body
        :return: ManagementUnit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `patch_workforcemanagement_managementunit`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_timeofflimit(self, management_unit_id, time_off_limit_id, **kwargs):
        """
        Updates a time off limit object.
        Updates time off limit object properties, but not daily values.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_timeofflimit(management_unit_id, time_off_limit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param str time_off_limit_id: The id of time off limit object to update (required)
        :param UpdateTimeOffLimitRequest body: body
        :return: TimeOffLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'time_off_limit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_timeofflimit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `patch_workforcemanagement_managementunit_timeofflimit`")
        # verify the required parameter 'time_off_limit_id' is set
        if ('time_off_limit_id' not in params) or (params['time_off_limit_id'] is None):
            raise ValueError("Missing the required parameter `time_off_limit_id` when calling `patch_workforcemanagement_managementunit_timeofflimit`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeofflimits/{timeOffLimitId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'time_off_limit_id' in params:
            path_params['timeOffLimitId'] = params['time_off_limit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffLimit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_timeoffplan(self, management_unit_id, time_off_plan_id, **kwargs):
        """
        Updates a time off plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_timeoffplan(management_unit_id, time_off_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit (required)
        :param str time_off_plan_id: The ID of the time off plan to update (required)
        :param UpdateTimeOffPlanRequest body: body
        :return: TimeOffPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'time_off_plan_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_timeoffplan" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `patch_workforcemanagement_managementunit_timeoffplan`")
        # verify the required parameter 'time_off_plan_id' is set
        if ('time_off_plan_id' not in params) or (params['time_off_plan_id'] is None):
            raise ValueError("Missing the required parameter `time_off_plan_id` when calling `patch_workforcemanagement_managementunit_timeoffplan`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeoffplans/{timeOffPlanId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'time_off_plan_id' in params:
            path_params['timeOffPlanId'] = params['time_off_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_user_timeoffrequest(self, management_unit_id, user_id, time_off_request_id, **kwargs):
        """
        Update a time off request
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_user_timeoffrequest(management_unit_id, user_id, time_off_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str user_id: The id of the user the requested time off request belongs to (required)
        :param str time_off_request_id: The id of the time off request to update (required)
        :param AdminTimeOffRequestPatch body: body
        :return: TimeOffRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'user_id', 'time_off_request_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_user_timeoffrequest" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `patch_workforcemanagement_managementunit_user_timeoffrequest`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_workforcemanagement_managementunit_user_timeoffrequest`")
        # verify the required parameter 'time_off_request_id' is set
        if ('time_off_request_id' not in params) or (params['time_off_request_id'] is None):
            raise ValueError("Missing the required parameter `time_off_request_id` when calling `patch_workforcemanagement_managementunit_user_timeoffrequest`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/users/{userId}/timeoffrequests/{timeOffRequestId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'time_off_request_id' in params:
            path_params['timeOffRequestId'] = params['time_off_request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_week_shifttrade(self, management_unit_id, week_date_id, trade_id, body, **kwargs):
        """
        Updates a shift trade. This route can only be called by the initiating agent
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_week_shifttrade(management_unit_id, week_date_id, trade_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param date week_date_id: The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str trade_id: The ID of the shift trade to update (required)
        :param PatchShiftTradeRequest body: body (required)
        :return: ShiftTradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'trade_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_week_shifttrade" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `patch_workforcemanagement_managementunit_week_shifttrade`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `patch_workforcemanagement_managementunit_week_shifttrade`")
        # verify the required parameter 'trade_id' is set
        if ('trade_id' not in params) or (params['trade_id'] is None):
            raise ValueError("Missing the required parameter `trade_id` when calling `patch_workforcemanagement_managementunit_week_shifttrade`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_workforcemanagement_managementunit_week_shifttrade`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/{tradeId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'trade_id' in params:
            path_params['tradeId'] = params['trade_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShiftTradeResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_workplan(self, management_unit_id, work_plan_id, **kwargs):
        """
        Update a work plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_workplan(management_unit_id, work_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_id: The ID of the work plan to update (required)
        :param str validation_mode: Allows to update work plan even if validation result is invalid
        :param WorkPlan body: body
        :return: WorkPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_id', 'validation_mode', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_workplan" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `patch_workforcemanagement_managementunit_workplan`")
        # verify the required parameter 'work_plan_id' is set
        if ('work_plan_id' not in params) or (params['work_plan_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_id` when calling `patch_workforcemanagement_managementunit_workplan`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_id' in params:
            path_params['workPlanId'] = params['work_plan_id']

        query_params = {}
        if 'validation_mode' in params:
            query_params['validationMode'] = params['validation_mode']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_workplanrotation(self, management_unit_id, work_plan_rotation_id, **kwargs):
        """
        Update a work plan rotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_workplanrotation(management_unit_id, work_plan_rotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_rotation_id: The ID of the work plan rotation to update (required)
        :param UpdateWorkPlanRotationRequest body: body
        :return: WorkPlanRotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_rotation_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_workplanrotation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `patch_workforcemanagement_managementunit_workplanrotation`")
        # verify the required parameter 'work_plan_rotation_id' is set
        if ('work_plan_rotation_id' not in params) or (params['work_plan_rotation_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_rotation_id` when calling `patch_workforcemanagement_managementunit_workplanrotation`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplanrotations/{workPlanRotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_rotation_id' in params:
            path_params['workPlanRotationId'] = params['work_plan_rotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlanRotationResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_timeoffrequest(self, time_off_request_id, **kwargs):
        """
        Update a time off request for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_timeoffrequest(time_off_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str time_off_request_id: The ID of the time off request (required)
        :param AgentTimeOffRequestPatch body: body
        :return: TimeOffRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['time_off_request_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_timeoffrequest" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'time_off_request_id' is set
        if ('time_off_request_id' not in params) or (params['time_off_request_id'] is None):
            raise ValueError("Missing the required parameter `time_off_request_id` when calling `patch_workforcemanagement_timeoffrequest`")


        resource_path = '/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}'.replace('{format}', 'json')
        path_params = {}
        if 'time_off_request_id' in params:
            path_params['timeOffRequestId'] = params['time_off_request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_adherence_historical(self, **kwargs):
        """
        Request a historical adherence report for users across management units
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_adherence_historical(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WfmHistoricalAdherenceQueryForUsers body: body
        :return: WfmHistoricalAdherenceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_adherence_historical" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/adherence/historical'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmHistoricalAdherenceResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_agentschedules_mine(self, **kwargs):
        """
        Get published schedule for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_agentschedules_mine(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BuGetCurrentAgentScheduleRequest body: body
        :return: BuCurrentAgentScheduleSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_agentschedules_mine" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/agentschedules/mine'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuCurrentAgentScheduleSearchResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_activitycodes(self, business_unit_id, **kwargs):
        """
        Create a new activity code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_activitycodes(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit, or 'mine' for the business unit of the logged-in user. (required)
        :param CreateActivityCodeRequest body: body
        :return: BusinessUnitActivityCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_activitycodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_activitycodes`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/activitycodes'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BusinessUnitActivityCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_agentschedules_search(self, business_unit_id, **kwargs):
        """
        Search published schedules
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_agentschedules_search(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification. For testing/app development purposes
        :param bool force_download_service: Force the result of this operation to be sent via download service. For testing/app development purposes
        :param BuSearchAgentSchedulesRequest body: body
        :return: BuAsyncAgentSchedulesSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'force_async', 'force_download_service', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_agentschedules_search" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_agentschedules_search`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/agentschedules/search'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuAsyncAgentSchedulesSearchResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_intraday(self, business_unit_id, **kwargs):
        """
        Get intraday data for the given date for the requested planningGroupIds
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_intraday(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes
        :param IntradayPlanningGroupRequest body: body
        :return: AsyncIntradayResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'force_async', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_intraday" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_intraday`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/intraday'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AsyncIntradayResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_planninggroups(self, business_unit_id, **kwargs):
        """
        Adds a new planning group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_planninggroups(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit. (required)
        :param CreatePlanningGroupRequest body: body
        :return: PlanningGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_planninggroups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_planninggroups`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PlanningGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_servicegoaltemplates(self, business_unit_id, **kwargs):
        """
        Adds a new service goal template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_servicegoaltemplates(business_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit. (required)
        :param CreateServiceGoalTemplate body: body
        :return: ServiceGoalTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_servicegoaltemplates" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_servicegoaltemplates`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ServiceGoalTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_schedule_agentschedules_query(self, business_unit_id, week_id, schedule_id, body, **kwargs):
        """
        Loads agent schedule data from the schedule. Used in combination with the metadata route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_schedule_agentschedules_query(business_unit_id, week_id, schedule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str schedule_id: The ID of the schedule (required)
        :param BuQueryAgentSchedulesRequest body: body (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification. For testing/app development purposes
        :param bool force_download_service: Force the result of this operation to be sent via download service. For testing/app development purposes
        :return: BuAsyncAgentSchedulesQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'schedule_id', 'body', 'force_async', 'force_download_service']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_schedule_agentschedules_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_schedule_agentschedules_query`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_businessunit_week_schedule_agentschedules_query`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `post_workforcemanagement_businessunit_week_schedule_agentschedules_query`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_schedule_agentschedules_query`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/agentschedules/query'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuAsyncAgentSchedulesQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_schedule_copy(self, business_unit_id, week_id, schedule_id, body, **kwargs):
        """
        Copy a schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_schedule_copy(business_unit_id, week_id, schedule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str schedule_id: The ID of the schedule to copy (required)
        :param BuCopyScheduleRequest body: body (required)
        :return: BuAsyncScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'schedule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_schedule_copy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_schedule_copy`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_businessunit_week_schedule_copy`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `post_workforcemanagement_businessunit_week_schedule_copy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_schedule_copy`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/copy'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuAsyncScheduleResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_schedule_reschedule(self, business_unit_id, week_id, schedule_id, body, **kwargs):
        """
        Start a rescheduling run
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_schedule_reschedule(business_unit_id, week_id, schedule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str schedule_id: The ID of the schedule (required)
        :param BuRescheduleRequest body: body (required)
        :return: BuAsyncScheduleRunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'schedule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_schedule_reschedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_schedule_reschedule`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_businessunit_week_schedule_reschedule`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `post_workforcemanagement_businessunit_week_schedule_reschedule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_schedule_reschedule`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/reschedule'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuAsyncScheduleRunResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_schedule_update(self, business_unit_id, week_id, schedule_id, body, **kwargs):
        """
        Starts processing a schedule update
        Call after uploading the schedule data to the url supplied by the /update/uploadurl route

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_schedule_update(business_unit_id, week_id, schedule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str schedule_id: The ID of the schedule (required)
        :param ProcessScheduleUpdateUploadRequest body: body (required)
        :return: BuAsyncScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'schedule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_schedule_update" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_schedule_update`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_businessunit_week_schedule_update`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `post_workforcemanagement_businessunit_week_schedule_update`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_schedule_update`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/update'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuAsyncScheduleResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_schedule_update_uploadurl(self, business_unit_id, week_id, schedule_id, body, **kwargs):
        """
        Creates a signed upload URL for updating a schedule
        Once the upload is complete, call the /{scheduleId}/update route to start the schedule update process

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_schedule_update_uploadurl(business_unit_id, week_id, schedule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str schedule_id: The ID of the schedule (required)
        :param UploadUrlRequestBody body: body (required)
        :return: UpdateScheduleUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'schedule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_schedule_update_uploadurl" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_schedule_update_uploadurl`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_businessunit_week_schedule_update_uploadurl`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `post_workforcemanagement_businessunit_week_schedule_update_uploadurl`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_schedule_update_uploadurl`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/update/uploadurl'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UpdateScheduleUploadResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_schedules(self, business_unit_id, week_id, body, **kwargs):
        """
        Create a blank schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_schedules(business_unit_id, week_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param BuCreateBlankScheduleRequest body: body (required)
        :return: BuScheduleMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_schedules`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_businessunit_week_schedules`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_schedules`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuScheduleMetadata',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_schedules_generate(self, business_unit_id, week_id, body, **kwargs):
        """
        Generate a schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_schedules_generate(business_unit_id, week_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param BuGenerateScheduleRequest body: body (required)
        :return: BuAsyncScheduleRunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_schedules_generate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_schedules_generate`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_businessunit_week_schedules_generate`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_schedules_generate`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/generate'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuAsyncScheduleRunResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_schedules_import(self, business_unit_id, week_id, body, **kwargs):
        """
        Starts processing a schedule import
        Call after uploading the schedule data to the url supplied by the /import/uploadurl route

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_schedules_import(business_unit_id, week_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param WfmProcessUploadRequest body:  (required)
        :return: ScheduleUploadProcessingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_schedules_import" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_schedules_import`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_businessunit_week_schedules_import`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_schedules_import`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/import'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleUploadProcessingResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_schedules_import_uploadurl(self, business_unit_id, week_id, body, **kwargs):
        """
        Creates a signed upload URL for importing a schedule
        Once the upload is complete, call the /import route to start the schedule import process

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_schedules_import_uploadurl(business_unit_id, week_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit (required)
        :param date week_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param UploadUrlRequestBody body: body (required)
        :return: ImportScheduleUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_schedules_import_uploadurl" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_schedules_import_uploadurl`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_businessunit_week_schedules_import_uploadurl`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_schedules_import_uploadurl`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/import/uploadurl'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportScheduleUploadResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_shorttermforecast_copy(self, business_unit_id, week_date_id, forecast_id, body, **kwargs):
        """
        Copy a short term forecast
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_shorttermforecast_copy(business_unit_id, week_date_id, forecast_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit to which the forecast belongs (required)
        :param date week_date_id: The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str forecast_id: The ID of the forecast to copy (required)
        :param CopyBuForecastRequest body: body (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes
        :return: AsyncForecastOperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_date_id', 'forecast_id', 'body', 'force_async']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_shorttermforecast_copy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_shorttermforecast_copy`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_businessunit_week_shorttermforecast_copy`")
        # verify the required parameter 'forecast_id' is set
        if ('forecast_id' not in params) or (params['forecast_id'] is None):
            raise ValueError("Missing the required parameter `forecast_id` when calling `post_workforcemanagement_businessunit_week_shorttermforecast_copy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_shorttermforecast_copy`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/copy'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'forecast_id' in params:
            path_params['forecastId'] = params['forecast_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AsyncForecastOperationResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_shorttermforecasts_generate(self, business_unit_id, week_date_id, body, **kwargs):
        """
        Generate a short term forecast
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_shorttermforecasts_generate(business_unit_id, week_date_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit to which the forecast belongs (required)
        :param date week_date_id: The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param GenerateBuForecastRequest body:  (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes
        :return: AsyncForecastOperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_date_id', 'body', 'force_async']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_shorttermforecasts_generate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_shorttermforecasts_generate`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_businessunit_week_shorttermforecasts_generate`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_shorttermforecasts_generate`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/generate'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AsyncForecastOperationResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_shorttermforecasts_import(self, business_unit_id, week_date_id, body, **kwargs):
        """
        Starts importing the uploaded short term forecast
        Call after uploading the forecast data to the url supplied by the /import/uploadurl route

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_shorttermforecasts_import(business_unit_id, week_date_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit to which the forecast belongs (required)
        :param date week_date_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param WfmProcessUploadRequest body:  (required)
        :return: ImportForecastResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_date_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_shorttermforecasts_import" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_shorttermforecasts_import`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_businessunit_week_shorttermforecasts_import`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_shorttermforecasts_import`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/import'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportForecastResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunit_week_shorttermforecasts_import_uploadurl(self, business_unit_id, week_date_id, body, **kwargs):
        """
        Creates a signed upload URL for importing a short term forecast
        Once the upload is complete, call the /import route to start the short term forecast import process

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunit_week_shorttermforecasts_import_uploadurl(business_unit_id, week_date_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str business_unit_id: The ID of the business unit to which the forecast belongs (required)
        :param date week_date_id: First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param UploadUrlRequestBody body: body (required)
        :return: ImportForecastUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_unit_id', 'week_date_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunit_week_shorttermforecasts_import_uploadurl" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'business_unit_id' is set
        if ('business_unit_id' not in params) or (params['business_unit_id'] is None):
            raise ValueError("Missing the required parameter `business_unit_id` when calling `post_workforcemanagement_businessunit_week_shorttermforecasts_import_uploadurl`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_businessunit_week_shorttermforecasts_import_uploadurl`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_businessunit_week_shorttermforecasts_import_uploadurl`")


        resource_path = '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/import/uploadurl'.replace('{format}', 'json')
        path_params = {}
        if 'business_unit_id' in params:
            path_params['businessUnitId'] = params['business_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportForecastUploadResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_businessunits(self, **kwargs):
        """
        Add a new business unit
        It may take a minute or two for a new business unit to be available for api operations

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_businessunits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateBusinessUnitRequest body: body
        :return: BusinessUnit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_businessunits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/businessunits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BusinessUnit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_calendar_url_ics(self, **kwargs):
        """
        Create a newly generated calendar link for the current user; if the current user has previously generated one, the generated link will be returned
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_calendar_url_ics(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str language: A language tag (which is sometimes referred to as a \"locale identifier\") to use to localize default activity code names in the ics-formatted calendar
        :return: CalendarUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_calendar_url_ics" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/calendar/url/ics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'language' in params:
            query_params['language'] = params['language']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CalendarUrlResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_historicaldata_deletejob(self, **kwargs):
        """
        Delete the entries of the historical data imports in the organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_historicaldata_deletejob(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: HistoricalImportDeleteJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_historicaldata_deletejob" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/historicaldata/deletejob'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HistoricalImportDeleteJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_historicaldata_validate(self, **kwargs):
        """
        Trigger validation process for historical import
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_historicaldata_validate(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ValidationServiceRequest body: body
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_historicaldata_validate" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/historicaldata/validate'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_agentschedules_search(self, management_unit_id, **kwargs):
        """
        Query published schedules for given given time range for set of users
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_agentschedules_search(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification. For testing/app development purposes
        :param bool force_download_service: Force the result of this operation to be sent via download service. For testing/app development purposes
        :param BuSearchAgentSchedulesRequest body: body
        :return: BuAsyncAgentSchedulesSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'force_async', 'force_download_service', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_agentschedules_search" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_agentschedules_search`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/agentschedules/search'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BuAsyncAgentSchedulesSearchResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_historicaladherencequery(self, management_unit_id, **kwargs):
        """
        Request a historical adherence report
        The maximum supported range for historical adherence queries is 31 days, or 7 days with includeExceptions = true

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_historicaladherencequery(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit (required)
        :param WfmHistoricalAdherenceQuery body: body
        :return: WfmHistoricalAdherenceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_historicaladherencequery" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_historicaladherencequery`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/historicaladherencequery'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmHistoricalAdherenceResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_move(self, management_unit_id, **kwargs):
        """
        Move the requested management unit to a new business unit
        Returns status 200 if the management unit is already in the requested business unit

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_move(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param MoveManagementUnitRequest body: body
        :return: MoveManagementUnitResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_move" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_move`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/move'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MoveManagementUnitResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_schedules_search(self, management_unit_id, **kwargs):
        """
        Query published schedules for given given time range for set of users
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_schedules_search(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param UserListScheduleRequestBody body: body
        :return: UserScheduleContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_schedules_search" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_schedules_search`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/schedules/search'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserScheduleContainer',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_timeofflimits(self, management_unit_id, **kwargs):
        """
        Creates a new time off limit object under management unit.
        Only one limit object is allowed under management unit, so an attempt to create second object will fail.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_timeofflimits(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param CreateTimeOffLimitRequest body: body
        :return: TimeOffLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_timeofflimits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_timeofflimits`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeofflimits'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffLimit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_timeofflimits_values_query(self, management_unit_id, **kwargs):
        """
        Retrieves time off limit related values based on a given set of filters.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_timeofflimits_values_query(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param QueryTimeOffLimitValuesRequest body: body
        :return: QueryTimeOffLimitValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_timeofflimits_values_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_timeofflimits_values_query`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeofflimits/values/query'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueryTimeOffLimitValuesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_timeoffplans(self, management_unit_id, **kwargs):
        """
        Creates a new time off plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_timeoffplans(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit (required)
        :param CreateTimeOffPlanRequest body: body
        :return: TimeOffPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_timeoffplans" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_timeoffplans`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeoffplans'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_timeoffrequests(self, management_unit_id, **kwargs):
        """
        Create a new time off request
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_timeoffrequests(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param CreateAdminTimeOffRequest body: body
        :return: TimeOffRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_timeoffrequests" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_timeoffrequests`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeoffrequests'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_timeoffrequests_query(self, management_unit_id, **kwargs):
        """
        Fetches time off requests matching the conditions specified in the request body
        Request body requires one of the following: User ID is specified, statuses == [Pending] or date range to be specified and less than or equal to 33 days.  All other fields are filters

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_timeoffrequests_query(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param TimeOffRequestQueryBody body: body
        :return: TimeOffRequestListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_timeoffrequests_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_timeoffrequests_query`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeoffrequests/query'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_timeoffrequests_waitlistpositions_query(self, management_unit_id, **kwargs):
        """
        Retrieves daily waitlist position for a list of time off requests
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_timeoffrequests_waitlistpositions_query(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param QueryWaitlistPositionsRequest body: body
        :return: WaitlistPositionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_timeoffrequests_waitlistpositions_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_timeoffrequests_waitlistpositions_query`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeoffrequests/waitlistpositions/query'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WaitlistPositionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_shifttrade_match(self, management_unit_id, week_date_id, trade_id, body, **kwargs):
        """
        Matches a shift trade. This route can only be called by the receiving agent
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_shifttrade_match(management_unit_id, week_date_id, trade_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param date week_date_id: The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str trade_id: The ID of the shift trade to update (required)
        :param MatchShiftTradeRequest body: body (required)
        :return: MatchShiftTradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'trade_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_shifttrade_match" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_shifttrade_match`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_managementunit_week_shifttrade_match`")
        # verify the required parameter 'trade_id' is set
        if ('trade_id' not in params) or (params['trade_id'] is None):
            raise ValueError("Missing the required parameter `trade_id` when calling `post_workforcemanagement_managementunit_week_shifttrade_match`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_managementunit_week_shifttrade_match`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/{tradeId}/match'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'trade_id' in params:
            path_params['tradeId'] = params['trade_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MatchShiftTradeResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_shifttrades(self, management_unit_id, week_date_id, body, **kwargs):
        """
        Adds a shift trade
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_shifttrades(management_unit_id, week_date_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param date week_date_id: The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param AddShiftTradeRequest body: body (required)
        :return: ShiftTradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_shifttrades" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_shifttrades`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_managementunit_week_shifttrades`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_managementunit_week_shifttrades`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShiftTradeResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_shifttrades_search(self, management_unit_id, week_date_id, body, **kwargs):
        """
        Searches for potential shift trade matches for the current agent
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_shifttrades_search(management_unit_id, week_date_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param date week_date_id: The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param SearchShiftTradesRequest body: body (required)
        :return: SearchShiftTradesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_shifttrades_search" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_shifttrades_search`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_managementunit_week_shifttrades_search`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_managementunit_week_shifttrades_search`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/search'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SearchShiftTradesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_shifttrades_state_bulk(self, management_unit_id, week_date_id, body, **kwargs):
        """
        Updates the state of a batch of shift trades
        Admin functionality is not supported with \"mine\".

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_shifttrades_state_bulk(management_unit_id, week_date_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param date week_date_id: The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param BulkShiftTradeStateUpdateRequest body: body (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes
        :return: BulkUpdateShiftTradeStateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'body', 'force_async']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_shifttrades_state_bulk" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_shifttrades_state_bulk`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_managementunit_week_shifttrades_state_bulk`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_managementunit_week_shifttrades_state_bulk`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/state/bulk'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkUpdateShiftTradeStateResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_workplan_copy(self, management_unit_id, work_plan_id, **kwargs):
        """
        Create a copy of work plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_workplan_copy(management_unit_id, work_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_id: The ID of the work plan to create a copy (required)
        :param CopyWorkPlan body: body
        :return: WorkPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_workplan_copy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_workplan_copy`")
        # verify the required parameter 'work_plan_id' is set
        if ('work_plan_id' not in params) or (params['work_plan_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_id` when calling `post_workforcemanagement_managementunit_workplan_copy`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}/copy'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_id' in params:
            path_params['workPlanId'] = params['work_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_workplan_validate(self, management_unit_id, work_plan_id, **kwargs):
        """
        Validate Work Plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_workplan_validate(management_unit_id, work_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_id: The ID of the work plan to validate. For new work plan, use the word 'new' for the ID. (required)
        :param list[str] expand: 
        :param WorkPlanValidationRequest body: body
        :return: ValidateWorkPlanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_id', 'expand', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_workplan_validate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_workplan_validate`")
        # verify the required parameter 'work_plan_id' is set
        if ('work_plan_id' not in params) or (params['work_plan_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_id` when calling `post_workforcemanagement_managementunit_workplan_validate`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}/validate'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_id' in params:
            path_params['workPlanId'] = params['work_plan_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ValidateWorkPlanResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_workplanrotation_copy(self, management_unit_id, work_plan_rotation_id, **kwargs):
        """
        Create a copy of work plan rotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_workplanrotation_copy(management_unit_id, work_plan_rotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_rotation_id: The ID of the work plan rotation to create a copy (required)
        :param CopyWorkPlanRotationRequest body: body
        :return: WorkPlanRotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_rotation_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_workplanrotation_copy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_workplanrotation_copy`")
        # verify the required parameter 'work_plan_rotation_id' is set
        if ('work_plan_rotation_id' not in params) or (params['work_plan_rotation_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_rotation_id` when calling `post_workforcemanagement_managementunit_workplanrotation_copy`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplanrotations/{workPlanRotationId}/copy'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_rotation_id' in params:
            path_params['workPlanRotationId'] = params['work_plan_rotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlanRotationResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_workplanrotations(self, management_unit_id, **kwargs):
        """
        Create a new work plan rotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_workplanrotations(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param AddWorkPlanRotationRequest body: body
        :return: WorkPlanRotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_workplanrotations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_workplanrotations`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplanrotations'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlanRotationResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_workplans(self, management_unit_id, **kwargs):
        """
        Create a new work plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_workplans(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str validation_mode: Allows to create work plan even if the validation result is invalid
        :param CreateWorkPlan body: body
        :return: WorkPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'validation_mode', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_workplans" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_workplans`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}
        if 'validation_mode' in params:
            query_params['validationMode'] = params['validation_mode']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunits(self, **kwargs):
        """
        Add a management unit
        It may take a minute or two for a new management unit to be available for api operations

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateManagementUnitApiRequest body: body
        :return: ManagementUnit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/managementunits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_notifications_update(self, **kwargs):
        """
        Mark a list of notifications as read or unread
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_notifications_update(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UpdateNotificationsRequest body: body
        :return: UpdateNotificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_notifications_update" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/notifications/update'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UpdateNotificationsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_schedules(self, **kwargs):
        """
        Get published schedule for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_schedules(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CurrentUserScheduleRequestBody body: body
        :return: UserScheduleContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_schedules" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/schedules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserScheduleContainer',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_timeofflimits_available_query(self, **kwargs):
        """
        Queries available time off for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_timeofflimits_available_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AvailableTimeOffRequest body: body
        :return: AvailableTimeOffResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_timeofflimits_available_query" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/timeofflimits/available/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AvailableTimeOffResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_timeoffrequests(self, **kwargs):
        """
        Create a time off request for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_timeoffrequests(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateAgentTimeOffRequest body: body
        :return: TimeOffRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_timeoffrequests" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/timeoffrequests'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_workforcemanagement_managementunit_timeofflimit_values(self, management_unit_id, time_off_limit_id, **kwargs):
        """
        Sets daily values for a date range of time off limit object
        Note that only limit daily values can be set through API, allocated and waitlisted values are read-only for time off limit API

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_workforcemanagement_managementunit_timeofflimit_values(management_unit_id, time_off_limit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param str time_off_limit_id: The ID of the time off limit object to set values for (required)
        :param SetTimeOffLimitValuesRequest body: body
        :return: TimeOffLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'time_off_limit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_workforcemanagement_managementunit_timeofflimit_values" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `put_workforcemanagement_managementunit_timeofflimit_values`")
        # verify the required parameter 'time_off_limit_id' is set
        if ('time_off_limit_id' not in params) or (params['time_off_limit_id'] is None):
            raise ValueError("Missing the required parameter `time_off_limit_id` when calling `put_workforcemanagement_managementunit_timeofflimit_values`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/timeofflimits/{timeOffLimitId}/values'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'time_off_limit_id' in params:
            path_params['timeOffLimitId'] = params['time_off_limit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffLimit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
