"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViaServicePrincipal = void 0;
const iam = require("@aws-cdk/aws-iam");
/**
 * A principal to allow access to a key if it's being used through another AWS service
 */
class ViaServicePrincipal extends iam.PrincipalBase {
    constructor(serviceName, basePrincipal) {
        super();
        this.serviceName = serviceName;
        this.basePrincipal = basePrincipal ? basePrincipal : new iam.AnyPrincipal();
    }
    get policyFragment() {
        // Make a copy of the base policyFragment to add a condition to it
        const base = this.basePrincipal.policyFragment;
        const conditions = Object.assign({}, base.conditions);
        if (conditions.StringEquals) {
            conditions.StringEquals = Object.assign({ 'kms:ViaService': this.serviceName }, conditions.StringEquals);
        }
        else {
            conditions.StringEquals = { 'kms:ViaService': this.serviceName };
        }
        return { principalJson: base.principalJson, conditions };
    }
}
exports.ViaServicePrincipal = ViaServicePrincipal;
//# sourceMappingURL=data:application/json;base64,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