/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import utils.TopoSortException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\b0\u0007\u00a8\u0006\n"}, d2={"Lutils/FastTopologicalSort;", "", "()V", "topoSort", "", "T", "m", "", "", "FastTopologicalSortWorker", "GeneralUtils"})
public final class FastTopologicalSort {
    @NotNull
    public static final FastTopologicalSort INSTANCE = new FastTopologicalSort();

    private FastTopologicalSort() {
    }

    @NotNull
    public final <T> List<T> topoSort(@NotNull Map<T, ? extends Set<? extends T>> m) {
        Intrinsics.checkNotNullParameter(m, "m");
        return new FastTopologicalSortWorker<T>(m).sort();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lutils/FastTopologicalSort$FastTopologicalSortWorker;", "T", "", "m", "", "", "(Ljava/util/Map;)V", "getM", "()Ljava/util/Map;", "revMap", "", "succRelation", "", "Ljava/util/BitSet;", "[Ljava/util/BitSet;", "univSize", "", "universe", "", "getValueNumber", "x", "(Ljava/lang/Object;)I", "mkUniverse", "", "sort", "", "GeneralUtils"})
    public static final class FastTopologicalSortWorker<T> {
        @NotNull
        private final Map<T, Set<T>> m;
        @NotNull
        private final Map<T, Integer> universe;
        @NotNull
        private final List<T> revMap;
        private int univSize;
        @NotNull
        private BitSet[] succRelation;

        public FastTopologicalSortWorker(@NotNull Map<T, ? extends Set<? extends T>> m) {
            Intrinsics.checkNotNullParameter(m, "m");
            this.m = m;
            int n = 0;
            this.universe = new LinkedHashMap();
            n = 0;
            this.revMap = new ArrayList();
            this.univSize = this.m.size();
            n = 0;
            int n2 = this.univSize;
            BitSet[] bitSetArray = new BitSet[n2];
            FastTopologicalSortWorker fastTopologicalSortWorker = this;
            while (n < n2) {
                int n3 = n++;
                bitSetArray[n3] = new BitSet(this.univSize);
            }
            fastTopologicalSortWorker.succRelation = bitSetArray;
            this.mkUniverse();
        }

        @NotNull
        public final Map<T, Set<T>> getM() {
            return this.m;
        }

        private final int getValueNumber(T x) {
            Integer n = this.universe.computeIfAbsent(x, arg_0 -> FastTopologicalSortWorker.getValueNumber$lambda-0(x, this, arg_0));
            Intrinsics.checkNotNullExpressionValue(n, "universe.computeIfAbsent\u2026          l\n            }");
            return ((Number)n).intValue();
        }

        private final void mkUniverse() {
            Object object = this.m;
            boolean bl = false;
            Iterator<Map.Entry<T, Set<T>>> iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object2 = object = iterator2.next();
                boolean bl2 = false;
                Object k = object2.getKey();
                Object object3 = object;
                boolean bl3 = false;
                Set v = (Set)object3.getValue();
                int i = this.getValueNumber(k);
                for (Object succ : v) {
                    this.succRelation[i].set(this.getValueNumber(succ));
                }
            }
        }

        @NotNull
        public final List<T> sort() {
            int nxt;
            int n;
            int n2;
            BitSet tmpSet = new BitSet(this.univSize);
            BitSet permSet = new BitSet(this.univSize);
            BitSet remaining = new BitSet(this.univSize);
            remaining.set(0, this.univSize);
            int ptr = -1;
            int n3 = 0;
            int n4 = this.univSize;
            int[] nArray = new int[n4];
            while (n3 < n4) {
                n2 = n3++;
                nArray[n2] = 0;
            }
            int[] worklist = nArray;
            Ref.IntRef outPtr = new Ref.IntRef();
            int n5 = 0;
            n2 = this.univSize;
            int[] nArray2 = new int[n2];
            while (n5 < n2) {
                n = n5++;
                nArray2[n] = 0;
            }
            int[] output = nArray2;
            Ref.IntRef popStackTop = new Ref.IntRef();
            popStackTop.element = -1;
            int n6 = 0;
            n = this.univSize;
            long[] lArray = new long[n];
            while (n6 < n) {
                int n7 = n6++;
                lArray[n7] = 0L;
            }
            long[] popStack = lArray;
            while (!remaining.isEmpty()) {
                nxt = remaining.nextSetBit(0);
                worklist[++ptr] = nxt;
                while (ptr >= 0) {
                    int poppedPosition = ptr;
                    int n8 = ptr;
                    ptr = n8 + -1;
                    int curr = worklist[n8];
                    remaining.clear(curr);
                    if (permSet.get(curr)) {
                        FastTopologicalSortWorker.sort$commitPop(popStackTop, popStack, tmpSet, permSet, output, outPtr, poppedPosition);
                        continue;
                    }
                    if (tmpSet.get(curr)) {
                        throw new TopoSortException("Found a cycle in our graph at node \"" + this.revMap.get(curr) + '\"', String.valueOf(this.revMap.get(curr)));
                    }
                    tmpSet.set(curr);
                    BitSet succ = this.succRelation[curr];
                    int it = succ.nextSetBit(0);
                    boolean pushed = false;
                    while (it > -1) {
                        if (!permSet.get(it)) {
                            worklist[++ptr] = it;
                            pushed = true;
                        }
                        it = succ.nextSetBit(it + 1);
                    }
                    if (pushed) {
                        ++popStackTop.element;
                        popStack[popStackTop.element] = (long)curr << 32 | (long)poppedPosition;
                        continue;
                    }
                    tmpSet.clear(curr);
                    permSet.set(curr);
                    int n9 = outPtr.element;
                    outPtr.element = n9 + 1;
                    output[n9] = curr;
                    FastTopologicalSortWorker.sort$commitPop(popStackTop, popStack, tmpSet, permSet, output, outPtr, poppedPosition);
                }
            }
            nxt = ptr == -1 ? 1 : 0;
            n = 0;
            boolean curr = false;
            if (_Assertions.ENABLED && nxt == 0) {
                boolean bl = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            nxt = outPtr.element == output.length ? 1 : 0;
            n = 0;
            curr = false;
            if (_Assertions.ENABLED && nxt == 0) {
                boolean bl = false;
                String string3 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string3));
            }
            n = 0;
            List toReturn = new ArrayList();
            n = ArraysKt.getLastIndex(output);
            if (0 <= n) {
                do {
                    int i = n--;
                    toReturn.add(this.revMap.get(output[i]));
                } while (0 <= n);
            }
            return toReturn;
        }

        private static final Integer getValueNumber$lambda-0(Object $x, FastTopologicalSortWorker this$0, Object it) {
            int n;
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            boolean bl = $x == it;
            boolean bl2 = false;
            int n2 = 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            int l = this$0.revMap.size();
            if (l == this$0.univSize) {
                FastTopologicalSortWorker fastTopologicalSortWorker = this$0;
                n2 = fastTopologicalSortWorker.univSize;
                fastTopologicalSortWorker.univSize = n2 + 1;
                if (this$0.univSize > this$0.succRelation.length) {
                    BitSet[] prev = this$0.succRelation;
                    n = prev.length * 2 + 1;
                    BitSet[] bitSetArray = new BitSet[n];
                    FastTopologicalSortWorker fastTopologicalSortWorker2 = this$0;
                    for (n2 = 0; n2 < n; ++n2) {
                        int n3 = n2;
                        bitSetArray[n3] = n3 < prev.length ? prev[n3] : new BitSet(this$0.univSize);
                    }
                    fastTopologicalSortWorker2.succRelation = bitSetArray;
                }
            }
            this$0.revMap.add(it);
            bl2 = CollectionsKt.getLastIndex(this$0.revMap) == l;
            n2 = 0;
            n = 0;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string3 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string3));
            }
            return l;
        }

        private static final void sort$commitPop(Ref.IntRef popStackTop, long[] popStack, BitSet tmpSet, BitSet permSet, int[] output, Ref.IntRef outPtr, int poppedPosition) {
            while (popStackTop.element >= 0 && (int)popStack[popStackTop.element] == poppedPosition) {
                int toPush = (int)(popStack[popStackTop.element] >> 32);
                tmpSet.clear(toPush);
                permSet.set(toPush);
                int n = outPtr.element;
                outPtr.element = n + 1;
                output[n] = toPush;
                n = popStackTop.element;
                popStackTop.element = n + -1;
            }
        }
    }
}

