/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import config.Config;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import log.Logger;
import log.LoggerTypes;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLRuleChoiceKt;
import spec.cvlast.DistanceToName;
import spec.cvlast.IRule;
import utils.CertoraErrorType;
import utils.CertoraException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001af\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\t\u001a\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"logger", "Llog/Logger;", "getClosestStrings", "", "", "illegalWord", "legalWords", "distanceFunc", "Lkotlin/Function2;", "", "maxDist", "maxDistRatio", "", "maxSuggestions", "maxDelta", "inputStringDistance", "_input_str", "_dict_str", "validateRuleChoice", "", "cvlAst", "Lspec/cvlast/CVLAst;", "Shared"})
public final class CVLRuleChoiceKt {
    @NotNull
    private static final Logger logger = new Logger(LoggerTypes.SPEC);

    public static final void validateRuleChoice(@NotNull CVLAst cvlAst) {
        Intrinsics.checkNotNullParameter(cvlAst, "cvlAst");
        String string2 = (String)Config.INSTANCE.getRuleChoice().getOrNull();
        if (string2 == null) {
            return;
        }
        String chosenRule = string2;
        List<IRule> allRules = cvlAst.getRules();
        boolean bl = false;
        List ruleNames = new ArrayList();
        for (IRule rule : allRules) {
            String ruleName = rule.getDeclarationId();
            if (Intrinsics.areEqual(ruleName, chosenRule)) {
                return;
            }
            ruleNames.add(ruleName);
        }
        logger.info((Function0<? extends Object>)new Function0<Object>(chosenRule, (List<String>)ruleNames){
            final /* synthetic */ String $chosenRule;
            final /* synthetic */ List<String> $ruleNames;
            {
                this.$chosenRule = $chosenRule;
                this.$ruleNames = $ruleNames;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "rule " + this.$chosenRule + " was not found. Starting to offer replacement rules names. All rule names are " + this.$ruleNames;
            }
        });
        String errStr = "rule " + chosenRule + " was not found in any of the specification files.";
        List allSuggestions = CVLRuleChoiceKt.getClosestStrings$default(chosenRule, ruleNames, null, 0, 0.0, 0, 0, 124, null);
        if (allSuggestions.size() == 1) {
            errStr = errStr + " Did you mean rule " + (String)allSuggestions.get(0) + '?';
        } else if (allSuggestions.size() == 2) {
            errStr = errStr + " Did you mean rule " + (String)allSuggestions.get(0) + " or " + (String)allSuggestions.get(1) + '?';
        }
        throw new CertoraException(CertoraErrorType.ILLEGAL_RULE_CHOICE, errStr, null, 4, null);
    }

    @NotNull
    public static final List<String> getClosestStrings(@NotNull String illegalWord, @NotNull List<String> legalWords, @NotNull Function2<? super String, ? super String, Integer> distanceFunc, int maxDist, double maxDistRatio, int maxSuggestions, int maxDelta) {
        DistanceToName currentTuple;
        int currDist;
        Intrinsics.checkNotNullParameter(illegalWord, "illegalWord");
        Intrinsics.checkNotNullParameter(legalWords, "legalWords");
        Intrinsics.checkNotNullParameter(distanceFunc, "distanceFunc");
        Comparator compareByDistance = CVLRuleChoiceKt::getClosestStrings$lambda-0;
        PriorityQueue<DistanceToName> distanceQueue = new PriorityQueue<DistanceToName>(compareByDistance);
        for (String legalWord : legalWords) {
            int distance = ((Number)distanceFunc.invoke(illegalWord, legalWord)).intValue();
            distanceQueue.add(new DistanceToName(distance, legalWord));
        }
        boolean legalWord = false;
        List allSuggestions = new ArrayList();
        int lastDist = Integer.MAX_VALUE;
        while (!distanceQueue.isEmpty() && allSuggestions.size() <= maxSuggestions && (currDist = (currentTuple = (DistanceToName)distanceQueue.poll()).getDistance()) <= maxDist && !((double)currDist / ((double)illegalWord.length() * 10.0) > maxDistRatio)) {
            if (lastDist != Integer.MAX_VALUE) {
                int n = currDist - lastDist;
                boolean bl = false;
                if (Math.abs(n) > maxDelta) continue;
            }
            allSuggestions.add(currentTuple.getName());
            lastDist = currDist;
        }
        return allSuggestions;
    }

    public static /* synthetic */ List getClosestStrings$default(String string2, List list2, Function2 function2, int n, double d, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            function2 = getClosestStrings.1.INSTANCE;
        }
        if ((n4 & 8) != 0) {
            n = 40;
        }
        if ((n4 & 0x10) != 0) {
            d = 0.5;
        }
        if ((n4 & 0x20) != 0) {
            n2 = 2;
        }
        if ((n4 & 0x40) != 0) {
            n3 = 2;
        }
        return CVLRuleChoiceKt.getClosestStrings(string2, list2, function2, n, d, n2, n3);
    }

    public static final int inputStringDistance(@NotNull String _input_str, @NotNull String _dict_str) {
        int row;
        Intrinsics.checkNotNullParameter(_input_str, "_input_str");
        Intrinsics.checkNotNullParameter(_dict_str, "_dict_str");
        String string2 = _input_str;
        boolean bl = false;
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).toLowerCase()");
        String inputStr = string3;
        String string4 = _dict_str;
        boolean bl2 = false;
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).toLowerCase()");
        String dictStr = string5;
        if (Intrinsics.areEqual(inputStr, dictStr)) {
            return 0;
        }
        if (StringsKt.startsWith$default(inputStr, dictStr, false, 2, null) || StringsKt.startsWith$default(dictStr, inputStr, false, 2, null)) {
            int n = dictStr.length() - inputStr.length();
            bl2 = false;
            return Math.abs(n);
        }
        int numRows = inputStr.length() + 1;
        int numCols = dictStr.length() + 1;
        int n = 0;
        int n2 = numRows;
        int[][] nArrayArray = new int[n2][];
        while (n < n2) {
            int n3 = n++;
            nArrayArray[n3] = new int[numCols];
        }
        int[][] distanceMatrix = nArrayArray;
        n = 1;
        if (n < numRows) {
            do {
                distanceMatrix[row][0] = row = n++;
            } while (n < numRows);
        }
        if ((n = 1) < numCols) {
            do {
                int col;
                distanceMatrix[0][col] = col = n++;
            } while (n < numCols);
        }
        if ((n = 1) < numRows) {
            do {
                row = n++;
                int n4 = 1;
                if (n4 >= numCols) continue;
                do {
                    char dictChar;
                    int col = n4++;
                    char inputChar = inputStr.charAt(row - 1);
                    int cost = inputChar == (dictChar = dictStr.charAt(col - 1)) ? 0 : (inputChar == '_' || dictChar == '_' ? 1 : 10);
                    int n5 = distanceMatrix[row - 1][col];
                    int n6 = distanceMatrix[row][col - 1];
                    int n7 = distanceMatrix[row - 1][col - 1];
                    boolean bl3 = false;
                    int n8 = 0;
                    n8 = Math.min(n6, n7);
                    boolean bl4 = false;
                    distanceMatrix[row][col] = cost + Math.min(n5, n8);
                } while (n4 < numCols);
            } while (n < numRows);
        }
        return distanceMatrix[numRows - 1][numCols - 1];
    }

    private static final int getClosestStrings$lambda-0(DistanceToName t1, DistanceToName t2) {
        Intrinsics.checkNotNullParameter(t1, "t1");
        Intrinsics.checkNotNullParameter(t2, "t2");
        return t1.getDistance() - t2.getDistance();
    }
}

