/*
 * Decompiled with CFR 0.152.
 */
package spec;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import log.Logger;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLErrorType;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLLhs;
import spec.cvlast.CVLLocation;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u0019\u001a\u00020\u0011J\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\nJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u000bJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\nJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\nJ\u0016\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006#"}, d2={"Lspec/CVLErrorLogger;", "", "()V", "errorCount", "", "getErrorCount", "()I", "errors", "", "Lkotlin/Pair;", "", "Lspec/cvlast/CVLLocation;", "getErrors", "()Ljava/util/Set;", "warnings", "getWarnings", "error", "", "msg", "loc", "foundTypeError", "", "getTypeErrorCount", "merge", "other", "stopIfHasErrors", "syntaxError", "message", "typeError", "Lspec/cvlast/CVLErrorType;", "exp", "Lspec/cvlast/CVLExp;", "lhs", "Lspec/cvlast/CVLLhs;", "warn", "Shared"})
public class CVLErrorLogger {
    @NotNull
    private final Set<Pair<String, CVLLocation>> errors;
    @NotNull
    private final Set<Pair<String, CVLLocation>> warnings;

    public CVLErrorLogger() {
        boolean bl = false;
        this.errors = new LinkedHashSet();
        bl = false;
        this.warnings = new LinkedHashSet();
    }

    private final int getErrorCount() {
        return this.errors.size();
    }

    public final boolean foundTypeError() {
        return this.getErrorCount() > 0;
    }

    public final int getTypeErrorCount() {
        return this.getErrorCount();
    }

    @NotNull
    public final Set<Pair<String, CVLLocation>> getErrors() {
        return this.errors;
    }

    @NotNull
    public final Set<Pair<String, CVLLocation>> getWarnings() {
        return this.warnings;
    }

    public final void error(@NotNull String msg, @NotNull CVLLocation loc) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(loc, "loc");
        if (this.errors.add(TuplesKt.to(msg, loc))) {
            String locStr = loc instanceof CVLLocation.Empty ? "" : " (" + loc + ')';
            String errorMsg = "Syntax error in spec file" + locStr + ": " + msg;
            Logger.Companion.alwaysError(errorMsg);
        }
    }

    public final void warn(@NotNull String msg, @NotNull CVLLocation loc) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(loc, "loc");
        if (this.warnings.add(TuplesKt.to(msg, loc))) {
            String locStr = loc instanceof CVLLocation.Empty ? "" : " (" + loc + ')';
            String warnMsg = "Syntax warning in spec file" + locStr + ": " + msg;
            Logger.Companion.always(warnMsg, false);
            Logger.Companion.regression((Function0<? extends Object>)new Function0<Object>(warnMsg){
                final /* synthetic */ String $warnMsg;
                {
                    this.$warnMsg = $warnMsg;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$warnMsg;
                }
            });
        }
    }

    public final void stopIfHasErrors() {
        if (this.foundTypeError()) {
            String string2 = "CVL file has errors.";
            boolean bl = false;
            System.out.println((Object)string2);
            int n = 1;
            bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    public final void merge(@NotNull CVLErrorLogger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.errors.addAll((Collection<Pair<String, CVLLocation>>)other.errors);
        this.warnings.addAll((Collection<Pair<String, CVLLocation>>)other.warnings);
    }

    public final void syntaxError(@NotNull CVLLocation loc, @NotNull String message) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(message, "message");
        this.error(message, loc);
    }

    @NotNull
    public final CVLErrorType typeError(@NotNull CVLLhs lhs, @NotNull CVLLocation loc, @NotNull String message) {
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(message, "message");
        this.error("could not type expression \"" + lhs + "\", message: " + message, loc);
        return new CVLErrorType(lhs.getIdLhs().toVariable(), message);
    }

    @NotNull
    public final CVLErrorType typeError(@NotNull CVLExp exp, @NotNull CVLLocation loc, @NotNull String message) {
        Intrinsics.checkNotNullParameter(exp, "exp");
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(message, "message");
        this.error("could not type expression \"" + exp + "\", message: " + message, loc);
        return new CVLErrorType(exp, message);
    }

    @NotNull
    public final CVLErrorType typeError(@NotNull CVLExp exp, @NotNull CVLLocation loc) {
        Intrinsics.checkNotNullParameter(exp, "exp");
        Intrinsics.checkNotNullParameter(loc, "loc");
        this.error("could not type expression \"" + exp + '\"', loc);
        return new CVLErrorType(exp, null, 2, null);
    }
}

