/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J5\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lsolver/VampireSolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_VAMPIRE_COMMAND", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "", "getDefaultConfigs", "Lsolver/SolverConfig;", "memlimitBytes", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "(Ljava/time/Duration;Ljava/lang/Long;ZLsolver/SolverConfig$LogicFeatures;)Ljava/util/List;", "getProcessTimeoutString", "getQueryTimeoutString", "supportsLogicFeatures", "features", "GeneralUtils"})
public final class VampireSolverInfo
extends SolverInfo {
    @NotNull
    public static final VampireSolverInfo INSTANCE = new VampireSolverInfo();
    @NotNull
    private static final String DEFAULT_VAMPIRE_COMMAND = "vprover";

    private VampireSolverInfo() {
        super("Vampire");
    }

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        String[] stringArray = new String[]{"--time_limit", String.valueOf(timeout.toSeconds())};
        return CollectionsKt.listOf(stringArray);
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        String[] stringArray = new String[]{"--time_limit", String.valueOf(timeout.toSeconds())};
        return CollectionsKt.listOf(stringArray);
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Duration timeout, boolean incrementalMode) {
        List<String> list2;
        boolean bl = !incrementalMode;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            throw new UnsupportedOperationException("incremental mode is not supported by Vampire");
        }
        String string2 = customSolverExecutable;
        String[] stringArray = new String[]{string2 == null ? DEFAULT_VAMPIRE_COMMAND : string2, "--input_syntax", "smtlib2", "--mode", "portfolio", "--schedule", "smtcomp", "--cores", "1", "--output_mode", "smtcomp"};
        Collection collection = CollectionsKt.listOf(stringArray);
        if (timeout != null) {
            list2 = this.getQueryTimeoutString(timeout);
        } else {
            boolean bl5 = false;
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list2);
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_VAMPIRE_COMMAND;
    }

    @Override
    @NotNull
    public List<SolverConfig> getDefaultConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode, @NotNull SolverConfig.LogicFeatures logicFeatures) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
        boolean bl = false;
        return CollectionsKt.listOf(new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.emptyList(), null, null, null, 224, null));
    }
}

