/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parallel.Parallel;
import parallel.Scheduler;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B8\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u001d\u0010\u0007\u001a\u0019\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0005\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u0013\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lparallel/CancellableJob;", "T", "", "Lparallel/Parallel;", "cancel", "Lkotlin/Function1;", "", "f", "Lparallel/Scheduler;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getCancel", "()Lkotlin/jvm/functions/Function1;", "deps", "", "getDeps", "()Ljava/util/List;", "errorResult", "Ljava/lang/Object;", "result", "getResult", "()Ljava/lang/Object;", "task", "done", "", "schedule", "ioPool", "Ljava/util/concurrent/ExecutorService;", "signalError", "", "t", "GeneralUtils"})
public final class CancellableJob<T>
extends Parallel<T> {
    @NotNull
    private final Function1<Throwable, T> cancel;
    @NotNull
    private final Parallel<T> task;
    @Nullable
    private T errorResult;

    public CancellableJob(@NotNull Function1<? super Throwable, ? extends T> cancel, @NotNull Function1<? super Scheduler, ? extends Parallel<? extends T>> f) {
        Intrinsics.checkNotNullParameter(cancel, "cancel");
        Intrinsics.checkNotNullParameter(f, "f");
        super(null);
        this.cancel = cancel;
        this.task = f.invoke(Scheduler.INSTANCE);
    }

    @NotNull
    public final Function1<Throwable, T> getCancel() {
        return this.cancel;
    }

    @Override
    @NotNull
    public List<Parallel<?>> getDeps() {
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    public final void signalError(@NotNull Throwable t2) {
        Intrinsics.checkNotNullParameter(t2, "t");
        this.errorResult = this.cancel.invoke(t2);
    }

    @Override
    public boolean done() {
        return this.errorResult != null || this.task.done();
    }

    @Override
    @NotNull
    public T getResult() {
        T t2 = this.errorResult;
        return t2 == null ? this.task.getResult() : t2;
    }

    @Override
    @NotNull
    public List<Parallel<?>> schedule(@NotNull ExecutorService ioPool) {
        Intrinsics.checkNotNullParameter(ioPool, "ioPool");
        return CollectionsKt.listOf(this.task);
    }
}

