/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PatternOptionBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHandler {
    public static Object createValue(String str2, Object obj) throws ParseException {
        return TypeHandler.createValue(str2, (Class)obj);
    }

    public static Object createValue(String str2, Class<?> clazz) throws ParseException {
        if (PatternOptionBuilder.STRING_VALUE == clazz) {
            return str2;
        }
        if (PatternOptionBuilder.OBJECT_VALUE == clazz) {
            return TypeHandler.createObject(str2);
        }
        if (PatternOptionBuilder.NUMBER_VALUE == clazz) {
            return TypeHandler.createNumber(str2);
        }
        if (PatternOptionBuilder.DATE_VALUE == clazz) {
            return TypeHandler.createDate(str2);
        }
        if (PatternOptionBuilder.CLASS_VALUE == clazz) {
            return TypeHandler.createClass(str2);
        }
        if (PatternOptionBuilder.FILE_VALUE == clazz) {
            return TypeHandler.createFile(str2);
        }
        if (PatternOptionBuilder.EXISTING_FILE_VALUE == clazz) {
            return TypeHandler.createFile(str2);
        }
        if (PatternOptionBuilder.FILES_VALUE == clazz) {
            return TypeHandler.createFiles(str2);
        }
        if (PatternOptionBuilder.URL_VALUE == clazz) {
            return TypeHandler.createURL(str2);
        }
        return null;
    }

    public static Object createObject(String classname) throws ParseException {
        Class<?> cl;
        try {
            cl = Class.forName(classname);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ParseException("Unable to find the class: " + classname);
        }
        try {
            return cl.newInstance();
        }
        catch (Exception e) {
            throw new ParseException(e.getClass().getName() + "; Unable to create an instance of: " + classname);
        }
    }

    public static Number createNumber(String str2) throws ParseException {
        try {
            if (str2.indexOf(46) != -1) {
                return Double.valueOf(str2);
            }
            return Long.valueOf(str2);
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.getMessage());
        }
    }

    public static Class<?> createClass(String classname) throws ParseException {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Unable to find the class: " + classname);
        }
    }

    public static Date createDate(String str2) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static URL createURL(String str2) throws ParseException {
        try {
            return new URL(str2);
        }
        catch (MalformedURLException e) {
            throw new ParseException("Unable to parse the URL: " + str2);
        }
    }

    public static File createFile(String str2) {
        return new File(str2);
    }

    public static File[] createFiles(String str2) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

