# Generated by ariadne-codegen
# Source: ./documents

from typing import List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    AzureDocumentIntelligenceModels,
    ContentTypes,
    DeepgramModels,
    EntityEnrichmentServiceTypes,
    EntityExtractionServiceTypes,
    EntityState,
    FilePreparationServiceTypes,
    FileTypes,
    IntegrationServiceTypes,
    LinkTypes,
    ObservableTypes,
    OpenAIVisionDetailLevels,
    SummarizationTypes,
)


class UpdateWorkflow(BaseModel):
    update_workflow: Optional["UpdateWorkflowUpdateWorkflow"] = Field(
        alias="updateWorkflow"
    )


class UpdateWorkflowUpdateWorkflow(BaseModel):
    id: str
    name: str
    state: EntityState
    ingestion: Optional["UpdateWorkflowUpdateWorkflowIngestion"]
    preparation: Optional["UpdateWorkflowUpdateWorkflowPreparation"]
    extraction: Optional["UpdateWorkflowUpdateWorkflowExtraction"]
    enrichment: Optional["UpdateWorkflowUpdateWorkflowEnrichment"]
    actions: Optional[List[Optional["UpdateWorkflowUpdateWorkflowActions"]]]


class UpdateWorkflowUpdateWorkflowIngestion(BaseModel):
    if_: Optional["UpdateWorkflowUpdateWorkflowIngestionIf"] = Field(alias="if")
    collections: Optional[
        List[Optional["UpdateWorkflowUpdateWorkflowIngestionCollections"]]
    ]


class UpdateWorkflowUpdateWorkflowIngestionIf(BaseModel):
    types: Optional[List[Optional[ContentTypes]]]
    file_types: Optional[List[Optional[FileTypes]]] = Field(alias="fileTypes")


class UpdateWorkflowUpdateWorkflowIngestionCollections(BaseModel):
    id: str


class UpdateWorkflowUpdateWorkflowPreparation(BaseModel):
    disable_smart_capture: Optional[bool] = Field(alias="disableSmartCapture")
    summarizations: Optional[
        List[Optional["UpdateWorkflowUpdateWorkflowPreparationSummarizations"]]
    ]
    jobs: Optional[List[Optional["UpdateWorkflowUpdateWorkflowPreparationJobs"]]]


class UpdateWorkflowUpdateWorkflowPreparationSummarizations(BaseModel):
    type: SummarizationTypes
    specification: Optional[
        "UpdateWorkflowUpdateWorkflowPreparationSummarizationsSpecification"
    ]
    tokens: Optional[int]
    items: Optional[int]


class UpdateWorkflowUpdateWorkflowPreparationSummarizationsSpecification(BaseModel):
    id: str


class UpdateWorkflowUpdateWorkflowPreparationJobs(BaseModel):
    connector: Optional["UpdateWorkflowUpdateWorkflowPreparationJobsConnector"]


class UpdateWorkflowUpdateWorkflowPreparationJobsConnector(BaseModel):
    type: FilePreparationServiceTypes
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    azure_document: Optional[
        "UpdateWorkflowUpdateWorkflowPreparationJobsConnectorAzureDocument"
    ] = Field(alias="azureDocument")
    deepgram: Optional["UpdateWorkflowUpdateWorkflowPreparationJobsConnectorDeepgram"]
    document: Optional["UpdateWorkflowUpdateWorkflowPreparationJobsConnectorDocument"]
    email: Optional["UpdateWorkflowUpdateWorkflowPreparationJobsConnectorEmail"]


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorAzureDocument(BaseModel):
    model: Optional[AzureDocumentIntelligenceModels]


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorDeepgram(BaseModel):
    model: Optional[DeepgramModels]
    key: Optional[str]
    enable_redaction: Optional[bool] = Field(alias="enableRedaction")
    enable_speaker_diarization: Optional[bool] = Field(alias="enableSpeakerDiarization")


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorDocument(BaseModel):
    include_images: Optional[bool] = Field(alias="includeImages")


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorEmail(BaseModel):
    include_attachments: Optional[bool] = Field(alias="includeAttachments")


class UpdateWorkflowUpdateWorkflowExtraction(BaseModel):
    jobs: Optional[List[Optional["UpdateWorkflowUpdateWorkflowExtractionJobs"]]]


class UpdateWorkflowUpdateWorkflowExtractionJobs(BaseModel):
    connector: Optional["UpdateWorkflowUpdateWorkflowExtractionJobsConnector"]


class UpdateWorkflowUpdateWorkflowExtractionJobsConnector(BaseModel):
    type: EntityExtractionServiceTypes
    content_types: Optional[List[ContentTypes]] = Field(alias="contentTypes")
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    extracted_types: Optional[List[ObservableTypes]] = Field(alias="extractedTypes")
    azure_text: Optional[
        "UpdateWorkflowUpdateWorkflowExtractionJobsConnectorAzureText"
    ] = Field(alias="azureText")
    azure_image: Optional[
        "UpdateWorkflowUpdateWorkflowExtractionJobsConnectorAzureImage"
    ] = Field(alias="azureImage")
    open_ai_image: Optional[
        "UpdateWorkflowUpdateWorkflowExtractionJobsConnectorOpenAiImage"
    ] = Field(alias="openAIImage")
    model_text: Optional[
        "UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelText"
    ] = Field(alias="modelText")


class UpdateWorkflowUpdateWorkflowExtractionJobsConnectorAzureText(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")
    enable_pii: Optional[bool] = Field(alias="enablePII")


class UpdateWorkflowUpdateWorkflowExtractionJobsConnectorAzureImage(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")


class UpdateWorkflowUpdateWorkflowExtractionJobsConnectorOpenAiImage(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")
    detail_level: Optional[OpenAIVisionDetailLevels] = Field(alias="detailLevel")


class UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelText(BaseModel):
    specification: Optional[
        "UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelTextSpecification"
    ]


class UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelTextSpecification(
    BaseModel
):
    id: str


class UpdateWorkflowUpdateWorkflowEnrichment(BaseModel):
    link: Optional["UpdateWorkflowUpdateWorkflowEnrichmentLink"]
    jobs: Optional[List[Optional["UpdateWorkflowUpdateWorkflowEnrichmentJobs"]]]


class UpdateWorkflowUpdateWorkflowEnrichmentLink(BaseModel):
    enable_crawling: Optional[bool] = Field(alias="enableCrawling")
    allowed_domains: Optional[List[str]] = Field(alias="allowedDomains")
    excluded_domains: Optional[List[str]] = Field(alias="excludedDomains")
    allowed_links: Optional[List[LinkTypes]] = Field(alias="allowedLinks")
    excluded_links: Optional[List[LinkTypes]] = Field(alias="excludedLinks")
    allowed_files: Optional[List[FileTypes]] = Field(alias="allowedFiles")
    excluded_files: Optional[List[FileTypes]] = Field(alias="excludedFiles")
    allow_content_domain: Optional[bool] = Field(alias="allowContentDomain")
    maximum_links: Optional[int] = Field(alias="maximumLinks")


class UpdateWorkflowUpdateWorkflowEnrichmentJobs(BaseModel):
    connector: Optional["UpdateWorkflowUpdateWorkflowEnrichmentJobsConnector"]


class UpdateWorkflowUpdateWorkflowEnrichmentJobsConnector(BaseModel):
    type: Optional[EntityEnrichmentServiceTypes]
    enriched_types: Optional[List[Optional[ObservableTypes]]] = Field(
        alias="enrichedTypes"
    )


class UpdateWorkflowUpdateWorkflowActions(BaseModel):
    connector: Optional["UpdateWorkflowUpdateWorkflowActionsConnector"]


class UpdateWorkflowUpdateWorkflowActionsConnector(BaseModel):
    type: IntegrationServiceTypes
    uri: Optional[str]
    slack: Optional["UpdateWorkflowUpdateWorkflowActionsConnectorSlack"]


class UpdateWorkflowUpdateWorkflowActionsConnectorSlack(BaseModel):
    token: str
    channel: str


UpdateWorkflow.model_rebuild()
UpdateWorkflowUpdateWorkflow.model_rebuild()
UpdateWorkflowUpdateWorkflowIngestion.model_rebuild()
UpdateWorkflowUpdateWorkflowPreparation.model_rebuild()
UpdateWorkflowUpdateWorkflowPreparationSummarizations.model_rebuild()
UpdateWorkflowUpdateWorkflowPreparationJobs.model_rebuild()
UpdateWorkflowUpdateWorkflowPreparationJobsConnector.model_rebuild()
UpdateWorkflowUpdateWorkflowExtraction.model_rebuild()
UpdateWorkflowUpdateWorkflowExtractionJobs.model_rebuild()
UpdateWorkflowUpdateWorkflowExtractionJobsConnector.model_rebuild()
UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelText.model_rebuild()
UpdateWorkflowUpdateWorkflowEnrichment.model_rebuild()
UpdateWorkflowUpdateWorkflowEnrichmentJobs.model_rebuild()
UpdateWorkflowUpdateWorkflowActions.model_rebuild()
UpdateWorkflowUpdateWorkflowActionsConnector.model_rebuild()
