# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    AzureDocumentIntelligenceModels,
    ContentTypes,
    DeepgramModels,
    EntityEnrichmentServiceTypes,
    EntityExtractionServiceTypes,
    EntityState,
    FilePreparationServiceTypes,
    FileTypes,
    IntegrationServiceTypes,
    LinkTypes,
    ObservableTypes,
    OpenAIVisionDetailLevels,
    SummarizationTypes,
)


class QueryWorkflows(BaseModel):
    workflows: Optional["QueryWorkflowsWorkflows"]


class QueryWorkflowsWorkflows(BaseModel):
    results: Optional[List[Optional["QueryWorkflowsWorkflowsResults"]]]


class QueryWorkflowsWorkflowsResults(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    owner: "QueryWorkflowsWorkflowsResultsOwner"
    state: EntityState
    ingestion: Optional["QueryWorkflowsWorkflowsResultsIngestion"]
    preparation: Optional["QueryWorkflowsWorkflowsResultsPreparation"]
    extraction: Optional["QueryWorkflowsWorkflowsResultsExtraction"]
    enrichment: Optional["QueryWorkflowsWorkflowsResultsEnrichment"]
    actions: Optional[List[Optional["QueryWorkflowsWorkflowsResultsActions"]]]


class QueryWorkflowsWorkflowsResultsOwner(BaseModel):
    id: str


class QueryWorkflowsWorkflowsResultsIngestion(BaseModel):
    if_: Optional["QueryWorkflowsWorkflowsResultsIngestionIf"] = Field(alias="if")
    collections: Optional[
        List[Optional["QueryWorkflowsWorkflowsResultsIngestionCollections"]]
    ]


class QueryWorkflowsWorkflowsResultsIngestionIf(BaseModel):
    types: Optional[List[Optional[ContentTypes]]]
    file_types: Optional[List[Optional[FileTypes]]] = Field(alias="fileTypes")


class QueryWorkflowsWorkflowsResultsIngestionCollections(BaseModel):
    id: str


class QueryWorkflowsWorkflowsResultsPreparation(BaseModel):
    disable_smart_capture: Optional[bool] = Field(alias="disableSmartCapture")
    summarizations: Optional[
        List[Optional["QueryWorkflowsWorkflowsResultsPreparationSummarizations"]]
    ]
    jobs: Optional[List[Optional["QueryWorkflowsWorkflowsResultsPreparationJobs"]]]


class QueryWorkflowsWorkflowsResultsPreparationSummarizations(BaseModel):
    type: SummarizationTypes
    specification: Optional[
        "QueryWorkflowsWorkflowsResultsPreparationSummarizationsSpecification"
    ]
    tokens: Optional[int]
    items: Optional[int]


class QueryWorkflowsWorkflowsResultsPreparationSummarizationsSpecification(BaseModel):
    id: str


class QueryWorkflowsWorkflowsResultsPreparationJobs(BaseModel):
    connector: Optional["QueryWorkflowsWorkflowsResultsPreparationJobsConnector"]


class QueryWorkflowsWorkflowsResultsPreparationJobsConnector(BaseModel):
    type: FilePreparationServiceTypes
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    azure_document: Optional[
        "QueryWorkflowsWorkflowsResultsPreparationJobsConnectorAzureDocument"
    ] = Field(alias="azureDocument")
    deepgram: Optional["QueryWorkflowsWorkflowsResultsPreparationJobsConnectorDeepgram"]
    document: Optional["QueryWorkflowsWorkflowsResultsPreparationJobsConnectorDocument"]
    email: Optional["QueryWorkflowsWorkflowsResultsPreparationJobsConnectorEmail"]


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorAzureDocument(BaseModel):
    model: Optional[AzureDocumentIntelligenceModels]


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorDeepgram(BaseModel):
    model: Optional[DeepgramModels]
    key: Optional[str]
    enable_redaction: Optional[bool] = Field(alias="enableRedaction")
    enable_speaker_diarization: Optional[bool] = Field(alias="enableSpeakerDiarization")


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorDocument(BaseModel):
    include_images: Optional[bool] = Field(alias="includeImages")


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorEmail(BaseModel):
    include_attachments: Optional[bool] = Field(alias="includeAttachments")


class QueryWorkflowsWorkflowsResultsExtraction(BaseModel):
    jobs: Optional[List[Optional["QueryWorkflowsWorkflowsResultsExtractionJobs"]]]


class QueryWorkflowsWorkflowsResultsExtractionJobs(BaseModel):
    connector: Optional["QueryWorkflowsWorkflowsResultsExtractionJobsConnector"]


class QueryWorkflowsWorkflowsResultsExtractionJobsConnector(BaseModel):
    type: EntityExtractionServiceTypes
    content_types: Optional[List[ContentTypes]] = Field(alias="contentTypes")
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    extracted_types: Optional[List[ObservableTypes]] = Field(alias="extractedTypes")
    azure_text: Optional[
        "QueryWorkflowsWorkflowsResultsExtractionJobsConnectorAzureText"
    ] = Field(alias="azureText")
    azure_image: Optional[
        "QueryWorkflowsWorkflowsResultsExtractionJobsConnectorAzureImage"
    ] = Field(alias="azureImage")
    open_ai_image: Optional[
        "QueryWorkflowsWorkflowsResultsExtractionJobsConnectorOpenAiImage"
    ] = Field(alias="openAIImage")
    model_text: Optional[
        "QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelText"
    ] = Field(alias="modelText")


class QueryWorkflowsWorkflowsResultsExtractionJobsConnectorAzureText(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")
    enable_pii: Optional[bool] = Field(alias="enablePII")


class QueryWorkflowsWorkflowsResultsExtractionJobsConnectorAzureImage(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")


class QueryWorkflowsWorkflowsResultsExtractionJobsConnectorOpenAiImage(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")
    detail_level: Optional[OpenAIVisionDetailLevels] = Field(alias="detailLevel")


class QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelText(BaseModel):
    specification: Optional[
        "QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelTextSpecification"
    ]


class QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelTextSpecification(
    BaseModel
):
    id: str


class QueryWorkflowsWorkflowsResultsEnrichment(BaseModel):
    link: Optional["QueryWorkflowsWorkflowsResultsEnrichmentLink"]
    jobs: Optional[List[Optional["QueryWorkflowsWorkflowsResultsEnrichmentJobs"]]]


class QueryWorkflowsWorkflowsResultsEnrichmentLink(BaseModel):
    enable_crawling: Optional[bool] = Field(alias="enableCrawling")
    allowed_domains: Optional[List[str]] = Field(alias="allowedDomains")
    excluded_domains: Optional[List[str]] = Field(alias="excludedDomains")
    allowed_links: Optional[List[LinkTypes]] = Field(alias="allowedLinks")
    excluded_links: Optional[List[LinkTypes]] = Field(alias="excludedLinks")
    allowed_files: Optional[List[FileTypes]] = Field(alias="allowedFiles")
    excluded_files: Optional[List[FileTypes]] = Field(alias="excludedFiles")
    allow_content_domain: Optional[bool] = Field(alias="allowContentDomain")
    maximum_links: Optional[int] = Field(alias="maximumLinks")


class QueryWorkflowsWorkflowsResultsEnrichmentJobs(BaseModel):
    connector: Optional["QueryWorkflowsWorkflowsResultsEnrichmentJobsConnector"]


class QueryWorkflowsWorkflowsResultsEnrichmentJobsConnector(BaseModel):
    type: Optional[EntityEnrichmentServiceTypes]
    enriched_types: Optional[List[Optional[ObservableTypes]]] = Field(
        alias="enrichedTypes"
    )


class QueryWorkflowsWorkflowsResultsActions(BaseModel):
    connector: Optional["QueryWorkflowsWorkflowsResultsActionsConnector"]


class QueryWorkflowsWorkflowsResultsActionsConnector(BaseModel):
    type: IntegrationServiceTypes
    uri: Optional[str]
    slack: Optional["QueryWorkflowsWorkflowsResultsActionsConnectorSlack"]


class QueryWorkflowsWorkflowsResultsActionsConnectorSlack(BaseModel):
    token: str
    channel: str


QueryWorkflows.model_rebuild()
QueryWorkflowsWorkflows.model_rebuild()
QueryWorkflowsWorkflowsResults.model_rebuild()
QueryWorkflowsWorkflowsResultsIngestion.model_rebuild()
QueryWorkflowsWorkflowsResultsPreparation.model_rebuild()
QueryWorkflowsWorkflowsResultsPreparationSummarizations.model_rebuild()
QueryWorkflowsWorkflowsResultsPreparationJobs.model_rebuild()
QueryWorkflowsWorkflowsResultsPreparationJobsConnector.model_rebuild()
QueryWorkflowsWorkflowsResultsExtraction.model_rebuild()
QueryWorkflowsWorkflowsResultsExtractionJobs.model_rebuild()
QueryWorkflowsWorkflowsResultsExtractionJobsConnector.model_rebuild()
QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelText.model_rebuild()
QueryWorkflowsWorkflowsResultsEnrichment.model_rebuild()
QueryWorkflowsWorkflowsResultsEnrichmentJobs.model_rebuild()
QueryWorkflowsWorkflowsResultsActions.model_rebuild()
QueryWorkflowsWorkflowsResultsActionsConnector.model_rebuild()
