# Generated by ariadne-codegen
# Source: https://data-scus-dev.graphlit.io/api/v1/graphql

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    AlertTypes,
    AnthropicModels,
    AzureDocumentIntelligenceModels,
    AzureOpenAIModels,
    CategoryFacetTypes,
    CollectionTypes,
    ContentFacetTypes,
    ContentPublishingFormats,
    ContentPublishingServiceTypes,
    ContentTypes,
    ConversationSearchTypes,
    ConversationStrategyTypes,
    ConversationTypes,
    DeepgramModels,
    ElevenLabsModels,
    EmailListingTypes,
    EntityEnrichmentServiceTypes,
    EntityExtractionServiceTypes,
    EntityState,
    EnvironmentTypes,
    EventFacetTypes,
    FeedListingTypes,
    FeedServiceTypes,
    FeedTypes,
    FilePreparationServiceTypes,
    FileTypes,
    GroqModels,
    H3ResolutionTypes,
    IntegrationServiceTypes,
    LabelFacetTypes,
    LinkTypes,
    MetadataTypes,
    MistralModels,
    ModelServiceTypes,
    NotionTypes,
    ObservableTypes,
    OccurrenceTypes,
    OpenAIModels,
    OpenAIVisionDetailLevels,
    OrderByTypes,
    OrderDirectionTypes,
    OrganizationFacetTypes,
    PersonFacetTypes,
    PlaceFacetTypes,
    PolicyTimeTypes,
    ProductFacetTypes,
    PromptStrategyTypes,
    ReplicateModels,
    RepoFacetTypes,
    ResourceConnectorTypes,
    RetrievalStrategyTypes,
    SearchQueryTypes,
    SearchTypes,
    SharePointAuthenticationTypes,
    SoftwareFacetTypes,
    SpecificationTypes,
    SummarizationTypes,
    TimedPolicyRecurrenceTypes,
    TimeIntervalTypes,
    YouTubeTypes,
)


class AlertFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    types: Optional[List[Optional[AlertTypes]]] = None


class CategoryFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )


class CollectionFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    types: Optional[List[CollectionTypes]] = None


class ContentFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    search_type: Optional[SearchTypes] = Field(alias="searchType", default=None)
    query_type: Optional[SearchQueryTypes] = Field(alias="queryType", default=None)
    number_similar: Optional[int] = Field(alias="numberSimilar", default=None)
    types: Optional[List[ContentTypes]] = None
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes", default=None)
    uri: Optional[Any] = None
    location: Optional["PointFilter"] = None
    h_3: Optional["H3Filter"] = Field(alias="h3", default=None)
    boundaries: Optional[List[Optional[Any]]] = None
    contents: Optional[List["EntityReferenceFilter"]] = None
    feeds: Optional[List["EntityReferenceFilter"]] = None
    workflows: Optional[List["EntityReferenceFilter"]] = None
    collections: Optional[List["EntityReferenceFilter"]] = None
    observations: Optional[List["ObservationReferenceFilter"]] = None
    original_date_range: Optional["DateRangeFilter"] = Field(
        alias="originalDateRange", default=None
    )
    formats: Optional[List[Optional[str]]] = None
    file_extensions: Optional[List[str]] = Field(alias="fileExtensions", default=None)
    file_size_range: Optional["Int64RangeFilter"] = Field(
        alias="fileSizeRange", default=None
    )


class ConversationFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    types: Optional[List[ConversationTypes]] = None
    search_type: Optional[SearchTypes] = Field(alias="searchType", default=None)
    query_type: Optional[SearchQueryTypes] = Field(alias="queryType", default=None)
    number_similar: Optional[int] = Field(alias="numberSimilar", default=None)
    conversations: Optional[List["EntityReferenceFilter"]] = None


class EventFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    address: Optional["AddressFilter"] = None
    location: Optional["PointFilter"] = None
    h_3: Optional["H3Filter"] = Field(alias="h3", default=None)
    boundaries: Optional[List[Optional[Any]]] = None
    start_date_range: Optional["DateRangeFilter"] = Field(
        alias="startDateRange", default=None
    )
    end_date_range: Optional["DateRangeFilter"] = Field(
        alias="endDateRange", default=None
    )
    availability_start_date_range: Optional["DateRangeFilter"] = Field(
        alias="availabilityStartDateRange", default=None
    )
    availability_end_date_range: Optional["DateRangeFilter"] = Field(
        alias="availabilityEndDateRange", default=None
    )
    price: Optional[Any] = None
    min_price: Optional[Any] = Field(alias="minPrice", default=None)
    max_price: Optional[Any] = Field(alias="maxPrice", default=None)
    price_currency: Optional[str] = Field(alias="priceCurrency", default=None)
    is_accessible_for_free: Optional[bool] = Field(
        alias="isAccessibleForFree", default=None
    )
    typical_age_range: Optional[str] = Field(alias="typicalAgeRange", default=None)


class FeedFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    types: Optional[List[Optional[FeedTypes]]] = None


class LabelFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )


class MetadataFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    metadata_types: Optional[List[Optional[MetadataTypes]]] = Field(
        alias="metadataTypes", default=None
    )
    content: Optional["EntityReferenceFilter"] = None


class ObservationReferenceFilter(BaseModel):
    type: ObservableTypes
    observable: "EntityReferenceFilter"
    states: Optional[List[Optional[EntityState]]] = None


class OrganizationFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    address: Optional["AddressFilter"] = None
    location: Optional["PointFilter"] = None
    h_3: Optional["H3Filter"] = Field(alias="h3", default=None)
    boundaries: Optional[List[Optional[Any]]] = None


class PersonFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    address: Optional["AddressFilter"] = None
    location: Optional["PointFilter"] = None
    h_3: Optional["H3Filter"] = Field(alias="h3", default=None)
    boundaries: Optional[List[Optional[Any]]] = None
    given_name: Optional[str] = Field(alias="givenName", default=None)
    family_name: Optional[str] = Field(alias="familyName", default=None)
    phone_number: Optional[str] = Field(alias="phoneNumber", default=None)
    email: Optional[str] = None


class PlaceFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    address: Optional["AddressFilter"] = None
    location: Optional["PointFilter"] = None
    h_3: Optional["H3Filter"] = Field(alias="h3", default=None)
    boundaries: Optional[List[Optional[Any]]] = None


class ProductFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    address: Optional["AddressFilter"] = None
    location: Optional["PointFilter"] = None
    h_3: Optional["H3Filter"] = Field(alias="h3", default=None)
    boundaries: Optional[List[Optional[Any]]] = None
    production_date_range: Optional["DateRangeFilter"] = Field(
        alias="productionDateRange", default=None
    )
    release_date_range: Optional["DateRangeFilter"] = Field(
        alias="releaseDateRange", default=None
    )
    sku: Optional[str] = None
    upc: Optional[str] = None
    manufacturer: Optional[str] = None
    brand: Optional[str] = None
    model: Optional[str] = None


class ProjectFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )


class RepoFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    address: Optional["AddressFilter"] = None
    location: Optional["PointFilter"] = None
    h_3: Optional["H3Filter"] = Field(alias="h3", default=None)
    boundaries: Optional[List[Optional[Any]]] = None


class SoftwareFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    address: Optional["AddressFilter"] = None
    location: Optional["PointFilter"] = None
    h_3: Optional["H3Filter"] = Field(alias="h3", default=None)
    boundaries: Optional[List[Optional[Any]]] = None


class SpecificationFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )
    types: Optional[List[Optional[SpecificationTypes]]] = None
    service_types: Optional[List[Optional[ModelServiceTypes]]] = Field(
        alias="serviceTypes", default=None
    )


class WorkflowFilter(BaseModel):
    search: Optional[str] = None
    order_by: Optional[OrderByTypes] = Field(alias="orderBy", default=None)
    direction: Optional[OrderDirectionTypes] = None
    offset: Optional[int] = None
    limit: Optional[int] = None
    id: Optional[str] = None
    name: Optional[str] = None
    states: Optional[List[EntityState]] = None
    creation_date_range: Optional["DateRangeFilter"] = Field(
        alias="creationDateRange", default=None
    )


class AlertInput(BaseModel):
    name: str
    type: AlertTypes
    summary_prompt: Optional[str] = Field(alias="summaryPrompt", default=None)
    publish_prompt: str = Field(alias="publishPrompt")
    filter: Optional["ContentCriteriaInput"] = None
    publishing: "ContentPublishingConnectorInput"
    integration: "IntegrationConnectorInput"
    summary_specification: Optional["EntityReferenceInput"] = Field(
        alias="summarySpecification", default=None
    )
    publish_specification: Optional["EntityReferenceInput"] = Field(
        alias="publishSpecification", default=None
    )
    schedule_policy: Optional["AlertSchedulePolicyInput"] = Field(
        alias="schedulePolicy", default=None
    )


class CategoryInput(BaseModel):
    name: str
    description: Optional[str] = None


class CollectionInput(BaseModel):
    name: str
    type: Optional[CollectionTypes] = None
    contents: Optional[List["EntityReferenceInput"]] = None
    expected_count: Optional[int] = Field(alias="expectedCount", default=None)


class ContentInput(BaseModel):
    name: str
    type: Optional[ContentTypes] = None
    uri: Optional[Any] = None
    description: Optional[str] = None
    text: Optional[str] = None
    workflow: Optional["EntityReferenceInput"] = None


class ConversationInput(BaseModel):
    name: str
    type: Optional[ConversationTypes] = None
    specification: Optional["EntityReferenceInput"] = None
    filter: Optional["ContentCriteriaInput"] = None


class EventInput(BaseModel):
    name: str
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    location: Optional["PointInput"] = None
    boundary: Optional[Any] = None
    address: Optional["AddressInput"] = None
    start_date: Optional[Any] = Field(alias="startDate", default=None)
    end_date: Optional[Any] = Field(alias="endDate", default=None)
    availability_start_date: Optional[Any] = Field(
        alias="availabilityStartDate", default=None
    )
    availability_end_date: Optional[Any] = Field(
        alias="availabilityEndDate", default=None
    )
    price: Optional[Any] = None
    min_price: Optional[Any] = Field(alias="minPrice", default=None)
    max_price: Optional[Any] = Field(alias="maxPrice", default=None)
    price_currency: Optional[str] = Field(alias="priceCurrency", default=None)
    is_accessible_for_free: Optional[bool] = Field(
        alias="isAccessibleForFree", default=None
    )
    typical_age_range: Optional[str] = Field(alias="typicalAgeRange", default=None)


class FeedInput(BaseModel):
    name: str
    description: Optional[str] = None
    type: FeedTypes
    site: Optional["SiteFeedPropertiesInput"] = None
    email: Optional["EmailFeedPropertiesInput"] = None
    issue: Optional["IssueFeedPropertiesInput"] = None
    rss: Optional["RSSFeedPropertiesInput"] = None
    web: Optional["WebFeedPropertiesInput"] = None
    reddit: Optional["RedditFeedPropertiesInput"] = None
    youtube: Optional["YouTubeFeedPropertiesInput"] = None
    notion: Optional["NotionFeedPropertiesInput"] = None
    slack: Optional["SlackFeedPropertiesInput"] = None
    discord: Optional["DiscordFeedPropertiesInput"] = None
    schedule_policy: Optional["FeedSchedulePolicyInput"] = Field(
        alias="schedulePolicy", default=None
    )
    workflow: Optional["EntityReferenceInput"] = None


class LabelInput(BaseModel):
    name: str
    description: Optional[str] = None


class MetadataInput(BaseModel):
    name: str
    mime_type: Optional[str] = Field(alias="mimeType", default=None)
    value: Optional[str] = None
    content: Optional["EntityReferenceInput"] = None


class ObservationInput(BaseModel):
    content: "EntityReferenceInput"
    type: ObservableTypes
    observable: "NamedEntityReferenceInput"
    occurrences: List["ObservationOccurrenceInput"]


class OrganizationInput(BaseModel):
    name: str
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    location: Optional["PointInput"] = None
    boundary: Optional[Any] = None
    address: Optional["AddressInput"] = None
    founding_date: Optional[Any] = Field(alias="foundingDate", default=None)
    industries: Optional[List[Optional[str]]] = None
    revenue_currency: Optional[str] = Field(alias="revenueCurrency", default=None)
    revenue: Optional[Any] = None
    investment_currency: Optional[str] = Field(alias="investmentCurrency", default=None)
    investment: Optional[Any] = None


class PersonInput(BaseModel):
    name: str
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    location: Optional["PointInput"] = None
    boundary: Optional[Any] = None
    address: Optional["AddressInput"] = None
    given_name: Optional[str] = Field(alias="givenName", default=None)
    family_name: Optional[str] = Field(alias="familyName", default=None)
    phone_number: Optional[str] = Field(alias="phoneNumber", default=None)
    email: Optional[str] = None
    birth_date: Optional[Any] = Field(alias="birthDate", default=None)
    title: Optional[str] = None
    occupation: Optional[str] = None
    education: Optional[str] = None


class PlaceInput(BaseModel):
    name: str
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    location: Optional["PointInput"] = None
    boundary: Optional[Any] = None
    address: Optional["AddressInput"] = None


class ProductInput(BaseModel):
    name: str
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    location: Optional["PointInput"] = None
    boundary: Optional[Any] = None
    address: Optional["AddressInput"] = None
    production_date: Optional[Any] = Field(alias="productionDate", default=None)
    release_date: Optional[Any] = Field(alias="releaseDate", default=None)
    sku: Optional[str] = None
    upc: Optional[str] = None
    manufacturer: Optional[str] = None
    brand: Optional[str] = None
    model: Optional[str] = None


class ProjectInput(BaseModel):
    name: str
    environment_type: EnvironmentTypes = Field(alias="environmentType")
    platform: ResourceConnectorTypes
    region: str
    jwt_secret: str = Field(alias="jwtSecret")
    quota: Optional["ProjectQuotaInput"] = None
    callback_uri: Optional[Any] = Field(alias="callbackUri", default=None)


class RepoInput(BaseModel):
    name: str
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None


class SoftwareInput(BaseModel):
    name: str
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    developer: Optional[str] = None
    release_date: Optional[Any] = Field(alias="releaseDate", default=None)


class SpecificationInput(BaseModel):
    name: str
    type: Optional[SpecificationTypes] = None
    service_type: ModelServiceTypes = Field(alias="serviceType")
    search_type: Optional[ConversationSearchTypes] = Field(
        alias="searchType", default=None
    )
    number_similar: Optional[int] = Field(alias="numberSimilar", default=None)
    system_prompt: Optional[str] = Field(alias="systemPrompt", default=None)
    custom_guidance: Optional[str] = Field(alias="customGuidance", default=None)
    custom_instructions: Optional[str] = Field(alias="customInstructions", default=None)
    strategy: Optional["ConversationStrategyInput"] = None
    prompt_strategy: Optional["PromptStrategyInput"] = Field(
        alias="promptStrategy", default=None
    )
    retrieval_strategy: Optional["RetrievalStrategyInput"] = Field(
        alias="retrievalStrategy", default=None
    )
    reranking_strategy: Optional["RerankingStrategyInput"] = Field(
        alias="rerankingStrategy", default=None
    )
    tools: Optional[List["ToolDefinitionInput"]] = None
    open_ai: Optional["OpenAIModelPropertiesInput"] = Field(
        alias="openAI", default=None
    )
    azure_open_ai: Optional["AzureOpenAIModelPropertiesInput"] = Field(
        alias="azureOpenAI", default=None
    )
    anthropic: Optional["AnthropicModelPropertiesInput"] = None
    replicate: Optional["ReplicateModelPropertiesInput"] = None
    mistral: Optional["MistralModelPropertiesInput"] = None
    groq: Optional["GroqModelPropertiesInput"] = None


class WorkflowInput(BaseModel):
    name: str
    ingestion: Optional["IngestionWorkflowStageInput"] = None
    preparation: Optional["PreparationWorkflowStageInput"] = None
    extraction: Optional["ExtractionWorkflowStageInput"] = None
    enrichment: Optional["EnrichmentWorkflowStageInput"] = None
    actions: Optional[List[Optional["WorkflowActionInput"]]] = None


class AlertUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    summary_prompt: Optional[str] = Field(alias="summaryPrompt", default=None)
    publish_prompt: Optional[str] = Field(alias="publishPrompt", default=None)
    filter: Optional["ContentCriteriaInput"] = None
    publishing: Optional["ContentPublishingConnectorUpdateInput"] = None
    integration: Optional["IntegrationConnectorUpdateInput"] = None
    summary_specification: Optional["EntityReferenceInput"] = Field(
        alias="summarySpecification", default=None
    )
    publish_specification: Optional["EntityReferenceInput"] = Field(
        alias="publishSpecification", default=None
    )
    schedule_policy: Optional["AlertSchedulePolicyInput"] = Field(
        alias="schedulePolicy", default=None
    )


class CategoryUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    description: Optional[str] = None


class CollectionUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    type: Optional[CollectionTypes] = None
    contents: Optional[List["EntityReferenceInput"]] = None
    expected_count: Optional[int] = Field(alias="expectedCount", default=None)


class ConversationUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    specification: Optional["EntityReferenceInput"] = None
    filter: Optional["ContentCriteriaInput"] = None


class EventUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    location: Optional["PointInput"] = None
    boundary: Optional[Any] = None
    address: Optional["AddressInput"] = None
    start_date: Optional[Any] = Field(alias="startDate", default=None)
    end_date: Optional[Any] = Field(alias="endDate", default=None)
    availability_start_date: Optional[Any] = Field(
        alias="availabilityStartDate", default=None
    )
    availability_end_date: Optional[Any] = Field(
        alias="availabilityEndDate", default=None
    )
    price: Optional[Any] = None
    min_price: Optional[Any] = Field(alias="minPrice", default=None)
    max_price: Optional[Any] = Field(alias="maxPrice", default=None)
    price_currency: Optional[str] = Field(alias="priceCurrency", default=None)
    is_accessible_for_free: Optional[bool] = Field(
        alias="isAccessibleForFree", default=None
    )
    typical_age_range: Optional[str] = Field(alias="typicalAgeRange", default=None)


class FeedUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    description: Optional[str] = None
    type: Optional[FeedTypes] = None
    site: Optional["SiteFeedPropertiesUpdateInput"] = None
    email: Optional["EmailFeedPropertiesUpdateInput"] = None
    issue: Optional["IssueFeedPropertiesUpdateInput"] = None
    rss: Optional["RSSFeedPropertiesUpdateInput"] = None
    web: Optional["WebFeedPropertiesUpdateInput"] = None
    reddit: Optional["RedditFeedPropertiesUpdateInput"] = None
    youtube: Optional["YouTubeFeedPropertiesUpdateInput"] = None
    notion: Optional["NotionFeedPropertiesUpdateInput"] = None
    slack: Optional["SlackFeedPropertiesUpdateInput"] = None
    discord: Optional["DiscordFeedPropertiesUpdateInput"] = None
    schedule_policy: Optional["FeedSchedulePolicyInput"] = Field(
        alias="schedulePolicy", default=None
    )
    workflow: Optional["EntityReferenceInput"] = None


class LabelUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    description: Optional[str] = None


class MetadataUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    mime_type: Optional[str] = Field(alias="mimeType", default=None)
    value: Optional[str] = None
    content: Optional["EntityReferenceInput"] = None


class ObservationUpdateInput(BaseModel):
    id: str
    type: Optional[ObservableTypes] = None
    observable: Optional["NamedEntityReferenceInput"] = None
    occurrences: Optional[List["ObservationOccurrenceInput"]] = None


class OrganizationUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    location: Optional["PointInput"] = None
    boundary: Optional[Any] = None
    address: Optional["AddressInput"] = None
    founding_date: Optional[Any] = Field(alias="foundingDate", default=None)
    industries: Optional[List[Optional[str]]] = None
    revenue_currency: Optional[str] = Field(alias="revenueCurrency", default=None)
    revenue: Optional[Any] = None
    investment_currency: Optional[str] = Field(alias="investmentCurrency", default=None)
    investment: Optional[Any] = None


class PersonUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    location: Optional["PointInput"] = None
    boundary: Optional[Any] = None
    address: Optional["AddressInput"] = None
    given_name: Optional[str] = Field(alias="givenName", default=None)
    family_name: Optional[str] = Field(alias="familyName", default=None)
    phone_number: Optional[str] = Field(alias="phoneNumber", default=None)
    email: Optional[str] = None
    birth_date: Optional[Any] = Field(alias="birthDate", default=None)
    title: Optional[str] = None
    occupation: Optional[str] = None
    education: Optional[str] = None


class PlaceUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    location: Optional["PointInput"] = None
    boundary: Optional[Any] = None
    address: Optional["AddressInput"] = None


class ProductUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    location: Optional["PointInput"] = None
    boundary: Optional[Any] = None
    address: Optional["AddressInput"] = None
    production_date: Optional[Any] = Field(alias="productionDate", default=None)
    release_date: Optional[Any] = Field(alias="releaseDate", default=None)
    sku: Optional[str] = None
    upc: Optional[str] = None
    manufacturer: Optional[str] = None
    brand: Optional[str] = None
    model: Optional[str] = None


class ProjectUpdateInput(BaseModel):
    workflow: Optional["EntityReferenceInput"] = None
    specification: Optional["EntityReferenceInput"] = None
    callback_uri: Optional[Any] = Field(alias="callbackUri", default=None)


class RepoUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None


class SoftwareUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    uri: Optional[Any] = None
    identifier: Optional[str] = None
    description: Optional[str] = None
    developer: Optional[str] = None
    release_date: Optional[Any] = Field(alias="releaseDate", default=None)


class SpecificationUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    type: Optional[SpecificationTypes] = None
    service_type: ModelServiceTypes = Field(alias="serviceType")
    search_type: Optional[ConversationSearchTypes] = Field(
        alias="searchType", default=None
    )
    number_similar: Optional[int] = Field(alias="numberSimilar", default=None)
    system_prompt: Optional[str] = Field(alias="systemPrompt", default=None)
    custom_guidance: Optional[str] = Field(alias="customGuidance", default=None)
    custom_instructions: Optional[str] = Field(alias="customInstructions", default=None)
    strategy: Optional["ConversationStrategyUpdateInput"] = None
    prompt_strategy: Optional["PromptStrategyUpdateInput"] = Field(
        alias="promptStrategy", default=None
    )
    retrieval_strategy: Optional["RetrievalStrategyUpdateInput"] = Field(
        alias="retrievalStrategy", default=None
    )
    reranking_strategy: Optional["RerankingStrategyUpdateInput"] = Field(
        alias="rerankingStrategy", default=None
    )
    tools: Optional[List["ToolDefinitionUpdateInput"]] = None
    open_ai: Optional["OpenAIModelPropertiesUpdateInput"] = Field(
        alias="openAI", default=None
    )
    azure_open_ai: Optional["AzureOpenAIModelPropertiesUpdateInput"] = Field(
        alias="azureOpenAI", default=None
    )
    anthropic: Optional["AnthropicModelPropertiesUpdateInput"] = None
    replicate: Optional["ReplicateModelPropertiesUpdateInput"] = None
    mistral: Optional["MistralModelPropertiesUpdateInput"] = None
    groq: Optional["GroqModelPropertiesUpdateInput"] = None


class WorkflowUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    ingestion: Optional["IngestionWorkflowStageInput"] = None
    preparation: Optional["PreparationWorkflowStageInput"] = None
    extraction: Optional["ExtractionWorkflowStageInput"] = None
    enrichment: Optional["EnrichmentWorkflowStageInput"] = None
    actions: Optional[List[Optional["WorkflowActionInput"]]] = None


class DateRangeFilter(BaseModel):
    from_: Optional[Any] = Field(alias="from", default=None)
    to: Optional[Any] = None


class PointFilter(BaseModel):
    latitude: float
    longitude: float
    distance: Optional[float] = None


class H3Filter(BaseModel):
    indexes: Optional[List["H3IndexFilter"]] = None


class EntityReferenceFilter(BaseModel):
    id: str


class Int64RangeFilter(BaseModel):
    from_: Optional[Any] = Field(alias="from", default=None)
    to: Optional[Any] = None


class AddressFilter(BaseModel):
    street_address: Optional[str] = Field(alias="streetAddress", default=None)
    city: Optional[str] = None
    region: Optional[str] = None
    country: Optional[str] = None
    postal_code: Optional[str] = Field(alias="postalCode", default=None)


class ContentCriteriaInput(BaseModel):
    date_range: Optional["DateRangeInput"] = Field(alias="dateRange", default=None)
    creation_date_range: Optional["DateRangeInput"] = Field(
        alias="creationDateRange", default=None
    )
    types: Optional[List[ContentTypes]] = None
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes", default=None)
    contents: Optional[List["EntityReferenceInput"]] = None
    feeds: Optional[List["EntityReferenceInput"]] = None
    workflows: Optional[List["EntityReferenceInput"]] = None
    collections: Optional[List["EntityReferenceInput"]] = None
    observations: Optional[List["ObservationCriteriaInput"]] = None


class ContentPublishingConnectorInput(BaseModel):
    type: ContentPublishingServiceTypes
    format: ContentPublishingFormats
    eleven_labs: Optional["ElevenLabsPublishingPropertiesInput"] = Field(
        alias="elevenLabs", default=None
    )


class IntegrationConnectorInput(BaseModel):
    type: IntegrationServiceTypes
    uri: Optional[str] = None
    slack: Optional["SlackIntegrationPropertiesInput"] = None


class EntityReferenceInput(BaseModel):
    id: str


class AlertSchedulePolicyInput(BaseModel):
    recurrence_type: Optional[TimedPolicyRecurrenceTypes] = Field(
        alias="recurrenceType", default=None
    )
    repeat_until_time: Optional[Any] = Field(alias="repeatUntilTime", default=None)
    repeat_interval: Optional[Any] = Field(alias="repeatInterval", default=None)
    delay: Optional[Any] = None
    time_type: Optional[PolicyTimeTypes] = Field(alias="timeType", default=None)
    absolute_time: Optional[Any] = Field(alias="absoluteTime", default=None)
    relative_time: Optional[Any] = Field(alias="relativeTime", default=None)


class PointInput(BaseModel):
    latitude: float
    longitude: float
    distance: Optional[float] = None


class AddressInput(BaseModel):
    street_address: Optional[str] = Field(alias="streetAddress", default=None)
    city: Optional[str] = None
    region: Optional[str] = None
    country: Optional[str] = None
    postal_code: Optional[str] = Field(alias="postalCode", default=None)


class SiteFeedPropertiesInput(BaseModel):
    type: FeedServiceTypes
    is_recursive: Optional[bool] = Field(alias="isRecursive", default=None)
    s_3: Optional["AmazonFeedPropertiesInput"] = Field(alias="s3", default=None)
    azure_blob: Optional["AzureBlobFeedPropertiesInput"] = Field(
        alias="azureBlob", default=None
    )
    azure_file: Optional["AzureFileFeedPropertiesInput"] = Field(
        alias="azureFile", default=None
    )
    google: Optional["GoogleFeedPropertiesInput"] = None
    share_point: Optional["SharePointFeedPropertiesInput"] = Field(
        alias="sharePoint", default=None
    )
    one_drive: Optional["OneDriveFeedPropertiesInput"] = Field(
        alias="oneDrive", default=None
    )
    google_drive: Optional["GoogleDriveFeedPropertiesInput"] = Field(
        alias="googleDrive", default=None
    )
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class EmailFeedPropertiesInput(BaseModel):
    type: FeedServiceTypes
    include_attachments: Optional[bool] = Field(
        alias="includeAttachments", default=None
    )
    google: Optional["GoogleEmailFeedPropertiesInput"] = None
    microsoft: Optional["MicrosoftEmailFeedPropertiesInput"] = None
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class IssueFeedPropertiesInput(BaseModel):
    type: FeedServiceTypes
    include_attachments: Optional[bool] = Field(
        alias="includeAttachments", default=None
    )
    jira: Optional["AtlassianJiraFeedPropertiesInput"] = None
    linear: Optional["LinearFeedPropertiesInput"] = None
    github: Optional["GitHubIssuesFeedPropertiesInput"] = None
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class RSSFeedPropertiesInput(BaseModel):
    uri: Any
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class WebFeedPropertiesInput(BaseModel):
    uri: Any
    include_files: Optional[bool] = Field(alias="includeFiles", default=None)
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class RedditFeedPropertiesInput(BaseModel):
    subreddit_name: str = Field(alias="subredditName")
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class YouTubeFeedPropertiesInput(BaseModel):
    type: YouTubeTypes
    video_name: Optional[str] = Field(alias="videoName", default=None)
    video_identifiers: Optional[List[str]] = Field(
        alias="videoIdentifiers", default=None
    )
    channel_identifier: Optional[str] = Field(alias="channelIdentifier", default=None)
    playlist_identifier: Optional[str] = Field(alias="playlistIdentifier", default=None)
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class NotionFeedPropertiesInput(BaseModel):
    is_recursive: Optional[bool] = Field(alias="isRecursive", default=None)
    token: str
    type: NotionTypes
    identifiers: List[str]
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class SlackFeedPropertiesInput(BaseModel):
    type: Optional[FeedListingTypes] = None
    token: str
    channel: str
    include_attachments: Optional[bool] = Field(
        alias="includeAttachments", default=None
    )
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class DiscordFeedPropertiesInput(BaseModel):
    type: Optional[FeedListingTypes] = None
    token: str
    channel: str
    include_attachments: Optional[bool] = Field(
        alias="includeAttachments", default=None
    )
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class FeedSchedulePolicyInput(BaseModel):
    recurrence_type: TimedPolicyRecurrenceTypes = Field(alias="recurrenceType")
    repeat_interval: Optional[Any] = Field(alias="repeatInterval", default=None)


class NamedEntityReferenceInput(BaseModel):
    id: Optional[str] = None
    name: Optional[str] = None


class ObservationOccurrenceInput(BaseModel):
    type: OccurrenceTypes
    confidence: Optional[float] = None
    bounding_box: Optional["BoundingBoxInput"] = Field(
        alias="boundingBox", default=None
    )
    page_index: Optional[int] = Field(alias="pageIndex", default=None)
    start_time: Optional[Any] = Field(alias="startTime", default=None)
    end_time: Optional[Any] = Field(alias="endTime", default=None)


class ProjectQuotaInput(BaseModel):
    storage: Optional[int] = None
    contents: Optional[int] = None
    feeds: Optional[int] = None
    posts: Optional[int] = None
    conversations: Optional[int] = None


class ConversationStrategyInput(BaseModel):
    type: Optional[ConversationStrategyTypes] = None
    message_limit: Optional[int] = Field(alias="messageLimit", default=None)
    embed_citations: Optional[bool] = Field(alias="embedCitations", default=None)
    enable_facets: Optional[bool] = Field(alias="enableFacets", default=None)
    messages_weight: Optional[float] = Field(alias="messagesWeight", default=None)
    contents_weight: Optional[float] = Field(alias="contentsWeight", default=None)


class PromptStrategyInput(BaseModel):
    type: Optional[PromptStrategyTypes] = None


class RetrievalStrategyInput(BaseModel):
    type: RetrievalStrategyTypes
    content_limit: Optional[int] = Field(alias="contentLimit", default=None)


class RerankingStrategyInput(BaseModel):
    service_type: ModelServiceTypes = Field(alias="serviceType")


class ToolDefinitionInput(BaseModel):
    name: str
    description: Optional[str] = None
    schema_: str = Field(alias="schema")
    uri: Optional[Any] = None


class OpenAIModelPropertiesInput(BaseModel):
    model: OpenAIModels
    model_name: Optional[str] = Field(alias="modelName", default=None)
    key: Optional[str] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class AzureOpenAIModelPropertiesInput(BaseModel):
    model: AzureOpenAIModels
    deployment_name: Optional[str] = Field(alias="deploymentName", default=None)
    key: Optional[str] = None
    endpoint: Optional[Any] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class AnthropicModelPropertiesInput(BaseModel):
    model: AnthropicModels
    model_name: Optional[str] = Field(alias="modelName", default=None)
    key: Optional[str] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class ReplicateModelPropertiesInput(BaseModel):
    model: ReplicateModels
    model_name: Optional[str] = Field(alias="modelName", default=None)
    key: Optional[str] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class MistralModelPropertiesInput(BaseModel):
    model: MistralModels
    model_name: Optional[str] = Field(alias="modelName", default=None)
    key: Optional[str] = None
    endpoint: Optional[Any] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class GroqModelPropertiesInput(BaseModel):
    model: GroqModels
    model_name: Optional[str] = Field(alias="modelName", default=None)
    key: Optional[str] = None
    endpoint: Optional[Any] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class IngestionWorkflowStageInput(BaseModel):
    if_: Optional["IngestionContentFilterInput"] = Field(alias="if", default=None)
    collections: Optional[List[Optional["EntityReferenceInput"]]] = None


class PreparationWorkflowStageInput(BaseModel):
    disable_smart_capture: Optional[bool] = Field(
        alias="disableSmartCapture", default=None
    )
    summarizations: Optional[List[Optional["SummarizationStrategyInput"]]] = None
    jobs: Optional[List[Optional["PreparationWorkflowJobInput"]]] = None


class ExtractionWorkflowStageInput(BaseModel):
    jobs: Optional[List[Optional["ExtractionWorkflowJobInput"]]] = None


class EnrichmentWorkflowStageInput(BaseModel):
    link: Optional["LinkStrategyInput"] = None
    jobs: Optional[List[Optional["EnrichmentWorkflowJobInput"]]] = None


class WorkflowActionInput(BaseModel):
    connector: Optional["IntegrationConnectorInput"] = None


class ContentPublishingConnectorUpdateInput(BaseModel):
    type: Optional[ContentPublishingServiceTypes] = None
    format: Optional[ContentPublishingFormats] = None
    eleven_labs: Optional["ElevenLabsPublishingPropertiesInput"] = Field(
        alias="elevenLabs", default=None
    )


class IntegrationConnectorUpdateInput(BaseModel):
    uri: Optional[str] = None
    slack: Optional["SlackIntegrationPropertiesInput"] = None


class SiteFeedPropertiesUpdateInput(BaseModel):
    is_recursive: Optional[bool] = Field(alias="isRecursive", default=None)
    s_3: Optional["AmazonFeedPropertiesUpdateInput"] = Field(alias="s3", default=None)
    azure_blob: Optional["AzureBlobFeedPropertiesUpdateInput"] = Field(
        alias="azureBlob", default=None
    )
    azure_file: Optional["AzureFileFeedPropertiesUpdateInput"] = Field(
        alias="azureFile", default=None
    )
    google: Optional["GoogleFeedPropertiesUpdateInput"] = None
    share_point: Optional["SharePointFeedPropertiesUpdateInput"] = Field(
        alias="sharePoint", default=None
    )
    one_drive: Optional["OneDriveFeedPropertiesUpdateInput"] = Field(
        alias="oneDrive", default=None
    )
    google_drive: Optional["GoogleDriveFeedPropertiesUpdateInput"] = Field(
        alias="googleDrive", default=None
    )
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class EmailFeedPropertiesUpdateInput(BaseModel):
    include_attachments: Optional[bool] = Field(
        alias="includeAttachments", default=None
    )
    google: Optional["GoogleEmailFeedPropertiesUpdateInput"] = None
    microsoft: Optional["MicrosoftEmailFeedPropertiesUpdateInput"] = None
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class IssueFeedPropertiesUpdateInput(BaseModel):
    include_attachments: Optional[bool] = Field(
        alias="includeAttachments", default=None
    )
    jira: Optional["AtlassianJiraFeedPropertiesUpdateInput"] = None
    linear: Optional["LinearFeedPropertiesUpdateInput"] = None
    github: Optional["GitHubIssuesFeedPropertiesUpdateInput"] = None
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class RSSFeedPropertiesUpdateInput(BaseModel):
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class WebFeedPropertiesUpdateInput(BaseModel):
    uri: Optional[Any] = None
    include_files: Optional[bool] = Field(alias="includeFiles", default=None)
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class RedditFeedPropertiesUpdateInput(BaseModel):
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class YouTubeFeedPropertiesUpdateInput(BaseModel):
    type: Optional[YouTubeTypes] = None
    video_name: Optional[str] = Field(alias="videoName", default=None)
    video_identifiers: Optional[List[str]] = Field(
        alias="videoIdentifiers", default=None
    )
    channel_identifier: Optional[str] = Field(alias="channelIdentifier", default=None)
    playlist_identifier: Optional[str] = Field(alias="playlistIdentifier", default=None)
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class NotionFeedPropertiesUpdateInput(BaseModel):
    is_recursive: Optional[bool] = Field(alias="isRecursive", default=None)
    token: str
    type: Optional[NotionTypes] = None
    identifiers: Optional[List[str]] = None
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class SlackFeedPropertiesUpdateInput(BaseModel):
    type: Optional[FeedListingTypes] = None
    token: Optional[str] = None
    channel: Optional[str] = None
    include_attachments: Optional[bool] = Field(
        alias="includeAttachments", default=None
    )
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class DiscordFeedPropertiesUpdateInput(BaseModel):
    type: Optional[FeedListingTypes] = None
    token: Optional[str] = None
    channel: Optional[str] = None
    include_attachments: Optional[bool] = Field(
        alias="includeAttachments", default=None
    )
    read_limit: Optional[int] = Field(alias="readLimit", default=None)


class ConversationStrategyUpdateInput(BaseModel):
    type: Optional[ConversationStrategyTypes] = None
    message_limit: Optional[int] = Field(alias="messageLimit", default=None)
    embed_citations: Optional[bool] = Field(alias="embedCitations", default=None)
    enable_facets: Optional[bool] = Field(alias="enableFacets", default=None)
    messages_weight: Optional[float] = Field(alias="messagesWeight", default=None)
    contents_weight: Optional[float] = Field(alias="contentsWeight", default=None)


class PromptStrategyUpdateInput(BaseModel):
    type: Optional[PromptStrategyTypes] = None


class RetrievalStrategyUpdateInput(BaseModel):
    type: Optional[RetrievalStrategyTypes] = None
    content_limit: Optional[int] = Field(alias="contentLimit", default=None)


class RerankingStrategyUpdateInput(BaseModel):
    service_type: Optional[ModelServiceTypes] = Field(alias="serviceType", default=None)


class ToolDefinitionUpdateInput(BaseModel):
    name: Optional[str] = None
    description: Optional[str] = None
    schema_: Optional[str] = Field(alias="schema", default=None)
    uri: Optional[Any] = None


class OpenAIModelPropertiesUpdateInput(BaseModel):
    model: OpenAIModels
    model_name: Optional[str] = Field(alias="modelName", default=None)
    key: Optional[str] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class AzureOpenAIModelPropertiesUpdateInput(BaseModel):
    model: AzureOpenAIModels
    deployment_name: Optional[str] = Field(alias="deploymentName", default=None)
    key: Optional[str] = None
    endpoint: Optional[Any] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class AnthropicModelPropertiesUpdateInput(BaseModel):
    model: AnthropicModels
    model_name: Optional[str] = Field(alias="modelName", default=None)
    key: Optional[str] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class ReplicateModelPropertiesUpdateInput(BaseModel):
    model: ReplicateModels
    model_name: Optional[str] = Field(alias="modelName", default=None)
    key: Optional[str] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class MistralModelPropertiesUpdateInput(BaseModel):
    model: MistralModels
    model_name: Optional[str] = Field(alias="modelName", default=None)
    key: Optional[str] = None
    endpoint: Optional[Any] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class GroqModelPropertiesUpdateInput(BaseModel):
    model: GroqModels
    model_name: Optional[str] = Field(alias="modelName", default=None)
    key: Optional[str] = None
    endpoint: Optional[Any] = None
    temperature: Optional[float] = None
    probability: Optional[float] = None
    token_limit: Optional[int] = Field(alias="tokenLimit", default=None)
    completion_token_limit: Optional[int] = Field(
        alias="completionTokenLimit", default=None
    )


class H3IndexFilter(BaseModel):
    resolution: Optional[H3ResolutionTypes] = None
    key: Optional[str] = None


class DateRangeInput(BaseModel):
    from_: Optional[Any] = Field(alias="from", default=None)
    to: Optional[Any] = None


class ObservationCriteriaInput(BaseModel):
    type: Optional[ObservableTypes] = None
    observable: Optional["EntityReferenceInput"] = None
    states: Optional[List[Optional[EntityState]]] = None


class ElevenLabsPublishingPropertiesInput(BaseModel):
    model: Optional[ElevenLabsModels] = None
    voice: Optional[str] = None


class SlackIntegrationPropertiesInput(BaseModel):
    channel: str
    token: str


class AmazonFeedPropertiesInput(BaseModel):
    access_key: str = Field(alias="accessKey")
    secret_access_key: str = Field(alias="secretAccessKey")
    bucket_name: str = Field(alias="bucketName")
    prefix: Optional[str] = None
    region: Optional[str] = None


class AzureBlobFeedPropertiesInput(BaseModel):
    storage_access_key: str = Field(alias="storageAccessKey")
    account_name: str = Field(alias="accountName")
    container_name: str = Field(alias="containerName")
    prefix: Optional[str] = None


class AzureFileFeedPropertiesInput(BaseModel):
    storage_access_key: str = Field(alias="storageAccessKey")
    account_name: str = Field(alias="accountName")
    share_name: str = Field(alias="shareName")
    prefix: Optional[str] = None


class GoogleFeedPropertiesInput(BaseModel):
    credentials: str
    container_name: str = Field(alias="containerName")
    prefix: Optional[str] = None


class SharePointFeedPropertiesInput(BaseModel):
    authentication_type: SharePointAuthenticationTypes = Field(
        alias="authenticationType"
    )
    account_name: str = Field(alias="accountName")
    library_id: str = Field(alias="libraryId")
    tenant_id: Optional[str] = Field(alias="tenantId", default=None)
    refresh_token: Optional[str] = Field(alias="refreshToken", default=None)


class OneDriveFeedPropertiesInput(BaseModel):
    folder_id: Optional[str] = Field(alias="folderId", default=None)
    refresh_token: str = Field(alias="refreshToken")


class GoogleDriveFeedPropertiesInput(BaseModel):
    folder_id: Optional[str] = Field(alias="folderId", default=None)
    refresh_token: str = Field(alias="refreshToken")


class GoogleEmailFeedPropertiesInput(BaseModel):
    type: Optional[EmailListingTypes] = None
    refresh_token: Optional[str] = Field(alias="refreshToken", default=None)


class MicrosoftEmailFeedPropertiesInput(BaseModel):
    type: Optional[EmailListingTypes] = None
    tenant_id: Optional[str] = Field(alias="tenantId", default=None)
    refresh_token: Optional[str] = Field(alias="refreshToken", default=None)


class AtlassianJiraFeedPropertiesInput(BaseModel):
    uri: Any
    project: str
    email: str
    token: str


class LinearFeedPropertiesInput(BaseModel):
    key: str
    project: str


class GitHubIssuesFeedPropertiesInput(BaseModel):
    repository_owner: str = Field(alias="repositoryOwner")
    repository_name: str = Field(alias="repositoryName")
    uri: Optional[Any] = None
    refresh_token: Optional[str] = Field(alias="refreshToken", default=None)
    personal_access_token: Optional[str] = Field(
        alias="personalAccessToken", default=None
    )


class BoundingBoxInput(BaseModel):
    left: Optional[float] = None
    top: Optional[float] = None
    width: Optional[float] = None
    height: Optional[float] = None


class IngestionContentFilterInput(BaseModel):
    types: Optional[List[Optional[ContentTypes]]] = None
    file_types: Optional[List[Optional[FileTypes]]] = Field(
        alias="fileTypes", default=None
    )


class SummarizationStrategyInput(BaseModel):
    type: SummarizationTypes
    specification: Optional["EntityReferenceInput"] = None
    tokens: Optional[int] = None
    items: Optional[int] = None
    prompt: Optional[str] = None


class PreparationWorkflowJobInput(BaseModel):
    connector: Optional["FilePreparationConnectorInput"] = None


class ExtractionWorkflowJobInput(BaseModel):
    connector: Optional["EntityExtractionConnectorInput"] = None


class LinkStrategyInput(BaseModel):
    enable_crawling: Optional[bool] = Field(alias="enableCrawling", default=None)
    allowed_domains: Optional[List[str]] = Field(alias="allowedDomains", default=None)
    excluded_domains: Optional[List[str]] = Field(alias="excludedDomains", default=None)
    allow_content_domain: Optional[bool] = Field(
        alias="allowContentDomain", default=None
    )
    allowed_links: Optional[List[LinkTypes]] = Field(alias="allowedLinks", default=None)
    excluded_links: Optional[List[LinkTypes]] = Field(
        alias="excludedLinks", default=None
    )
    allowed_files: Optional[List[FileTypes]] = Field(alias="allowedFiles", default=None)
    excluded_files: Optional[List[FileTypes]] = Field(
        alias="excludedFiles", default=None
    )
    maximum_links: Optional[int] = Field(alias="maximumLinks", default=None)


class EnrichmentWorkflowJobInput(BaseModel):
    connector: Optional["EntityEnrichmentConnectorInput"] = None


class AmazonFeedPropertiesUpdateInput(BaseModel):
    access_key: Optional[str] = Field(alias="accessKey", default=None)
    secret_access_key: Optional[str] = Field(alias="secretAccessKey", default=None)
    bucket_name: Optional[str] = Field(alias="bucketName", default=None)
    prefix: Optional[str] = None
    region: Optional[str] = None


class AzureBlobFeedPropertiesUpdateInput(BaseModel):
    storage_access_key: Optional[str] = Field(alias="storageAccessKey", default=None)
    account_name: Optional[str] = Field(alias="accountName", default=None)
    container_name: Optional[str] = Field(alias="containerName", default=None)
    prefix: Optional[str] = None


class AzureFileFeedPropertiesUpdateInput(BaseModel):
    storage_access_key: Optional[str] = Field(alias="storageAccessKey", default=None)
    account_name: Optional[str] = Field(alias="accountName", default=None)
    share_name: Optional[str] = Field(alias="shareName", default=None)
    prefix: Optional[str] = None


class GoogleFeedPropertiesUpdateInput(BaseModel):
    credentials: Optional[str] = None
    container_name: Optional[str] = Field(alias="containerName", default=None)
    prefix: Optional[str] = None


class SharePointFeedPropertiesUpdateInput(BaseModel):
    authentication_type: Optional[SharePointAuthenticationTypes] = Field(
        alias="authenticationType", default=None
    )
    account_name: Optional[str] = Field(alias="accountName", default=None)
    library_id: Optional[str] = Field(alias="libraryId", default=None)
    tenant_id: Optional[str] = Field(alias="tenantId", default=None)
    refresh_token: Optional[str] = Field(alias="refreshToken", default=None)


class OneDriveFeedPropertiesUpdateInput(BaseModel):
    folder_id: Optional[str] = Field(alias="folderId", default=None)
    refresh_token: Optional[str] = Field(alias="refreshToken", default=None)


class GoogleDriveFeedPropertiesUpdateInput(BaseModel):
    folder_id: Optional[str] = Field(alias="folderId", default=None)
    refresh_token: Optional[str] = Field(alias="refreshToken", default=None)


class GoogleEmailFeedPropertiesUpdateInput(BaseModel):
    type: Optional[EmailListingTypes] = None
    refresh_token: Optional[str] = Field(alias="refreshToken", default=None)


class MicrosoftEmailFeedPropertiesUpdateInput(BaseModel):
    type: Optional[EmailListingTypes] = None
    tenant_id: Optional[str] = Field(alias="tenantId", default=None)
    refresh_token: Optional[str] = Field(alias="refreshToken", default=None)


class AtlassianJiraFeedPropertiesUpdateInput(BaseModel):
    uri: Optional[Any] = None
    project: Optional[str] = None
    email: Optional[str] = None
    token: Optional[str] = None


class LinearFeedPropertiesUpdateInput(BaseModel):
    key: Optional[str] = None
    project: Optional[str] = None


class GitHubIssuesFeedPropertiesUpdateInput(BaseModel):
    repository_owner: Optional[str] = Field(alias="repositoryOwner", default=None)
    repository_name: Optional[str] = Field(alias="repositoryName", default=None)
    uri: Optional[Any] = None
    refresh_token: Optional[str] = Field(alias="refreshToken", default=None)
    personal_access_token: Optional[str] = Field(
        alias="personalAccessToken", default=None
    )


class FilePreparationConnectorInput(BaseModel):
    type: FilePreparationServiceTypes
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes", default=None)
    document: Optional["DocumentPreparationPropertiesInput"] = None
    email: Optional["EmailPreparationPropertiesInput"] = None
    azure_document: Optional["AzureDocumentPreparationPropertiesInput"] = Field(
        alias="azureDocument", default=None
    )
    deepgram: Optional["DeepgramAudioPreparationPropertiesInput"] = None


class EntityExtractionConnectorInput(BaseModel):
    type: EntityExtractionServiceTypes
    content_types: Optional[List[ContentTypes]] = Field(
        alias="contentTypes", default=None
    )
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes", default=None)
    extracted_types: Optional[List[ObservableTypes]] = Field(
        alias="extractedTypes", default=None
    )
    azure_text: Optional["AzureTextExtractionPropertiesInput"] = Field(
        alias="azureText", default=None
    )
    azure_image: Optional["AzureImageExtractionPropertiesInput"] = Field(
        alias="azureImage", default=None
    )
    open_ai_image: Optional["OpenAIImageExtractionPropertiesInput"] = Field(
        alias="openAIImage", default=None
    )
    model_text: Optional["ModelTextExtractionPropertiesInput"] = Field(
        alias="modelText", default=None
    )


class EntityEnrichmentConnectorInput(BaseModel):
    type: EntityEnrichmentServiceTypes
    enriched_types: Optional[List[Optional[ObservableTypes]]] = Field(
        alias="enrichedTypes", default=None
    )


class DocumentPreparationPropertiesInput(BaseModel):
    include_images: Optional[bool] = Field(alias="includeImages", default=None)


class EmailPreparationPropertiesInput(BaseModel):
    include_attachments: Optional[bool] = Field(
        alias="includeAttachments", default=None
    )


class AzureDocumentPreparationPropertiesInput(BaseModel):
    model: Optional[AzureDocumentIntelligenceModels] = None


class DeepgramAudioPreparationPropertiesInput(BaseModel):
    model: Optional[DeepgramModels] = None
    key: Optional[str] = None
    enable_redaction: Optional[bool] = Field(alias="enableRedaction", default=None)
    enable_speaker_diarization: Optional[bool] = Field(
        alias="enableSpeakerDiarization", default=None
    )


class AzureTextExtractionPropertiesInput(BaseModel):
    enable_pii: Optional[bool] = Field(alias="enablePII", default=None)
    confidence_threshold: Optional[float] = Field(
        alias="confidenceThreshold", default=None
    )


class AzureImageExtractionPropertiesInput(BaseModel):
    confidence_threshold: Optional[float] = Field(
        alias="confidenceThreshold", default=None
    )


class OpenAIImageExtractionPropertiesInput(BaseModel):
    detail_level: Optional[OpenAIVisionDetailLevels] = Field(
        alias="detailLevel", default=None
    )
    confidence_threshold: Optional[float] = Field(
        alias="confidenceThreshold", default=None
    )


class ModelTextExtractionPropertiesInput(BaseModel):
    specification: Optional["EntityReferenceInput"] = None


class CategoryFacetInput(BaseModel):
    time_interval: Optional[TimeIntervalTypes] = Field(
        alias="timeInterval", default=None
    )
    time_offset: Optional[int] = Field(alias="timeOffset", default=None)
    facet: Optional[CategoryFacetTypes] = None


class ContentFacetInput(BaseModel):
    time_interval: Optional[TimeIntervalTypes] = Field(
        alias="timeInterval", default=None
    )
    time_offset: Optional[int] = Field(alias="timeOffset", default=None)
    facet: Optional[ContentFacetTypes] = None


class EventFacetInput(BaseModel):
    time_interval: Optional[TimeIntervalTypes] = Field(
        alias="timeInterval", default=None
    )
    time_offset: Optional[int] = Field(alias="timeOffset", default=None)
    facet: Optional[EventFacetTypes] = None


class SharePointLibrariesInput(BaseModel):
    authentication_type: SharePointAuthenticationTypes = Field(
        alias="authenticationType"
    )
    tenant_id: Optional[str] = Field(alias="tenantId", default=None)
    refresh_token: Optional[str] = Field(alias="refreshToken", default=None)


class LabelFacetInput(BaseModel):
    time_interval: Optional[TimeIntervalTypes] = Field(
        alias="timeInterval", default=None
    )
    time_offset: Optional[int] = Field(alias="timeOffset", default=None)
    facet: Optional[LabelFacetTypes] = None


class OrganizationFacetInput(BaseModel):
    time_interval: Optional[TimeIntervalTypes] = Field(
        alias="timeInterval", default=None
    )
    time_offset: Optional[int] = Field(alias="timeOffset", default=None)
    facet: Optional[OrganizationFacetTypes] = None


class PersonFacetInput(BaseModel):
    time_interval: Optional[TimeIntervalTypes] = Field(
        alias="timeInterval", default=None
    )
    time_offset: Optional[int] = Field(alias="timeOffset", default=None)
    facet: Optional[PersonFacetTypes] = None


class PlaceFacetInput(BaseModel):
    time_interval: Optional[TimeIntervalTypes] = Field(
        alias="timeInterval", default=None
    )
    time_offset: Optional[int] = Field(alias="timeOffset", default=None)
    facet: Optional[PlaceFacetTypes] = None


class ProductFacetInput(BaseModel):
    time_interval: Optional[TimeIntervalTypes] = Field(
        alias="timeInterval", default=None
    )
    time_offset: Optional[int] = Field(alias="timeOffset", default=None)
    facet: Optional[ProductFacetTypes] = None


class RepoFacetInput(BaseModel):
    time_interval: Optional[TimeIntervalTypes] = Field(
        alias="timeInterval", default=None
    )
    time_offset: Optional[int] = Field(alias="timeOffset", default=None)
    facet: Optional[RepoFacetTypes] = None


class SoftwareFacetInput(BaseModel):
    time_interval: Optional[TimeIntervalTypes] = Field(
        alias="timeInterval", default=None
    )
    time_offset: Optional[int] = Field(alias="timeOffset", default=None)
    facet: Optional[SoftwareFacetTypes] = None


class ContentUpdateInput(BaseModel):
    id: str
    name: Optional[str] = None
    description: Optional[str] = None
