# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    ContentTypes,
    EntityState,
    FileTypes,
    LinkTypes,
    MailImportance,
    MailPriority,
    MailSensitivity,
    ObservableTypes,
    OccurrenceTypes,
)


class GetContent(BaseModel):
    content: Optional["GetContentContent"]


class GetContentContent(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    owner: "GetContentContentOwner"
    state: EntityState
    original_date: Optional[Any] = Field(alias="originalDate")
    finished_date: Optional[Any] = Field(alias="finishedDate")
    workflow_duration: Optional[Any] = Field(alias="workflowDuration")
    uri: Optional[Any]
    type: Optional[ContentTypes]
    file_type: Optional[FileTypes] = Field(alias="fileType")
    mime_type: Optional[str] = Field(alias="mimeType")
    file_name: Optional[str] = Field(alias="fileName")
    file_size: Optional[Any] = Field(alias="fileSize")
    master_uri: Optional[Any] = Field(alias="masterUri")
    image_uri: Optional[Any] = Field(alias="imageUri")
    text_uri: Optional[Any] = Field(alias="textUri")
    audio_uri: Optional[Any] = Field(alias="audioUri")
    transcript_uri: Optional[Any] = Field(alias="transcriptUri")
    video: Optional["GetContentContentVideo"]
    audio: Optional["GetContentContentAudio"]
    image: Optional["GetContentContentImage"]
    document: Optional["GetContentContentDocument"]
    email: Optional["GetContentContentEmail"]
    issue: Optional["GetContentContentIssue"]
    observations: Optional[List[Optional["GetContentContentObservations"]]]
    parent: Optional["GetContentContentParent"]
    children: Optional[List[Optional["GetContentContentChildren"]]]
    collections: Optional[List[Optional["GetContentContentCollections"]]]
    feed: Optional["GetContentContentFeed"]
    workflow: Optional["GetContentContentWorkflow"]
    markdown: Optional[str]
    links: Optional[List["GetContentContentLinks"]]
    error: Optional[str]


class GetContentContentOwner(BaseModel):
    id: str


class GetContentContentVideo(BaseModel):
    width: Optional[int]
    height: Optional[int]
    duration: Optional[str]
    software: Optional[str]
    make: Optional[str]
    model: Optional[str]


class GetContentContentAudio(BaseModel):
    keywords: Optional[List[Optional[str]]]
    author: Optional[str]
    series: Optional[str]
    episode: Optional[str]
    episode_type: Optional[str] = Field(alias="episodeType")
    season: Optional[str]
    publisher: Optional[str]
    copyright: Optional[str]
    language: Optional[str]
    genre: Optional[str]
    title: Optional[str]
    bitrate: Optional[int]
    channels: Optional[int]
    sample_rate: Optional[int] = Field(alias="sampleRate")
    bits_per_sample: Optional[int] = Field(alias="bitsPerSample")
    duration: Optional[str]


class GetContentContentImage(BaseModel):
    width: Optional[int]
    height: Optional[int]
    description: Optional[str]
    software: Optional[str]
    identifier: Optional[str]
    make: Optional[str]
    model: Optional[str]


class GetContentContentDocument(BaseModel):
    title: Optional[str]
    subject: Optional[str]
    author: Optional[str]
    software: Optional[str]
    publisher: Optional[str]
    description: Optional[str]
    summary: Optional[str]
    keywords: Optional[List[Optional[str]]]
    page_count: Optional[int] = Field(alias="pageCount")
    worksheet_count: Optional[int] = Field(alias="worksheetCount")
    slide_count: Optional[int] = Field(alias="slideCount")
    word_count: Optional[int] = Field(alias="wordCount")
    line_count: Optional[int] = Field(alias="lineCount")
    paragraph_count: Optional[int] = Field(alias="paragraphCount")
    character_count: Optional[int] = Field(alias="characterCount")
    is_encrypted: Optional[bool] = Field(alias="isEncrypted")
    has_digital_signature: Optional[bool] = Field(alias="hasDigitalSignature")


class GetContentContentEmail(BaseModel):
    subject: Optional[str]
    identifier: Optional[str]
    sensitivity: Optional[MailSensitivity]
    priority: Optional[MailPriority]
    importance: Optional[MailImportance]
    labels: Optional[List[Optional[str]]]
    from_: Optional[List[Optional["GetContentContentEmailFrom"]]] = Field(alias="from")
    to: Optional[List[Optional["GetContentContentEmailTo"]]]
    cc: Optional[List[Optional["GetContentContentEmailCc"]]]
    bcc: Optional[List[Optional["GetContentContentEmailBcc"]]]


class GetContentContentEmailFrom(BaseModel):
    name: Optional[str]
    family_name: Optional[str] = Field(alias="familyName")
    given_name: Optional[str] = Field(alias="givenName")
    email: Optional[str]


class GetContentContentEmailTo(BaseModel):
    name: Optional[str]
    family_name: Optional[str] = Field(alias="familyName")
    given_name: Optional[str] = Field(alias="givenName")
    email: Optional[str]


class GetContentContentEmailCc(BaseModel):
    name: Optional[str]
    family_name: Optional[str] = Field(alias="familyName")
    given_name: Optional[str] = Field(alias="givenName")
    email: Optional[str]


class GetContentContentEmailBcc(BaseModel):
    name: Optional[str]
    family_name: Optional[str] = Field(alias="familyName")
    given_name: Optional[str] = Field(alias="givenName")
    email: Optional[str]


class GetContentContentIssue(BaseModel):
    title: Optional[str]
    project: Optional[str]
    team: Optional[str]
    status: Optional[str]
    priority: Optional[str]
    type: Optional[str]
    identifier: Optional[str]
    labels: Optional[List[Optional[str]]]


class GetContentContentObservations(BaseModel):
    type: ObservableTypes
    observable: "GetContentContentObservationsObservable"
    occurrences: Optional[List[Optional["GetContentContentObservationsOccurrences"]]]


class GetContentContentObservationsObservable(BaseModel):
    id: str
    name: Optional[str]


class GetContentContentObservationsOccurrences(BaseModel):
    type: Optional[OccurrenceTypes]
    confidence: Optional[float]
    bounding_box: Optional["GetContentContentObservationsOccurrencesBoundingBox"] = (
        Field(alias="boundingBox")
    )
    page_index: Optional[int] = Field(alias="pageIndex")
    start_time: Optional[Any] = Field(alias="startTime")
    end_time: Optional[Any] = Field(alias="endTime")


class GetContentContentObservationsOccurrencesBoundingBox(BaseModel):
    left: Optional[float]
    top: Optional[float]
    width: Optional[float]
    height: Optional[float]


class GetContentContentParent(BaseModel):
    id: str


class GetContentContentChildren(BaseModel):
    id: str


class GetContentContentCollections(BaseModel):
    id: str


class GetContentContentFeed(BaseModel):
    id: str


class GetContentContentWorkflow(BaseModel):
    id: str


class GetContentContentLinks(BaseModel):
    uri: Optional[Any]
    link_type: Optional[LinkTypes] = Field(alias="linkType")


GetContent.model_rebuild()
GetContentContent.model_rebuild()
GetContentContentEmail.model_rebuild()
GetContentContentObservations.model_rebuild()
GetContentContentObservationsOccurrences.model_rebuild()
