# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    AlertTypes,
    ContentPublishingServiceTypes,
    ContentTypes,
    ElevenLabsModels,
    EntityState,
    FileTypes,
    IntegrationServiceTypes,
    ObservableTypes,
)


class GetAlert(BaseModel):
    alert: Optional["GetAlertAlert"]


class GetAlertAlert(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    owner: "GetAlertAlertOwner"
    state: EntityState
    correlation_id: Optional[str] = Field(alias="correlationId")
    type: AlertTypes
    summary_prompt: Optional[str] = Field(alias="summaryPrompt")
    publish_prompt: str = Field(alias="publishPrompt")
    filter: Optional["GetAlertAlertFilter"]
    integration: "GetAlertAlertIntegration"
    publishing: "GetAlertAlertPublishing"
    summary_specification: Optional["GetAlertAlertSummarySpecification"] = Field(
        alias="summarySpecification"
    )
    publish_specification: Optional["GetAlertAlertPublishSpecification"] = Field(
        alias="publishSpecification"
    )
    last_alert_date: Optional[Any] = Field(alias="lastAlertDate")


class GetAlertAlertOwner(BaseModel):
    id: str


class GetAlertAlertFilter(BaseModel):
    date_range: Optional["GetAlertAlertFilterDateRange"] = Field(alias="dateRange")
    creation_date_range: Optional["GetAlertAlertFilterCreationDateRange"] = Field(
        alias="creationDateRange"
    )
    types: Optional[List[ContentTypes]]
    file_types: Optional[List[Optional[FileTypes]]] = Field(alias="fileTypes")
    contents: Optional[List["GetAlertAlertFilterContents"]]
    feeds: Optional[List["GetAlertAlertFilterFeeds"]]
    workflows: Optional[List["GetAlertAlertFilterWorkflows"]]
    collections: Optional[List["GetAlertAlertFilterCollections"]]
    observations: Optional[List["GetAlertAlertFilterObservations"]]


class GetAlertAlertFilterDateRange(BaseModel):
    from_: Optional[Any] = Field(alias="from")
    to: Optional[Any]


class GetAlertAlertFilterCreationDateRange(BaseModel):
    from_: Optional[Any] = Field(alias="from")
    to: Optional[Any]


class GetAlertAlertFilterContents(BaseModel):
    id: str


class GetAlertAlertFilterFeeds(BaseModel):
    id: str


class GetAlertAlertFilterWorkflows(BaseModel):
    id: str


class GetAlertAlertFilterCollections(BaseModel):
    id: str


class GetAlertAlertFilterObservations(BaseModel):
    type: ObservableTypes
    observable: "GetAlertAlertFilterObservationsObservable"
    states: Optional[List[Optional[EntityState]]]


class GetAlertAlertFilterObservationsObservable(BaseModel):
    id: str


class GetAlertAlertIntegration(BaseModel):
    type: IntegrationServiceTypes
    uri: Optional[str]
    slack: Optional["GetAlertAlertIntegrationSlack"]


class GetAlertAlertIntegrationSlack(BaseModel):
    token: str
    channel: str


class GetAlertAlertPublishing(BaseModel):
    type: ContentPublishingServiceTypes
    eleven_labs: Optional["GetAlertAlertPublishingElevenLabs"] = Field(
        alias="elevenLabs"
    )


class GetAlertAlertPublishingElevenLabs(BaseModel):
    model: Optional[ElevenLabsModels]
    voice: Optional[str]


class GetAlertAlertSummarySpecification(BaseModel):
    id: str


class GetAlertAlertPublishSpecification(BaseModel):
    id: str


GetAlert.model_rebuild()
GetAlertAlert.model_rebuild()
GetAlertAlertFilter.model_rebuild()
GetAlertAlertFilterObservations.model_rebuild()
GetAlertAlertIntegration.model_rebuild()
GetAlertAlertPublishing.model_rebuild()
