# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, Dict, List, Optional, Union

from .add_contents_to_collections import AddContentsToCollections
from .async_base_client import AsyncBaseClient
from .base_model import UNSET, UnsetType
from .clear_conversation import ClearConversation
from .close_conversation import CloseConversation
from .create_alert import CreateAlert
from .create_collection import CreateCollection
from .create_conversation import CreateConversation
from .create_feed import CreateFeed
from .create_specification import CreateSpecification
from .create_workflow import CreateWorkflow
from .credits import Credits
from .delete_alert import DeleteAlert
from .delete_alerts import DeleteAlerts
from .delete_all_alerts import DeleteAllAlerts
from .delete_all_contents import DeleteAllContents
from .delete_all_conversations import DeleteAllConversations
from .delete_all_feeds import DeleteAllFeeds
from .delete_all_workflows import DeleteAllWorkflows
from .delete_collection import DeleteCollection
from .delete_collections import DeleteCollections
from .delete_content import DeleteContent
from .delete_contents import DeleteContents
from .delete_conversation import DeleteConversation
from .delete_conversations import DeleteConversations
from .delete_feed import DeleteFeed
from .delete_feeds import DeleteFeeds
from .delete_specification import DeleteSpecification
from .delete_workflow import DeleteWorkflow
from .delete_workflows import DeleteWorkflows
from .disable_alert import DisableAlert
from .disable_feed import DisableFeed
from .enable_alert import EnableAlert
from .enable_feed import EnableFeed
from .enums import TextTypes
from .extract_contents import ExtractContents
from .get_alert import GetAlert
from .get_collection import GetCollection
from .get_content import GetContent
from .get_conversation import GetConversation
from .get_feed import GetFeed
from .get_project import GetProject
from .get_specification import GetSpecification
from .get_workflow import GetWorkflow
from .ingest_encoded_file import IngestEncodedFile
from .ingest_text import IngestText
from .ingest_uri import IngestUri
from .input_types import (
    AlertFilter,
    AlertInput,
    AlertUpdateInput,
    CollectionFilter,
    CollectionInput,
    CollectionUpdateInput,
    ContentFacetInput,
    ContentFilter,
    ContentPublishingConnectorInput,
    ContentUpdateInput,
    ConversationFilter,
    ConversationInput,
    ConversationUpdateInput,
    EntityReferenceInput,
    FeedFilter,
    FeedInput,
    FeedUpdateInput,
    ProjectUpdateInput,
    SpecificationFilter,
    SpecificationInput,
    SpecificationUpdateInput,
    SummarizationStrategyInput,
    WorkflowFilter,
    WorkflowInput,
    WorkflowUpdateInput,
)
from .is_content_done import IsContentDone
from .is_feed_done import IsFeedDone
from .lookup_credits import LookupCredits
from .lookup_usage import LookupUsage
from .operations import (
    ADD_CONTENTS_TO_COLLECTIONS_GQL,
    CLEAR_CONVERSATION_GQL,
    CLOSE_CONVERSATION_GQL,
    CREATE_ALERT_GQL,
    CREATE_COLLECTION_GQL,
    CREATE_CONVERSATION_GQL,
    CREATE_FEED_GQL,
    CREATE_SPECIFICATION_GQL,
    CREATE_WORKFLOW_GQL,
    CREDITS_GQL,
    DELETE_ALERT_GQL,
    DELETE_ALERTS_GQL,
    DELETE_ALL_ALERTS_GQL,
    DELETE_ALL_CONTENTS_GQL,
    DELETE_ALL_CONVERSATIONS_GQL,
    DELETE_ALL_FEEDS_GQL,
    DELETE_ALL_WORKFLOWS_GQL,
    DELETE_COLLECTION_GQL,
    DELETE_COLLECTIONS_GQL,
    DELETE_CONTENT_GQL,
    DELETE_CONTENTS_GQL,
    DELETE_CONVERSATION_GQL,
    DELETE_CONVERSATIONS_GQL,
    DELETE_FEED_GQL,
    DELETE_FEEDS_GQL,
    DELETE_SPECIFICATION_GQL,
    DELETE_WORKFLOW_GQL,
    DELETE_WORKFLOWS_GQL,
    DISABLE_ALERT_GQL,
    DISABLE_FEED_GQL,
    ENABLE_ALERT_GQL,
    ENABLE_FEED_GQL,
    EXTRACT_CONTENTS_GQL,
    GET_ALERT_GQL,
    GET_COLLECTION_GQL,
    GET_CONTENT_GQL,
    GET_CONVERSATION_GQL,
    GET_FEED_GQL,
    GET_PROJECT_GQL,
    GET_SPECIFICATION_GQL,
    GET_WORKFLOW_GQL,
    INGEST_ENCODED_FILE_GQL,
    INGEST_TEXT_GQL,
    INGEST_URI_GQL,
    IS_CONTENT_DONE_GQL,
    IS_FEED_DONE_GQL,
    LOOKUP_CREDITS_GQL,
    LOOKUP_USAGE_GQL,
    PROMPT_CONVERSATION_GQL,
    PROMPT_SPECIFICATIONS_GQL,
    PUBLISH_CONTENTS_GQL,
    PUBLISH_CONVERSATION_GQL,
    QUERY_ALERTS_GQL,
    QUERY_COLLECTIONS_GQL,
    QUERY_CONTENT_FACETS_GQL,
    QUERY_CONTENTS_GQL,
    QUERY_CONVERSATIONS_GQL,
    QUERY_FEEDS_GQL,
    QUERY_SPECIFICATIONS_GQL,
    QUERY_WORKFLOWS_GQL,
    REMOVE_CONTENTS_FROM_COLLECTION_GQL,
    SUGGEST_CONVERSATION_GQL,
    SUMMARIZE_CONTENTS_GQL,
    UPDATE_ALERT_GQL,
    UPDATE_COLLECTION_GQL,
    UPDATE_CONTENT_GQL,
    UPDATE_CONVERSATION_GQL,
    UPDATE_FEED_GQL,
    UPDATE_PROJECT_GQL,
    UPDATE_SPECIFICATION_GQL,
    UPDATE_WORKFLOW_GQL,
    USAGE_GQL,
)
from .prompt_conversation import PromptConversation
from .prompt_specifications import PromptSpecifications
from .publish_contents import PublishContents
from .publish_conversation import PublishConversation
from .query_alerts import QueryAlerts
from .query_collections import QueryCollections
from .query_content_facets import QueryContentFacets
from .query_contents import QueryContents
from .query_conversations import QueryConversations
from .query_feeds import QueryFeeds
from .query_specifications import QuerySpecifications
from .query_workflows import QueryWorkflows
from .remove_contents_from_collection import RemoveContentsFromCollection
from .suggest_conversation import SuggestConversation
from .summarize_contents import SummarizeContents
from .update_alert import UpdateAlert
from .update_collection import UpdateCollection
from .update_content import UpdateContent
from .update_conversation import UpdateConversation
from .update_feed import UpdateFeed
from .update_project import UpdateProject
from .update_specification import UpdateSpecification
from .update_workflow import UpdateWorkflow
from .usage import Usage


def gql(q: str) -> str:
    return q


class Client(AsyncBaseClient):
    async def create_alert(
        self,
        alert: AlertInput,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> CreateAlert:
        variables: Dict[str, object] = {"alert": alert, "correlationId": correlation_id}
        response = await self.execute(
            query=CREATE_ALERT_GQL,
            operation_name="CreateAlert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateAlert.model_validate(data)

    async def delete_alert(self, id: str, **kwargs: Any) -> DeleteAlert:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=DELETE_ALERT_GQL,
            operation_name="DeleteAlert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteAlert.model_validate(data)

    async def delete_alerts(self, ids: List[str], **kwargs: Any) -> DeleteAlerts:
        variables: Dict[str, object] = {"ids": ids}
        response = await self.execute(
            query=DELETE_ALERTS_GQL,
            operation_name="DeleteAlerts",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteAlerts.model_validate(data)

    async def delete_all_alerts(self, **kwargs: Any) -> DeleteAllAlerts:
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=DELETE_ALL_ALERTS_GQL,
            operation_name="DeleteAllAlerts",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteAllAlerts.model_validate(data)

    async def disable_alert(self, id: str, **kwargs: Any) -> DisableAlert:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=DISABLE_ALERT_GQL,
            operation_name="DisableAlert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DisableAlert.model_validate(data)

    async def enable_alert(self, id: str, **kwargs: Any) -> EnableAlert:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=ENABLE_ALERT_GQL,
            operation_name="EnableAlert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return EnableAlert.model_validate(data)

    async def get_alert(self, id: str, **kwargs: Any) -> GetAlert:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=GET_ALERT_GQL,
            operation_name="GetAlert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetAlert.model_validate(data)

    async def query_alerts(
        self, filter: Union[Optional[AlertFilter], UnsetType] = UNSET, **kwargs: Any
    ) -> QueryAlerts:
        variables: Dict[str, object] = {"filter": filter}
        response = await self.execute(
            query=QUERY_ALERTS_GQL,
            operation_name="QueryAlerts",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return QueryAlerts.model_validate(data)

    async def update_alert(self, alert: AlertUpdateInput, **kwargs: Any) -> UpdateAlert:
        variables: Dict[str, object] = {"alert": alert}
        response = await self.execute(
            query=UPDATE_ALERT_GQL,
            operation_name="UpdateAlert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateAlert.model_validate(data)

    async def add_contents_to_collections(
        self,
        contents: List[EntityReferenceInput],
        collections: List[EntityReferenceInput],
        **kwargs: Any
    ) -> AddContentsToCollections:
        variables: Dict[str, object] = {
            "contents": contents,
            "collections": collections,
        }
        response = await self.execute(
            query=ADD_CONTENTS_TO_COLLECTIONS_GQL,
            operation_name="AddContentsToCollections",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return AddContentsToCollections.model_validate(data)

    async def create_collection(
        self, collection: CollectionInput, **kwargs: Any
    ) -> CreateCollection:
        variables: Dict[str, object] = {"collection": collection}
        response = await self.execute(
            query=CREATE_COLLECTION_GQL,
            operation_name="CreateCollection",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateCollection.model_validate(data)

    async def delete_collection(self, id: str, **kwargs: Any) -> DeleteCollection:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=DELETE_COLLECTION_GQL,
            operation_name="DeleteCollection",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteCollection.model_validate(data)

    async def delete_collections(
        self, ids: List[str], **kwargs: Any
    ) -> DeleteCollections:
        variables: Dict[str, object] = {"ids": ids}
        response = await self.execute(
            query=DELETE_COLLECTIONS_GQL,
            operation_name="DeleteCollections",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteCollections.model_validate(data)

    async def get_collection(self, id: str, **kwargs: Any) -> GetCollection:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=GET_COLLECTION_GQL,
            operation_name="GetCollection",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetCollection.model_validate(data)

    async def query_collections(
        self,
        filter: Union[Optional[CollectionFilter], UnsetType] = UNSET,
        **kwargs: Any
    ) -> QueryCollections:
        variables: Dict[str, object] = {"filter": filter}
        response = await self.execute(
            query=QUERY_COLLECTIONS_GQL,
            operation_name="QueryCollections",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return QueryCollections.model_validate(data)

    async def remove_contents_from_collection(
        self,
        contents: List[EntityReferenceInput],
        collection: EntityReferenceInput,
        **kwargs: Any
    ) -> RemoveContentsFromCollection:
        variables: Dict[str, object] = {"contents": contents, "collection": collection}
        response = await self.execute(
            query=REMOVE_CONTENTS_FROM_COLLECTION_GQL,
            operation_name="RemoveContentsFromCollection",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return RemoveContentsFromCollection.model_validate(data)

    async def update_collection(
        self, collection: CollectionUpdateInput, **kwargs: Any
    ) -> UpdateCollection:
        variables: Dict[str, object] = {"collection": collection}
        response = await self.execute(
            query=UPDATE_COLLECTION_GQL,
            operation_name="UpdateCollection",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateCollection.model_validate(data)

    async def delete_all_contents(self, **kwargs: Any) -> DeleteAllContents:
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=DELETE_ALL_CONTENTS_GQL,
            operation_name="DeleteAllContents",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteAllContents.model_validate(data)

    async def delete_content(self, id: str, **kwargs: Any) -> DeleteContent:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=DELETE_CONTENT_GQL,
            operation_name="DeleteContent",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteContent.model_validate(data)

    async def delete_contents(self, ids: List[str], **kwargs: Any) -> DeleteContents:
        variables: Dict[str, object] = {"ids": ids}
        response = await self.execute(
            query=DELETE_CONTENTS_GQL,
            operation_name="DeleteContents",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteContents.model_validate(data)

    async def extract_contents(
        self,
        prompt: str,
        specification: EntityReferenceInput,
        filter: Union[Optional[ContentFilter], UnsetType] = UNSET,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ExtractContents:
        variables: Dict[str, object] = {
            "prompt": prompt,
            "filter": filter,
            "specification": specification,
            "correlationId": correlation_id,
        }
        response = await self.execute(
            query=EXTRACT_CONTENTS_GQL,
            operation_name="ExtractContents",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ExtractContents.model_validate(data)

    async def get_content(self, id: str, **kwargs: Any) -> GetContent:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=GET_CONTENT_GQL,
            operation_name="GetContent",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetContent.model_validate(data)

    async def ingest_encoded_file(
        self,
        name: str,
        data: str,
        mime_type: str,
        id: Union[Optional[str], UnsetType] = UNSET,
        is_synchronous: Union[Optional[bool], UnsetType] = UNSET,
        workflow: Union[Optional[EntityReferenceInput], UnsetType] = UNSET,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> IngestEncodedFile:
        variables: Dict[str, object] = {
            "name": name,
            "data": data,
            "mimeType": mime_type,
            "id": id,
            "isSynchronous": is_synchronous,
            "workflow": workflow,
            "correlationId": correlation_id,
        }
        response = await self.execute(
            query=INGEST_ENCODED_FILE_GQL,
            operation_name="IngestEncodedFile",
            variables=variables,
            **kwargs
        )
        _data = self.get_data(response)
        return IngestEncodedFile.model_validate(_data)

    async def ingest_text(
        self,
        name: str,
        text: str,
        text_type: Union[Optional[TextTypes], UnsetType] = UNSET,
        uri: Union[Optional[Any], UnsetType] = UNSET,
        id: Union[Optional[str], UnsetType] = UNSET,
        is_synchronous: Union[Optional[bool], UnsetType] = UNSET,
        workflow: Union[Optional[EntityReferenceInput], UnsetType] = UNSET,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> IngestText:
        variables: Dict[str, object] = {
            "name": name,
            "text": text,
            "textType": text_type,
            "uri": uri,
            "id": id,
            "isSynchronous": is_synchronous,
            "workflow": workflow,
            "correlationId": correlation_id,
        }
        response = await self.execute(
            query=INGEST_TEXT_GQL,
            operation_name="IngestText",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return IngestText.model_validate(data)

    async def ingest_uri(
        self,
        uri: Any,
        name: Union[Optional[str], UnsetType] = UNSET,
        id: Union[Optional[str], UnsetType] = UNSET,
        is_synchronous: Union[Optional[bool], UnsetType] = UNSET,
        workflow: Union[Optional[EntityReferenceInput], UnsetType] = UNSET,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> IngestUri:
        variables: Dict[str, object] = {
            "name": name,
            "uri": uri,
            "id": id,
            "isSynchronous": is_synchronous,
            "workflow": workflow,
            "correlationId": correlation_id,
        }
        response = await self.execute(
            query=INGEST_URI_GQL,
            operation_name="IngestUri",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return IngestUri.model_validate(data)

    async def is_content_done(self, id: str, **kwargs: Any) -> IsContentDone:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=IS_CONTENT_DONE_GQL,
            operation_name="IsContentDone",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return IsContentDone.model_validate(data)

    async def publish_contents(
        self,
        publish_prompt: str,
        connector: ContentPublishingConnectorInput,
        summary_prompt: Union[Optional[str], UnsetType] = UNSET,
        filter: Union[Optional[ContentFilter], UnsetType] = UNSET,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        name: Union[Optional[str], UnsetType] = UNSET,
        summary_specification: Union[Optional[EntityReferenceInput], UnsetType] = UNSET,
        publish_specification: Union[Optional[EntityReferenceInput], UnsetType] = UNSET,
        workflow: Union[Optional[EntityReferenceInput], UnsetType] = UNSET,
        **kwargs: Any
    ) -> PublishContents:
        variables: Dict[str, object] = {
            "summaryPrompt": summary_prompt,
            "publishPrompt": publish_prompt,
            "connector": connector,
            "filter": filter,
            "correlationId": correlation_id,
            "name": name,
            "summarySpecification": summary_specification,
            "publishSpecification": publish_specification,
            "workflow": workflow,
        }
        response = await self.execute(
            query=PUBLISH_CONTENTS_GQL,
            operation_name="PublishContents",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return PublishContents.model_validate(data)

    async def query_content_facets(
        self,
        filter: Union[Optional[ContentFilter], UnsetType] = UNSET,
        facets: Union[Optional[List[ContentFacetInput]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> QueryContentFacets:
        variables: Dict[str, object] = {"filter": filter, "facets": facets}
        response = await self.execute(
            query=QUERY_CONTENT_FACETS_GQL,
            operation_name="QueryContentFacets",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return QueryContentFacets.model_validate(data)

    async def query_contents(
        self, filter: Union[Optional[ContentFilter], UnsetType] = UNSET, **kwargs: Any
    ) -> QueryContents:
        variables: Dict[str, object] = {"filter": filter}
        response = await self.execute(
            query=QUERY_CONTENTS_GQL,
            operation_name="QueryContents",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return QueryContents.model_validate(data)

    async def summarize_contents(
        self,
        summarizations: List[SummarizationStrategyInput],
        filter: Union[Optional[ContentFilter], UnsetType] = UNSET,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> SummarizeContents:
        variables: Dict[str, object] = {
            "summarizations": summarizations,
            "filter": filter,
            "correlationId": correlation_id,
        }
        response = await self.execute(
            query=SUMMARIZE_CONTENTS_GQL,
            operation_name="SummarizeContents",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SummarizeContents.model_validate(data)

    async def update_content(
        self, content: ContentUpdateInput, **kwargs: Any
    ) -> UpdateContent:
        variables: Dict[str, object] = {"content": content}
        response = await self.execute(
            query=UPDATE_CONTENT_GQL,
            operation_name="UpdateContent",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateContent.model_validate(data)

    async def clear_conversation(self, id: str, **kwargs: Any) -> ClearConversation:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=CLEAR_CONVERSATION_GQL,
            operation_name="ClearConversation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ClearConversation.model_validate(data)

    async def close_conversation(self, id: str, **kwargs: Any) -> CloseConversation:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=CLOSE_CONVERSATION_GQL,
            operation_name="CloseConversation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CloseConversation.model_validate(data)

    async def create_conversation(
        self,
        conversation: ConversationInput,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> CreateConversation:
        variables: Dict[str, object] = {
            "conversation": conversation,
            "correlationId": correlation_id,
        }
        response = await self.execute(
            query=CREATE_CONVERSATION_GQL,
            operation_name="CreateConversation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateConversation.model_validate(data)

    async def delete_all_conversations(self, **kwargs: Any) -> DeleteAllConversations:
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=DELETE_ALL_CONVERSATIONS_GQL,
            operation_name="DeleteAllConversations",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteAllConversations.model_validate(data)

    async def delete_conversation(self, id: str, **kwargs: Any) -> DeleteConversation:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=DELETE_CONVERSATION_GQL,
            operation_name="DeleteConversation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteConversation.model_validate(data)

    async def delete_conversations(
        self, ids: List[str], **kwargs: Any
    ) -> DeleteConversations:
        variables: Dict[str, object] = {"ids": ids}
        response = await self.execute(
            query=DELETE_CONVERSATIONS_GQL,
            operation_name="DeleteConversations",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteConversations.model_validate(data)

    async def get_conversation(self, id: str, **kwargs: Any) -> GetConversation:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=GET_CONVERSATION_GQL,
            operation_name="GetConversation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetConversation.model_validate(data)

    async def prompt_conversation(
        self,
        prompt: str,
        id: Union[Optional[str], UnsetType] = UNSET,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> PromptConversation:
        variables: Dict[str, object] = {
            "prompt": prompt,
            "id": id,
            "correlationId": correlation_id,
        }
        response = await self.execute(
            query=PROMPT_CONVERSATION_GQL,
            operation_name="PromptConversation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return PromptConversation.model_validate(data)

    async def publish_conversation(
        self,
        id: str,
        connector: ContentPublishingConnectorInput,
        name: Union[Optional[str], UnsetType] = UNSET,
        workflow: Union[Optional[EntityReferenceInput], UnsetType] = UNSET,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> PublishConversation:
        variables: Dict[str, object] = {
            "id": id,
            "connector": connector,
            "name": name,
            "workflow": workflow,
            "correlationId": correlation_id,
        }
        response = await self.execute(
            query=PUBLISH_CONVERSATION_GQL,
            operation_name="PublishConversation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return PublishConversation.model_validate(data)

    async def query_conversations(
        self,
        filter: Union[Optional[ConversationFilter], UnsetType] = UNSET,
        **kwargs: Any
    ) -> QueryConversations:
        variables: Dict[str, object] = {"filter": filter}
        response = await self.execute(
            query=QUERY_CONVERSATIONS_GQL,
            operation_name="QueryConversations",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return QueryConversations.model_validate(data)

    async def suggest_conversation(
        self,
        id: str,
        count: Union[Optional[int], UnsetType] = UNSET,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> SuggestConversation:
        variables: Dict[str, object] = {
            "id": id,
            "count": count,
            "correlationId": correlation_id,
        }
        response = await self.execute(
            query=SUGGEST_CONVERSATION_GQL,
            operation_name="SuggestConversation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SuggestConversation.model_validate(data)

    async def update_conversation(
        self, conversation: ConversationUpdateInput, **kwargs: Any
    ) -> UpdateConversation:
        variables: Dict[str, object] = {"conversation": conversation}
        response = await self.execute(
            query=UPDATE_CONVERSATION_GQL,
            operation_name="UpdateConversation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateConversation.model_validate(data)

    async def create_feed(
        self,
        feed: FeedInput,
        correlation_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> CreateFeed:
        variables: Dict[str, object] = {"feed": feed, "correlationId": correlation_id}
        response = await self.execute(
            query=CREATE_FEED_GQL,
            operation_name="CreateFeed",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateFeed.model_validate(data)

    async def delete_all_feeds(self, **kwargs: Any) -> DeleteAllFeeds:
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=DELETE_ALL_FEEDS_GQL,
            operation_name="DeleteAllFeeds",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteAllFeeds.model_validate(data)

    async def delete_feed(self, id: str, **kwargs: Any) -> DeleteFeed:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=DELETE_FEED_GQL,
            operation_name="DeleteFeed",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteFeed.model_validate(data)

    async def delete_feeds(self, ids: List[str], **kwargs: Any) -> DeleteFeeds:
        variables: Dict[str, object] = {"ids": ids}
        response = await self.execute(
            query=DELETE_FEEDS_GQL,
            operation_name="DeleteFeeds",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteFeeds.model_validate(data)

    async def disable_feed(self, id: str, **kwargs: Any) -> DisableFeed:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=DISABLE_FEED_GQL,
            operation_name="DisableFeed",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DisableFeed.model_validate(data)

    async def enable_feed(self, id: str, **kwargs: Any) -> EnableFeed:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=ENABLE_FEED_GQL,
            operation_name="EnableFeed",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return EnableFeed.model_validate(data)

    async def get_feed(self, id: str, **kwargs: Any) -> GetFeed:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=GET_FEED_GQL, operation_name="GetFeed", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetFeed.model_validate(data)

    async def is_feed_done(self, id: str, **kwargs: Any) -> IsFeedDone:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=IS_FEED_DONE_GQL,
            operation_name="IsFeedDone",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return IsFeedDone.model_validate(data)

    async def query_feeds(
        self, filter: Union[Optional[FeedFilter], UnsetType] = UNSET, **kwargs: Any
    ) -> QueryFeeds:
        variables: Dict[str, object] = {"filter": filter}
        response = await self.execute(
            query=QUERY_FEEDS_GQL,
            operation_name="QueryFeeds",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return QueryFeeds.model_validate(data)

    async def update_feed(self, feed: FeedUpdateInput, **kwargs: Any) -> UpdateFeed:
        variables: Dict[str, object] = {"feed": feed}
        response = await self.execute(
            query=UPDATE_FEED_GQL,
            operation_name="UpdateFeed",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateFeed.model_validate(data)

    async def credits(self, start_date: Any, duration: Any, **kwargs: Any) -> Credits:
        variables: Dict[str, object] = {"startDate": start_date, "duration": duration}
        response = await self.execute(
            query=CREDITS_GQL, operation_name="Credits", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Credits.model_validate(data)

    async def get_project(self, **kwargs: Any) -> GetProject:
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=GET_PROJECT_GQL,
            operation_name="GetProject",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetProject.model_validate(data)

    async def lookup_credits(self, correlation_id: str, **kwargs: Any) -> LookupCredits:
        variables: Dict[str, object] = {"correlationId": correlation_id}
        response = await self.execute(
            query=LOOKUP_CREDITS_GQL,
            operation_name="LookupCredits",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return LookupCredits.model_validate(data)

    async def lookup_usage(self, correlation_id: str, **kwargs: Any) -> LookupUsage:
        variables: Dict[str, object] = {"correlationId": correlation_id}
        response = await self.execute(
            query=LOOKUP_USAGE_GQL,
            operation_name="LookupUsage",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return LookupUsage.model_validate(data)

    async def update_project(
        self, project: ProjectUpdateInput, **kwargs: Any
    ) -> UpdateProject:
        variables: Dict[str, object] = {"project": project}
        response = await self.execute(
            query=UPDATE_PROJECT_GQL,
            operation_name="UpdateProject",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateProject.model_validate(data)

    async def usage(self, start_date: Any, duration: Any, **kwargs: Any) -> Usage:
        variables: Dict[str, object] = {"startDate": start_date, "duration": duration}
        response = await self.execute(
            query=USAGE_GQL, operation_name="Usage", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Usage.model_validate(data)

    async def create_specification(
        self, specification: SpecificationInput, **kwargs: Any
    ) -> CreateSpecification:
        variables: Dict[str, object] = {"specification": specification}
        response = await self.execute(
            query=CREATE_SPECIFICATION_GQL,
            operation_name="CreateSpecification",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateSpecification.model_validate(data)

    async def delete_specification(self, id: str, **kwargs: Any) -> DeleteSpecification:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=DELETE_SPECIFICATION_GQL,
            operation_name="DeleteSpecification",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteSpecification.model_validate(data)

    async def get_specification(self, id: str, **kwargs: Any) -> GetSpecification:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=GET_SPECIFICATION_GQL,
            operation_name="GetSpecification",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetSpecification.model_validate(data)

    async def prompt_specifications(
        self, prompt: str, ids: List[str], **kwargs: Any
    ) -> PromptSpecifications:
        variables: Dict[str, object] = {"prompt": prompt, "ids": ids}
        response = await self.execute(
            query=PROMPT_SPECIFICATIONS_GQL,
            operation_name="PromptSpecifications",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return PromptSpecifications.model_validate(data)

    async def query_specifications(
        self,
        filter: Union[Optional[SpecificationFilter], UnsetType] = UNSET,
        **kwargs: Any
    ) -> QuerySpecifications:
        variables: Dict[str, object] = {"filter": filter}
        response = await self.execute(
            query=QUERY_SPECIFICATIONS_GQL,
            operation_name="QuerySpecifications",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return QuerySpecifications.model_validate(data)

    async def update_specification(
        self, specification: SpecificationUpdateInput, **kwargs: Any
    ) -> UpdateSpecification:
        variables: Dict[str, object] = {"specification": specification}
        response = await self.execute(
            query=UPDATE_SPECIFICATION_GQL,
            operation_name="UpdateSpecification",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateSpecification.model_validate(data)

    async def create_workflow(
        self, workflow: WorkflowInput, **kwargs: Any
    ) -> CreateWorkflow:
        variables: Dict[str, object] = {"workflow": workflow}
        response = await self.execute(
            query=CREATE_WORKFLOW_GQL,
            operation_name="CreateWorkflow",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateWorkflow.model_validate(data)

    async def delete_all_workflows(self, **kwargs: Any) -> DeleteAllWorkflows:
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=DELETE_ALL_WORKFLOWS_GQL,
            operation_name="DeleteAllWorkflows",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteAllWorkflows.model_validate(data)

    async def delete_workflow(self, id: str, **kwargs: Any) -> DeleteWorkflow:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=DELETE_WORKFLOW_GQL,
            operation_name="DeleteWorkflow",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteWorkflow.model_validate(data)

    async def delete_workflows(self, ids: List[str], **kwargs: Any) -> DeleteWorkflows:
        variables: Dict[str, object] = {"ids": ids}
        response = await self.execute(
            query=DELETE_WORKFLOWS_GQL,
            operation_name="DeleteWorkflows",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteWorkflows.model_validate(data)

    async def get_workflow(self, id: str, **kwargs: Any) -> GetWorkflow:
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=GET_WORKFLOW_GQL,
            operation_name="GetWorkflow",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetWorkflow.model_validate(data)

    async def query_workflows(
        self, filter: Union[Optional[WorkflowFilter], UnsetType] = UNSET, **kwargs: Any
    ) -> QueryWorkflows:
        variables: Dict[str, object] = {"filter": filter}
        response = await self.execute(
            query=QUERY_WORKFLOWS_GQL,
            operation_name="QueryWorkflows",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return QueryWorkflows.model_validate(data)

    async def update_workflow(
        self, workflow: WorkflowUpdateInput, **kwargs: Any
    ) -> UpdateWorkflow:
        variables: Dict[str, object] = {"workflow": workflow}
        response = await self.execute(
            query=UPDATE_WORKFLOW_GQL,
            operation_name="UpdateWorkflow",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateWorkflow.model_validate(data)
