#!/bin/bash
#
# write-scm-version.sh exists because `proxy.py``
# auto-detects it's next version from git.  Hence,
# for `proxy.py` to work `proxy/common/_scm_version.py`
# file must be auto-generated with necessary information.
#
# For CI/CD, this file is generated via `tox` integration.
# For local development (without editable install), you
# must run this script to pre-populate `_scm_version.py`.
#
# This file is integrated by default within `Makefile`.
# For every make target invocation, `_scm_version.py` file
# will be re-written.

# Guessed Version 2.3.2.dev146+gad54132.d20211114
VERSION=$(python -m setuptools_scm --version | \
    # 2.3.2.dev146+gad54132.d20211114
    awk '{print $3}')

# Store default IFS
OLDIFS=$IFS

IFS="+"
set -- $VERSION
SEMVER=$1
DATE_AND_HASH=$2

IFS="."
set -- $SEMVER
MAJOR=$1
MINOR=$2
PATCH=$3
DISTANCE=$4

# Reset IFS
IFS=$OLDIFS

echo "# coding: utf-8
# file generated by setuptools_scm
# don't change, don't track in version control
version = '${VERSION}'
version_tuple = (${MAJOR}, ${MINOR}, '${PATCH}', '${DISTANCE}', '${DATE_AND_HASH}')" > \
    proxy/common/_scm_version.py

echo $MAJOR.$MINOR.$PATCH.$DISTANCE
