from .lib import loadLibrary
from .response import Response
from . import sessions
import ctypes
import json

globalLibrary = loadLibrary()


def get(url: str, **kwargs) -> Response:
    with sessions.Session(one_time=True, library=globalLibrary) as session:
        return session.get(url, **kwargs)


def post(url: str, **kwargs) -> Response:
    with sessions.Session(one_time=True, library=globalLibrary) as session:
        return session.post(url, **kwargs)


def put(url: str, **kwargs) -> Response:
    with sessions.Session(one_time=True, library=globalLibrary) as session:
        return session.put(url, **kwargs)


def session(proxy="") -> sessions.Session:

    return sessions.Session(proxy, library=globalLibrary)
