# coding: utf-8

"""
    AKEYLESS Proxy API

    RESTFull API for interacting with AKEYLESS Proxy Vault  # noqa: E501

    OpenAPI spec version: 0.1.1
    Contact: refael@akeyless.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from akeyless_proxy_api.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def assoc_role_am(self, role_name, am_name, token, **kwargs):  # noqa: E501
        """Create an association between role and auth method  # noqa: E501

        Create an association between role and auth method Options:   role-name -    The role name to associate   am-name -    The auth method name to associate   sub-claims -    key/val of sub claims, ex. group=admins,developers   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assoc_role_am(role_name, am_name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role_name: The role name to associate (required)
        :param str am_name: The auth method name to associate (required)
        :param str token: Access token (required)
        :param str sub_claims: key/val of sub claims, ex. group=admins,developers
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assoc_role_am_with_http_info(role_name, am_name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.assoc_role_am_with_http_info(role_name, am_name, token, **kwargs)  # noqa: E501
            return data

    def assoc_role_am_with_http_info(self, role_name, am_name, token, **kwargs):  # noqa: E501
        """Create an association between role and auth method  # noqa: E501

        Create an association between role and auth method Options:   role-name -    The role name to associate   am-name -    The auth method name to associate   sub-claims -    key/val of sub claims, ex. group=admins,developers   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assoc_role_am_with_http_info(role_name, am_name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role_name: The role name to associate (required)
        :param str am_name: The auth method name to associate (required)
        :param str token: Access token (required)
        :param str sub_claims: key/val of sub claims, ex. group=admins,developers
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name', 'am_name', 'token', 'sub_claims']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assoc_role_am" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `assoc_role_am`")  # noqa: E501
        # verify the required parameter 'am_name' is set
        if ('am_name' not in params or
                params['am_name'] is None):
            raise ValueError("Missing the required parameter `am_name` when calling `assoc_role_am`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `assoc_role_am`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role_name' in params:
            query_params.append(('role-name', params['role_name']))  # noqa: E501
        if 'am_name' in params:
            query_params.append(('am-name', params['am_name']))  # noqa: E501
        if 'sub_claims' in params:
            query_params.append(('sub-claims', params['sub_claims']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/assoc-role-am', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def auth(self, access_id, **kwargs):  # noqa: E501
        """Authenticate to the service and returns a token to be used as a profile to execute the CLI without the need for re-authentication  # noqa: E501

        Authenticate to the service and returns a token to be used as a profile to execute the CLI without the need for re-authentication Options:   access-id -    Access ID   access-type -    Access Type (api_key/okta_saml/ldap)   access-key -    Access key (relevant only for access-type=api_key)   ldap_proxy_url -    Address URL for LDAP proxy (relevant only for access-type=ldap)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access ID (required)
        :param str access_type: Access Type (api_key/okta_saml/ldap)
        :param str access_key: Access key (relevant only for access-type=api_key)
        :param str ldap_proxy_url: Address URL for LDAP proxy (relevant only for access-type=ldap)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.auth_with_http_info(access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.auth_with_http_info(access_id, **kwargs)  # noqa: E501
            return data

    def auth_with_http_info(self, access_id, **kwargs):  # noqa: E501
        """Authenticate to the service and returns a token to be used as a profile to execute the CLI without the need for re-authentication  # noqa: E501

        Authenticate to the service and returns a token to be used as a profile to execute the CLI without the need for re-authentication Options:   access-id -    Access ID   access-type -    Access Type (api_key/okta_saml/ldap)   access-key -    Access key (relevant only for access-type=api_key)   ldap_proxy_url -    Address URL for LDAP proxy (relevant only for access-type=ldap)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_with_http_info(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access ID (required)
        :param str access_type: Access Type (api_key/okta_saml/ldap)
        :param str access_key: Access key (relevant only for access-type=api_key)
        :param str ldap_proxy_url: Address URL for LDAP proxy (relevant only for access-type=ldap)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_id', 'access_type', 'access_key', 'ldap_proxy_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auth" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `auth`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_id' in params:
            query_params.append(('access-id', params['access_id']))  # noqa: E501
        if 'access_type' in params:
            query_params.append(('access-type', params['access_type']))  # noqa: E501
        if 'access_key' in params:
            query_params.append(('access-key', params['access_key']))  # noqa: E501
        if 'ldap_proxy_url' in params:
            query_params.append(('ldap_proxy_url', params['ldap_proxy_url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def configure(self, access_id, **kwargs):  # noqa: E501
        """Configure client profile.  # noqa: E501

        Configure client profile. Options:   access-id -    Access ID   access-key -    Access Key   access-type -    Access Type (api_key/azure_ad/okta_saml/ldap)   ldap_proxy_url -    Address URL for ldap proxy (relevant only for access-type=ldap)   azure_ad_object_id -    Azure Active Directory ObjectId (relevant only for access-type=azure_ad)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.configure(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access ID (required)
        :param str access_key: Access Key
        :param str access_type: Access Type (api_key/azure_ad/okta_saml/ldap)
        :param str ldap_proxy_url: Address URL for ldap proxy (relevant only for access-type=ldap)
        :param str azure_ad_object_id: Azure Active Directory ObjectId (relevant only for access-type=azure_ad)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.configure_with_http_info(access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.configure_with_http_info(access_id, **kwargs)  # noqa: E501
            return data

    def configure_with_http_info(self, access_id, **kwargs):  # noqa: E501
        """Configure client profile.  # noqa: E501

        Configure client profile. Options:   access-id -    Access ID   access-key -    Access Key   access-type -    Access Type (api_key/azure_ad/okta_saml/ldap)   ldap_proxy_url -    Address URL for ldap proxy (relevant only for access-type=ldap)   azure_ad_object_id -    Azure Active Directory ObjectId (relevant only for access-type=azure_ad)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.configure_with_http_info(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access ID (required)
        :param str access_key: Access Key
        :param str access_type: Access Type (api_key/azure_ad/okta_saml/ldap)
        :param str ldap_proxy_url: Address URL for ldap proxy (relevant only for access-type=ldap)
        :param str azure_ad_object_id: Azure Active Directory ObjectId (relevant only for access-type=azure_ad)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_id', 'access_key', 'access_type', 'ldap_proxy_url', 'azure_ad_object_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method configure" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `configure`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_id' in params:
            query_params.append(('access-id', params['access_id']))  # noqa: E501
        if 'access_key' in params:
            query_params.append(('access-key', params['access_key']))  # noqa: E501
        if 'access_type' in params:
            query_params.append(('access-type', params['access_type']))  # noqa: E501
        if 'ldap_proxy_url' in params:
            query_params.append(('ldap_proxy_url', params['ldap_proxy_url']))  # noqa: E501
        if 'azure_ad_object_id' in params:
            query_params.append(('azure_ad_object_id', params['azure_ad_object_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/configure', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_auth_method(self, name, token, **kwargs):  # noqa: E501
        """Create a new Auth Method in the account  # noqa: E501

        Create a new Auth Method in the account Options:   name -    Auth Method name   access-expires -    Access expiration date in Unix timestamp (select 0 for access without expiry date)   bound-ips -    A CIDR whitelist with the IPs that the access is restricted to   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str token: Access token (required)
        :param str access_expires: Access expiration date in Unix timestamp (select 0 for access without expiry date)
        :param str bound_ips: A CIDR whitelist with the IPs that the access is restricted to
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_auth_method_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.create_auth_method_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def create_auth_method_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Create a new Auth Method in the account  # noqa: E501

        Create a new Auth Method in the account Options:   name -    Auth Method name   access-expires -    Access expiration date in Unix timestamp (select 0 for access without expiry date)   bound-ips -    A CIDR whitelist with the IPs that the access is restricted to   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str token: Access token (required)
        :param str access_expires: Access expiration date in Unix timestamp (select 0 for access without expiry date)
        :param str bound_ips: A CIDR whitelist with the IPs that the access is restricted to
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token', 'access_expires', 'bound_ips']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_method" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_auth_method`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `create_auth_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'access_expires' in params:
            query_params.append(('access-expires', params['access_expires']))  # noqa: E501
        if 'bound_ips' in params:
            query_params.append(('bound-ips', params['bound_ips']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-auth-method', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_auth_method_azure_ad(self, name, bound_tenant_id, token, **kwargs):  # noqa: E501
        """Create a new Auth Method that will be able to authentication using Azure Active Directory credentials  # noqa: E501

        Create a new Auth Method that will be able to authentication using Azure Active Directory credentials Options:   name -    Auth Method name   access-expires -    Access expiration date in Unix timestamp (select 0 for access without expiry date)   bound-ips -    A CIDR whitelist of the IPs that the access is restricted to   bound-tenant-id -    The Azure tenant id that the access is restricted to   issuer -    Issuer URL   jwks-uri -    The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.   audience -    The audience in the JWT   bound-spid -    A list of service principal IDs that the access is restricted to   bound-group-id -    A list of group ids that the access is restricted to   bound-sub-id -    A list of subscription ids that the access is restricted to   bound-rg-id -    A list of resource groups that the access is restricted to   bound-providers -    A list of resource providers that the access is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc)   bound-resource-types -    A list of resource types that the access is restricted to (e.g, virtualMachines, userAssignedIdentities, etc)   bound-resource-names -    A list of resource names that the access is restricted to (e.g, a virtual machine name, scale set name, etc).   bound-resource-id -    A list of full resource ids that the access is restricted to   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method_azure_ad(name, bound_tenant_id, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str bound_tenant_id: The Azure tenant id that the access is restricted to (required)
        :param str token: Access token (required)
        :param str access_expires: Access expiration date in Unix timestamp (select 0 for access without expiry date)
        :param str bound_ips: A CIDR whitelist of the IPs that the access is restricted to
        :param str issuer: Issuer URL
        :param str jwks_uri: The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.
        :param str audience: The audience in the JWT
        :param str bound_spid: A list of service principal IDs that the access is restricted to
        :param str bound_group_id: A list of group ids that the access is restricted to
        :param str bound_sub_id: A list of subscription ids that the access is restricted to
        :param str bound_rg_id: A list of resource groups that the access is restricted to
        :param str bound_providers: A list of resource providers that the access is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc)
        :param str bound_resource_types: A list of resource types that the access is restricted to (e.g, virtualMachines, userAssignedIdentities, etc)
        :param str bound_resource_names: A list of resource names that the access is restricted to (e.g, a virtual machine name, scale set name, etc).
        :param str bound_resource_id: A list of full resource ids that the access is restricted to
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_auth_method_azure_ad_with_http_info(name, bound_tenant_id, token, **kwargs)  # noqa: E501
        else:
            (data) = self.create_auth_method_azure_ad_with_http_info(name, bound_tenant_id, token, **kwargs)  # noqa: E501
            return data

    def create_auth_method_azure_ad_with_http_info(self, name, bound_tenant_id, token, **kwargs):  # noqa: E501
        """Create a new Auth Method that will be able to authentication using Azure Active Directory credentials  # noqa: E501

        Create a new Auth Method that will be able to authentication using Azure Active Directory credentials Options:   name -    Auth Method name   access-expires -    Access expiration date in Unix timestamp (select 0 for access without expiry date)   bound-ips -    A CIDR whitelist of the IPs that the access is restricted to   bound-tenant-id -    The Azure tenant id that the access is restricted to   issuer -    Issuer URL   jwks-uri -    The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.   audience -    The audience in the JWT   bound-spid -    A list of service principal IDs that the access is restricted to   bound-group-id -    A list of group ids that the access is restricted to   bound-sub-id -    A list of subscription ids that the access is restricted to   bound-rg-id -    A list of resource groups that the access is restricted to   bound-providers -    A list of resource providers that the access is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc)   bound-resource-types -    A list of resource types that the access is restricted to (e.g, virtualMachines, userAssignedIdentities, etc)   bound-resource-names -    A list of resource names that the access is restricted to (e.g, a virtual machine name, scale set name, etc).   bound-resource-id -    A list of full resource ids that the access is restricted to   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method_azure_ad_with_http_info(name, bound_tenant_id, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str bound_tenant_id: The Azure tenant id that the access is restricted to (required)
        :param str token: Access token (required)
        :param str access_expires: Access expiration date in Unix timestamp (select 0 for access without expiry date)
        :param str bound_ips: A CIDR whitelist of the IPs that the access is restricted to
        :param str issuer: Issuer URL
        :param str jwks_uri: The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.
        :param str audience: The audience in the JWT
        :param str bound_spid: A list of service principal IDs that the access is restricted to
        :param str bound_group_id: A list of group ids that the access is restricted to
        :param str bound_sub_id: A list of subscription ids that the access is restricted to
        :param str bound_rg_id: A list of resource groups that the access is restricted to
        :param str bound_providers: A list of resource providers that the access is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc)
        :param str bound_resource_types: A list of resource types that the access is restricted to (e.g, virtualMachines, userAssignedIdentities, etc)
        :param str bound_resource_names: A list of resource names that the access is restricted to (e.g, a virtual machine name, scale set name, etc).
        :param str bound_resource_id: A list of full resource ids that the access is restricted to
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'bound_tenant_id', 'token', 'access_expires', 'bound_ips', 'issuer', 'jwks_uri', 'audience', 'bound_spid', 'bound_group_id', 'bound_sub_id', 'bound_rg_id', 'bound_providers', 'bound_resource_types', 'bound_resource_names', 'bound_resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_method_azure_ad" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_auth_method_azure_ad`")  # noqa: E501
        # verify the required parameter 'bound_tenant_id' is set
        if ('bound_tenant_id' not in params or
                params['bound_tenant_id'] is None):
            raise ValueError("Missing the required parameter `bound_tenant_id` when calling `create_auth_method_azure_ad`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `create_auth_method_azure_ad`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'access_expires' in params:
            query_params.append(('access-expires', params['access_expires']))  # noqa: E501
        if 'bound_ips' in params:
            query_params.append(('bound-ips', params['bound_ips']))  # noqa: E501
        if 'bound_tenant_id' in params:
            query_params.append(('bound-tenant-id', params['bound_tenant_id']))  # noqa: E501
        if 'issuer' in params:
            query_params.append(('issuer', params['issuer']))  # noqa: E501
        if 'jwks_uri' in params:
            query_params.append(('jwks-uri', params['jwks_uri']))  # noqa: E501
        if 'audience' in params:
            query_params.append(('audience', params['audience']))  # noqa: E501
        if 'bound_spid' in params:
            query_params.append(('bound-spid', params['bound_spid']))  # noqa: E501
        if 'bound_group_id' in params:
            query_params.append(('bound-group-id', params['bound_group_id']))  # noqa: E501
        if 'bound_sub_id' in params:
            query_params.append(('bound-sub-id', params['bound_sub_id']))  # noqa: E501
        if 'bound_rg_id' in params:
            query_params.append(('bound-rg-id', params['bound_rg_id']))  # noqa: E501
        if 'bound_providers' in params:
            query_params.append(('bound-providers', params['bound_providers']))  # noqa: E501
        if 'bound_resource_types' in params:
            query_params.append(('bound-resource-types', params['bound_resource_types']))  # noqa: E501
        if 'bound_resource_names' in params:
            query_params.append(('bound-resource-names', params['bound_resource_names']))  # noqa: E501
        if 'bound_resource_id' in params:
            query_params.append(('bound-resource-id', params['bound_resource_id']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-auth-method-azure-ad', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_auth_method_ldap(self, name, public_key_file_path, token, **kwargs):  # noqa: E501
        """Create a new Auth Method that will be able to authentication using LDAP  # noqa: E501

        Create a new Auth Method that will be able to authentication using LDAP Options:   name -    Auth Method name   access-expires -    Access expiration date in Unix timestamp (select 0 for access without expiry date)   bound-ips -    A CIDR whitelist of the IPs that the access is restricted to   public-key-file-path -    A public key generated for LDAP authentication method on Akeyless [RSA2048]   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method_ldap(name, public_key_file_path, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str public_key_file_path: A public key generated for LDAP authentication method on Akeyless [RSA2048] (required)
        :param str token: Access token (required)
        :param str access_expires: Access expiration date in Unix timestamp (select 0 for access without expiry date)
        :param str bound_ips: A CIDR whitelist of the IPs that the access is restricted to
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_auth_method_ldap_with_http_info(name, public_key_file_path, token, **kwargs)  # noqa: E501
        else:
            (data) = self.create_auth_method_ldap_with_http_info(name, public_key_file_path, token, **kwargs)  # noqa: E501
            return data

    def create_auth_method_ldap_with_http_info(self, name, public_key_file_path, token, **kwargs):  # noqa: E501
        """Create a new Auth Method that will be able to authentication using LDAP  # noqa: E501

        Create a new Auth Method that will be able to authentication using LDAP Options:   name -    Auth Method name   access-expires -    Access expiration date in Unix timestamp (select 0 for access without expiry date)   bound-ips -    A CIDR whitelist of the IPs that the access is restricted to   public-key-file-path -    A public key generated for LDAP authentication method on Akeyless [RSA2048]   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method_ldap_with_http_info(name, public_key_file_path, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str public_key_file_path: A public key generated for LDAP authentication method on Akeyless [RSA2048] (required)
        :param str token: Access token (required)
        :param str access_expires: Access expiration date in Unix timestamp (select 0 for access without expiry date)
        :param str bound_ips: A CIDR whitelist of the IPs that the access is restricted to
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'public_key_file_path', 'token', 'access_expires', 'bound_ips']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_method_ldap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_auth_method_ldap`")  # noqa: E501
        # verify the required parameter 'public_key_file_path' is set
        if ('public_key_file_path' not in params or
                params['public_key_file_path'] is None):
            raise ValueError("Missing the required parameter `public_key_file_path` when calling `create_auth_method_ldap`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `create_auth_method_ldap`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'access_expires' in params:
            query_params.append(('access-expires', params['access_expires']))  # noqa: E501
        if 'bound_ips' in params:
            query_params.append(('bound-ips', params['bound_ips']))  # noqa: E501
        if 'public_key_file_path' in params:
            query_params.append(('public-key-file-path', params['public_key_file_path']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-auth-method-ldap', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_auth_method_oauth2(self, name, bound_clients_ids, issuer, jwks_uri, audience, token, **kwargs):  # noqa: E501
        """Create a new Auth Method that will be able to authentication using OpenId/OAuth2  # noqa: E501

        Create a new Auth Method that will be able to authentication using OpenId/OAuth2 Options:   name -    Auth Method name   access-expires -    Access expiration date in Unix timestamp (select 0 for access without expiry date)   bound-ips -    A CIDR whitelist of the IPs that the access is restricted to   bound-clients-ids -    The clients ids that the access is restricted to   issuer -    Issuer URL   jwks-uri -    The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.   audience -    The audience in the JWT   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method_oauth2(name, bound_clients_ids, issuer, jwks_uri, audience, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str bound_clients_ids: The clients ids that the access is restricted to (required)
        :param str issuer: Issuer URL (required)
        :param str jwks_uri: The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server. (required)
        :param str audience: The audience in the JWT (required)
        :param str token: Access token (required)
        :param str access_expires: Access expiration date in Unix timestamp (select 0 for access without expiry date)
        :param str bound_ips: A CIDR whitelist of the IPs that the access is restricted to
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_auth_method_oauth2_with_http_info(name, bound_clients_ids, issuer, jwks_uri, audience, token, **kwargs)  # noqa: E501
        else:
            (data) = self.create_auth_method_oauth2_with_http_info(name, bound_clients_ids, issuer, jwks_uri, audience, token, **kwargs)  # noqa: E501
            return data

    def create_auth_method_oauth2_with_http_info(self, name, bound_clients_ids, issuer, jwks_uri, audience, token, **kwargs):  # noqa: E501
        """Create a new Auth Method that will be able to authentication using OpenId/OAuth2  # noqa: E501

        Create a new Auth Method that will be able to authentication using OpenId/OAuth2 Options:   name -    Auth Method name   access-expires -    Access expiration date in Unix timestamp (select 0 for access without expiry date)   bound-ips -    A CIDR whitelist of the IPs that the access is restricted to   bound-clients-ids -    The clients ids that the access is restricted to   issuer -    Issuer URL   jwks-uri -    The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.   audience -    The audience in the JWT   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method_oauth2_with_http_info(name, bound_clients_ids, issuer, jwks_uri, audience, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str bound_clients_ids: The clients ids that the access is restricted to (required)
        :param str issuer: Issuer URL (required)
        :param str jwks_uri: The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server. (required)
        :param str audience: The audience in the JWT (required)
        :param str token: Access token (required)
        :param str access_expires: Access expiration date in Unix timestamp (select 0 for access without expiry date)
        :param str bound_ips: A CIDR whitelist of the IPs that the access is restricted to
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'bound_clients_ids', 'issuer', 'jwks_uri', 'audience', 'token', 'access_expires', 'bound_ips']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_method_oauth2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_auth_method_oauth2`")  # noqa: E501
        # verify the required parameter 'bound_clients_ids' is set
        if ('bound_clients_ids' not in params or
                params['bound_clients_ids'] is None):
            raise ValueError("Missing the required parameter `bound_clients_ids` when calling `create_auth_method_oauth2`")  # noqa: E501
        # verify the required parameter 'issuer' is set
        if ('issuer' not in params or
                params['issuer'] is None):
            raise ValueError("Missing the required parameter `issuer` when calling `create_auth_method_oauth2`")  # noqa: E501
        # verify the required parameter 'jwks_uri' is set
        if ('jwks_uri' not in params or
                params['jwks_uri'] is None):
            raise ValueError("Missing the required parameter `jwks_uri` when calling `create_auth_method_oauth2`")  # noqa: E501
        # verify the required parameter 'audience' is set
        if ('audience' not in params or
                params['audience'] is None):
            raise ValueError("Missing the required parameter `audience` when calling `create_auth_method_oauth2`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `create_auth_method_oauth2`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'access_expires' in params:
            query_params.append(('access-expires', params['access_expires']))  # noqa: E501
        if 'bound_ips' in params:
            query_params.append(('bound-ips', params['bound_ips']))  # noqa: E501
        if 'bound_clients_ids' in params:
            query_params.append(('bound-clients-ids', params['bound_clients_ids']))  # noqa: E501
        if 'issuer' in params:
            query_params.append(('issuer', params['issuer']))  # noqa: E501
        if 'jwks_uri' in params:
            query_params.append(('jwks-uri', params['jwks_uri']))  # noqa: E501
        if 'audience' in params:
            query_params.append(('audience', params['audience']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-auth-method-oauth2', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_auth_method_saml(self, name, idp_metadata_url, token, **kwargs):  # noqa: E501
        """Create a new Auth Method that will be able to authentication using SAML  # noqa: E501

        Create a new Auth Method that will be able to authentication using SAML Options:   name -    Auth Method name   access-expires -    Access expiration date in Unix timestamp (select 0 for access without expiry date)   bound-ips -    A CIDR whitelist of the IPs that the access is restricted to   idp-metadata-url -    IDP metadata url   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method_saml(name, idp_metadata_url, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str idp_metadata_url: IDP metadata url (required)
        :param str token: Access token (required)
        :param str access_expires: Access expiration date in Unix timestamp (select 0 for access without expiry date)
        :param str bound_ips: A CIDR whitelist of the IPs that the access is restricted to
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_auth_method_saml_with_http_info(name, idp_metadata_url, token, **kwargs)  # noqa: E501
        else:
            (data) = self.create_auth_method_saml_with_http_info(name, idp_metadata_url, token, **kwargs)  # noqa: E501
            return data

    def create_auth_method_saml_with_http_info(self, name, idp_metadata_url, token, **kwargs):  # noqa: E501
        """Create a new Auth Method that will be able to authentication using SAML  # noqa: E501

        Create a new Auth Method that will be able to authentication using SAML Options:   name -    Auth Method name   access-expires -    Access expiration date in Unix timestamp (select 0 for access without expiry date)   bound-ips -    A CIDR whitelist of the IPs that the access is restricted to   idp-metadata-url -    IDP metadata url   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method_saml_with_http_info(name, idp_metadata_url, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str idp_metadata_url: IDP metadata url (required)
        :param str token: Access token (required)
        :param str access_expires: Access expiration date in Unix timestamp (select 0 for access without expiry date)
        :param str bound_ips: A CIDR whitelist of the IPs that the access is restricted to
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'idp_metadata_url', 'token', 'access_expires', 'bound_ips']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_method_saml" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_auth_method_saml`")  # noqa: E501
        # verify the required parameter 'idp_metadata_url' is set
        if ('idp_metadata_url' not in params or
                params['idp_metadata_url'] is None):
            raise ValueError("Missing the required parameter `idp_metadata_url` when calling `create_auth_method_saml`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `create_auth_method_saml`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'access_expires' in params:
            query_params.append(('access-expires', params['access_expires']))  # noqa: E501
        if 'bound_ips' in params:
            query_params.append(('bound-ips', params['bound_ips']))  # noqa: E501
        if 'idp_metadata_url' in params:
            query_params.append(('idp-metadata-url', params['idp_metadata_url']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-auth-method-saml', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_dynamic_secret(self, name, token, **kwargs):  # noqa: E501
        """Creates a new dynamic secret item  # noqa: E501

        Creates a new dynamic secret item Options:   name -    Dynamic secret name   metadata -    Metadata about the dynamic secret   key -    The name of a key that used to encrypt the dynamic secret values (if empty, the account default protectionKey key will be used)   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dynamic_secret(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Dynamic secret name (required)
        :param str token: Access token (required)
        :param str metadata: Metadata about the dynamic secret
        :param str key: The name of a key that used to encrypt the dynamic secret values (if empty, the account default protectionKey key will be used)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_dynamic_secret_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.create_dynamic_secret_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def create_dynamic_secret_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Creates a new dynamic secret item  # noqa: E501

        Creates a new dynamic secret item Options:   name -    Dynamic secret name   metadata -    Metadata about the dynamic secret   key -    The name of a key that used to encrypt the dynamic secret values (if empty, the account default protectionKey key will be used)   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dynamic_secret_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Dynamic secret name (required)
        :param str token: Access token (required)
        :param str metadata: Metadata about the dynamic secret
        :param str key: The name of a key that used to encrypt the dynamic secret values (if empty, the account default protectionKey key will be used)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token', 'metadata', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_dynamic_secret" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_dynamic_secret`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `create_dynamic_secret`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'metadata' in params:
            query_params.append(('metadata', params['metadata']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-dynamic-secret', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_key(self, name, alg, token, **kwargs):  # noqa: E501
        """Creates a new key  # noqa: E501

        Creates a new key Options:   name -    Key name   alg -    Key type. options- [AES128GCM, AES256GCM, AES128SIV, AES256SIV, RSA1024, RSA2048]   metadata -    Metadata about the key   split-level -    The number of fragments that the item will be split into (not includes customer fragment)   customer-frg-id -    The customer fragment ID that will be used to create the key (if empty, the key will be created independently of a customer fragment)   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_key(name, alg, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Key name (required)
        :param str alg: Key type. options- [AES128GCM, AES256GCM, AES128SIV, AES256SIV, RSA1024, RSA2048] (required)
        :param str token: Access token (required)
        :param str metadata: Metadata about the key
        :param str split_level: The number of fragments that the item will be split into (not includes customer fragment)
        :param str customer_frg_id: The customer fragment ID that will be used to create the key (if empty, the key will be created independently of a customer fragment)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_key_with_http_info(name, alg, token, **kwargs)  # noqa: E501
        else:
            (data) = self.create_key_with_http_info(name, alg, token, **kwargs)  # noqa: E501
            return data

    def create_key_with_http_info(self, name, alg, token, **kwargs):  # noqa: E501
        """Creates a new key  # noqa: E501

        Creates a new key Options:   name -    Key name   alg -    Key type. options- [AES128GCM, AES256GCM, AES128SIV, AES256SIV, RSA1024, RSA2048]   metadata -    Metadata about the key   split-level -    The number of fragments that the item will be split into (not includes customer fragment)   customer-frg-id -    The customer fragment ID that will be used to create the key (if empty, the key will be created independently of a customer fragment)   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_key_with_http_info(name, alg, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Key name (required)
        :param str alg: Key type. options- [AES128GCM, AES256GCM, AES128SIV, AES256SIV, RSA1024, RSA2048] (required)
        :param str token: Access token (required)
        :param str metadata: Metadata about the key
        :param str split_level: The number of fragments that the item will be split into (not includes customer fragment)
        :param str customer_frg_id: The customer fragment ID that will be used to create the key (if empty, the key will be created independently of a customer fragment)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'alg', 'token', 'metadata', 'split_level', 'customer_frg_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_key`")  # noqa: E501
        # verify the required parameter 'alg' is set
        if ('alg' not in params or
                params['alg'] is None):
            raise ValueError("Missing the required parameter `alg` when calling `create_key`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `create_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'alg' in params:
            query_params.append(('alg', params['alg']))  # noqa: E501
        if 'metadata' in params:
            query_params.append(('metadata', params['metadata']))  # noqa: E501
        if 'split_level' in params:
            query_params.append(('split-level', params['split_level']))  # noqa: E501
        if 'customer_frg_id' in params:
            query_params.append(('customer-frg-id', params['customer_frg_id']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-key', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_role(self, name, token, **kwargs):  # noqa: E501
        """Creates a new role  # noqa: E501

        Creates a new role Options:   name -    Role name   comment -    Comment about the role   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_role(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Role name (required)
        :param str token: Access token (required)
        :param str comment: Comment about the role
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_role_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.create_role_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def create_role_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Creates a new role  # noqa: E501

        Creates a new role Options:   name -    Role name   comment -    Comment about the role   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_role_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Role name (required)
        :param str token: Access token (required)
        :param str comment: Comment about the role
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token', 'comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_role`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `create_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'comment' in params:
            query_params.append(('comment', params['comment']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-role', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_secret(self, name, value, token, **kwargs):  # noqa: E501
        """Creates a new secret item  # noqa: E501

        Creates a new secret item Options:   name -    Secret name   value -    The secret value   metadata -    Metadata about the secret   key -    The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)   multiline -    The provided value is a multiline value (separated by '\\n')   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_secret(name, value, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Secret name (required)
        :param str value: The secret value (required)
        :param str token: Access token (required)
        :param str metadata: Metadata about the secret
        :param str key: The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)
        :param bool multiline: The provided value is a multiline value (separated by '\\n')
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_secret_with_http_info(name, value, token, **kwargs)  # noqa: E501
        else:
            (data) = self.create_secret_with_http_info(name, value, token, **kwargs)  # noqa: E501
            return data

    def create_secret_with_http_info(self, name, value, token, **kwargs):  # noqa: E501
        """Creates a new secret item  # noqa: E501

        Creates a new secret item Options:   name -    Secret name   value -    The secret value   metadata -    Metadata about the secret   key -    The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)   multiline -    The provided value is a multiline value (separated by '\\n')   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_secret_with_http_info(name, value, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Secret name (required)
        :param str value: The secret value (required)
        :param str token: Access token (required)
        :param str metadata: Metadata about the secret
        :param str key: The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)
        :param bool multiline: The provided value is a multiline value (separated by '\\n')
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'value', 'token', 'metadata', 'key', 'multiline']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_secret" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_secret`")  # noqa: E501
        # verify the required parameter 'value' is set
        if ('value' not in params or
                params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `create_secret`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `create_secret`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'value' in params:
            query_params.append(('value', params['value']))  # noqa: E501
        if 'metadata' in params:
            query_params.append(('metadata', params['metadata']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'multiline' in params:
            query_params.append(('multiline', params['multiline']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-secret', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ssh_cert_issuer(self, name, signer_key_name, allowed_users, expiration_sec, token, **kwargs):  # noqa: E501
        """Creates a new SSH certificate issuer  # noqa: E501

        Creates a new SSH certificate issuer Options:   name -    SSH certificate issuer name   signer-key-name -    A key to sign the certificate with   allowed-users -    Users allowed to fetch the certificate, ex. root,ubuntu   principals -    Signed certificates with principal, ex. example_role1,example_role2   extensions -    Signed certificates with extensions, ex. permit-port-forwarding=\"\"   expiration-sec -    Signed certificates with expiration, use second units   metadata -    A metadata about the issuer   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ssh_cert_issuer(name, signer_key_name, allowed_users, expiration_sec, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: SSH certificate issuer name (required)
        :param str signer_key_name: A key to sign the certificate with (required)
        :param str allowed_users: Users allowed to fetch the certificate, ex. root,ubuntu (required)
        :param str expiration_sec: Signed certificates with expiration, use second units (required)
        :param str token: Access token (required)
        :param str principals: Signed certificates with principal, ex. example_role1,example_role2
        :param str extensions: Signed certificates with extensions, ex. permit-port-forwarding=\"\"
        :param str metadata: A metadata about the issuer
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ssh_cert_issuer_with_http_info(name, signer_key_name, allowed_users, expiration_sec, token, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ssh_cert_issuer_with_http_info(name, signer_key_name, allowed_users, expiration_sec, token, **kwargs)  # noqa: E501
            return data

    def create_ssh_cert_issuer_with_http_info(self, name, signer_key_name, allowed_users, expiration_sec, token, **kwargs):  # noqa: E501
        """Creates a new SSH certificate issuer  # noqa: E501

        Creates a new SSH certificate issuer Options:   name -    SSH certificate issuer name   signer-key-name -    A key to sign the certificate with   allowed-users -    Users allowed to fetch the certificate, ex. root,ubuntu   principals -    Signed certificates with principal, ex. example_role1,example_role2   extensions -    Signed certificates with extensions, ex. permit-port-forwarding=\"\"   expiration-sec -    Signed certificates with expiration, use second units   metadata -    A metadata about the issuer   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ssh_cert_issuer_with_http_info(name, signer_key_name, allowed_users, expiration_sec, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: SSH certificate issuer name (required)
        :param str signer_key_name: A key to sign the certificate with (required)
        :param str allowed_users: Users allowed to fetch the certificate, ex. root,ubuntu (required)
        :param str expiration_sec: Signed certificates with expiration, use second units (required)
        :param str token: Access token (required)
        :param str principals: Signed certificates with principal, ex. example_role1,example_role2
        :param str extensions: Signed certificates with extensions, ex. permit-port-forwarding=\"\"
        :param str metadata: A metadata about the issuer
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'signer_key_name', 'allowed_users', 'expiration_sec', 'token', 'principals', 'extensions', 'metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ssh_cert_issuer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_ssh_cert_issuer`")  # noqa: E501
        # verify the required parameter 'signer_key_name' is set
        if ('signer_key_name' not in params or
                params['signer_key_name'] is None):
            raise ValueError("Missing the required parameter `signer_key_name` when calling `create_ssh_cert_issuer`")  # noqa: E501
        # verify the required parameter 'allowed_users' is set
        if ('allowed_users' not in params or
                params['allowed_users'] is None):
            raise ValueError("Missing the required parameter `allowed_users` when calling `create_ssh_cert_issuer`")  # noqa: E501
        # verify the required parameter 'expiration_sec' is set
        if ('expiration_sec' not in params or
                params['expiration_sec'] is None):
            raise ValueError("Missing the required parameter `expiration_sec` when calling `create_ssh_cert_issuer`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `create_ssh_cert_issuer`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'signer_key_name' in params:
            query_params.append(('signer-key-name', params['signer_key_name']))  # noqa: E501
        if 'allowed_users' in params:
            query_params.append(('allowed-users', params['allowed_users']))  # noqa: E501
        if 'principals' in params:
            query_params.append(('principals', params['principals']))  # noqa: E501
        if 'extensions' in params:
            query_params.append(('extensions', params['extensions']))  # noqa: E501
        if 'expiration_sec' in params:
            query_params.append(('expiration-sec', params['expiration_sec']))  # noqa: E501
        if 'metadata' in params:
            query_params.append(('metadata', params['metadata']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-ssh-cert-issuer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def decrypt(self, key_name, ciphertext, token, **kwargs):  # noqa: E501
        """Decrypts ciphertext into plaintext by using an AES key  # noqa: E501

        Decrypts ciphertext into plaintext by using an AES key Options:   key-name -    The name of the key to use in the decryption process   ciphertext -    Ciphertext to be decrypted in base64 encoded format   encryption-context -    The encryption context. If this was specified in the encrypt command, it must be specified here or the decryption operation will fail   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decrypt(key_name, ciphertext, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the key to use in the decryption process (required)
        :param str ciphertext: Ciphertext to be decrypted in base64 encoded format (required)
        :param str token: Access token (required)
        :param str encryption_context: The encryption context. If this was specified in the encrypt command, it must be specified here or the decryption operation will fail
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.decrypt_with_http_info(key_name, ciphertext, token, **kwargs)  # noqa: E501
        else:
            (data) = self.decrypt_with_http_info(key_name, ciphertext, token, **kwargs)  # noqa: E501
            return data

    def decrypt_with_http_info(self, key_name, ciphertext, token, **kwargs):  # noqa: E501
        """Decrypts ciphertext into plaintext by using an AES key  # noqa: E501

        Decrypts ciphertext into plaintext by using an AES key Options:   key-name -    The name of the key to use in the decryption process   ciphertext -    Ciphertext to be decrypted in base64 encoded format   encryption-context -    The encryption context. If this was specified in the encrypt command, it must be specified here or the decryption operation will fail   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decrypt_with_http_info(key_name, ciphertext, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the key to use in the decryption process (required)
        :param str ciphertext: Ciphertext to be decrypted in base64 encoded format (required)
        :param str token: Access token (required)
        :param str encryption_context: The encryption context. If this was specified in the encrypt command, it must be specified here or the decryption operation will fail
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_name', 'ciphertext', 'token', 'encryption_context']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method decrypt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_name' is set
        if ('key_name' not in params or
                params['key_name'] is None):
            raise ValueError("Missing the required parameter `key_name` when calling `decrypt`")  # noqa: E501
        # verify the required parameter 'ciphertext' is set
        if ('ciphertext' not in params or
                params['ciphertext'] is None):
            raise ValueError("Missing the required parameter `ciphertext` when calling `decrypt`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `decrypt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key_name' in params:
            query_params.append(('key-name', params['key_name']))  # noqa: E501
        if 'ciphertext' in params:
            query_params.append(('ciphertext', params['ciphertext']))  # noqa: E501
        if 'encryption_context' in params:
            query_params.append(('encryption-context', params['encryption_context']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decrypt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def decrypt_file(self, key_name, _in, token, **kwargs):  # noqa: E501
        """Decrypts a file by using an AES key  # noqa: E501

        Decrypts a file by using an AES key Options:   key-name -    The name of the key to use in the decryption process   in -    Path to the file to be decrypted. If not provided, the content will be taken from stdin   out -    Path to the output file. If not provided, the output will be sent to stdout   encryption-context -    The encryption context. If this was specified in the encrypt command, it must be specified here or the decryption operation will fail   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decrypt_file(key_name, _in, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the key to use in the decryption process (required)
        :param str _in: Path to the file to be decrypted. If not provided, the content will be taken from stdin (required)
        :param str token: Access token (required)
        :param str out: Path to the output file. If not provided, the output will be sent to stdout
        :param str encryption_context: The encryption context. If this was specified in the encrypt command, it must be specified here or the decryption operation will fail
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.decrypt_file_with_http_info(key_name, _in, token, **kwargs)  # noqa: E501
        else:
            (data) = self.decrypt_file_with_http_info(key_name, _in, token, **kwargs)  # noqa: E501
            return data

    def decrypt_file_with_http_info(self, key_name, _in, token, **kwargs):  # noqa: E501
        """Decrypts a file by using an AES key  # noqa: E501

        Decrypts a file by using an AES key Options:   key-name -    The name of the key to use in the decryption process   in -    Path to the file to be decrypted. If not provided, the content will be taken from stdin   out -    Path to the output file. If not provided, the output will be sent to stdout   encryption-context -    The encryption context. If this was specified in the encrypt command, it must be specified here or the decryption operation will fail   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decrypt_file_with_http_info(key_name, _in, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the key to use in the decryption process (required)
        :param str _in: Path to the file to be decrypted. If not provided, the content will be taken from stdin (required)
        :param str token: Access token (required)
        :param str out: Path to the output file. If not provided, the output will be sent to stdout
        :param str encryption_context: The encryption context. If this was specified in the encrypt command, it must be specified here or the decryption operation will fail
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_name', '_in', 'token', 'out', 'encryption_context']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method decrypt_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_name' is set
        if ('key_name' not in params or
                params['key_name'] is None):
            raise ValueError("Missing the required parameter `key_name` when calling `decrypt_file`")  # noqa: E501
        # verify the required parameter '_in' is set
        if ('_in' not in params or
                params['_in'] is None):
            raise ValueError("Missing the required parameter `_in` when calling `decrypt_file`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `decrypt_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key_name' in params:
            query_params.append(('key-name', params['key_name']))  # noqa: E501
        if '_in' in params:
            query_params.append(('in', params['_in']))  # noqa: E501
        if 'out' in params:
            query_params.append(('out', params['out']))  # noqa: E501
        if 'encryption_context' in params:
            query_params.append(('encryption-context', params['encryption_context']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decrypt-file', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def decrypt_pkcs1(self, key_name, ciphertext, token, **kwargs):  # noqa: E501
        """Decrypts a plaintext using RSA and the padding scheme from PKCS#1 v1.5  # noqa: E501

        Decrypts a plaintext using RSA and the padding scheme from PKCS#1 v1.5 Options:   key-name -    The name of the RSA key to use in the decryption process   ciphertext -    Ciphertext to be decrypted in base64 encoded format   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decrypt_pkcs1(key_name, ciphertext, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the RSA key to use in the decryption process (required)
        :param str ciphertext: Ciphertext to be decrypted in base64 encoded format (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.decrypt_pkcs1_with_http_info(key_name, ciphertext, token, **kwargs)  # noqa: E501
        else:
            (data) = self.decrypt_pkcs1_with_http_info(key_name, ciphertext, token, **kwargs)  # noqa: E501
            return data

    def decrypt_pkcs1_with_http_info(self, key_name, ciphertext, token, **kwargs):  # noqa: E501
        """Decrypts a plaintext using RSA and the padding scheme from PKCS#1 v1.5  # noqa: E501

        Decrypts a plaintext using RSA and the padding scheme from PKCS#1 v1.5 Options:   key-name -    The name of the RSA key to use in the decryption process   ciphertext -    Ciphertext to be decrypted in base64 encoded format   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decrypt_pkcs1_with_http_info(key_name, ciphertext, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the RSA key to use in the decryption process (required)
        :param str ciphertext: Ciphertext to be decrypted in base64 encoded format (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_name', 'ciphertext', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method decrypt_pkcs1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_name' is set
        if ('key_name' not in params or
                params['key_name'] is None):
            raise ValueError("Missing the required parameter `key_name` when calling `decrypt_pkcs1`")  # noqa: E501
        # verify the required parameter 'ciphertext' is set
        if ('ciphertext' not in params or
                params['ciphertext'] is None):
            raise ValueError("Missing the required parameter `ciphertext` when calling `decrypt_pkcs1`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `decrypt_pkcs1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key_name' in params:
            query_params.append(('key-name', params['key_name']))  # noqa: E501
        if 'ciphertext' in params:
            query_params.append(('ciphertext', params['ciphertext']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decrypt-pkcs1', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_assoc(self, assoc_id, token, **kwargs):  # noqa: E501
        """Delete an association between role and auth method  # noqa: E501

        Delete an association between role and auth method Options:   assoc-id -    The association id to be deleted   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_assoc(assoc_id, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assoc_id: The association id to be deleted (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_assoc_with_http_info(assoc_id, token, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_assoc_with_http_info(assoc_id, token, **kwargs)  # noqa: E501
            return data

    def delete_assoc_with_http_info(self, assoc_id, token, **kwargs):  # noqa: E501
        """Delete an association between role and auth method  # noqa: E501

        Delete an association between role and auth method Options:   assoc-id -    The association id to be deleted   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_assoc_with_http_info(assoc_id, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assoc_id: The association id to be deleted (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assoc_id', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_assoc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assoc_id' is set
        if ('assoc_id' not in params or
                params['assoc_id'] is None):
            raise ValueError("Missing the required parameter `assoc_id` when calling `delete_assoc`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `delete_assoc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'assoc_id' in params:
            query_params.append(('assoc-id', params['assoc_id']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/delete-assoc', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_auth_method(self, name, token, **kwargs):  # noqa: E501
        """Delete the Auth Method  # noqa: E501

        Delete the Auth Method Options:   name -    Auth Method name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_method(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_auth_method_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_auth_method_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def delete_auth_method_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Delete the Auth Method  # noqa: E501

        Delete the Auth Method Options:   name -    Auth Method name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_method_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_auth_method" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_auth_method`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `delete_auth_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/delete-auth-method', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_item(self, name, token, **kwargs):  # noqa: E501
        """Delete an item  # noqa: E501

        Delete an item Options:   name -    Item name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Item name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_item_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_item_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def delete_item_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Delete an item  # noqa: E501

        Delete an item Options:   name -    Item name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Item name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_item`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `delete_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/delete-item', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role(self, name, token, **kwargs):  # noqa: E501
        """Delete a role  # noqa: E501

        Delete a role Options:   name -    Role name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Role name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_role_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def delete_role_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Delete a role  # noqa: E501

        Delete a role Options:   name -    Role name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Role name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_role`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `delete_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/delete-role', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role_rule(self, role_name, path, token, **kwargs):  # noqa: E501
        """Delete a rule from a role  # noqa: E501

        Delete a rule from a role Options:   role-name -    The role name to be updated   path -    The path the rule refers to   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_rule(role_name, path, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role_name: The role name to be updated (required)
        :param str path: The path the rule refers to (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_role_rule_with_http_info(role_name, path, token, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_rule_with_http_info(role_name, path, token, **kwargs)  # noqa: E501
            return data

    def delete_role_rule_with_http_info(self, role_name, path, token, **kwargs):  # noqa: E501
        """Delete a rule from a role  # noqa: E501

        Delete a rule from a role Options:   role-name -    The role name to be updated   path -    The path the rule refers to   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_rule_with_http_info(role_name, path, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role_name: The role name to be updated (required)
        :param str path: The path the rule refers to (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name', 'path', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `delete_role_rule`")  # noqa: E501
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `delete_role_rule`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `delete_role_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role_name' in params:
            query_params.append(('role-name', params['role_name']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/delete-role-rule', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_item(self, name, token, **kwargs):  # noqa: E501
        """Returns the item details  # noqa: E501

        Returns the item details Options:   name -    Item name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_item(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Item name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_item_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_item_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def describe_item_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Returns the item details  # noqa: E501

        Returns the item details Options:   name -    Item name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_item_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Item name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `describe_item`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `describe_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/describe-item', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def encrypt(self, key_name, plaintext, token, **kwargs):  # noqa: E501
        """Encrypts plaintext into ciphertext by using an AES key  # noqa: E501

        Encrypts plaintext into ciphertext by using an AES key Options:   key-name -    The name of the key to use in the encryption process   plaintext -    Data to be encrypted   encryption-context -    name-value pair that specifies the encryption context to be used for authenticated encryption. If used here, the same value must be supplied to the decrypt command or decryption will fail   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.encrypt(key_name, plaintext, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the key to use in the encryption process (required)
        :param str plaintext: Data to be encrypted (required)
        :param str token: Access token (required)
        :param str encryption_context: name-value pair that specifies the encryption context to be used for authenticated encryption. If used here, the same value must be supplied to the decrypt command or decryption will fail
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.encrypt_with_http_info(key_name, plaintext, token, **kwargs)  # noqa: E501
        else:
            (data) = self.encrypt_with_http_info(key_name, plaintext, token, **kwargs)  # noqa: E501
            return data

    def encrypt_with_http_info(self, key_name, plaintext, token, **kwargs):  # noqa: E501
        """Encrypts plaintext into ciphertext by using an AES key  # noqa: E501

        Encrypts plaintext into ciphertext by using an AES key Options:   key-name -    The name of the key to use in the encryption process   plaintext -    Data to be encrypted   encryption-context -    name-value pair that specifies the encryption context to be used for authenticated encryption. If used here, the same value must be supplied to the decrypt command or decryption will fail   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.encrypt_with_http_info(key_name, plaintext, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the key to use in the encryption process (required)
        :param str plaintext: Data to be encrypted (required)
        :param str token: Access token (required)
        :param str encryption_context: name-value pair that specifies the encryption context to be used for authenticated encryption. If used here, the same value must be supplied to the decrypt command or decryption will fail
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_name', 'plaintext', 'token', 'encryption_context']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method encrypt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_name' is set
        if ('key_name' not in params or
                params['key_name'] is None):
            raise ValueError("Missing the required parameter `key_name` when calling `encrypt`")  # noqa: E501
        # verify the required parameter 'plaintext' is set
        if ('plaintext' not in params or
                params['plaintext'] is None):
            raise ValueError("Missing the required parameter `plaintext` when calling `encrypt`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `encrypt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key_name' in params:
            query_params.append(('key-name', params['key_name']))  # noqa: E501
        if 'plaintext' in params:
            query_params.append(('plaintext', params['plaintext']))  # noqa: E501
        if 'encryption_context' in params:
            query_params.append(('encryption-context', params['encryption_context']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/encrypt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def encrypt_file(self, key_name, _in, token, **kwargs):  # noqa: E501
        """Encrypts a file by using an AES key  # noqa: E501

        Encrypts a file by using an AES key Options:   key-name -    The name of the key to use in the encryption process   in -    Path to the file to be encrypted. If not provided, the content will be taken from stdin   out -    Path to the output file. If not provided, the output will be sent to stdout   encryption-context -    name-value pair that specifies the encryption context to be used for authenticated encryption. If used here, the same value must be supplied to the decrypt command or decryption will fail   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.encrypt_file(key_name, _in, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the key to use in the encryption process (required)
        :param str _in: Path to the file to be encrypted. If not provided, the content will be taken from stdin (required)
        :param str token: Access token (required)
        :param str out: Path to the output file. If not provided, the output will be sent to stdout
        :param str encryption_context: name-value pair that specifies the encryption context to be used for authenticated encryption. If used here, the same value must be supplied to the decrypt command or decryption will fail
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.encrypt_file_with_http_info(key_name, _in, token, **kwargs)  # noqa: E501
        else:
            (data) = self.encrypt_file_with_http_info(key_name, _in, token, **kwargs)  # noqa: E501
            return data

    def encrypt_file_with_http_info(self, key_name, _in, token, **kwargs):  # noqa: E501
        """Encrypts a file by using an AES key  # noqa: E501

        Encrypts a file by using an AES key Options:   key-name -    The name of the key to use in the encryption process   in -    Path to the file to be encrypted. If not provided, the content will be taken from stdin   out -    Path to the output file. If not provided, the output will be sent to stdout   encryption-context -    name-value pair that specifies the encryption context to be used for authenticated encryption. If used here, the same value must be supplied to the decrypt command or decryption will fail   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.encrypt_file_with_http_info(key_name, _in, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the key to use in the encryption process (required)
        :param str _in: Path to the file to be encrypted. If not provided, the content will be taken from stdin (required)
        :param str token: Access token (required)
        :param str out: Path to the output file. If not provided, the output will be sent to stdout
        :param str encryption_context: name-value pair that specifies the encryption context to be used for authenticated encryption. If used here, the same value must be supplied to the decrypt command or decryption will fail
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_name', '_in', 'token', 'out', 'encryption_context']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method encrypt_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_name' is set
        if ('key_name' not in params or
                params['key_name'] is None):
            raise ValueError("Missing the required parameter `key_name` when calling `encrypt_file`")  # noqa: E501
        # verify the required parameter '_in' is set
        if ('_in' not in params or
                params['_in'] is None):
            raise ValueError("Missing the required parameter `_in` when calling `encrypt_file`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `encrypt_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key_name' in params:
            query_params.append(('key-name', params['key_name']))  # noqa: E501
        if '_in' in params:
            query_params.append(('in', params['_in']))  # noqa: E501
        if 'out' in params:
            query_params.append(('out', params['out']))  # noqa: E501
        if 'encryption_context' in params:
            query_params.append(('encryption-context', params['encryption_context']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/encrypt-file', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def encrypt_pkcs1(self, key_name, plaintext, token, **kwargs):  # noqa: E501
        """Encrypts the given message with RSA and the padding scheme from PKCS#1 v1.5  # noqa: E501

        Encrypts the given message with RSA and the padding scheme from PKCS#1 v1.5 Options:   key-name -    The name of the RSA key to use in the encryption process   plaintext -    Data to be encrypted   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.encrypt_pkcs1(key_name, plaintext, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the RSA key to use in the encryption process (required)
        :param str plaintext: Data to be encrypted (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.encrypt_pkcs1_with_http_info(key_name, plaintext, token, **kwargs)  # noqa: E501
        else:
            (data) = self.encrypt_pkcs1_with_http_info(key_name, plaintext, token, **kwargs)  # noqa: E501
            return data

    def encrypt_pkcs1_with_http_info(self, key_name, plaintext, token, **kwargs):  # noqa: E501
        """Encrypts the given message with RSA and the padding scheme from PKCS#1 v1.5  # noqa: E501

        Encrypts the given message with RSA and the padding scheme from PKCS#1 v1.5 Options:   key-name -    The name of the RSA key to use in the encryption process   plaintext -    Data to be encrypted   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.encrypt_pkcs1_with_http_info(key_name, plaintext, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the RSA key to use in the encryption process (required)
        :param str plaintext: Data to be encrypted (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_name', 'plaintext', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method encrypt_pkcs1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_name' is set
        if ('key_name' not in params or
                params['key_name'] is None):
            raise ValueError("Missing the required parameter `key_name` when calling `encrypt_pkcs1`")  # noqa: E501
        # verify the required parameter 'plaintext' is set
        if ('plaintext' not in params or
                params['plaintext'] is None):
            raise ValueError("Missing the required parameter `plaintext` when calling `encrypt_pkcs1`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `encrypt_pkcs1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key_name' in params:
            query_params.append(('key-name', params['key_name']))  # noqa: E501
        if 'plaintext' in params:
            query_params.append(('plaintext', params['plaintext']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/encrypt-pkcs1', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_method(self, name, token, **kwargs):  # noqa: E501
        """Returns an information about the Auth Method  # noqa: E501

        Returns an information about the Auth Method Options:   name -    Auth Method name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_method(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_method_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_method_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def get_auth_method_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Returns an information about the Auth Method  # noqa: E501

        Returns an information about the Auth Method Options:   name -    Auth Method name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_method_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Auth Method name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_method" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_auth_method`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `get_auth_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/get-auth-method', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dynamic_secret_value(self, name, token, **kwargs):  # noqa: E501
        """Get dynamic secret value  # noqa: E501

        Get dynamic secret value Options:   name -    Dynamic secret name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_secret_value(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Dynamic secret name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dynamic_secret_value_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dynamic_secret_value_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def get_dynamic_secret_value_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Get dynamic secret value  # noqa: E501

        Get dynamic secret value Options:   name -    Dynamic secret name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_secret_value_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Dynamic secret name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dynamic_secret_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_dynamic_secret_value`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `get_dynamic_secret_value`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/get-dynamic-secret-value', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role(self, name, token, **kwargs):  # noqa: E501
        """Get role details  # noqa: E501

        Get role details Options:   name -    Role name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Role name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_role_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.get_role_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def get_role_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Get role details  # noqa: E501

        Get role details Options:   name -    Role name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Role name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_role`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `get_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/get-role', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rsa_public(self, name, token, **kwargs):  # noqa: E501
        """Obtain the public key from a specific RSA private key  # noqa: E501

        Obtain the public key from a specific RSA private key Options:   name -    Name of key to be created   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rsa_public(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name of key to be created (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rsa_public_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rsa_public_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def get_rsa_public_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Obtain the public key from a specific RSA private key  # noqa: E501

        Obtain the public key from a specific RSA private key Options:   name -    Name of key to be created   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rsa_public_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name of key to be created (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rsa_public" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_rsa_public`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `get_rsa_public`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/get-rsa-public', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_secret_value(self, name, token, **kwargs):  # noqa: E501
        """Get static secret value  # noqa: E501

        Get static secret value Options:   name -    Secret name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_secret_value(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Secret name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_secret_value_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.get_secret_value_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def get_secret_value_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Get static secret value  # noqa: E501

        Get static secret value Options:   name -    Secret name   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_secret_value_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Secret name (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_secret_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_secret_value`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `get_secret_value`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/get-secret-value', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ssh_certificate(self, cert_username, cert_issuer_name, public_key_file_path, token, **kwargs):  # noqa: E501
        """Generates SSH certificate  # noqa: E501

        Generates SSH certificate Options:   cert-username -    The username to sign in the SSH certificate   cert-issuer-name -    The name of the SSH certificate issuer   public-key-file-path -    SSH public key   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ssh_certificate(cert_username, cert_issuer_name, public_key_file_path, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cert_username: The username to sign in the SSH certificate (required)
        :param str cert_issuer_name: The name of the SSH certificate issuer (required)
        :param str public_key_file_path: SSH public key (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ssh_certificate_with_http_info(cert_username, cert_issuer_name, public_key_file_path, token, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ssh_certificate_with_http_info(cert_username, cert_issuer_name, public_key_file_path, token, **kwargs)  # noqa: E501
            return data

    def get_ssh_certificate_with_http_info(self, cert_username, cert_issuer_name, public_key_file_path, token, **kwargs):  # noqa: E501
        """Generates SSH certificate  # noqa: E501

        Generates SSH certificate Options:   cert-username -    The username to sign in the SSH certificate   cert-issuer-name -    The name of the SSH certificate issuer   public-key-file-path -    SSH public key   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ssh_certificate_with_http_info(cert_username, cert_issuer_name, public_key_file_path, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cert_username: The username to sign in the SSH certificate (required)
        :param str cert_issuer_name: The name of the SSH certificate issuer (required)
        :param str public_key_file_path: SSH public key (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cert_username', 'cert_issuer_name', 'public_key_file_path', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ssh_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cert_username' is set
        if ('cert_username' not in params or
                params['cert_username'] is None):
            raise ValueError("Missing the required parameter `cert_username` when calling `get_ssh_certificate`")  # noqa: E501
        # verify the required parameter 'cert_issuer_name' is set
        if ('cert_issuer_name' not in params or
                params['cert_issuer_name'] is None):
            raise ValueError("Missing the required parameter `cert_issuer_name` when calling `get_ssh_certificate`")  # noqa: E501
        # verify the required parameter 'public_key_file_path' is set
        if ('public_key_file_path' not in params or
                params['public_key_file_path'] is None):
            raise ValueError("Missing the required parameter `public_key_file_path` when calling `get_ssh_certificate`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `get_ssh_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cert_username' in params:
            query_params.append(('cert-username', params['cert_username']))  # noqa: E501
        if 'cert_issuer_name' in params:
            query_params.append(('cert-issuer-name', params['cert_issuer_name']))  # noqa: E501
        if 'public_key_file_path' in params:
            query_params.append(('public-key-file-path', params['public_key_file_path']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/get-ssh-certificate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def help(self, **kwargs):  # noqa: E501
        """help text  # noqa: E501

        help text  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.help(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.help_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.help_with_http_info(**kwargs)  # noqa: E501
            return data

    def help_with_http_info(self, **kwargs):  # noqa: E501
        """help text  # noqa: E501

        help text  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.help_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method help" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/help', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_auth_methods(self, token, **kwargs):  # noqa: E501
        """Returns a list of all the Auth Methods in the account  # noqa: E501

        Returns a list of all the Auth Methods in the account Options:   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_auth_methods(token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_auth_methods_with_http_info(token, **kwargs)  # noqa: E501
        else:
            (data) = self.list_auth_methods_with_http_info(token, **kwargs)  # noqa: E501
            return data

    def list_auth_methods_with_http_info(self, token, **kwargs):  # noqa: E501
        """Returns a list of all the Auth Methods in the account  # noqa: E501

        Returns a list of all the Auth Methods in the account Options:   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_auth_methods_with_http_info(token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_auth_methods" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `list_auth_methods`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/list-auth-methods', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_items(self, token, **kwargs):  # noqa: E501
        """Returns a list of all accessible items  # noqa: E501

        Returns a list of all accessible items Options:   type -    The item types list of the requested items. In case it is empty, all types of items will be returned. options- [key, static-secret, dynamic-secret]   ItemsTypes -    ItemsTypes   path -    Path to folder   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_items(token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token: Access token (required)
        :param str type: The item types list of the requested items. In case it is empty, all types of items will be returned. options- [key, static-secret, dynamic-secret]
        :param str items_types: ItemsTypes
        :param str path: Path to folder
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_items_with_http_info(token, **kwargs)  # noqa: E501
        else:
            (data) = self.list_items_with_http_info(token, **kwargs)  # noqa: E501
            return data

    def list_items_with_http_info(self, token, **kwargs):  # noqa: E501
        """Returns a list of all accessible items  # noqa: E501

        Returns a list of all accessible items Options:   type -    The item types list of the requested items. In case it is empty, all types of items will be returned. options- [key, static-secret, dynamic-secret]   ItemsTypes -    ItemsTypes   path -    Path to folder   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_items_with_http_info(token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token: Access token (required)
        :param str type: The item types list of the requested items. In case it is empty, all types of items will be returned. options- [key, static-secret, dynamic-secret]
        :param str items_types: ItemsTypes
        :param str path: Path to folder
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['token', 'type', 'items_types', 'path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `list_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'items_types' in params:
            query_params.append(('ItemsTypes', params['items_types']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/list-items', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_roles(self, token, **kwargs):  # noqa: E501
        """Returns a list of all roles in the account  # noqa: E501

        Returns a list of all roles in the account Options:   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_roles(token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_roles_with_http_info(token, **kwargs)  # noqa: E501
        else:
            (data) = self.list_roles_with_http_info(token, **kwargs)  # noqa: E501
            return data

    def list_roles_with_http_info(self, token, **kwargs):  # noqa: E501
        """Returns a list of all roles in the account  # noqa: E501

        Returns a list of all roles in the account Options:   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_roles_with_http_info(token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `list_roles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/list-roles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_role_rule(self, role_name, path, capability, token, **kwargs):  # noqa: E501
        """Set a rule to a role  # noqa: E501

        Set a rule to a role Options:   role-name -    The role name to be updated   path -    The path the rule refers to   capability -    List of the approved/denied capabilities in the path options- [read, create, update, delete, list, deny]   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_role_rule(role_name, path, capability, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role_name: The role name to be updated (required)
        :param str path: The path the rule refers to (required)
        :param str capability: List of the approved/denied capabilities in the path options- [read, create, update, delete, list, deny] (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_role_rule_with_http_info(role_name, path, capability, token, **kwargs)  # noqa: E501
        else:
            (data) = self.set_role_rule_with_http_info(role_name, path, capability, token, **kwargs)  # noqa: E501
            return data

    def set_role_rule_with_http_info(self, role_name, path, capability, token, **kwargs):  # noqa: E501
        """Set a rule to a role  # noqa: E501

        Set a rule to a role Options:   role-name -    The role name to be updated   path -    The path the rule refers to   capability -    List of the approved/denied capabilities in the path options- [read, create, update, delete, list, deny]   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_role_rule_with_http_info(role_name, path, capability, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role_name: The role name to be updated (required)
        :param str path: The path the rule refers to (required)
        :param str capability: List of the approved/denied capabilities in the path options- [read, create, update, delete, list, deny] (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name', 'path', 'capability', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_role_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `set_role_rule`")  # noqa: E501
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `set_role_rule`")  # noqa: E501
        # verify the required parameter 'capability' is set
        if ('capability' not in params or
                params['capability'] is None):
            raise ValueError("Missing the required parameter `capability` when calling `set_role_rule`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `set_role_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role_name' in params:
            query_params.append(('role-name', params['role_name']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'capability' in params:
            query_params.append(('capability', params['capability']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/set-role-rule', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def sign_pkcs1(self, key_name, message, token, **kwargs):  # noqa: E501
        """Calculates the signature of hashed using RSASSA-PKCS1-V1_5-SIGN from RSA PKCS#1 v1.5  # noqa: E501

        Calculates the signature of hashed using RSASSA-PKCS1-V1_5-SIGN from RSA PKCS#1 v1.5 Options:   key-name -    The name of the RSA key to use in the signing process   message -    The message to be signed   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sign_pkcs1(key_name, message, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the RSA key to use in the signing process (required)
        :param str message: The message to be signed (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.sign_pkcs1_with_http_info(key_name, message, token, **kwargs)  # noqa: E501
        else:
            (data) = self.sign_pkcs1_with_http_info(key_name, message, token, **kwargs)  # noqa: E501
            return data

    def sign_pkcs1_with_http_info(self, key_name, message, token, **kwargs):  # noqa: E501
        """Calculates the signature of hashed using RSASSA-PKCS1-V1_5-SIGN from RSA PKCS#1 v1.5  # noqa: E501

        Calculates the signature of hashed using RSASSA-PKCS1-V1_5-SIGN from RSA PKCS#1 v1.5 Options:   key-name -    The name of the RSA key to use in the signing process   message -    The message to be signed   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sign_pkcs1_with_http_info(key_name, message, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the RSA key to use in the signing process (required)
        :param str message: The message to be signed (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_name', 'message', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sign_pkcs1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_name' is set
        if ('key_name' not in params or
                params['key_name'] is None):
            raise ValueError("Missing the required parameter `key_name` when calling `sign_pkcs1`")  # noqa: E501
        # verify the required parameter 'message' is set
        if ('message' not in params or
                params['message'] is None):
            raise ValueError("Missing the required parameter `message` when calling `sign_pkcs1`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `sign_pkcs1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key_name' in params:
            query_params.append(('key-name', params['key_name']))  # noqa: E501
        if 'message' in params:
            query_params.append(('message', params['message']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/sign-pkcs1', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unconfigure(self, token, **kwargs):  # noqa: E501
        """Remove Configuration of client profile.  # noqa: E501

        Remove Configuration of client profile. Options:   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unconfigure(token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unconfigure_with_http_info(token, **kwargs)  # noqa: E501
        else:
            (data) = self.unconfigure_with_http_info(token, **kwargs)  # noqa: E501
            return data

    def unconfigure_with_http_info(self, token, **kwargs):  # noqa: E501
        """Remove Configuration of client profile.  # noqa: E501

        Remove Configuration of client profile. Options:   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unconfigure_with_http_info(token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unconfigure" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `unconfigure`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/unconfigure', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_item(self, name, token, **kwargs):  # noqa: E501
        """Update item name and metadata  # noqa: E501

        Update item name and metadata Options:   name -    Current item name   new-name -    New item name   new-metadata -    New item metadata   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_item(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Current item name (required)
        :param str token: Access token (required)
        :param str new_name: New item name
        :param str new_metadata: New item metadata
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_item_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.update_item_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def update_item_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Update item name and metadata  # noqa: E501

        Update item name and metadata Options:   name -    Current item name   new-name -    New item name   new-metadata -    New item metadata   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_item_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Current item name (required)
        :param str token: Access token (required)
        :param str new_name: New item name
        :param str new_metadata: New item metadata
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token', 'new_name', 'new_metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `update_item`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `update_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'new_name' in params:
            query_params.append(('new-name', params['new_name']))  # noqa: E501
        if 'new_metadata' in params:
            query_params.append(('new-metadata', params['new_metadata']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/update-item', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_role(self, name, token, **kwargs):  # noqa: E501
        """Update role details  # noqa: E501

        Update role details Options:   name -    Role name   new-name -    New Role name   new-comment -    New comment about the role   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_role(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Role name (required)
        :param str token: Access token (required)
        :param str new_name: New Role name
        :param str new_comment: New comment about the role
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_role_with_http_info(name, token, **kwargs)  # noqa: E501
        else:
            (data) = self.update_role_with_http_info(name, token, **kwargs)  # noqa: E501
            return data

    def update_role_with_http_info(self, name, token, **kwargs):  # noqa: E501
        """Update role details  # noqa: E501

        Update role details Options:   name -    Role name   new-name -    New Role name   new-comment -    New comment about the role   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_role_with_http_info(name, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Role name (required)
        :param str token: Access token (required)
        :param str new_name: New Role name
        :param str new_comment: New comment about the role
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'token', 'new_name', 'new_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `update_role`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `update_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'new_name' in params:
            query_params.append(('new-name', params['new_name']))  # noqa: E501
        if 'new_comment' in params:
            query_params.append(('new-comment', params['new_comment']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/update-role', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_secret_val(self, name, value, token, **kwargs):  # noqa: E501
        """Update static secret value  # noqa: E501

        Update static secret value Options:   name -    Secret name   value -    The new secret value   key -    The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)   multiline -    The provided value is a multiline value (separated by '\\n')   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_secret_val(name, value, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Secret name (required)
        :param str value: The new secret value (required)
        :param str token: Access token (required)
        :param str key: The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)
        :param bool multiline: The provided value is a multiline value (separated by '\\n')
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_secret_val_with_http_info(name, value, token, **kwargs)  # noqa: E501
        else:
            (data) = self.update_secret_val_with_http_info(name, value, token, **kwargs)  # noqa: E501
            return data

    def update_secret_val_with_http_info(self, name, value, token, **kwargs):  # noqa: E501
        """Update static secret value  # noqa: E501

        Update static secret value Options:   name -    Secret name   value -    The new secret value   key -    The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)   multiline -    The provided value is a multiline value (separated by '\\n')   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_secret_val_with_http_info(name, value, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Secret name (required)
        :param str value: The new secret value (required)
        :param str token: Access token (required)
        :param str key: The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)
        :param bool multiline: The provided value is a multiline value (separated by '\\n')
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'value', 'token', 'key', 'multiline']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_secret_val" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `update_secret_val`")  # noqa: E501
        # verify the required parameter 'value' is set
        if ('value' not in params or
                params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `update_secret_val`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `update_secret_val`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'value' in params:
            query_params.append(('value', params['value']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'multiline' in params:
            query_params.append(('multiline', params['multiline']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/update-secret-val', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_pkcs12(self, name, _in, passphrase, token, **kwargs):  # noqa: E501
        """Upload a PKCS#12 key and certificates  # noqa: E501

        Upload a PKCS#12 key and certificates Options:   name -    Name of key to be created   in -    PKCS#12 input file (private key and certificate only)   passphrase -    Passphrase to unlock the pkcs#12 bundle   metadata -    A metadata about the key   split-level -    The number of fragments that the item will be split into   customer-frg-id -    The customer fragment ID that will be used to split the key (if empty, the key will be created independently of a customer fragment)   cert -    Path to a file that contain the certificate in a PEM format. If this parameter is not empty, the certificate will be taken from here and not from the PKCS#12 input file   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_pkcs12(name, _in, passphrase, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name of key to be created (required)
        :param str _in: PKCS#12 input file (private key and certificate only) (required)
        :param str passphrase: Passphrase to unlock the pkcs#12 bundle (required)
        :param str token: Access token (required)
        :param str metadata: A metadata about the key
        :param str split_level: The number of fragments that the item will be split into
        :param str customer_frg_id: The customer fragment ID that will be used to split the key (if empty, the key will be created independently of a customer fragment)
        :param str cert: Path to a file that contain the certificate in a PEM format. If this parameter is not empty, the certificate will be taken from here and not from the PKCS#12 input file
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_pkcs12_with_http_info(name, _in, passphrase, token, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_pkcs12_with_http_info(name, _in, passphrase, token, **kwargs)  # noqa: E501
            return data

    def upload_pkcs12_with_http_info(self, name, _in, passphrase, token, **kwargs):  # noqa: E501
        """Upload a PKCS#12 key and certificates  # noqa: E501

        Upload a PKCS#12 key and certificates Options:   name -    Name of key to be created   in -    PKCS#12 input file (private key and certificate only)   passphrase -    Passphrase to unlock the pkcs#12 bundle   metadata -    A metadata about the key   split-level -    The number of fragments that the item will be split into   customer-frg-id -    The customer fragment ID that will be used to split the key (if empty, the key will be created independently of a customer fragment)   cert -    Path to a file that contain the certificate in a PEM format. If this parameter is not empty, the certificate will be taken from here and not from the PKCS#12 input file   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_pkcs12_with_http_info(name, _in, passphrase, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name of key to be created (required)
        :param str _in: PKCS#12 input file (private key and certificate only) (required)
        :param str passphrase: Passphrase to unlock the pkcs#12 bundle (required)
        :param str token: Access token (required)
        :param str metadata: A metadata about the key
        :param str split_level: The number of fragments that the item will be split into
        :param str customer_frg_id: The customer fragment ID that will be used to split the key (if empty, the key will be created independently of a customer fragment)
        :param str cert: Path to a file that contain the certificate in a PEM format. If this parameter is not empty, the certificate will be taken from here and not from the PKCS#12 input file
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', '_in', 'passphrase', 'token', 'metadata', 'split_level', 'customer_frg_id', 'cert']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_pkcs12" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `upload_pkcs12`")  # noqa: E501
        # verify the required parameter '_in' is set
        if ('_in' not in params or
                params['_in'] is None):
            raise ValueError("Missing the required parameter `_in` when calling `upload_pkcs12`")  # noqa: E501
        # verify the required parameter 'passphrase' is set
        if ('passphrase' not in params or
                params['passphrase'] is None):
            raise ValueError("Missing the required parameter `passphrase` when calling `upload_pkcs12`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `upload_pkcs12`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if '_in' in params:
            query_params.append(('in', params['_in']))  # noqa: E501
        if 'passphrase' in params:
            query_params.append(('passphrase', params['passphrase']))  # noqa: E501
        if 'metadata' in params:
            query_params.append(('metadata', params['metadata']))  # noqa: E501
        if 'split_level' in params:
            query_params.append(('split-level', params['split_level']))  # noqa: E501
        if 'customer_frg_id' in params:
            query_params.append(('customer-frg-id', params['customer_frg_id']))  # noqa: E501
        if 'cert' in params:
            query_params.append(('cert', params['cert']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/upload-pkcs12', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_rsa(self, name, alg, rsa_key_file_path, token, **kwargs):  # noqa: E501
        """Upload RSA key  # noqa: E501

        Upload RSA key Options:   name -    Name of key to be created   alg -    Key type. options- [RSA1024, RSA2048]   rsa-key-file-path -    RSA private key file path   metadata -    A metadata about the key   split-level -    The number of fragments that the item will be split into   customer-frg-id -    The customer fragment ID that will be used to split the key (if empty, the key will be created independently of a customer fragment)   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_rsa(name, alg, rsa_key_file_path, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name of key to be created (required)
        :param str alg: Key type. options- [RSA1024, RSA2048] (required)
        :param str rsa_key_file_path: RSA private key file path (required)
        :param str token: Access token (required)
        :param str metadata: A metadata about the key
        :param str split_level: The number of fragments that the item will be split into
        :param str customer_frg_id: The customer fragment ID that will be used to split the key (if empty, the key will be created independently of a customer fragment)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_rsa_with_http_info(name, alg, rsa_key_file_path, token, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_rsa_with_http_info(name, alg, rsa_key_file_path, token, **kwargs)  # noqa: E501
            return data

    def upload_rsa_with_http_info(self, name, alg, rsa_key_file_path, token, **kwargs):  # noqa: E501
        """Upload RSA key  # noqa: E501

        Upload RSA key Options:   name -    Name of key to be created   alg -    Key type. options- [RSA1024, RSA2048]   rsa-key-file-path -    RSA private key file path   metadata -    A metadata about the key   split-level -    The number of fragments that the item will be split into   customer-frg-id -    The customer fragment ID that will be used to split the key (if empty, the key will be created independently of a customer fragment)   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_rsa_with_http_info(name, alg, rsa_key_file_path, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name of key to be created (required)
        :param str alg: Key type. options- [RSA1024, RSA2048] (required)
        :param str rsa_key_file_path: RSA private key file path (required)
        :param str token: Access token (required)
        :param str metadata: A metadata about the key
        :param str split_level: The number of fragments that the item will be split into
        :param str customer_frg_id: The customer fragment ID that will be used to split the key (if empty, the key will be created independently of a customer fragment)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'alg', 'rsa_key_file_path', 'token', 'metadata', 'split_level', 'customer_frg_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_rsa" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `upload_rsa`")  # noqa: E501
        # verify the required parameter 'alg' is set
        if ('alg' not in params or
                params['alg'] is None):
            raise ValueError("Missing the required parameter `alg` when calling `upload_rsa`")  # noqa: E501
        # verify the required parameter 'rsa_key_file_path' is set
        if ('rsa_key_file_path' not in params or
                params['rsa_key_file_path'] is None):
            raise ValueError("Missing the required parameter `rsa_key_file_path` when calling `upload_rsa`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `upload_rsa`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'alg' in params:
            query_params.append(('alg', params['alg']))  # noqa: E501
        if 'rsa_key_file_path' in params:
            query_params.append(('rsa-key-file-path', params['rsa_key_file_path']))  # noqa: E501
        if 'metadata' in params:
            query_params.append(('metadata', params['metadata']))  # noqa: E501
        if 'split_level' in params:
            query_params.append(('split-level', params['split_level']))  # noqa: E501
        if 'customer_frg_id' in params:
            query_params.append(('customer-frg-id', params['customer_frg_id']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/upload-rsa', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def verify_pkcs1(self, key_name, message, signature, token, **kwargs):  # noqa: E501
        """Verifies an RSA PKCS#1 v1.5 signature  # noqa: E501

        Verifies an RSA PKCS#1 v1.5 signature Options:   key-name -    The name of the RSA key to use in the verification process   message -    The message to be verified   signature -    The message's signature   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_pkcs1(key_name, message, signature, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the RSA key to use in the verification process (required)
        :param str message: The message to be verified (required)
        :param str signature: The message's signature (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.verify_pkcs1_with_http_info(key_name, message, signature, token, **kwargs)  # noqa: E501
        else:
            (data) = self.verify_pkcs1_with_http_info(key_name, message, signature, token, **kwargs)  # noqa: E501
            return data

    def verify_pkcs1_with_http_info(self, key_name, message, signature, token, **kwargs):  # noqa: E501
        """Verifies an RSA PKCS#1 v1.5 signature  # noqa: E501

        Verifies an RSA PKCS#1 v1.5 signature Options:   key-name -    The name of the RSA key to use in the verification process   message -    The message to be verified   signature -    The message's signature   token -    Access token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_pkcs1_with_http_info(key_name, message, signature, token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: The name of the RSA key to use in the verification process (required)
        :param str message: The message to be verified (required)
        :param str signature: The message's signature (required)
        :param str token: Access token (required)
        :return: ReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_name', 'message', 'signature', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_pkcs1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_name' is set
        if ('key_name' not in params or
                params['key_name'] is None):
            raise ValueError("Missing the required parameter `key_name` when calling `verify_pkcs1`")  # noqa: E501
        # verify the required parameter 'message' is set
        if ('message' not in params or
                params['message'] is None):
            raise ValueError("Missing the required parameter `message` when calling `verify_pkcs1`")  # noqa: E501
        # verify the required parameter 'signature' is set
        if ('signature' not in params or
                params['signature'] is None):
            raise ValueError("Missing the required parameter `signature` when calling `verify_pkcs1`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `verify_pkcs1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key_name' in params:
            query_params.append(('key-name', params['key_name']))  # noqa: E501
        if 'message' in params:
            query_params.append(('message', params['message']))  # noqa: E501
        if 'signature' in params:
            query_params.append(('signature', params['signature']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/verify-pkcs1', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
