# Generated by Django 2.2.8 on 2019-12-13 16:29

import django.db.models.deletion
import jsonfield.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("services_listing", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="EmbeddedInfo",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("path", models.CharField(max_length=500)),
                ("query_key", models.CharField(max_length=50)),
                ("index", models.IntegerField(null=True)),
                ("title", models.CharField(max_length=300, null=True)),
                ("cover", models.URLField(max_length=1000, null=True)),
                ("year", models.IntegerField(null=True)),
                ("plot", models.TextField(null=True)),
                ("duration", models.IntegerField(null=True)),
                (
                    "rating",
                    models.DecimalField(decimal_places=2, max_digits=3, null=True),
                ),
                ("genres", jsonfield.fields.JSONField(default=[])),
                ("primary_language", models.CharField(max_length=50, null=True)),
                ("file_source", models.CharField(max_length=100, null=True)),
                ("mediainfo_resolution", models.CharField(max_length=100, null=True)),
                ("mediainfo_codec", models.CharField(max_length=100, null=True)),
                ("mediainfo_container", models.CharField(max_length=100, null=True)),
                ("mediainfo_source", models.CharField(max_length=100, null=True)),
                ("mediainfo_scene", models.BooleanField(default=False)),
                ("mediainfo_best", models.BooleanField(default=False)),
                ("bittorrent_seeders", models.IntegerField(null=True)),
                ("bittorrent_leechers", models.IntegerField(null=True)),
                ("bittorrent_snatched", models.IntegerField(null=True)),
                (
                    "episodeinfo_episode_type",
                    models.CharField(blank=True, max_length=200, null=True),
                ),
                ("episodeinfo_season", models.IntegerField(blank=True, null=True)),
                ("episodeinfo_episode", models.IntegerField(blank=True, null=True)),
                ("episodeinfo_year", models.IntegerField(blank=True, null=True)),
                ("episodeinfo_month", models.IntegerField(blank=True, null=True)),
                ("episodeinfo_day", models.IntegerField(blank=True, null=True)),
                (
                    "episodeinfo_sub_title",
                    models.CharField(blank=True, max_length=150, null=True),
                ),
                ("datetime", models.DateTimeField(auto_now=True)),
            ],
            options={"unique_together": {("query_key", "path")},},
        ),
        migrations.CreateModel(
            name="ListingItemRelation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "listingitem",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_embedded",
                        to="services_listing.ListingItem",
                    ),
                ),
                (
                    "metadata",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_embedded.EmbeddedInfo",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_embedded",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("listingitem", "metadata", "user")},
            },
        ),
    ]
