[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)
[![codecov](https://codecov.io/gh/mashi/codecov-validator/branch/main/graph/badge.svg?token=WBOQOGFC51)](https://codecov.io/gh/mashi/codecov-validator)
[![CircleCI](https://circleci.com/gh/circleci/circleci-docs.svg?style=shield)](https://app.circleci.com/pipelines/github/mashi/codecov-validator?branch=main)


# Description
Validates the `codecov.yml` configuration file.

This code is simply the `curl` command described in the [codecov documentation](https://docs.codecov.io/docs/codecov-yaml)
converted to python.


## Usage
The recommended use is to add in the `.pre-commit-config.yaml` file
```
- repo: https://github.com/mashi/codecov-validator
  rev: v1.0.0  # replace by any tag version >= 1.0.0 available
  hooks:
    - id: ccv
      # args: [--filename, .codecov.yml]  # example with arguments
```

In this way, the `codecov.yml` file is checked before `commit` and prevents the user
from including invalid files in the version control.


## Instructions (Development)
Create a virtual environment and install the required packages with
```
python3 -m venv .venv
source .venv/bin/activate
pip install wheel
pip install -r requirements.txt
pre-commit install
```
