# generated by datamodel-codegen:
#   filename:  quartr-openapi.json
#   timestamp: 2025-03-18T09:47:22+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum

from pydantic import BaseModel, ConfigDict, Field
from pydantic.alias_generators import to_camel


class CamelizedModel(BaseModel):
    model_config = ConfigDict(
        alias_generator=to_camel,
        populate_by_name=True,
        json_encoders={datetime: lambda v: v.isoformat()},
    )


class TickerDto(CamelizedModel):
    ticker: str
    exchange: str


class CompanyDto(CamelizedModel):
    country: str = Field(..., examples=["US"])
    display_name: str | None = Field(default=None, examples=["Apple"])
    id: float = Field(..., examples=[4742])
    name: str = Field(..., examples=["Apple Inc."])
    tickers: list[TickerDto] | None = Field(
        default=None,
        examples=[
            {"ticker": "AAPL", "exchange": "BASE"},
            {"ticker": "AAPL", "exchange": "NasdaqGS"},
        ],
    )
    isins: list[str] | None = Field(default=None, examples=["US0378331005"])
    updated_at: datetime = Field(..., examples=["2021-09-15T15:00:00.000Z"])
    created_at: datetime = Field(..., examples=["2021-09-01T12:00:00.000Z"])
    backlink_url: str = Field(..., examples=["https://example.com"])


class CursorPagination(CamelizedModel):
    next_cursor: float | None = Field(
        ...,
        description="A unique identifier indicating the position to continue fetching the next set of results in subsequent requests.",
        examples=[10],
    )


class PaginatedCompaniesResponseDto(CamelizedModel):
    data: list[CompanyDto]
    pagination: CursorPagination


class CompanyResponseDto(CamelizedModel):
    data: CompanyDto


class EventDto(CamelizedModel):
    company_id: float = Field(..., examples=[4742])
    date: datetime = Field(..., examples=["2021-09-15T15:00:00.000Z"])
    id: float = Field(..., examples=[128301])
    title: str = Field(..., examples=["Q1 2024"])
    type_id: float = Field(..., examples=[26])
    fiscal_year: float | None = Field(default=None, examples=[2024])
    fiscal_period: str | None = Field(default=None, examples=["Q1"])
    backlink_url: str = Field(..., examples=["quartr.com/companies/apple"])
    updated_at: datetime = Field(..., examples=["2021-09-19T15:00:00.000Z"])
    created_at: datetime = Field(..., examples=["2021-09-15T15:00:00.000Z"])


class PaginatedEventResponseDto(CamelizedModel):
    data: list[EventDto]
    pagination: CursorPagination


class EventResponseDto(CamelizedModel):
    data: EventDto


class EventTypeDto(CamelizedModel):
    id: float = Field(..., examples=[26])
    name: str | None = Field(default=None, examples=["Q1"])
    parent: str | None = Field(default=None, examples=["Earnings Call"])
    updated_at: datetime = Field(..., examples=["2021-09-19T15:00:00.000Z"])
    created_at: datetime = Field(..., examples=["2021-09-15T15:00:00.000Z"])


class PaginatedEventTypeResponseDto(CamelizedModel):
    data: list[EventTypeDto]
    pagination: CursorPagination


class EventTypeResponseDto(CamelizedModel):
    data: EventTypeDto


class DocumentDto(CamelizedModel):
    company_id: float | None = Field(default=None, examples=[4742])
    event_id: float | None = Field(default=None, examples=[128301])
    file_url: str = Field(..., examples=["https://quartr.com/file.pdf"])
    id: float = Field(..., examples=[432907])
    type_id: float = Field(..., examples=[7])
    updated_at: datetime = Field(..., examples=["2021-09-19T15:00:00.000Z"])
    created_at: datetime = Field(..., examples=["2021-09-15T15:00:00.000Z"])


class PaginatedDocumentResponseDto(CamelizedModel):
    data: list[DocumentDto]
    pagination: CursorPagination


class DocumentResponseDto(CamelizedModel):
    data: DocumentDto


class DocumentDataDto(CamelizedModel):
    id: float = Field(..., examples=[55])
    page: float = Field(..., examples=[1])
    pdf_url: str = Field(..., examples=["https://quartr.com/file.pdf"])
    image_url: str = Field(..., examples=["https://quartr.com/image.png"])
    updated_at: datetime = Field(..., examples=["2021-09-19T15:00:00.000Z"])
    created_at: datetime = Field(..., examples=["2021-09-15T15:00:00.000Z"])


class PaginatedDocumentDataResponseDto(CamelizedModel):
    data: list[DocumentDataDto]
    pagination: CursorPagination


class DocumentTypeDto(CamelizedModel):
    id: float = Field(..., examples=[7])
    name: str = Field(..., examples=["Quarterly Report"])
    description: str | None = Field(
        default=None,
        examples=["General form for quarterly reports under Section 13 or 15(d)"],
    )
    form: str | None = Field(default=None, examples=["10-Q"])
    updated_at: datetime = Field(..., examples=["2024-04-09T14:19:21.000Z"])
    created_at: datetime = Field(..., examples=["2024-04-05T14:19:21.000Z"])
    category: str = Field(..., examples=["Report"])
    document_group_id: float | None = Field(default=None, examples=[1])


class PaginatedDocumentTypeResponseDto(CamelizedModel):
    data: list[DocumentTypeDto]
    pagination: CursorPagination


class DocumentTypeResponseDto(CamelizedModel):
    data: DocumentTypeDto


class AudioMetadataDto(CamelizedModel):
    size: str | None = Field(default=None, examples=["200.00 MB"])
    duration: float | None = Field(default=None, examples=[19000.1])
    encoding: str | None = Field(default=None, examples=["7bit"])
    mimetype: str | None = Field(default=None, examples=["audio/mpeg"])


class AudioDto(CamelizedModel):
    company_id: float = Field(..., examples=[4742])
    event_id: float = Field(..., examples=[128301])
    file_url: str | None = Field(default=None, examples=["https://quartr.com/file.mp3"])
    id: float = Field(..., examples=[123964])
    qna: float | None = Field(default=None, examples=[1510])
    stream_url: str | None = Field(
        default=None, examples=["https://quartr.com/file.m3u8"]
    )
    audio_metadata: AudioMetadataDto | None = None
    updated_at: datetime = Field(..., examples=["2024-10-08T09:00:00.000Z"])
    created_at: datetime = Field(..., examples=["2024-10-03T09:00:00.000Z"])


class PaginatedAudioResponseDto(CamelizedModel):
    data: list[AudioDto]
    pagination: CursorPagination


class AudioResponseDto(CamelizedModel):
    data: AudioDto


class LiveDto(CamelizedModel):
    id: float = Field(..., examples=[127537])
    event_id: float = Field(..., examples=[128301])
    company_id: float = Field(..., examples=[4742])
    date: datetime = Field(..., examples=["2021-09-15T15:00:00.000Z"])
    updated_at: datetime = Field(..., examples=["2021-09-15T15:02:00.000Z"])
    created_at: datetime = Field(..., examples=["2021-05-15T15:00:00.000Z"])
    went_live_at: datetime | None = Field(
        default=None, examples=["2021-09-15T15:02:00.000Z"]
    )
    state: str | None = Field(default=None, examples=["recordingAvailable"])
    audio: str | None = Field(default=None, examples=["https://quartr.com/file.mp3"])
    transcript: str | None = Field(
        default=None, examples=["https://quartr.com/file.json"]
    )


class PaginatedLiveResponseDto(CamelizedModel):
    data: list[LiveDto]
    pagination: CursorPagination


class LiveResponseDto(CamelizedModel):
    data: LiveDto


class LiveAudioDto(CamelizedModel):
    id: float = Field(..., examples=[127537])
    event_id: float = Field(..., examples=[128301])
    company_id: float = Field(..., examples=[4742])
    date: datetime = Field(..., examples=["2021-09-15T15:00:00.000Z"])
    updated_at: datetime = Field(..., examples=["2021-09-15T15:02:00.000Z"])
    created_at: datetime = Field(..., examples=["2021-05-15T15:00:00.000Z"])
    went_live_at: datetime | None = Field(
        default=None, examples=["2021-09-15T15:02:00.000Z"]
    )
    state: str | None = Field(default=None, examples=["recordingAvailable"])
    audio: str | None = Field(default=None, examples=["https://quartr.com/file.mp3"])


class PaginatedLiveAudioResponseDto(CamelizedModel):
    data: list[LiveAudioDto]
    pagination: CursorPagination


class LiveAudioResponseDto(CamelizedModel):
    data: LiveAudioDto


class LiveTranscriptDto(CamelizedModel):
    id: float = Field(..., examples=[127537])
    event_id: float = Field(..., examples=[128301])
    company_id: float = Field(..., examples=[4742])
    date: datetime = Field(..., examples=["2021-09-15T15:00:00.000Z"])
    updated_at: datetime = Field(..., examples=["2021-09-15T15:02:00.000Z"])
    created_at: datetime = Field(..., examples=["2021-05-15T15:00:00.000Z"])
    went_live_at: datetime | None = Field(
        default=None, examples=["2021-09-15T15:02:00.000Z"]
    )
    state: str | None = Field(default=None, examples=["recordingAvailable"])
    transcript: str | None = Field(
        default=None, examples=["https://quartr.com/file.json"]
    )


class PaginatedLiveTranscriptResponseDto(CamelizedModel):
    data: list[LiveTranscriptDto]
    pagination: CursorPagination


class LiveTranscriptResponseDto(CamelizedModel):
    data: LiveTranscriptDto


class CookieParametersQuery(CamelizedModel): ...


class CookieResponseDto(CamelizedModel):
    cloud_front_key_pair_id: str = Field(alias="CloudFront-Key-Pair-Id")
    cloud_front_signature: str = Field(alias="CloudFront-Signature")
    cloud_front_policy: str = Field(alias="CloudFront-Policy")


class Direction(str, Enum):
    ASC = "asc"
    DESC = "desc"


class PublicV3CompaniesGetParametersQuery(CamelizedModel):
    countries: str | None = Field(default=None, examples=["US,CA"])
    exchanges: str | None = Field(default=None, examples=["NasdaqCM,NasdaqGS,NYSE"])
    tickers: str | None = Field(default=None, examples=["AAPL,AMZN"])
    limit: float | None = Field(default=10, examples=[500], le=500.0)
    cursor: float | None = Field(default=0, examples=[2432], ge=0.0)
    direction: Direction | None = Field(default=Direction.ASC, examples=["asc"])
    isins: str | None = Field(default=None, examples=["US0378331005,US0231351067"])
    updated_before: str | None = Field(default=None, examples=["2024-01-24T12:00:00Z"])
    updated_after: str | None = Field(default=None, examples=["2025-01-12T15:00:00Z"])
    ids: str | None = Field(default=None, examples=["4024,5025,6026"])


class MessageItem(CamelizedModel):
    field: str | None = Field(default=None, examples=["country"])
    message: str | None = Field(
        default=None, examples=["country must be a valid ISO31661 Alpha2 code"]
    )


class PublicV3CompaniesGetResponse(CamelizedModel):
    error: str | None = Field(default=None, examples=["Bad Request"])
    message: list[MessageItem] | None = None
    status_code: float | None = Field(default=None, examples=[400])


class PublicV3CompaniesGetResponse1(CamelizedModel):
    message: str | None = Field(default=None, examples=["Unauthorized"])
    status_code: float | None = Field(default=None, examples=[401])


class PublicV3CompaniesGetResponse2(CamelizedModel):
    message: str | None = Field(default=None, examples=["Forbidden"])
    status_code: float | None = Field(default=None, examples=[403])


class PublicV3CompaniesIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3CompaniesIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3CompaniesIdGetResponse2(CamelizedModel):
    message: str | None = Field(default=None, examples=["Not Found"])
    status_code: float | None = Field(default=None, examples=[404])


class PublicV3EventsGetParametersQuery(CamelizedModel):
    countries: str | None = Field(default=None, examples=["US,CA"])
    exchanges: str | None = Field(default=None, examples=["NasdaqCM,NasdaqGS,NYSE"])
    tickers: str | None = Field(default=None, examples=["AAPL,AMZN"])
    limit: float | None = Field(default=10, examples=[500], le=500.0)
    cursor: float | None = Field(default=0, examples=[2432], ge=0.0)
    direction: Direction | None = Field(default=Direction.ASC, examples=["asc"])
    end_date: str | None = Field(default=None, examples=["2025-01-10T13:00:00Z"])
    start_date: str | None = Field(default=None, examples=["2024-12-12T15:00:00Z"])
    isins: str | None = Field(default=None, examples=["US0378331005,US0231351067"])
    type_ids: str | None = Field(default=None, examples=["26,29,35"])
    company_ids: str | None = Field(default=None, examples=["4024,5025,6026"])
    updated_before: str | None = Field(default=None, examples=["2024-01-24T12:00:00Z"])
    updated_after: str | None = Field(default=None, examples=["2025-01-12T15:00:00Z"])


class PublicV3EventsGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3EventsGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3EventsGetResponse2(PublicV3CompaniesGetResponse2):
    pass


class PublicV3EventsIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3EventsIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3EventsIdGetResponse2(PublicV3CompaniesIdGetResponse2):
    pass


class PublicV3EventTypesGetParametersQuery(CamelizedModel):
    limit: float | None = Field(default=10, examples=[500], le=500.0)
    cursor: float | None = Field(default=0, examples=[2432], ge=0.0)
    direction: Direction | None = Field(default=Direction.ASC, examples=["asc"])


class PublicV3EventTypesGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3EventTypesGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3EventTypesGetResponse2(PublicV3CompaniesGetResponse2):
    pass


class PublicV3EventTypesIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3EventTypesIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3EventTypesIdGetResponse2(PublicV3CompaniesIdGetResponse2):
    pass


class PublicV3DocumentsGetParametersQuery(CamelizedModel):
    countries: str | None = Field(default=None, examples=["US,CA"])
    exchanges: str | None = Field(default=None, examples=["NasdaqCM,NasdaqGS,NYSE"])
    tickers: str | None = Field(default=None, examples=["AAPL,AMZN"])
    limit: float | None = Field(default=10, examples=[500], le=500.0)
    cursor: float | None = Field(default=0, examples=[2432], ge=0.0)
    direction: Direction | None = Field(default=Direction.ASC, examples=["asc"])
    end_date: str | None = Field(default=None, examples=["2025-01-10T13:00:00Z"])
    start_date: str | None = Field(default=None, examples=["2024-12-12T15:00:00Z"])
    type_ids: str | None = Field(default=None, examples=["6,13,39"])
    isins: str | None = Field(default=None, examples=["US0378331005,US0231351067"])
    company_ids: str | None = Field(default=None, examples=["4024,5025,6026"])
    event_ids: str | None = Field(default=None, examples=["4042,8934,16342"])
    document_group_ids: str | None = Field(default=None, examples=["3,4"])
    updated_before: str | None = Field(default=None, examples=["2024-01-24T12:00:00Z"])
    updated_after: str | None = Field(default=None, examples=["2025-01-12T15:00:00Z"])


class PublicV3DocumentsGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3DocumentsGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentsGetResponse2(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentsIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentsIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentsIdGetResponse2(PublicV3CompaniesIdGetResponse2):
    pass


class PublicV3DocumentsReportsGetParametersQuery(PublicV3DocumentsGetParametersQuery):
    pass


class PublicV3DocumentsReportsGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3DocumentsReportsGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentsReportsGetResponse2(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentsReportsIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentsReportsIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentsReportsIdGetResponse2(PublicV3CompaniesIdGetResponse2):
    pass


class PublicV3DocumentsReportsIdPagesGetParametersQuery(
    PublicV3EventTypesGetParametersQuery
):
    pass


class PublicV3DocumentsReportsIdPagesGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentsReportsIdPagesGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentsSlidesGetParametersQuery(PublicV3DocumentsGetParametersQuery):
    pass


class PublicV3DocumentsSlidesGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3DocumentsSlidesGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentsSlidesGetResponse2(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentsSlidesIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentsSlidesIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentsSlidesIdGetResponse2(PublicV3CompaniesIdGetResponse2):
    pass


class PublicV3DocumentsSlidesIdPagesGetParametersQuery(
    PublicV3EventTypesGetParametersQuery
):
    pass


class PublicV3DocumentsSlidesIdPagesGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentsSlidesIdPagesGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentsTranscriptsGetParametersQuery(
    PublicV3DocumentsGetParametersQuery
):
    pass


class PublicV3DocumentsTranscriptsGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3DocumentsTranscriptsGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentsTranscriptsGetResponse2(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentsTranscriptsIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentsTranscriptsIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentsTranscriptsIdGetResponse2(PublicV3CompaniesIdGetResponse2):
    pass


class PublicV3DocumentTypesGetParametersQuery(PublicV3EventTypesGetParametersQuery):
    pass


class PublicV3DocumentTypesGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3DocumentTypesGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentTypesGetResponse2(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentTypesIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3DocumentTypesIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3DocumentTypesIdGetResponse2(PublicV3CompaniesIdGetResponse2):
    pass


class PublicV3AudioGetParametersQuery(CamelizedModel):
    countries: str | None = Field(default=None, examples=["US,CA"])
    exchanges: str | None = Field(default=None, examples=["NasdaqCM,NasdaqGS,NYSE"])
    tickers: str | None = Field(default=None, examples=["AAPL,AMZN"])
    limit: float | None = Field(default=10, examples=[500], le=500.0)
    cursor: float | None = Field(default=0, examples=[2432], ge=0.0)
    direction: Direction | None = Field(default=Direction.ASC, examples=["asc"])
    end_date: str | None = Field(default=None, examples=["2025-01-10T13:00:00Z"])
    start_date: str | None = Field(default=None, examples=["2024-12-12T15:00:00Z"])
    isins: str | None = Field(default=None, examples=["US0378331005,US0231351067"])
    company_ids: str | None = Field(default=None, examples=["4024,5025,6026"])
    event_ids: str | None = Field(default=None, examples=["4042,8934,16342"])
    updated_before: str | None = Field(default=None, examples=["2024-01-24T12:00:00Z"])
    updated_after: str | None = Field(default=None, examples=["2025-01-12T15:00:00Z"])


class PublicV3AudioGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3AudioGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3AudioGetResponse2(PublicV3CompaniesGetResponse2):
    pass


class PublicV3AudioIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3AudioIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3AudioIdGetResponse2(PublicV3CompaniesIdGetResponse2):
    pass


class PublicV3LiveGetParametersQuery(CamelizedModel):
    countries: str | None = Field(default=None, examples=["US,CA"])
    exchanges: str | None = Field(default=None, examples=["NasdaqCM,NasdaqGS,NYSE"])
    tickers: str | None = Field(default=None, examples=["AAPL,AMZN"])
    limit: float | None = Field(default=10, examples=[500], le=500.0)
    cursor: float | None = Field(default=0, examples=[2432], ge=0.0)
    direction: Direction | None = Field(default=Direction.ASC, examples=["asc"])
    isins: str | None = Field(default=None, examples=["US0378331005,US0231351067"])
    company_ids: str | None = Field(default=None, examples=["4024,5025,6026"])
    event_ids: str | None = Field(default=None, examples=["4042,8934,16342"])
    states: str | None = Field(default=None, examples=["willBeLive,live"])
    end_date: str | None = Field(default=None, examples=["2025-01-10T13:00:00Z"])
    start_date: str | None = Field(default=None, examples=["2024-12-12T15:00:00Z"])
    updated_before: str | None = Field(default=None, examples=["2024-01-24T12:00:00Z"])
    updated_after: str | None = Field(default=None, examples=["2025-01-12T15:00:00Z"])


class PublicV3LiveGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3LiveGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3LiveGetResponse2(PublicV3CompaniesGetResponse2):
    pass


class PublicV3LiveIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3LiveIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3LiveIdGetResponse2(PublicV3CompaniesIdGetResponse2):
    pass


class PublicV3LiveAudioGetParametersQuery(PublicV3LiveGetParametersQuery):
    pass


class PublicV3LiveAudioGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3LiveAudioGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3LiveAudioGetResponse2(PublicV3CompaniesGetResponse2):
    pass


class PublicV3LiveAudioIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3LiveAudioIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3LiveAudioIdGetResponse2(PublicV3CompaniesIdGetResponse2):
    pass


class PublicV3LiveTranscriptsGetParametersQuery(PublicV3LiveGetParametersQuery):
    pass


class PublicV3LiveTranscriptsGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3LiveTranscriptsGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3LiveTranscriptsGetResponse2(PublicV3CompaniesGetResponse2):
    pass


class PublicV3LiveTranscriptsIdGetResponse(PublicV3CompaniesGetResponse1):
    pass


class PublicV3LiveTranscriptsIdGetResponse1(PublicV3CompaniesGetResponse2):
    pass


class PublicV3LiveTranscriptsIdGetResponse2(PublicV3CompaniesIdGetResponse2):
    pass


class PublicV3CookiesGetResponse(PublicV3CompaniesGetResponse):
    pass


class PublicV3CookiesGetResponse1(PublicV3CompaniesGetResponse1):
    pass


class PublicV3CookiesGetResponse2(PublicV3CompaniesGetResponse2):
    pass
