/*
 * This file is part of Xpra.
 * Copyright (C) 2010-2017 Antoine Martin <antoine@xpra.org>
 * Licensed under MPL 2.0, see:
 * http://www.mozilla.org/MPL/2.0/
 *
 */


/**
 * Map javascript key names to the X11 naming convention the server expects:
 */
KEY_TO_NAME = {
		"Escape"			: "Escape",
		"Tab"				: "Tab",
		"CapsLock"			: "Caps_Lock",
		"ShiftLeft"			: "Shift_L",
		"ControlLeft"		: "Control_L",
		"MetaLeft"			: "Meta_L",
		"AltLeft"			: "Alt_L",
		"Space"				: "space",
		"AltRight"			: "Alt_R",
		"MetaRight"			: "Meta_R",
		"ContextMenu"		: "Menu_R",
		"ControlRight"		: "Control_L",
		"ShiftRight"		: "Shift_R",
		"Enter"				: "Return",
		"Backspace"			: "BackSpace",
		//special keys:
		"ScrollLock"		: "Scroll_Lock",
		"Pause"				: "Pause",
		"NumLock"			: "Num_Lock",
		//Arrow pad:
		"Insert"			: "Insert",
		"Home"				: "Home",
		"PageUp"			: "Prior",
		"Delete"			: "Delete",
		"End"				: "End",
		"PageDown"			: "Next",
};
NUMPAD_TO_NAME = {
		//Num pad:
		"NumpadDivide"		: "KP_Divide",
		"NumpadMultiply"	: "KP_Multiply",
		"NumpadSubstract"	: "KP_Substract",
		"NumpadAdd"			: "KP_Add",
		"NumpadEnter"		: "KP_Enter",
		"NumpadDecimal"		: "KP_Decimal",		//TODO: send KP_Delete when Num_Lock is off
		//Num_Lock off:
		"Insert"			: "KP_Insert",
		"End"				: "KP_End",
		"ArrowDown"			: "KP_Down",
		"PageDown"			: "KP_Next",
		"ArrowLeft"			: "KP_Left",
		"Clear"				: "KP_Begin",
		"ArrowRight"		: "KP_Right",
		"Home"				: "KP_Home",
		"ArrowUp"			: "KP_Up",
		"PageUp"			: "KP_Prior",
};
for (let i=0; i<=9; i++) {
	KEY_TO_NAME["Numpad"+i]	= ""+i;
	KEY_TO_NAME["KP"+i]	= "KP"+i;
}
for (let i=1; i<=20; i++) {
	KEY_TO_NAME["F"+i]	= "F"+i;
}


/**
 * This table was generated using:
 * grep "#define XKB_KEY_" /usr/include/xkbcommon/xkbcommon-keysyms.h | \
 * 		grep "/* U+" | grep -v "A-Z" | \
 * 		sed 's/#define XKB_KEY_//g; s/ *0x.*U+/ 0x/g' | \
 * 		awk '{print "\""$1"\" : "$2","}'
 */
KEYSYM_TO_UNICODE = {
	"space" : 0x0020,
	"exclam" : 0x0021,
	"quotedbl" : 0x0022,
	"numbersign" : 0x0023,
	"dollar" : 0x0024,
	"percent" : 0x0025,
	"ampersand" : 0x0026,
	"apostrophe" : 0x0027,
	"parenleft" : 0x0028,
	"parenright" : 0x0029,
	"asterisk" : 0x002A,
	"plus" : 0x002B,
	"comma" : 0x002C,
	"minus" : 0x002D,
	"period" : 0x002E,
	"slash" : 0x002F,
	"0" : 0x0030,
	"1" : 0x0031,
	"2" : 0x0032,
	"3" : 0x0033,
	"4" : 0x0034,
	"5" : 0x0035,
	"6" : 0x0036,
	"7" : 0x0037,
	"8" : 0x0038,
	"9" : 0x0039,
	"colon" : 0x003A,
	"semicolon" : 0x003B,
	"less" : 0x003C,
	"equal" : 0x003D,
	"greater" : 0x003E,
	"question" : 0x003F,
	"at" : 0x0040,
	"A" : 0x0041,
	"B" : 0x0042,
	"C" : 0x0043,
	"D" : 0x0044,
	"E" : 0x0045,
	"F" : 0x0046,
	"G" : 0x0047,
	"H" : 0x0048,
	"I" : 0x0049,
	"J" : 0x004A,
	"K" : 0x004B,
	"L" : 0x004C,
	"M" : 0x004D,
	"N" : 0x004E,
	"O" : 0x004F,
	"P" : 0x0050,
	"Q" : 0x0051,
	"R" : 0x0052,
	"S" : 0x0053,
	"T" : 0x0054,
	"U" : 0x0055,
	"V" : 0x0056,
	"W" : 0x0057,
	"X" : 0x0058,
	"Y" : 0x0059,
	"Z" : 0x005A,
	"bracketleft" : 0x005B,
	"backslash" : 0x005C,
	"bracketright" : 0x005D,
	"asciicircum" : 0x005E,
	"underscore" : 0x005F,
	"grave" : 0x0060,
	"a" : 0x0061,
	"b" : 0x0062,
	"c" : 0x0063,
	"d" : 0x0064,
	"e" : 0x0065,
	"f" : 0x0066,
	"g" : 0x0067,
	"h" : 0x0068,
	"i" : 0x0069,
	"j" : 0x006A,
	"k" : 0x006B,
	"l" : 0x006C,
	"m" : 0x006D,
	"n" : 0x006E,
	"o" : 0x006F,
	"p" : 0x0070,
	"q" : 0x0071,
	"r" : 0x0072,
	"s" : 0x0073,
	"t" : 0x0074,
	"u" : 0x0075,
	"v" : 0x0076,
	"w" : 0x0077,
	"x" : 0x0078,
	"y" : 0x0079,
	"z" : 0x007A,
	"braceleft" : 0x007B,
	"bar" : 0x007C,
	"braceright" : 0x007D,
	"asciitilde" : 0x007E,
	"nobreakspace" : 0x00A0,
	"exclamdown" : 0x00A1,
	"cent" : 0x00A2,
	"sterling" : 0x00A3,
	"currency" : 0x00A4,
	"yen" : 0x00A5,
	"brokenbar" : 0x00A6,
	"section" : 0x00A7,
	"diaeresis" : 0x00A8,
	"copyright" : 0x00A9,
	"ordfeminine" : 0x00AA,
	"guillemotleft" : 0x00AB,
	"notsign" : 0x00AC,
	"hyphen" : 0x00AD,
	"registered" : 0x00AE,
	"macron" : 0x00AF,
	"degree" : 0x00B0,
	"plusminus" : 0x00B1,
	"twosuperior" : 0x00B2,
	"threesuperior" : 0x00B3,
	"acute" : 0x00B4,
	"mu" : 0x00B5,
	"paragraph" : 0x00B6,
	"periodcentered" : 0x00B7,
	"cedilla" : 0x00B8,
	"onesuperior" : 0x00B9,
	"masculine" : 0x00BA,
	"guillemotright" : 0x00BB,
	"onequarter" : 0x00BC,
	"onehalf" : 0x00BD,
	"threequarters" : 0x00BE,
	"questiondown" : 0x00BF,
	"Agrave" : 0x00C0,
	"Aacute" : 0x00C1,
	"Acircumflex" : 0x00C2,
	"Atilde" : 0x00C3,
	"Adiaeresis" : 0x00C4,
	"Aring" : 0x00C5,
	"AE" : 0x00C6,
	"Ccedilla" : 0x00C7,
	"Egrave" : 0x00C8,
	"Eacute" : 0x00C9,
	"Ecircumflex" : 0x00CA,
	"Ediaeresis" : 0x00CB,
	"Igrave" : 0x00CC,
	"Iacute" : 0x00CD,
	"Icircumflex" : 0x00CE,
	"Idiaeresis" : 0x00CF,
	"ETH" : 0x00D0,
	"Ntilde" : 0x00D1,
	"Ograve" : 0x00D2,
	"Oacute" : 0x00D3,
	"Ocircumflex" : 0x00D4,
	"Otilde" : 0x00D5,
	"Odiaeresis" : 0x00D6,
	"multiply" : 0x00D7,
	"Ooblique" : 0x00D8,
	"Oslash" : 0x00D8,
	"Ugrave" : 0x00D9,
	"Uacute" : 0x00DA,
	"Ucircumflex" : 0x00DB,
	"Udiaeresis" : 0x00DC,
	"Yacute" : 0x00DD,
	"THORN" : 0x00DE,
	"ssharp" : 0x00DF,
	"agrave" : 0x00E0,
	"aacute" : 0x00E1,
	"acircumflex" : 0x00E2,
	"atilde" : 0x00E3,
	"adiaeresis" : 0x00E4,
	"aring" : 0x00E5,
	"ae" : 0x00E6,
	"ccedilla" : 0x00E7,
	"egrave" : 0x00E8,
	"eacute" : 0x00E9,
	"ecircumflex" : 0x00EA,
	"ediaeresis" : 0x00EB,
	"igrave" : 0x00EC,
	"iacute" : 0x00ED,
	"icircumflex" : 0x00EE,
	"idiaeresis" : 0x00EF,
	"eth" : 0x00F0,
	"ntilde" : 0x00F1,
	"ograve" : 0x00F2,
	"oacute" : 0x00F3,
	"ocircumflex" : 0x00F4,
	"otilde" : 0x00F5,
	"odiaeresis" : 0x00F6,
	"division" : 0x00F7,
	"oslash" : 0x00F8,
	"ooblique" : 0x00F8,
	"ugrave" : 0x00F9,
	"uacute" : 0x00FA,
	"ucircumflex" : 0x00FB,
	"udiaeresis" : 0x00FC,
	"yacute" : 0x00FD,
	"thorn" : 0x00FE,
	"ydiaeresis" : 0x00FF,
	"Aogonek" : 0x0104,
	"breve" : 0x02D8,
	"Lstroke" : 0x0141,
	"Lcaron" : 0x013D,
	"Sacute" : 0x015A,
	"Scaron" : 0x0160,
	"Scedilla" : 0x015E,
	"Tcaron" : 0x0164,
	"Zacute" : 0x0179,
	"Zcaron" : 0x017D,
	"Zabovedot" : 0x017B,
	"aogonek" : 0x0105,
	"ogonek" : 0x02DB,
	"lstroke" : 0x0142,
	"lcaron" : 0x013E,
	"sacute" : 0x015B,
	"caron" : 0x02C7,
	"scaron" : 0x0161,
	"scedilla" : 0x015F,
	"tcaron" : 0x0165,
	"zacute" : 0x017A,
	"doubleacute" : 0x02DD,
	"zcaron" : 0x017E,
	"zabovedot" : 0x017C,
	"Racute" : 0x0154,
	"Abreve" : 0x0102,
	"Lacute" : 0x0139,
	"Cacute" : 0x0106,
	"Ccaron" : 0x010C,
	"Eogonek" : 0x0118,
	"Ecaron" : 0x011A,
	"Dcaron" : 0x010E,
	"Dstroke" : 0x0110,
	"Nacute" : 0x0143,
	"Ncaron" : 0x0147,
	"Odoubleacute" : 0x0150,
	"Rcaron" : 0x0158,
	"Uring" : 0x016E,
	"Udoubleacute" : 0x0170,
	"Tcedilla" : 0x0162,
	"racute" : 0x0155,
	"abreve" : 0x0103,
	"lacute" : 0x013A,
	"cacute" : 0x0107,
	"ccaron" : 0x010D,
	"eogonek" : 0x0119,
	"ecaron" : 0x011B,
	"dcaron" : 0x010F,
	"dstroke" : 0x0111,
	"nacute" : 0x0144,
	"ncaron" : 0x0148,
	"odoubleacute" : 0x0151,
	"rcaron" : 0x0159,
	"uring" : 0x016F,
	"udoubleacute" : 0x0171,
	"tcedilla" : 0x0163,
	"abovedot" : 0x02D9,
	"Hstroke" : 0x0126,
	"Hcircumflex" : 0x0124,
	"Iabovedot" : 0x0130,
	"Gbreve" : 0x011E,
	"Jcircumflex" : 0x0134,
	"hstroke" : 0x0127,
	"hcircumflex" : 0x0125,
	"idotless" : 0x0131,
	"gbreve" : 0x011F,
	"jcircumflex" : 0x0135,
	"Cabovedot" : 0x010A,
	"Ccircumflex" : 0x0108,
	"Gabovedot" : 0x0120,
	"Gcircumflex" : 0x011C,
	"Ubreve" : 0x016C,
	"Scircumflex" : 0x015C,
	"cabovedot" : 0x010B,
	"ccircumflex" : 0x0109,
	"gabovedot" : 0x0121,
	"gcircumflex" : 0x011D,
	"ubreve" : 0x016D,
	"scircumflex" : 0x015D,
	"kra" : 0x0138,
	"Rcedilla" : 0x0156,
	"Itilde" : 0x0128,
	"Lcedilla" : 0x013B,
	"Emacron" : 0x0112,
	"Gcedilla" : 0x0122,
	"Tslash" : 0x0166,
	"rcedilla" : 0x0157,
	"itilde" : 0x0129,
	"lcedilla" : 0x013C,
	"emacron" : 0x0113,
	"gcedilla" : 0x0123,
	"tslash" : 0x0167,
	"ENG" : 0x014A,
	"eng" : 0x014B,
	"Amacron" : 0x0100,
	"Iogonek" : 0x012E,
	"Eabovedot" : 0x0116,
	"Imacron" : 0x012A,
	"Ncedilla" : 0x0145,
	"Omacron" : 0x014C,
	"Kcedilla" : 0x0136,
	"Uogonek" : 0x0172,
	"Utilde" : 0x0168,
	"Umacron" : 0x016A,
	"amacron" : 0x0101,
	"iogonek" : 0x012F,
	"eabovedot" : 0x0117,
	"imacron" : 0x012B,
	"ncedilla" : 0x0146,
	"omacron" : 0x014D,
	"kcedilla" : 0x0137,
	"uogonek" : 0x0173,
	"utilde" : 0x0169,
	"umacron" : 0x016B,
	"Wcircumflex" : 0x0174,
	"wcircumflex" : 0x0175,
	"Ycircumflex" : 0x0176,
	"ycircumflex" : 0x0177,
	"Babovedot" : 0x1E02,
	"babovedot" : 0x1E03,
	"Dabovedot" : 0x1E0A,
	"dabovedot" : 0x1E0B,
	"Fabovedot" : 0x1E1E,
	"fabovedot" : 0x1E1F,
	"Mabovedot" : 0x1E40,
	"mabovedot" : 0x1E41,
	"Pabovedot" : 0x1E56,
	"pabovedot" : 0x1E57,
	"Sabovedot" : 0x1E60,
	"sabovedot" : 0x1E61,
	"Tabovedot" : 0x1E6A,
	"tabovedot" : 0x1E6B,
	"Wgrave" : 0x1E80,
	"wgrave" : 0x1E81,
	"Wacute" : 0x1E82,
	"wacute" : 0x1E83,
	"Wdiaeresis" : 0x1E84,
	"wdiaeresis" : 0x1E85,
	"Ygrave" : 0x1EF2,
	"ygrave" : 0x1EF3,
	"OE" : 0x0152,
	"oe" : 0x0153,
	"Ydiaeresis" : 0x0178,
	"overline" : 0x203E,
	"kana_fullstop" : 0x3002,
	"kana_openingbracket" : 0x300C,
	"kana_closingbracket" : 0x300D,
	"kana_comma" : 0x3001,
	"kana_conjunctive" : 0x30FB,
	"kana_WO" : 0x30F2,
	"kana_a" : 0x30A1,
	"kana_i" : 0x30A3,
	"kana_u" : 0x30A5,
	"kana_e" : 0x30A7,
	"kana_o" : 0x30A9,
	"kana_ya" : 0x30E3,
	"kana_yu" : 0x30E5,
	"kana_yo" : 0x30E7,
	"kana_tsu" : 0x30C3,
	"prolongedsound" : 0x30FC,
	"kana_A" : 0x30A2,
	"kana_I" : 0x30A4,
	"kana_U" : 0x30A6,
	"kana_E" : 0x30A8,
	"kana_O" : 0x30AA,
	"kana_KA" : 0x30AB,
	"kana_KI" : 0x30AD,
	"kana_KU" : 0x30AF,
	"kana_KE" : 0x30B1,
	"kana_KO" : 0x30B3,
	"kana_SA" : 0x30B5,
	"kana_SHI" : 0x30B7,
	"kana_SU" : 0x30B9,
	"kana_SE" : 0x30BB,
	"kana_SO" : 0x30BD,
	"kana_TA" : 0x30BF,
	"kana_CHI" : 0x30C1,
	"kana_TSU" : 0x30C4,
	"kana_TE" : 0x30C6,
	"kana_TO" : 0x30C8,
	"kana_NA" : 0x30CA,
	"kana_NI" : 0x30CB,
	"kana_NU" : 0x30CC,
	"kana_NE" : 0x30CD,
	"kana_NO" : 0x30CE,
	"kana_HA" : 0x30CF,
	"kana_HI" : 0x30D2,
	"kana_FU" : 0x30D5,
	"kana_HE" : 0x30D8,
	"kana_HO" : 0x30DB,
	"kana_MA" : 0x30DE,
	"kana_MI" : 0x30DF,
	"kana_MU" : 0x30E0,
	"kana_ME" : 0x30E1,
	"kana_MO" : 0x30E2,
	"kana_YA" : 0x30E4,
	"kana_YU" : 0x30E6,
	"kana_YO" : 0x30E8,
	"kana_RA" : 0x30E9,
	"kana_RI" : 0x30EA,
	"kana_RU" : 0x30EB,
	"kana_RE" : 0x30EC,
	"kana_RO" : 0x30ED,
	"kana_WA" : 0x30EF,
	"kana_N" : 0x30F3,
	"voicedsound" : 0x309B,
	"semivoicedsound" : 0x309C,
	"Farsi_0" : 0x06F0,
	"Farsi_1" : 0x06F1,
	"Farsi_2" : 0x06F2,
	"Farsi_3" : 0x06F3,
	"Farsi_4" : 0x06F4,
	"Farsi_5" : 0x06F5,
	"Farsi_6" : 0x06F6,
	"Farsi_7" : 0x06F7,
	"Farsi_8" : 0x06F8,
	"Farsi_9" : 0x06F9,
	"Arabic_percent" : 0x066A,
	"Arabic_superscript_alef" : 0x0670,
	"Arabic_tteh" : 0x0679,
	"Arabic_peh" : 0x067E,
	"Arabic_tcheh" : 0x0686,
	"Arabic_ddal" : 0x0688,
	"Arabic_rreh" : 0x0691,
	"Arabic_comma" : 0x060C,
	"Arabic_fullstop" : 0x06D4,
	"Arabic_0" : 0x0660,
	"Arabic_1" : 0x0661,
	"Arabic_2" : 0x0662,
	"Arabic_3" : 0x0663,
	"Arabic_4" : 0x0664,
	"Arabic_5" : 0x0665,
	"Arabic_6" : 0x0666,
	"Arabic_7" : 0x0667,
	"Arabic_8" : 0x0668,
	"Arabic_9" : 0x0669,
	"Arabic_semicolon" : 0x061B,
	"Arabic_question_mark" : 0x061F,
	"Arabic_hamza" : 0x0621,
	"Arabic_maddaonalef" : 0x0622,
	"Arabic_hamzaonalef" : 0x0623,
	"Arabic_hamzaonwaw" : 0x0624,
	"Arabic_hamzaunderalef" : 0x0625,
	"Arabic_hamzaonyeh" : 0x0626,
	"Arabic_alef" : 0x0627,
	"Arabic_beh" : 0x0628,
	"Arabic_tehmarbuta" : 0x0629,
	"Arabic_teh" : 0x062A,
	"Arabic_theh" : 0x062B,
	"Arabic_jeem" : 0x062C,
	"Arabic_hah" : 0x062D,
	"Arabic_khah" : 0x062E,
	"Arabic_dal" : 0x062F,
	"Arabic_thal" : 0x0630,
	"Arabic_ra" : 0x0631,
	"Arabic_zain" : 0x0632,
	"Arabic_seen" : 0x0633,
	"Arabic_sheen" : 0x0634,
	"Arabic_sad" : 0x0635,
	"Arabic_dad" : 0x0636,
	"Arabic_tah" : 0x0637,
	"Arabic_zah" : 0x0638,
	"Arabic_ain" : 0x0639,
	"Arabic_ghain" : 0x063A,
	"Arabic_tatweel" : 0x0640,
	"Arabic_feh" : 0x0641,
	"Arabic_qaf" : 0x0642,
	"Arabic_kaf" : 0x0643,
	"Arabic_lam" : 0x0644,
	"Arabic_meem" : 0x0645,
	"Arabic_noon" : 0x0646,
	"Arabic_ha" : 0x0647,
	"Arabic_waw" : 0x0648,
	"Arabic_alefmaksura" : 0x0649,
	"Arabic_yeh" : 0x064A,
	"Arabic_fathatan" : 0x064B,
	"Arabic_dammatan" : 0x064C,
	"Arabic_kasratan" : 0x064D,
	"Arabic_fatha" : 0x064E,
	"Arabic_damma" : 0x064F,
	"Arabic_kasra" : 0x0650,
	"Arabic_shadda" : 0x0651,
	"Arabic_sukun" : 0x0652,
	"Arabic_madda_above" : 0x0653,
	"Arabic_hamza_above" : 0x0654,
	"Arabic_hamza_below" : 0x0655,
	"Arabic_jeh" : 0x0698,
	"Arabic_veh" : 0x06A4,
	"Arabic_keheh" : 0x06A9,
	"Arabic_gaf" : 0x06AF,
	"Arabic_noon_ghunna" : 0x06BA,
	"Arabic_heh_doachashmee" : 0x06BE,
	"Farsi_yeh" : 0x06CC,
	"Arabic_farsi_yeh" : 0x06CC,
	"Arabic_yeh_baree" : 0x06D2,
	"Arabic_heh_goal" : 0x06C1,
	"Cyrillic_GHE_bar" : 0x0492,
	"Cyrillic_ghe_bar" : 0x0493,
	"Cyrillic_ZHE_descender" : 0x0496,
	"Cyrillic_zhe_descender" : 0x0497,
	"Cyrillic_KA_descender" : 0x049A,
	"Cyrillic_ka_descender" : 0x049B,
	"Cyrillic_KA_vertstroke" : 0x049C,
	"Cyrillic_ka_vertstroke" : 0x049D,
	"Cyrillic_EN_descender" : 0x04A2,
	"Cyrillic_en_descender" : 0x04A3,
	"Cyrillic_U_straight" : 0x04AE,
	"Cyrillic_u_straight" : 0x04AF,
	"Cyrillic_U_straight_bar" : 0x04B0,
	"Cyrillic_u_straight_bar" : 0x04B1,
	"Cyrillic_HA_descender" : 0x04B2,
	"Cyrillic_ha_descender" : 0x04B3,
	"Cyrillic_CHE_descender" : 0x04B6,
	"Cyrillic_che_descender" : 0x04B7,
	"Cyrillic_CHE_vertstroke" : 0x04B8,
	"Cyrillic_che_vertstroke" : 0x04B9,
	"Cyrillic_SHHA" : 0x04BA,
	"Cyrillic_shha" : 0x04BB,
	"Cyrillic_SCHWA" : 0x04D8,
	"Cyrillic_schwa" : 0x04D9,
	"Cyrillic_I_macron" : 0x04E2,
	"Cyrillic_i_macron" : 0x04E3,
	"Cyrillic_O_bar" : 0x04E8,
	"Cyrillic_o_bar" : 0x04E9,
	"Cyrillic_U_macron" : 0x04EE,
	"Cyrillic_u_macron" : 0x04EF,
	"Serbian_dje" : 0x0452,
	"Macedonia_gje" : 0x0453,
	"Cyrillic_io" : 0x0451,
	"Ukrainian_ie" : 0x0454,
	"Macedonia_dse" : 0x0455,
	"Ukrainian_i" : 0x0456,
	"Ukrainian_yi" : 0x0457,
	"Cyrillic_je" : 0x0458,
	"Cyrillic_lje" : 0x0459,
	"Cyrillic_nje" : 0x045A,
	"Serbian_tshe" : 0x045B,
	"Macedonia_kje" : 0x045C,
	"Ukrainian_ghe_with_upturn" : 0x0491,
	"Byelorussian_shortu" : 0x045E,
	"Cyrillic_dzhe" : 0x045F,
	"numerosign" : 0x2116,
	"Serbian_DJE" : 0x0402,
	"Macedonia_GJE" : 0x0403,
	"Cyrillic_IO" : 0x0401,
	"Ukrainian_IE" : 0x0404,
	"Macedonia_DSE" : 0x0405,
	"Ukrainian_I" : 0x0406,
	"Ukrainian_YI" : 0x0407,
	"Cyrillic_JE" : 0x0408,
	"Cyrillic_LJE" : 0x0409,
	"Cyrillic_NJE" : 0x040A,
	"Serbian_TSHE" : 0x040B,
	"Macedonia_KJE" : 0x040C,
	"Ukrainian_GHE_WITH_UPTURN" : 0x0490,
	"Byelorussian_SHORTU" : 0x040E,
	"Cyrillic_DZHE" : 0x040F,
	"Cyrillic_yu" : 0x044E,
	"Cyrillic_a" : 0x0430,
	"Cyrillic_be" : 0x0431,
	"Cyrillic_tse" : 0x0446,
	"Cyrillic_de" : 0x0434,
	"Cyrillic_ie" : 0x0435,
	"Cyrillic_ef" : 0x0444,
	"Cyrillic_ghe" : 0x0433,
	"Cyrillic_ha" : 0x0445,
	"Cyrillic_i" : 0x0438,
	"Cyrillic_shorti" : 0x0439,
	"Cyrillic_ka" : 0x043A,
	"Cyrillic_el" : 0x043B,
	"Cyrillic_em" : 0x043C,
	"Cyrillic_en" : 0x043D,
	"Cyrillic_o" : 0x043E,
	"Cyrillic_pe" : 0x043F,
	"Cyrillic_ya" : 0x044F,
	"Cyrillic_er" : 0x0440,
	"Cyrillic_es" : 0x0441,
	"Cyrillic_te" : 0x0442,
	"Cyrillic_u" : 0x0443,
	"Cyrillic_zhe" : 0x0436,
	"Cyrillic_ve" : 0x0432,
	"Cyrillic_softsign" : 0x044C,
	"Cyrillic_yeru" : 0x044B,
	"Cyrillic_ze" : 0x0437,
	"Cyrillic_sha" : 0x0448,
	"Cyrillic_e" : 0x044D,
	"Cyrillic_shcha" : 0x0449,
	"Cyrillic_che" : 0x0447,
	"Cyrillic_hardsign" : 0x044A,
	"Cyrillic_YU" : 0x042E,
	"Cyrillic_A" : 0x0410,
	"Cyrillic_BE" : 0x0411,
	"Cyrillic_TSE" : 0x0426,
	"Cyrillic_DE" : 0x0414,
	"Cyrillic_IE" : 0x0415,
	"Cyrillic_EF" : 0x0424,
	"Cyrillic_GHE" : 0x0413,
	"Cyrillic_HA" : 0x0425,
	"Cyrillic_I" : 0x0418,
	"Cyrillic_SHORTI" : 0x0419,
	"Cyrillic_KA" : 0x041A,
	"Cyrillic_EL" : 0x041B,
	"Cyrillic_EM" : 0x041C,
	"Cyrillic_EN" : 0x041D,
	"Cyrillic_O" : 0x041E,
	"Cyrillic_PE" : 0x041F,
	"Cyrillic_YA" : 0x042F,
	"Cyrillic_ER" : 0x0420,
	"Cyrillic_ES" : 0x0421,
	"Cyrillic_TE" : 0x0422,
	"Cyrillic_U" : 0x0423,
	"Cyrillic_ZHE" : 0x0416,
	"Cyrillic_VE" : 0x0412,
	"Cyrillic_SOFTSIGN" : 0x042C,
	"Cyrillic_YERU" : 0x042B,
	"Cyrillic_ZE" : 0x0417,
	"Cyrillic_SHA" : 0x0428,
	"Cyrillic_E" : 0x042D,
	"Cyrillic_SHCHA" : 0x0429,
	"Cyrillic_CHE" : 0x0427,
	"Cyrillic_HARDSIGN" : 0x042A,
	"Greek_ALPHAaccent" : 0x0386,
	"Greek_EPSILONaccent" : 0x0388,
	"Greek_ETAaccent" : 0x0389,
	"Greek_IOTAaccent" : 0x038A,
	"Greek_IOTAdieresis" : 0x03AA,
	"Greek_OMICRONaccent" : 0x038C,
	"Greek_UPSILONaccent" : 0x038E,
	"Greek_UPSILONdieresis" : 0x03AB,
	"Greek_OMEGAaccent" : 0x038F,
	"Greek_accentdieresis" : 0x0385,
	"Greek_horizbar" : 0x2015,
	"Greek_alphaaccent" : 0x03AC,
	"Greek_epsilonaccent" : 0x03AD,
	"Greek_etaaccent" : 0x03AE,
	"Greek_iotaaccent" : 0x03AF,
	"Greek_iotadieresis" : 0x03CA,
	"Greek_iotaaccentdieresis" : 0x0390,
	"Greek_omicronaccent" : 0x03CC,
	"Greek_upsilonaccent" : 0x03CD,
	"Greek_upsilondieresis" : 0x03CB,
	"Greek_upsilonaccentdieresis" : 0x03B0,
	"Greek_omegaaccent" : 0x03CE,
	"Greek_ALPHA" : 0x0391,
	"Greek_BETA" : 0x0392,
	"Greek_GAMMA" : 0x0393,
	"Greek_DELTA" : 0x0394,
	"Greek_EPSILON" : 0x0395,
	"Greek_ZETA" : 0x0396,
	"Greek_ETA" : 0x0397,
	"Greek_THETA" : 0x0398,
	"Greek_IOTA" : 0x0399,
	"Greek_KAPPA" : 0x039A,
	"Greek_LAMDA" : 0x039B,
	"Greek_LAMBDA" : 0x039B,
	"Greek_MU" : 0x039C,
	"Greek_NU" : 0x039D,
	"Greek_XI" : 0x039E,
	"Greek_OMICRON" : 0x039F,
	"Greek_PI" : 0x03A0,
	"Greek_RHO" : 0x03A1,
	"Greek_SIGMA" : 0x03A3,
	"Greek_TAU" : 0x03A4,
	"Greek_UPSILON" : 0x03A5,
	"Greek_PHI" : 0x03A6,
	"Greek_CHI" : 0x03A7,
	"Greek_PSI" : 0x03A8,
	"Greek_OMEGA" : 0x03A9,
	"Greek_alpha" : 0x03B1,
	"Greek_beta" : 0x03B2,
	"Greek_gamma" : 0x03B3,
	"Greek_delta" : 0x03B4,
	"Greek_epsilon" : 0x03B5,
	"Greek_zeta" : 0x03B6,
	"Greek_eta" : 0x03B7,
	"Greek_theta" : 0x03B8,
	"Greek_iota" : 0x03B9,
	"Greek_kappa" : 0x03BA,
	"Greek_lamda" : 0x03BB,
	"Greek_lambda" : 0x03BB,
	"Greek_mu" : 0x03BC,
	"Greek_nu" : 0x03BD,
	"Greek_xi" : 0x03BE,
	"Greek_omicron" : 0x03BF,
	"Greek_pi" : 0x03C0,
	"Greek_rho" : 0x03C1,
	"Greek_sigma" : 0x03C3,
	"Greek_finalsmallsigma" : 0x03C2,
	"Greek_tau" : 0x03C4,
	"Greek_upsilon" : 0x03C5,
	"Greek_phi" : 0x03C6,
	"Greek_chi" : 0x03C7,
	"Greek_psi" : 0x03C8,
	"Greek_omega" : 0x03C9,
	"leftradical" : 0x23B7,
	"topintegral" : 0x2320,
	"botintegral" : 0x2321,
	"topleftsqbracket" : 0x23A1,
	"botleftsqbracket" : 0x23A3,
	"toprightsqbracket" : 0x23A4,
	"botrightsqbracket" : 0x23A6,
	"topleftparens" : 0x239B,
	"botleftparens" : 0x239D,
	"toprightparens" : 0x239E,
	"botrightparens" : 0x23A0,
	"leftmiddlecurlybrace" : 0x23A8,
	"rightmiddlecurlybrace" : 0x23AC,
	"lessthanequal" : 0x2264,
	"notequal" : 0x2260,
	"greaterthanequal" : 0x2265,
	"integral" : 0x222B,
	"therefore" : 0x2234,
	"variation" : 0x221D,
	"infinity" : 0x221E,
	"nabla" : 0x2207,
	"approximate" : 0x223C,
	"similarequal" : 0x2243,
	"ifonlyif" : 0x21D4,
	"implies" : 0x21D2,
	"identical" : 0x2261,
	"radical" : 0x221A,
	"includedin" : 0x2282,
	"includes" : 0x2283,
	"intersection" : 0x2229,
	"union" : 0x222A,
	"logicaland" : 0x2227,
	"logicalor" : 0x2228,
	"partialderivative" : 0x2202,
	"function" : 0x0192,
	"leftarrow" : 0x2190,
	"uparrow" : 0x2191,
	"rightarrow" : 0x2192,
	"downarrow" : 0x2193,
	"soliddiamond" : 0x25C6,
	"checkerboard" : 0x2592,
	"ht" : 0x2409,
	"ff" : 0x240C,
	"cr" : 0x240D,
	"lf" : 0x240A,
	"nl" : 0x2424,
	"vt" : 0x240B,
	"lowrightcorner" : 0x2518,
	"uprightcorner" : 0x2510,
	"upleftcorner" : 0x250C,
	"lowleftcorner" : 0x2514,
	"crossinglines" : 0x253C,
	"horizlinescan1" : 0x23BA,
	"horizlinescan3" : 0x23BB,
	"horizlinescan5" : 0x2500,
	"horizlinescan7" : 0x23BC,
	"horizlinescan9" : 0x23BD,
	"leftt" : 0x251C,
	"rightt" : 0x2524,
	"bott" : 0x2534,
	"topt" : 0x252C,
	"vertbar" : 0x2502,
	"emspace" : 0x2003,
	"enspace" : 0x2002,
	"em3space" : 0x2004,
	"em4space" : 0x2005,
	"digitspace" : 0x2007,
	"punctspace" : 0x2008,
	"thinspace" : 0x2009,
	"hairspace" : 0x200A,
	"emdash" : 0x2014,
	"endash" : 0x2013,
	"ellipsis" : 0x2026,
	"doubbaselinedot" : 0x2025,
	"onethird" : 0x2153,
	"twothirds" : 0x2154,
	"onefifth" : 0x2155,
	"twofifths" : 0x2156,
	"threefifths" : 0x2157,
	"fourfifths" : 0x2158,
	"onesixth" : 0x2159,
	"fivesixths" : 0x215A,
	"careof" : 0x2105,
	"figdash" : 0x2012,
	"oneeighth" : 0x215B,
	"threeeighths" : 0x215C,
	"fiveeighths" : 0x215D,
	"seveneighths" : 0x215E,
	"trademark" : 0x2122,
	"leftsinglequotemark" : 0x2018,
	"rightsinglequotemark" : 0x2019,
	"leftdoublequotemark" : 0x201C,
	"rightdoublequotemark" : 0x201D,
	"prescription" : 0x211E,
	"permille" : 0x2030,
	"minutes" : 0x2032,
	"seconds" : 0x2033,
	"latincross" : 0x271D,
	"club" : 0x2663,
	"diamond" : 0x2666,
	"heart" : 0x2665,
	"maltesecross" : 0x2720,
	"dagger" : 0x2020,
	"doubledagger" : 0x2021,
	"checkmark" : 0x2713,
	"ballotcross" : 0x2717,
	"musicalsharp" : 0x266F,
	"musicalflat" : 0x266D,
	"malesymbol" : 0x2642,
	"femalesymbol" : 0x2640,
	"telephone" : 0x260E,
	"telephonerecorder" : 0x2315,
	"phonographcopyright" : 0x2117,
	"caret" : 0x2038,
	"singlelowquotemark" : 0x201A,
	"doublelowquotemark" : 0x201E,
	"downtack" : 0x22A4,
	"downstile" : 0x230A,
	"jot" : 0x2218,
	"quad" : 0x2395,
	"uptack" : 0x22A5,
	"circle" : 0x25CB,
	"upstile" : 0x2308,
	"lefttack" : 0x22A3,
	"righttack" : 0x22A2,
	"hebrew_doublelowline" : 0x2017,
	"hebrew_aleph" : 0x05D0,
	"hebrew_bet" : 0x05D1,
	"hebrew_gimel" : 0x05D2,
	"hebrew_dalet" : 0x05D3,
	"hebrew_he" : 0x05D4,
	"hebrew_waw" : 0x05D5,
	"hebrew_zain" : 0x05D6,
	"hebrew_chet" : 0x05D7,
	"hebrew_tet" : 0x05D8,
	"hebrew_yod" : 0x05D9,
	"hebrew_finalkaph" : 0x05DA,
	"hebrew_kaph" : 0x05DB,
	"hebrew_lamed" : 0x05DC,
	"hebrew_finalmem" : 0x05DD,
	"hebrew_mem" : 0x05DE,
	"hebrew_finalnun" : 0x05DF,
	"hebrew_nun" : 0x05E0,
	"hebrew_samech" : 0x05E1,
	"hebrew_ayin" : 0x05E2,
	"hebrew_finalpe" : 0x05E3,
	"hebrew_pe" : 0x05E4,
	"hebrew_finalzade" : 0x05E5,
	"hebrew_zade" : 0x05E6,
	"hebrew_qoph" : 0x05E7,
	"hebrew_resh" : 0x05E8,
	"hebrew_shin" : 0x05E9,
	"hebrew_taw" : 0x05EA,
	"Thai_kokai" : 0x0E01,
	"Thai_khokhai" : 0x0E02,
	"Thai_khokhuat" : 0x0E03,
	"Thai_khokhwai" : 0x0E04,
	"Thai_khokhon" : 0x0E05,
	"Thai_khorakhang" : 0x0E06,
	"Thai_ngongu" : 0x0E07,
	"Thai_chochan" : 0x0E08,
	"Thai_choching" : 0x0E09,
	"Thai_chochang" : 0x0E0A,
	"Thai_soso" : 0x0E0B,
	"Thai_chochoe" : 0x0E0C,
	"Thai_yoying" : 0x0E0D,
	"Thai_dochada" : 0x0E0E,
	"Thai_topatak" : 0x0E0F,
	"Thai_thothan" : 0x0E10,
	"Thai_thonangmontho" : 0x0E11,
	"Thai_thophuthao" : 0x0E12,
	"Thai_nonen" : 0x0E13,
	"Thai_dodek" : 0x0E14,
	"Thai_totao" : 0x0E15,
	"Thai_thothung" : 0x0E16,
	"Thai_thothahan" : 0x0E17,
	"Thai_thothong" : 0x0E18,
	"Thai_nonu" : 0x0E19,
	"Thai_bobaimai" : 0x0E1A,
	"Thai_popla" : 0x0E1B,
	"Thai_phophung" : 0x0E1C,
	"Thai_fofa" : 0x0E1D,
	"Thai_phophan" : 0x0E1E,
	"Thai_fofan" : 0x0E1F,
	"Thai_phosamphao" : 0x0E20,
	"Thai_moma" : 0x0E21,
	"Thai_yoyak" : 0x0E22,
	"Thai_rorua" : 0x0E23,
	"Thai_ru" : 0x0E24,
	"Thai_loling" : 0x0E25,
	"Thai_lu" : 0x0E26,
	"Thai_wowaen" : 0x0E27,
	"Thai_sosala" : 0x0E28,
	"Thai_sorusi" : 0x0E29,
	"Thai_sosua" : 0x0E2A,
	"Thai_hohip" : 0x0E2B,
	"Thai_lochula" : 0x0E2C,
	"Thai_oang" : 0x0E2D,
	"Thai_honokhuk" : 0x0E2E,
	"Thai_paiyannoi" : 0x0E2F,
	"Thai_saraa" : 0x0E30,
	"Thai_maihanakat" : 0x0E31,
	"Thai_saraaa" : 0x0E32,
	"Thai_saraam" : 0x0E33,
	"Thai_sarai" : 0x0E34,
	"Thai_saraii" : 0x0E35,
	"Thai_saraue" : 0x0E36,
	"Thai_sarauee" : 0x0E37,
	"Thai_sarau" : 0x0E38,
	"Thai_sarauu" : 0x0E39,
	"Thai_phinthu" : 0x0E3A,
	"Thai_baht" : 0x0E3F,
	"Thai_sarae" : 0x0E40,
	"Thai_saraae" : 0x0E41,
	"Thai_sarao" : 0x0E42,
	"Thai_saraaimaimuan" : 0x0E43,
	"Thai_saraaimaimalai" : 0x0E44,
	"Thai_lakkhangyao" : 0x0E45,
	"Thai_maiyamok" : 0x0E46,
	"Thai_maitaikhu" : 0x0E47,
	"Thai_maiek" : 0x0E48,
	"Thai_maitho" : 0x0E49,
	"Thai_maitri" : 0x0E4A,
	"Thai_maichattawa" : 0x0E4B,
	"Thai_thanthakhat" : 0x0E4C,
	"Thai_nikhahit" : 0x0E4D,
	"Thai_leksun" : 0x0E50,
	"Thai_leknung" : 0x0E51,
	"Thai_leksong" : 0x0E52,
	"Thai_leksam" : 0x0E53,
	"Thai_leksi" : 0x0E54,
	"Thai_lekha" : 0x0E55,
	"Thai_lekhok" : 0x0E56,
	"Thai_lekchet" : 0x0E57,
	"Thai_lekpaet" : 0x0E58,
	"Thai_lekkao" : 0x0E59,
	"Armenian_ligature_ew" : 0x0587,
	"Armenian_full_stop" : 0x0589,
	"Armenian_verjaket" : 0x0589,
	"Armenian_separation_mark" : 0x055D,
	"Armenian_but" : 0x055D,
	"Armenian_hyphen" : 0x058A,
	"Armenian_yentamna" : 0x058A,
	"Armenian_exclam" : 0x055C,
	"Armenian_amanak" : 0x055C,
	"Armenian_accent" : 0x055B,
	"Armenian_shesht" : 0x055B,
	"Armenian_question" : 0x055E,
	"Armenian_paruyk" : 0x055E,
	"Armenian_AYB" : 0x0531,
	"Armenian_ayb" : 0x0561,
	"Armenian_BEN" : 0x0532,
	"Armenian_ben" : 0x0562,
	"Armenian_GIM" : 0x0533,
	"Armenian_gim" : 0x0563,
	"Armenian_DA" : 0x0534,
	"Armenian_da" : 0x0564,
	"Armenian_YECH" : 0x0535,
	"Armenian_yech" : 0x0565,
	"Armenian_ZA" : 0x0536,
	"Armenian_za" : 0x0566,
	"Armenian_E" : 0x0537,
	"Armenian_e" : 0x0567,
	"Armenian_AT" : 0x0538,
	"Armenian_at" : 0x0568,
	"Armenian_TO" : 0x0539,
	"Armenian_to" : 0x0569,
	"Armenian_ZHE" : 0x053A,
	"Armenian_zhe" : 0x056A,
	"Armenian_INI" : 0x053B,
	"Armenian_ini" : 0x056B,
	"Armenian_LYUN" : 0x053C,
	"Armenian_lyun" : 0x056C,
	"Armenian_KHE" : 0x053D,
	"Armenian_khe" : 0x056D,
	"Armenian_TSA" : 0x053E,
	"Armenian_tsa" : 0x056E,
	"Armenian_KEN" : 0x053F,
	"Armenian_ken" : 0x056F,
	"Armenian_HO" : 0x0540,
	"Armenian_ho" : 0x0570,
	"Armenian_DZA" : 0x0541,
	"Armenian_dza" : 0x0571,
	"Armenian_GHAT" : 0x0542,
	"Armenian_ghat" : 0x0572,
	"Armenian_TCHE" : 0x0543,
	"Armenian_tche" : 0x0573,
	"Armenian_MEN" : 0x0544,
	"Armenian_men" : 0x0574,
	"Armenian_HI" : 0x0545,
	"Armenian_hi" : 0x0575,
	"Armenian_NU" : 0x0546,
	"Armenian_nu" : 0x0576,
	"Armenian_SHA" : 0x0547,
	"Armenian_sha" : 0x0577,
	"Armenian_VO" : 0x0548,
	"Armenian_vo" : 0x0578,
	"Armenian_CHA" : 0x0549,
	"Armenian_cha" : 0x0579,
	"Armenian_PE" : 0x054A,
	"Armenian_pe" : 0x057A,
	"Armenian_JE" : 0x054B,
	"Armenian_je" : 0x057B,
	"Armenian_RA" : 0x054C,
	"Armenian_ra" : 0x057C,
	"Armenian_SE" : 0x054D,
	"Armenian_se" : 0x057D,
	"Armenian_VEV" : 0x054E,
	"Armenian_vev" : 0x057E,
	"Armenian_TYUN" : 0x054F,
	"Armenian_tyun" : 0x057F,
	"Armenian_RE" : 0x0550,
	"Armenian_re" : 0x0580,
	"Armenian_TSO" : 0x0551,
	"Armenian_tso" : 0x0581,
	"Armenian_VYUN" : 0x0552,
	"Armenian_vyun" : 0x0582,
	"Armenian_PYUR" : 0x0553,
	"Armenian_pyur" : 0x0583,
	"Armenian_KE" : 0x0554,
	"Armenian_ke" : 0x0584,
	"Armenian_O" : 0x0555,
	"Armenian_o" : 0x0585,
	"Armenian_FE" : 0x0556,
	"Armenian_fe" : 0x0586,
	"Armenian_apostrophe" : 0x055A,
	"Georgian_an" : 0x10D0,
	"Georgian_ban" : 0x10D1,
	"Georgian_gan" : 0x10D2,
	"Georgian_don" : 0x10D3,
	"Georgian_en" : 0x10D4,
	"Georgian_vin" : 0x10D5,
	"Georgian_zen" : 0x10D6,
	"Georgian_tan" : 0x10D7,
	"Georgian_in" : 0x10D8,
	"Georgian_kan" : 0x10D9,
	"Georgian_las" : 0x10DA,
	"Georgian_man" : 0x10DB,
	"Georgian_nar" : 0x10DC,
	"Georgian_on" : 0x10DD,
	"Georgian_par" : 0x10DE,
	"Georgian_zhar" : 0x10DF,
	"Georgian_rae" : 0x10E0,
	"Georgian_san" : 0x10E1,
	"Georgian_tar" : 0x10E2,
	"Georgian_un" : 0x10E3,
	"Georgian_phar" : 0x10E4,
	"Georgian_khar" : 0x10E5,
	"Georgian_ghan" : 0x10E6,
	"Georgian_qar" : 0x10E7,
	"Georgian_shin" : 0x10E8,
	"Georgian_chin" : 0x10E9,
	"Georgian_can" : 0x10EA,
	"Georgian_jil" : 0x10EB,
	"Georgian_cil" : 0x10EC,
	"Georgian_char" : 0x10ED,
	"Georgian_xan" : 0x10EE,
	"Georgian_jhan" : 0x10EF,
	"Georgian_hae" : 0x10F0,
	"Georgian_he" : 0x10F1,
	"Georgian_hie" : 0x10F2,
	"Georgian_we" : 0x10F3,
	"Georgian_har" : 0x10F4,
	"Georgian_hoe" : 0x10F5,
	"Georgian_fi" : 0x10F6,
	"Xabovedot" : 0x1E8A,
	"Ibreve" : 0x012C,
	"Zstroke" : 0x01B5,
	"Gcaron" : 0x01E6,
	"Ocaron" : 0x01D2,
	"Obarred" : 0x019F,
	"xabovedot" : 0x1E8B,
	"ibreve" : 0x012D,
	"zstroke" : 0x01B6,
	"gcaron" : 0x01E7,
	"ocaron" : 0x01D2,
	"obarred" : 0x0275,
	"SCHWA" : 0x018F,
	"schwa" : 0x0259,
	"EZH" : 0x01B7,
	"ezh" : 0x0292,
	"Lbelowdot" : 0x1E36,
	"lbelowdot" : 0x1E37,
	"Abelowdot" : 0x1EA0,
	"abelowdot" : 0x1EA1,
	"Ahook" : 0x1EA2,
	"ahook" : 0x1EA3,
	"Acircumflexacute" : 0x1EA4,
	"acircumflexacute" : 0x1EA5,
	"Acircumflexgrave" : 0x1EA6,
	"acircumflexgrave" : 0x1EA7,
	"Acircumflexhook" : 0x1EA8,
	"acircumflexhook" : 0x1EA9,
	"Acircumflextilde" : 0x1EAA,
	"acircumflextilde" : 0x1EAB,
	"Acircumflexbelowdot" : 0x1EAC,
	"acircumflexbelowdot" : 0x1EAD,
	"Abreveacute" : 0x1EAE,
	"abreveacute" : 0x1EAF,
	"Abrevegrave" : 0x1EB0,
	"abrevegrave" : 0x1EB1,
	"Abrevehook" : 0x1EB2,
	"abrevehook" : 0x1EB3,
	"Abrevetilde" : 0x1EB4,
	"abrevetilde" : 0x1EB5,
	"Abrevebelowdot" : 0x1EB6,
	"abrevebelowdot" : 0x1EB7,
	"Ebelowdot" : 0x1EB8,
	"ebelowdot" : 0x1EB9,
	"Ehook" : 0x1EBA,
	"ehook" : 0x1EBB,
	"Etilde" : 0x1EBC,
	"etilde" : 0x1EBD,
	"Ecircumflexacute" : 0x1EBE,
	"ecircumflexacute" : 0x1EBF,
	"Ecircumflexgrave" : 0x1EC0,
	"ecircumflexgrave" : 0x1EC1,
	"Ecircumflexhook" : 0x1EC2,
	"ecircumflexhook" : 0x1EC3,
	"Ecircumflextilde" : 0x1EC4,
	"ecircumflextilde" : 0x1EC5,
	"Ecircumflexbelowdot" : 0x1EC6,
	"ecircumflexbelowdot" : 0x1EC7,
	"Ihook" : 0x1EC8,
	"ihook" : 0x1EC9,
	"Ibelowdot" : 0x1ECA,
	"ibelowdot" : 0x1ECB,
	"Obelowdot" : 0x1ECC,
	"obelowdot" : 0x1ECD,
	"Ohook" : 0x1ECE,
	"ohook" : 0x1ECF,
	"Ocircumflexacute" : 0x1ED0,
	"ocircumflexacute" : 0x1ED1,
	"Ocircumflexgrave" : 0x1ED2,
	"ocircumflexgrave" : 0x1ED3,
	"Ocircumflexhook" : 0x1ED4,
	"ocircumflexhook" : 0x1ED5,
	"Ocircumflextilde" : 0x1ED6,
	"ocircumflextilde" : 0x1ED7,
	"Ocircumflexbelowdot" : 0x1ED8,
	"ocircumflexbelowdot" : 0x1ED9,
	"Ohornacute" : 0x1EDA,
	"ohornacute" : 0x1EDB,
	"Ohorngrave" : 0x1EDC,
	"ohorngrave" : 0x1EDD,
	"Ohornhook" : 0x1EDE,
	"ohornhook" : 0x1EDF,
	"Ohorntilde" : 0x1EE0,
	"ohorntilde" : 0x1EE1,
	"Ohornbelowdot" : 0x1EE2,
	"ohornbelowdot" : 0x1EE3,
	"Ubelowdot" : 0x1EE4,
	"ubelowdot" : 0x1EE5,
	"Uhook" : 0x1EE6,
	"uhook" : 0x1EE7,
	"Uhornacute" : 0x1EE8,
	"uhornacute" : 0x1EE9,
	"Uhorngrave" : 0x1EEA,
	"uhorngrave" : 0x1EEB,
	"Uhornhook" : 0x1EEC,
	"uhornhook" : 0x1EED,
	"Uhorntilde" : 0x1EEE,
	"uhorntilde" : 0x1EEF,
	"Uhornbelowdot" : 0x1EF0,
	"uhornbelowdot" : 0x1EF1,
	"Ybelowdot" : 0x1EF4,
	"ybelowdot" : 0x1EF5,
	"Yhook" : 0x1EF6,
	"yhook" : 0x1EF7,
	"Ytilde" : 0x1EF8,
	"ytilde" : 0x1EF9,
	"Ohorn" : 0x01A0,
	"ohorn" : 0x01A1,
	"Uhorn" : 0x01AF,
	"uhorn" : 0x01B0,
	"EcuSign" : 0x20A0,
	"ColonSign" : 0x20A1,
	"CruzeiroSign" : 0x20A2,
	"FFrancSign" : 0x20A3,
	"LiraSign" : 0x20A4,
	"MillSign" : 0x20A5,
	"NairaSign" : 0x20A6,
	"PesetaSign" : 0x20A7,
	"RupeeSign" : 0x20A8,
	"WonSign" : 0x20A9,
	"NewSheqelSign" : 0x20AA,
	"DongSign" : 0x20AB,
	"EuroSign" : 0x20AC,
	"zerosuperior" : 0x2070,
	"foursuperior" : 0x2074,
	"fivesuperior" : 0x2075,
	"sixsuperior" : 0x2076,
	"sevensuperior" : 0x2077,
	"eightsuperior" : 0x2078,
	"ninesuperior" : 0x2079,
	"zerosubscript" : 0x2080,
	"onesubscript" : 0x2081,
	"twosubscript" : 0x2082,
	"threesubscript" : 0x2083,
	"foursubscript" : 0x2084,
	"fivesubscript" : 0x2085,
	"sixsubscript" : 0x2086,
	"sevensubscript" : 0x2087,
	"eightsubscript" : 0x2088,
	"ninesubscript" : 0x2089,
	"partdifferential" : 0x2202,
	"emptyset" : 0x2205,
	"elementof" : 0x2208,
	"notelementof" : 0x2209,
	"containsas" : 0x220B,
	"squareroot" : 0x221A,
	"cuberoot" : 0x221B,
	"fourthroot" : 0x221C,
	"dintegral" : 0x222C,
	"tintegral" : 0x222D,
	"because" : 0x2235,
	"approxeq" : 0x2245,
	"notapproxeq" : 0x2247,
	"notidentical" : 0x2262,
	"stricteq" : 0x2263,
	"braille_blank" : 0x2800,
	"braille_dots_1" : 0x2801,
	"braille_dots_2" : 0x2802,
	"braille_dots_12" : 0x2803,
	"braille_dots_3" : 0x2804,
	"braille_dots_13" : 0x2805,
	"braille_dots_23" : 0x2806,
	"braille_dots_123" : 0x2807,
	"braille_dots_4" : 0x2808,
	"braille_dots_14" : 0x2809,
	"braille_dots_24" : 0x280a,
	"braille_dots_124" : 0x280b,
	"braille_dots_34" : 0x280c,
	"braille_dots_134" : 0x280d,
	"braille_dots_234" : 0x280e,
	"braille_dots_1234" : 0x280f,
	"braille_dots_5" : 0x2810,
	"braille_dots_15" : 0x2811,
	"braille_dots_25" : 0x2812,
	"braille_dots_125" : 0x2813,
	"braille_dots_35" : 0x2814,
	"braille_dots_135" : 0x2815,
	"braille_dots_235" : 0x2816,
	"braille_dots_1235" : 0x2817,
	"braille_dots_45" : 0x2818,
	"braille_dots_145" : 0x2819,
	"braille_dots_245" : 0x281a,
	"braille_dots_1245" : 0x281b,
	"braille_dots_345" : 0x281c,
	"braille_dots_1345" : 0x281d,
	"braille_dots_2345" : 0x281e,
	"braille_dots_12345" : 0x281f,
	"braille_dots_6" : 0x2820,
	"braille_dots_16" : 0x2821,
	"braille_dots_26" : 0x2822,
	"braille_dots_126" : 0x2823,
	"braille_dots_36" : 0x2824,
	"braille_dots_136" : 0x2825,
	"braille_dots_236" : 0x2826,
	"braille_dots_1236" : 0x2827,
	"braille_dots_46" : 0x2828,
	"braille_dots_146" : 0x2829,
	"braille_dots_246" : 0x282a,
	"braille_dots_1246" : 0x282b,
	"braille_dots_346" : 0x282c,
	"braille_dots_1346" : 0x282d,
	"braille_dots_2346" : 0x282e,
	"braille_dots_12346" : 0x282f,
	"braille_dots_56" : 0x2830,
	"braille_dots_156" : 0x2831,
	"braille_dots_256" : 0x2832,
	"braille_dots_1256" : 0x2833,
	"braille_dots_356" : 0x2834,
	"braille_dots_1356" : 0x2835,
	"braille_dots_2356" : 0x2836,
	"braille_dots_12356" : 0x2837,
	"braille_dots_456" : 0x2838,
	"braille_dots_1456" : 0x2839,
	"braille_dots_2456" : 0x283a,
	"braille_dots_12456" : 0x283b,
	"braille_dots_3456" : 0x283c,
	"braille_dots_13456" : 0x283d,
	"braille_dots_23456" : 0x283e,
	"braille_dots_123456" : 0x283f,
	"braille_dots_7" : 0x2840,
	"braille_dots_17" : 0x2841,
	"braille_dots_27" : 0x2842,
	"braille_dots_127" : 0x2843,
	"braille_dots_37" : 0x2844,
	"braille_dots_137" : 0x2845,
	"braille_dots_237" : 0x2846,
	"braille_dots_1237" : 0x2847,
	"braille_dots_47" : 0x2848,
	"braille_dots_147" : 0x2849,
	"braille_dots_247" : 0x284a,
	"braille_dots_1247" : 0x284b,
	"braille_dots_347" : 0x284c,
	"braille_dots_1347" : 0x284d,
	"braille_dots_2347" : 0x284e,
	"braille_dots_12347" : 0x284f,
	"braille_dots_57" : 0x2850,
	"braille_dots_157" : 0x2851,
	"braille_dots_257" : 0x2852,
	"braille_dots_1257" : 0x2853,
	"braille_dots_357" : 0x2854,
	"braille_dots_1357" : 0x2855,
	"braille_dots_2357" : 0x2856,
	"braille_dots_12357" : 0x2857,
	"braille_dots_457" : 0x2858,
	"braille_dots_1457" : 0x2859,
	"braille_dots_2457" : 0x285a,
	"braille_dots_12457" : 0x285b,
	"braille_dots_3457" : 0x285c,
	"braille_dots_13457" : 0x285d,
	"braille_dots_23457" : 0x285e,
	"braille_dots_123457" : 0x285f,
	"braille_dots_67" : 0x2860,
	"braille_dots_167" : 0x2861,
	"braille_dots_267" : 0x2862,
	"braille_dots_1267" : 0x2863,
	"braille_dots_367" : 0x2864,
	"braille_dots_1367" : 0x2865,
	"braille_dots_2367" : 0x2866,
	"braille_dots_12367" : 0x2867,
	"braille_dots_467" : 0x2868,
	"braille_dots_1467" : 0x2869,
	"braille_dots_2467" : 0x286a,
	"braille_dots_12467" : 0x286b,
	"braille_dots_3467" : 0x286c,
	"braille_dots_13467" : 0x286d,
	"braille_dots_23467" : 0x286e,
	"braille_dots_123467" : 0x286f,
	"braille_dots_567" : 0x2870,
	"braille_dots_1567" : 0x2871,
	"braille_dots_2567" : 0x2872,
	"braille_dots_12567" : 0x2873,
	"braille_dots_3567" : 0x2874,
	"braille_dots_13567" : 0x2875,
	"braille_dots_23567" : 0x2876,
	"braille_dots_123567" : 0x2877,
	"braille_dots_4567" : 0x2878,
	"braille_dots_14567" : 0x2879,
	"braille_dots_24567" : 0x287a,
	"braille_dots_124567" : 0x287b,
	"braille_dots_34567" : 0x287c,
	"braille_dots_134567" : 0x287d,
	"braille_dots_234567" : 0x287e,
	"braille_dots_1234567" : 0x287f,
	"braille_dots_8" : 0x2880,
	"braille_dots_18" : 0x2881,
	"braille_dots_28" : 0x2882,
	"braille_dots_128" : 0x2883,
	"braille_dots_38" : 0x2884,
	"braille_dots_138" : 0x2885,
	"braille_dots_238" : 0x2886,
	"braille_dots_1238" : 0x2887,
	"braille_dots_48" : 0x2888,
	"braille_dots_148" : 0x2889,
	"braille_dots_248" : 0x288a,
	"braille_dots_1248" : 0x288b,
	"braille_dots_348" : 0x288c,
	"braille_dots_1348" : 0x288d,
	"braille_dots_2348" : 0x288e,
	"braille_dots_12348" : 0x288f,
	"braille_dots_58" : 0x2890,
	"braille_dots_158" : 0x2891,
	"braille_dots_258" : 0x2892,
	"braille_dots_1258" : 0x2893,
	"braille_dots_358" : 0x2894,
	"braille_dots_1358" : 0x2895,
	"braille_dots_2358" : 0x2896,
	"braille_dots_12358" : 0x2897,
	"braille_dots_458" : 0x2898,
	"braille_dots_1458" : 0x2899,
	"braille_dots_2458" : 0x289a,
	"braille_dots_12458" : 0x289b,
	"braille_dots_3458" : 0x289c,
	"braille_dots_13458" : 0x289d,
	"braille_dots_23458" : 0x289e,
	"braille_dots_123458" : 0x289f,
	"braille_dots_68" : 0x28a0,
	"braille_dots_168" : 0x28a1,
	"braille_dots_268" : 0x28a2,
	"braille_dots_1268" : 0x28a3,
	"braille_dots_368" : 0x28a4,
	"braille_dots_1368" : 0x28a5,
	"braille_dots_2368" : 0x28a6,
	"braille_dots_12368" : 0x28a7,
	"braille_dots_468" : 0x28a8,
	"braille_dots_1468" : 0x28a9,
	"braille_dots_2468" : 0x28aa,
	"braille_dots_12468" : 0x28ab,
	"braille_dots_3468" : 0x28ac,
	"braille_dots_13468" : 0x28ad,
	"braille_dots_23468" : 0x28ae,
	"braille_dots_123468" : 0x28af,
	"braille_dots_568" : 0x28b0,
	"braille_dots_1568" : 0x28b1,
	"braille_dots_2568" : 0x28b2,
	"braille_dots_12568" : 0x28b3,
	"braille_dots_3568" : 0x28b4,
	"braille_dots_13568" : 0x28b5,
	"braille_dots_23568" : 0x28b6,
	"braille_dots_123568" : 0x28b7,
	"braille_dots_4568" : 0x28b8,
	"braille_dots_14568" : 0x28b9,
	"braille_dots_24568" : 0x28ba,
	"braille_dots_124568" : 0x28bb,
	"braille_dots_34568" : 0x28bc,
	"braille_dots_134568" : 0x28bd,
	"braille_dots_234568" : 0x28be,
	"braille_dots_1234568" : 0x28bf,
	"braille_dots_78" : 0x28c0,
	"braille_dots_178" : 0x28c1,
	"braille_dots_278" : 0x28c2,
	"braille_dots_1278" : 0x28c3,
	"braille_dots_378" : 0x28c4,
	"braille_dots_1378" : 0x28c5,
	"braille_dots_2378" : 0x28c6,
	"braille_dots_12378" : 0x28c7,
	"braille_dots_478" : 0x28c8,
	"braille_dots_1478" : 0x28c9,
	"braille_dots_2478" : 0x28ca,
	"braille_dots_12478" : 0x28cb,
	"braille_dots_3478" : 0x28cc,
	"braille_dots_13478" : 0x28cd,
	"braille_dots_23478" : 0x28ce,
	"braille_dots_123478" : 0x28cf,
	"braille_dots_578" : 0x28d0,
	"braille_dots_1578" : 0x28d1,
	"braille_dots_2578" : 0x28d2,
	"braille_dots_12578" : 0x28d3,
	"braille_dots_3578" : 0x28d4,
	"braille_dots_13578" : 0x28d5,
	"braille_dots_23578" : 0x28d6,
	"braille_dots_123578" : 0x28d7,
	"braille_dots_4578" : 0x28d8,
	"braille_dots_14578" : 0x28d9,
	"braille_dots_24578" : 0x28da,
	"braille_dots_124578" : 0x28db,
	"braille_dots_34578" : 0x28dc,
	"braille_dots_134578" : 0x28dd,
	"braille_dots_234578" : 0x28de,
	"braille_dots_1234578" : 0x28df,
	"braille_dots_678" : 0x28e0,
	"braille_dots_1678" : 0x28e1,
	"braille_dots_2678" : 0x28e2,
	"braille_dots_12678" : 0x28e3,
	"braille_dots_3678" : 0x28e4,
	"braille_dots_13678" : 0x28e5,
	"braille_dots_23678" : 0x28e6,
	"braille_dots_123678" : 0x28e7,
	"braille_dots_4678" : 0x28e8,
	"braille_dots_14678" : 0x28e9,
	"braille_dots_24678" : 0x28ea,
	"braille_dots_124678" : 0x28eb,
	"braille_dots_34678" : 0x28ec,
	"braille_dots_134678" : 0x28ed,
	"braille_dots_234678" : 0x28ee,
	"braille_dots_1234678" : 0x28ef,
	"braille_dots_5678" : 0x28f0,
	"braille_dots_15678" : 0x28f1,
	"braille_dots_25678" : 0x28f2,
	"braille_dots_125678" : 0x28f3,
	"braille_dots_35678" : 0x28f4,
	"braille_dots_135678" : 0x28f5,
	"braille_dots_235678" : 0x28f6,
	"braille_dots_1235678" : 0x28f7,
	"braille_dots_45678" : 0x28f8,
	"braille_dots_145678" : 0x28f9,
	"braille_dots_245678" : 0x28fa,
	"braille_dots_1245678" : 0x28fb,
	"braille_dots_345678" : 0x28fc,
	"braille_dots_1345678" : 0x28fd,
	"braille_dots_2345678" : 0x28fe,
	"braille_dots_12345678" : 0x28ff,
	"Sinh_ng" : 0x0D82,
	"Sinh_h2" : 0x0D83,
	"Sinh_a" : 0x0D85,
	"Sinh_aa" : 0x0D86,
	"Sinh_ae" : 0x0D87,
	"Sinh_aee" : 0x0D88,
	"Sinh_i" : 0x0D89,
	"Sinh_ii" : 0x0D8A,
	"Sinh_u" : 0x0D8B,
	"Sinh_uu" : 0x0D8C,
	"Sinh_ri" : 0x0D8D,
	"Sinh_rii" : 0x0D8E,
	"Sinh_lu" : 0x0D8F,
	"Sinh_luu" : 0x0D90,
	"Sinh_e" : 0x0D91,
	"Sinh_ee" : 0x0D92,
	"Sinh_ai" : 0x0D93,
	"Sinh_o" : 0x0D94,
	"Sinh_oo" : 0x0D95,
	"Sinh_au" : 0x0D96,
	"Sinh_ka" : 0x0D9A,
	"Sinh_kha" : 0x0D9B,
	"Sinh_ga" : 0x0D9C,
	"Sinh_gha" : 0x0D9D,
	"Sinh_ng2" : 0x0D9E,
	"Sinh_nga" : 0x0D9F,
	"Sinh_ca" : 0x0DA0,
	"Sinh_cha" : 0x0DA1,
	"Sinh_ja" : 0x0DA2,
	"Sinh_jha" : 0x0DA3,
	"Sinh_nya" : 0x0DA4,
	"Sinh_jnya" : 0x0DA5,
	"Sinh_nja" : 0x0DA6,
	"Sinh_tta" : 0x0DA7,
	"Sinh_ttha" : 0x0DA8,
	"Sinh_dda" : 0x0DA9,
	"Sinh_ddha" : 0x0DAA,
	"Sinh_nna" : 0x0DAB,
	"Sinh_ndda" : 0x0DAC,
	"Sinh_tha" : 0x0DAD,
	"Sinh_thha" : 0x0DAE,
	"Sinh_dha" : 0x0DAF,
	"Sinh_dhha" : 0x0DB0,
	"Sinh_na" : 0x0DB1,
	"Sinh_ndha" : 0x0DB3,
	"Sinh_pa" : 0x0DB4,
	"Sinh_pha" : 0x0DB5,
	"Sinh_ba" : 0x0DB6,
	"Sinh_bha" : 0x0DB7,
	"Sinh_ma" : 0x0DB8,
	"Sinh_mba" : 0x0DB9,
	"Sinh_ya" : 0x0DBA,
	"Sinh_ra" : 0x0DBB,
	"Sinh_la" : 0x0DBD,
	"Sinh_va" : 0x0DC0,
	"Sinh_sha" : 0x0DC1,
	"Sinh_ssha" : 0x0DC2,
	"Sinh_sa" : 0x0DC3,
	"Sinh_ha" : 0x0DC4,
	"Sinh_lla" : 0x0DC5,
	"Sinh_fa" : 0x0DC6,
	"Sinh_al" : 0x0DCA,
	"Sinh_aa2" : 0x0DCF,
	"Sinh_ae2" : 0x0DD0,
	"Sinh_aee2" : 0x0DD1,
	"Sinh_i2" : 0x0DD2,
	"Sinh_ii2" : 0x0DD3,
	"Sinh_u2" : 0x0DD4,
	"Sinh_uu2" : 0x0DD6,
	"Sinh_ru2" : 0x0DD8,
	"Sinh_e2" : 0x0DD9,
	"Sinh_ee2" : 0x0DDA,
	"Sinh_ai2" : 0x0DDB,
	"Sinh_o2" : 0x0DDC,
	"Sinh_oo2" : 0x0DDD,
	"Sinh_au2" : 0x0DDE,
	"Sinh_lu2" : 0x0DDF,
	"Sinh_ruu2" : 0x0DF2,
	"Sinh_luu2" : 0x0DF3,
	"Sinh_kunddaliya" : 0x0DF4,
};

CHAR_TO_NAME = {
	" "					: "space",
	};
//console.debug("KEYSYM_TO_UNICODE=", KEYSYM_TO_UNICODE);
for (let keysym in KEYSYM_TO_UNICODE) {
	const u = KEYSYM_TO_UNICODE[keysym];
	const character = String.fromCharCode(u);
	CHAR_TO_NAME[character] = keysym;
}
//console.debug("CHAR_TO_NAME=", KEYSYM_TO_UNICODE);


//some keysyms require specific layouts
KEYSYM_TO_LAYOUT = {
	"kana"		: "jp",
	"Farsi"		: "ir",
	"Arabic"	: "ar",
	"Cyrillic"	: "ru",
	"Ukrainian"	: "uk",
	"Macedonia"	: "mk",
	"Greek"		: "gr",
	"hebrew"	: "he",
	"Thai"		: "th",
	"Armenian"	: "am",
	"Georgian"	: "ge",
	"braille"	: "brai",
};


/**
 * Maps web keycodes to the corresponding X11 keysym:
 *
 * TODO: some values are missing..
 */
CHARCODE_TO_NAME = {
	8	: "BackSpace",
	9	: "Tab",
	12	: "KP_Begin",
	13	: "Return",
	16	: "Shift_L",
	17	: "Control_L",
	18	: "Alt_L",
	19	: "Pause",			//pause/break
	20	: "Caps_Lock",
	27	: "Escape",
	31	: "Mode_switch",
	32	: "space",
	33	: "Prior",			//Page Up
	34	: "Next",			//Page Down
	35	: "End",
	36	: "Home",
	37	: "Left",
	38	: "Up",
	39	: "Right",
	40	: "Down",
	42	: "Print",
	45	: "Insert",
	46	: "Delete",
	58	: "colon",
	59	: "semicolon",
	60	: "less",
	61	: "equal",
	62	: "greater",
	63	: "question",
	64	: "at",
	91	: "Menu",			//Left Window Key
	92	: "Menu",			//Right Window Key
	93	: "KP_Enter",		//"select key"?
	106	: "KP_Multiply",
	107	: "KP_Add",
	109	: "KP_Subtract",
	110	: "KP_Delete",
	111	: "KP_Divide",
	144	: "Num_Lock",
	145	: "Scroll_Lock",
	160	: "dead_circumflex",
	161	: "exclam",
	162	: "quotedbl",
	163	: "numbersign",
	164	: "dollar",
	165	: "percent",
	166	: "ampersand",
	167	: "underscore",
	168 : "parenleft",
	169 : "parenright",
	170 : "asterisk",
	171	: "plus",
	172	: "bar",
	173	: "minus",
	174 : "braceleft",
	175 : "braceright",
	176 : "asciitilde",
	186	: "semicolon",
	187	: "equal",
	188	: "comma",
	189	: "minus",
	190	: "period",
	191	: "slash",
	192	: "grave",
	219	: "bracketleft",
	220	: "backslash",
	221	: "bracketright",
	222	: "apostrophe",
};
for (let i=0; i<26; i++) {
	CHARCODE_TO_NAME[65+i] = "abcdefghijklmnopqrstuvwxyz"[i];
}
for (let i=0; i<10; i++) {
	CHARCODE_TO_NAME[48+i] = ""+i;
	CHARCODE_TO_NAME[96+i] = ""+i;
	//fix for OSX numpad?
	//CHARCODE_TO_NAME[96+i] = "KP_"+i;
}
for (let i=1; i<=24; i++) {
	CHARCODE_TO_NAME[111+i] = "F"+i;
}
//overrides: only for 'de' layout?
CHARCODE_TO_NAME[192] = "dead_circumflex";
CHARCODE_TO_NAME[219] = "backtick";
CHARCODE_TO_NAME[221] = "dead_acute";
CHARCODE_TO_NAME[220] = "dead_circumflex";


/**
 * Converts an event into a list of modifiers.
 *
 * @param event
 * @returns {Array} of strings
 */
function get_event_modifiers(event) {
	const modifiers = [];
	if (event.getModifierState) {
		if (event.getModifierState("Control"))
			modifiers.push("control");
		if (event.getModifierState("Alt"))
			modifiers.push("alt");
		if (event.getModifierState("Meta"))
			modifiers.push("meta");
		if (event.getModifierState("Shift"))
			modifiers.push("shift");
		if (event.getModifierState("CapsLock"))
			modifiers.push("capslock");
		if (event.getModifierState("NumLock"))
			modifiers.push("numlock");
		//ScrollLock
		//Fn
		//AltGraph
	}
	else if (event.modifiers) {
		if (event.modifiers & Event.ALT_MASK)
			modifiers.push("alt");
		if (event.modifiers & Event.CONTROL_MASK)
			modifiers.push("control");
		if (event.modifiers & Event.SHIFT_MASK)
			modifiers.push("shift");
		if (event.modifiers & Event.META_MASK)
			modifiers.push("meta");
	} else {
		if (event.altKey)
			modifiers.push("alt");
		if (event.ctrlKey)
			modifiers.push("control");
		if (event.metaKey)
			modifiers.push("meta");
		if (event.shiftKey)
			modifiers.push("shift");
	}
	return modifiers;
}
