# coding=utf-8
#
#  Copyright © 2013 Hewlett-Packard Development Company, L.P.
#
#  This work is distributed under the W3C® Software License [1]
#  in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
#  [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
#
"""WebIDL parser."""

from .constructs import (
	Argument,
	Callback,
	Const,
	Construct,
	Dictionary,
	DictionaryMember,
	Enum,
	ExtendedAttribute,
	ExtendedAttributeArgList,
	ExtendedAttributeIdent,
	ExtendedAttributeIdentList,
	ExtendedAttributeNamedArgList,
	ExtendedAttributeNoArgs,
	ExtendedAttributeTypePair,
	ExtendedAttributeUnknown,
	ImplementsStatement,
	IncludesStatement,
	Interface,
	InterfaceMember,
	Mixin,
	MixinMember,
	Namespace,
	NamespaceMember,
	SyntaxError,
	Typedef,
)
from .parser import Parser
from .productions import (
	AnyType,
	ArgumentList,
	ArgumentName,
	AsyncIterable,
	Attribute,
	AttributeName,
	AttributeRest,
	ChildProduction,
	ConstType,
	ConstValue,
	Constructor,
	Default,
	EnumValue,
	EnumValueList,
	ExtendedAttributeList,
	FloatLiteral,
	FloatType,
	Identifier,
	Identifiers,
	Ignore,
	IgnoreInOut,
	IgnoreMultipleInheritance,
	Inheritance,
	Integer,
	IntegerType,
	Iterable,
	Maplike,
	MixinAttribute,
	NonAnyType,
	Operation,
	OperationName,
	OperationRest,
	PrimitiveType,
	Production,
	Setlike,
	SingleType,
	Special,
	SpecialOperation,
	StaticMember,
	String,
	Stringifier,
	Symbol,
	Type,
	TypeIdentifier,
	TypeIdentifiers,
	TypeSuffix,
	TypeSuffixStartingWithArray,
	TypeWithExtendedAttributes,
	UnionMemberType,
	UnionType,
	UnrestrictedFloatType,
	UnsignedIntegerType,
)
from .tokenizer import (
	Token,
	TokenType,
	Tokenizer,
	UserInterface,
)

__all__ = [
	'Parser',

	# tokenizer
	'UserInterface',
	'TokenType',
	'Token',
	'Tokenizer',

	# productions
	'Production',
	'ChildProduction',
	'String',
	'Symbol',
	'Integer',
	'IntegerType',
	'UnsignedIntegerType',
	'FloatType',
	'UnrestrictedFloatType',
	'PrimitiveType',
	'Identifier',
	'TypeIdentifier',
	'ConstType',
	'FloatLiteral',
	'ConstValue',
	'EnumValue',
	'EnumValueList',
	'TypeSuffix',
	'TypeSuffixStartingWithArray',
	'AnyType',
	'SingleType',
	'NonAnyType',
	'UnionMemberType',
	'UnionType',
	'Type',
	'TypeWithExtendedAttributes',
	'IgnoreInOut',
	'Ignore',
	'IgnoreMultipleInheritance',
	'Inheritance',
	'Default',
	'ArgumentName',
	'ArgumentList',
	'Special',
	'AttributeName',
	'AttributeRest',
	'MixinAttribute',
	'Attribute',
	'OperationName',
	'OperationRest',
	'Iterable',
	'AsyncIterable',
	'Maplike',
	'Setlike',
	'SpecialOperation',
	'Operation',
	'Stringifier',
	'Identifiers',
	'TypeIdentifiers',
	'StaticMember',
	'Constructor',
	'ExtendedAttributeList',

	# constructs
	'Construct',
	'Const',
	'Enum',
	'Typedef',
	'Argument',
	'InterfaceMember',
	'MixinMember',
	'SyntaxError',
	'Interface',
	'Mixin',
	'NamespaceMember',
	'Namespace',
	'DictionaryMember',
	'Dictionary',
	'Callback',
	'ImplementsStatement',
	'IncludesStatement',
	'ExtendedAttributeUnknown',
	'ExtendedAttributeNoArgs',
	'ExtendedAttributeArgList',
	'ExtendedAttributeIdent',
	'ExtendedAttributeIdentList',
	'ExtendedAttributeNamedArgList',
	'ExtendedAttributeTypePair',
	'ExtendedAttribute',
]
