"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInvokeAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The action to write the data to an AWS Lambda function.
 */
class LambdaInvokeAction {
    /**
     * @param func the AWS Lambda function to be invoked by this action
     */
    constructor(func) {
        this.func = func;
    }
    bind(_scope, options) {
        this.func.grantInvoke(options.role);
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
exports.LambdaInvokeAction = LambdaInvokeAction;
_a = JSII_RTTI_SYMBOL_1;
LambdaInvokeAction[_a] = { fqn: "@aws-cdk/aws-iotevents-actions.LambdaInvokeAction", version: "1.163.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWludm9rZS1hY3Rpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsYW1iZGEtaW52b2tlLWFjdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUlBOztHQUVHO0FBQ0gsTUFBYSxrQkFBa0I7SUFDN0I7O09BRUc7SUFDSCxZQUE2QixJQUFzQjtRQUF0QixTQUFJLEdBQUosSUFBSSxDQUFrQjtLQUNsRDtJQUVELElBQUksQ0FBQyxNQUFpQixFQUFFLE9BQW9DO1FBQzFELElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNwQyxPQUFPO1lBQ0wsYUFBYSxFQUFFO2dCQUNiLE1BQU0sRUFBRTtvQkFDTixXQUFXLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXO2lCQUNuQzthQUNGO1NBQ0YsQ0FBQztLQUNIOztBQWhCSCxnREFpQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpb3RldmVudHMgZnJvbSAnQGF3cy1jZGsvYXdzLWlvdGV2ZW50cyc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuLyoqXG4gKiBUaGUgYWN0aW9uIHRvIHdyaXRlIHRoZSBkYXRhIHRvIGFuIEFXUyBMYW1iZGEgZnVuY3Rpb24uXG4gKi9cbmV4cG9ydCBjbGFzcyBMYW1iZGFJbnZva2VBY3Rpb24gaW1wbGVtZW50cyBpb3RldmVudHMuSUFjdGlvbiB7XG4gIC8qKlxuICAgKiBAcGFyYW0gZnVuYyB0aGUgQVdTIExhbWJkYSBmdW5jdGlvbiB0byBiZSBpbnZva2VkIGJ5IHRoaXMgYWN0aW9uXG4gICAqL1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGZ1bmM6IGxhbWJkYS5JRnVuY3Rpb24pIHtcbiAgfVxuXG4gIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QsIG9wdGlvbnM6IGlvdGV2ZW50cy5BY3Rpb25CaW5kT3B0aW9ucyk6IGlvdGV2ZW50cy5BY3Rpb25Db25maWcge1xuICAgIHRoaXMuZnVuYy5ncmFudEludm9rZShvcHRpb25zLnJvbGUpO1xuICAgIHJldHVybiB7XG4gICAgICBjb25maWd1cmF0aW9uOiB7XG4gICAgICAgIGxhbWJkYToge1xuICAgICAgICAgIGZ1bmN0aW9uQXJuOiB0aGlzLmZ1bmMuZnVuY3Rpb25Bcm4sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==