# flake8: noqa
import pandas as pd

AWS_INSTANCE_TYPES = pd.DataFrame(
    [
        {
            "instance_type": "a1.2xlarge",
            "instance_family": "a1",
            "instance_size": "2xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.204,
            "on_demand_windows_pricing": 0.572,
        },
        {
            "instance_type": "a1.4xlarge",
            "instance_family": "a1",
            "instance_size": "4xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.408,
            "on_demand_windows_pricing": 1.144,
        },
        {
            "instance_type": "a1.large",
            "instance_family": "a1",
            "instance_size": "large",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.051,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "a1.medium",
            "instance_family": "a1",
            "instance_size": "medium",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 1,
            "architecture": "arm64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 2.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.0255,
            "on_demand_windows_pricing": 0.0715,
        },
        {
            "instance_type": "a1.metal",
            "instance_family": "a1",
            "instance_size": "metal",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.408,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "a1.xlarge",
            "instance_family": "a1",
            "instance_size": "xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.102,
            "on_demand_windows_pricing": 0.286,
        },
        {
            "instance_type": "c1.medium",
            "instance_family": "c1",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "i386, x86_64",
            "cores": 2,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": float("nan"),
            "memory_gb": 1.7,
            "storage_gb": 350.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 6,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.13,
            "on_demand_windows_pricing": 0.21,
        },
        {
            "instance_type": "c1.xlarge",
            "instance_family": "c1",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": float("nan"),
            "memory_gb": 7.0,
            "storage_gb": 1680.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.52,
            "on_demand_windows_pricing": 0.84,
        },
        {
            "instance_type": "c3.2xlarge",
            "instance_family": "c3",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.8,
            "memory_gb": 15.0,
            "storage_gb": 160.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.42,
            "on_demand_windows_pricing": 0.752,
        },
        {
            "instance_type": "c3.4xlarge",
            "instance_family": "c3",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.8,
            "memory_gb": 30.0,
            "storage_gb": 320.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.84,
            "on_demand_windows_pricing": 1.504,
        },
        {
            "instance_type": "c3.8xlarge",
            "instance_family": "c3",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.8,
            "memory_gb": 60.0,
            "storage_gb": 640.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "10 Gigabit",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 1.68,
            "on_demand_windows_pricing": 3.008,
        },
        {
            "instance_type": "c3.large",
            "instance_family": "c3",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "i386, x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.8,
            "memory_gb": 3.75,
            "storage_gb": 32.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.105,
            "on_demand_windows_pricing": 0.188,
        },
        {
            "instance_type": "c3.xlarge",
            "instance_family": "c3",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.8,
            "memory_gb": 7.5,
            "storage_gb": 80.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.21,
            "on_demand_windows_pricing": 0.376,
        },
        {
            "instance_type": "c4.2xlarge",
            "instance_family": "c4",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.9,
            "memory_gb": 15.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.398,
            "on_demand_windows_pricing": 0.766,
        },
        {
            "instance_type": "c4.4xlarge",
            "instance_family": "c4",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.9,
            "memory_gb": 30.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.796,
            "on_demand_windows_pricing": 1.532,
        },
        {
            "instance_type": "c4.8xlarge",
            "instance_family": "c4",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 36,
            "architecture": "x86_64",
            "cores": 18,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.9,
            "memory_gb": 60.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.591,
            "on_demand_windows_pricing": 3.091,
        },
        {
            "instance_type": "c4.large",
            "instance_family": "c4",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.9,
            "memory_gb": 3.75,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1,
            "on_demand_windows_pricing": 0.192,
        },
        {
            "instance_type": "c4.xlarge",
            "instance_family": "c4",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.9,
            "memory_gb": 7.5,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.199,
            "on_demand_windows_pricing": 0.383,
        },
        {
            "instance_type": "c5.12xlarge",
            "instance_family": "c5",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 96.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.04,
            "on_demand_windows_pricing": 4.248,
        },
        {
            "instance_type": "c5.18xlarge",
            "instance_family": "c5",
            "instance_size": "18xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 72,
            "architecture": "x86_64",
            "cores": 36,
            "valid_cores": [
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 144.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.06,
            "on_demand_windows_pricing": 6.372,
        },
        {
            "instance_type": "c5.24xlarge",
            "instance_family": "c5",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.08,
            "on_demand_windows_pricing": 8.496,
        },
        {
            "instance_type": "c5.2xlarge",
            "instance_family": "c5",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.34,
            "on_demand_windows_pricing": 0.708,
        },
        {
            "instance_type": "c5.4xlarge",
            "instance_family": "c5",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.68,
            "on_demand_windows_pricing": 1.416,
        },
        {
            "instance_type": "c5.9xlarge",
            "instance_family": "c5",
            "instance_size": "9xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 36,
            "architecture": "x86_64",
            "cores": 18,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 72.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.53,
            "on_demand_windows_pricing": 3.186,
        },
        {
            "instance_type": "c5.large",
            "instance_family": "c5",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.085,
            "on_demand_windows_pricing": 0.177,
        },
        {
            "instance_type": "c5.metal",
            "instance_family": "c5",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.08,
            "on_demand_windows_pricing": 8.496,
        },
        {
            "instance_type": "c5.xlarge",
            "instance_family": "c5",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.17,
            "on_demand_windows_pricing": 0.354,
        },
        {
            "instance_type": "c5a.12xlarge",
            "instance_family": "c5a",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [1, 2, 3, 4, 8, 12, 16, 20, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 96.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.848,
            "on_demand_windows_pricing": 4.056,
        },
        {
            "instance_type": "c5a.16xlarge",
            "instance_family": "c5a",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [1, 2, 3, 4, 8, 12, 16, 20, 24, 28, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.464,
            "on_demand_windows_pricing": 5.408,
        },
        {
            "instance_type": "c5a.24xlarge",
            "instance_family": "c5a",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [1, 2, 3, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.696,
            "on_demand_windows_pricing": 8.112,
        },
        {
            "instance_type": "c5a.2xlarge",
            "instance_family": "c5a",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.308,
            "on_demand_windows_pricing": 0.676,
        },
        {
            "instance_type": "c5a.4xlarge",
            "instance_family": "c5a",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.616,
            "on_demand_windows_pricing": 1.352,
        },
        {
            "instance_type": "c5a.8xlarge",
            "instance_family": "c5a",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 8, 12, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.232,
            "on_demand_windows_pricing": 2.704,
        },
        {
            "instance_type": "c5a.large",
            "instance_family": "c5a",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.077,
            "on_demand_windows_pricing": 0.169,
        },
        {
            "instance_type": "c5a.xlarge",
            "instance_family": "c5a",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.154,
            "on_demand_windows_pricing": 0.338,
        },
        {
            "instance_type": "c5ad.12xlarge",
            "instance_family": "c5ad",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [1, 2, 3, 4, 8, 12, 16, 20, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 96.0,
            "storage_gb": 1800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.064,
            "on_demand_windows_pricing": 4.272,
        },
        {
            "instance_type": "c5ad.16xlarge",
            "instance_family": "c5ad",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [1, 2, 3, 4, 8, 12, 16, 20, 24, 28, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 128.0,
            "storage_gb": 2400.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.752,
            "on_demand_windows_pricing": 5.696,
        },
        {
            "instance_type": "c5ad.24xlarge",
            "instance_family": "c5ad",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [1, 2, 3, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 192.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.128,
            "on_demand_windows_pricing": 8.544,
        },
        {
            "instance_type": "c5ad.2xlarge",
            "instance_family": "c5ad",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 16.0,
            "storage_gb": 300.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.344,
            "on_demand_windows_pricing": 0.712,
        },
        {
            "instance_type": "c5ad.4xlarge",
            "instance_family": "c5ad",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 32.0,
            "storage_gb": 600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.688,
            "on_demand_windows_pricing": 1.424,
        },
        {
            "instance_type": "c5ad.8xlarge",
            "instance_family": "c5ad",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 8, 12, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 64.0,
            "storage_gb": 1200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.376,
            "on_demand_windows_pricing": 2.848,
        },
        {
            "instance_type": "c5ad.large",
            "instance_family": "c5ad",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 4.0,
            "storage_gb": 75.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.086,
            "on_demand_windows_pricing": 0.178,
        },
        {
            "instance_type": "c5ad.xlarge",
            "instance_family": "c5ad",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 8.0,
            "storage_gb": 150.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.172,
            "on_demand_windows_pricing": 0.356,
        },
        {
            "instance_type": "c5d.12xlarge",
            "instance_family": "c5d",
            "instance_size": "12xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 96.0,
            "storage_gb": 1800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.304,
            "on_demand_windows_pricing": 4.512,
        },
        {
            "instance_type": "c5d.18xlarge",
            "instance_family": "c5d",
            "instance_size": "18xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 72,
            "architecture": "x86_64",
            "cores": 36,
            "valid_cores": [
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 144.0,
            "storage_gb": 1800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.456,
            "on_demand_windows_pricing": 6.768,
        },
        {
            "instance_type": "c5d.24xlarge",
            "instance_family": "c5d",
            "instance_size": "24xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 192.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.608,
            "on_demand_windows_pricing": 9.024,
        },
        {
            "instance_type": "c5d.2xlarge",
            "instance_family": "c5d",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 16.0,
            "storage_gb": 200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.384,
            "on_demand_windows_pricing": 0.752,
        },
        {
            "instance_type": "c5d.4xlarge",
            "instance_family": "c5d",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 32.0,
            "storage_gb": 400.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.768,
            "on_demand_windows_pricing": 1.504,
        },
        {
            "instance_type": "c5d.9xlarge",
            "instance_family": "c5d",
            "instance_size": "9xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 36,
            "architecture": "x86_64",
            "cores": 18,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 72.0,
            "storage_gb": 900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.728,
            "on_demand_windows_pricing": 3.384,
        },
        {
            "instance_type": "c5d.large",
            "instance_family": "c5d",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 4.0,
            "storage_gb": 50.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.096,
            "on_demand_windows_pricing": 0.188,
        },
        {
            "instance_type": "c5d.metal",
            "instance_family": "c5d",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 192.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.608,
            "on_demand_windows_pricing": 9.024,
        },
        {
            "instance_type": "c5d.xlarge",
            "instance_family": "c5d",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 8.0,
            "storage_gb": 100.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.192,
            "on_demand_windows_pricing": 0.376,
        },
        {
            "instance_type": "c5n.18xlarge",
            "instance_family": "c5n",
            "instance_size": "18xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 72,
            "architecture": "x86_64",
            "cores": 36,
            "valid_cores": [
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.888,
            "on_demand_windows_pricing": 7.2,
        },
        {
            "instance_type": "c5n.2xlarge",
            "instance_family": "c5n",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 21.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.432,
            "on_demand_windows_pricing": 0.8,
        },
        {
            "instance_type": "c5n.4xlarge",
            "instance_family": "c5n",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 42.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.864,
            "on_demand_windows_pricing": 1.6,
        },
        {
            "instance_type": "c5n.9xlarge",
            "instance_family": "c5n",
            "instance_size": "9xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 36,
            "architecture": "x86_64",
            "cores": 18,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 96.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.944,
            "on_demand_windows_pricing": 3.6,
        },
        {
            "instance_type": "c5n.large",
            "instance_family": "c5n",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 5.3,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.108,
            "on_demand_windows_pricing": 0.2,
        },
        {
            "instance_type": "c5n.metal",
            "instance_family": "c5n",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 72,
            "architecture": "x86_64",
            "cores": 36,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.888,
            "on_demand_windows_pricing": 7.2,
        },
        {
            "instance_type": "c5n.xlarge",
            "instance_family": "c5n",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.4,
            "memory_gb": 10.5,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.216,
            "on_demand_windows_pricing": 0.4,
        },
        {
            "instance_type": "c6a.12xlarge",
            "instance_family": "c6a",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 16, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 96.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "18.75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.836,
            "on_demand_windows_pricing": 4.044,
        },
        {
            "instance_type": "c6a.16xlarge",
            "instance_family": "c6a",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.448,
            "on_demand_windows_pricing": 5.392,
        },
        {
            "instance_type": "c6a.24xlarge",
            "instance_family": "c6a",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 32, 48],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "37.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.672,
            "on_demand_windows_pricing": 8.088,
        },
        {
            "instance_type": "c6a.2xlarge",
            "instance_family": "c6a",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.306,
            "on_demand_windows_pricing": 0.674,
        },
        {
            "instance_type": "c6a.32xlarge",
            "instance_family": "c6a",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [4, 8, 12, 16, 20, 24, 28, 32, 64],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.896,
            "on_demand_windows_pricing": 10.784,
        },
        {
            "instance_type": "c6a.48xlarge",
            "instance_family": "c6a",
            "instance_size": "48xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 192,
            "architecture": "x86_64",
            "cores": 96,
            "valid_cores": [4, 8, 12, 16, 20, 24, 28, 32, 64, 96],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 7.344,
            "on_demand_windows_pricing": 16.176,
        },
        {
            "instance_type": "c6a.4xlarge",
            "instance_family": "c6a",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.612,
            "on_demand_windows_pricing": 1.348,
        },
        {
            "instance_type": "c6a.8xlarge",
            "instance_family": "c6a",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.224,
            "on_demand_windows_pricing": 2.696,
        },
        {
            "instance_type": "c6a.large",
            "instance_family": "c6a",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0765,
            "on_demand_windows_pricing": 0.1685,
        },
        {
            "instance_type": "c6a.metal",
            "instance_family": "c6a",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 192,
            "architecture": "x86_64",
            "cores": 96,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 7.344,
            "on_demand_windows_pricing": 16.176,
        },
        {
            "instance_type": "c6a.xlarge",
            "instance_family": "c6a",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.153,
            "on_demand_windows_pricing": 0.337,
        },
        {
            "instance_type": "c6g.12xlarge",
            "instance_family": "c6g",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "arm64",
            "cores": 48,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 96.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.632,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6g.16xlarge",
            "instance_family": "c6g",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
                49,
                50,
                51,
                52,
                53,
                54,
                55,
                56,
                57,
                58,
                59,
                60,
                61,
                62,
                63,
                64,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.176,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6g.2xlarge",
            "instance_family": "c6g",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.272,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6g.4xlarge",
            "instance_family": "c6g",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.544,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6g.8xlarge",
            "instance_family": "c6g",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.088,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6g.large",
            "instance_family": "c6g",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.068,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6g.medium",
            "instance_family": "c6g",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 1,
            "architecture": "arm64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 2.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.034,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6g.metal",
            "instance_family": "c6g",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.176,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6g.xlarge",
            "instance_family": "c6g",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.136,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gd.12xlarge",
            "instance_family": "c6gd",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "arm64",
            "cores": 48,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 96.0,
            "storage_gb": 2850.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.8432,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gd.16xlarge",
            "instance_family": "c6gd",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
                49,
                50,
                51,
                52,
                53,
                54,
                55,
                56,
                57,
                58,
                59,
                60,
                61,
                62,
                63,
                64,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.4576,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gd.2xlarge",
            "instance_family": "c6gd",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 474.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.3072,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gd.4xlarge",
            "instance_family": "c6gd",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 950.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.6144,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gd.8xlarge",
            "instance_family": "c6gd",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 1900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.2288,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gd.large",
            "instance_family": "c6gd",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 4.0,
            "storage_gb": 118.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0768,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gd.medium",
            "instance_family": "c6gd",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 1,
            "architecture": "arm64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 2.0,
            "storage_gb": 59.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0384,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gd.metal",
            "instance_family": "c6gd",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.4576,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gd.xlarge",
            "instance_family": "c6gd",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 237.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1536,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gn.12xlarge",
            "instance_family": "c6gn",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "arm64",
            "cores": 48,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 96.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.0736,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gn.16xlarge",
            "instance_family": "c6gn",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
                49,
                50,
                51,
                52,
                53,
                54,
                55,
                56,
                57,
                58,
                59,
                60,
                61,
                62,
                63,
                64,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.7648,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gn.2xlarge",
            "instance_family": "c6gn",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.3456,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gn.4xlarge",
            "instance_family": "c6gn",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.6912,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gn.8xlarge",
            "instance_family": "c6gn",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.3824,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gn.large",
            "instance_family": "c6gn",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0864,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gn.medium",
            "instance_family": "c6gn",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 1,
            "architecture": "arm64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 2.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 16 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0432,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6gn.xlarge",
            "instance_family": "c6gn",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1728,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c6i.12xlarge",
            "instance_family": "c6i",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 96.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "18.75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.04,
            "on_demand_windows_pricing": 4.248,
        },
        {
            "instance_type": "c6i.16xlarge",
            "instance_family": "c6i",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.72,
            "on_demand_windows_pricing": 5.664,
        },
        {
            "instance_type": "c6i.24xlarge",
            "instance_family": "c6i",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "37.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.08,
            "on_demand_windows_pricing": 8.496,
        },
        {
            "instance_type": "c6i.2xlarge",
            "instance_family": "c6i",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.34,
            "on_demand_windows_pricing": 0.708,
        },
        {
            "instance_type": "c6i.32xlarge",
            "instance_family": "c6i",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
                50,
                52,
                54,
                56,
                58,
                60,
                62,
                64,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.44,
            "on_demand_windows_pricing": 11.328,
        },
        {
            "instance_type": "c6i.4xlarge",
            "instance_family": "c6i",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.68,
            "on_demand_windows_pricing": 1.416,
        },
        {
            "instance_type": "c6i.8xlarge",
            "instance_family": "c6i",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.36,
            "on_demand_windows_pricing": 2.832,
        },
        {
            "instance_type": "c6i.large",
            "instance_family": "c6i",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.085,
            "on_demand_windows_pricing": 0.177,
        },
        {
            "instance_type": "c6i.metal",
            "instance_family": "c6i",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.44,
            "on_demand_windows_pricing": 11.328,
        },
        {
            "instance_type": "c6i.xlarge",
            "instance_family": "c6i",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.17,
            "on_demand_windows_pricing": 0.354,
        },
        {
            "instance_type": "c6id.12xlarge",
            "instance_family": "c6id",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 96.0,
            "storage_gb": 2850.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "18.75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.4192,
            "on_demand_windows_pricing": 4.6272,
        },
        {
            "instance_type": "c6id.16xlarge",
            "instance_family": "c6id",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 128.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.2256,
            "on_demand_windows_pricing": 6.1696,
        },
        {
            "instance_type": "c6id.24xlarge",
            "instance_family": "c6id",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 192.0,
            "storage_gb": 5700.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "37.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.8384,
            "on_demand_windows_pricing": 9.2544,
        },
        {
            "instance_type": "c6id.2xlarge",
            "instance_family": "c6id",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 16.0,
            "storage_gb": 474.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.4032,
            "on_demand_windows_pricing": 0.7712,
        },
        {
            "instance_type": "c6id.32xlarge",
            "instance_family": "c6id",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
                50,
                52,
                54,
                56,
                58,
                60,
                62,
                64,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 256.0,
            "storage_gb": 7600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.4512,
            "on_demand_windows_pricing": 12.3392,
        },
        {
            "instance_type": "c6id.4xlarge",
            "instance_family": "c6id",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 32.0,
            "storage_gb": 950.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.8064,
            "on_demand_windows_pricing": 1.5424,
        },
        {
            "instance_type": "c6id.8xlarge",
            "instance_family": "c6id",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 64.0,
            "storage_gb": 1900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.6128,
            "on_demand_windows_pricing": 3.0848,
        },
        {
            "instance_type": "c6id.large",
            "instance_family": "c6id",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 4.0,
            "storage_gb": 118.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1008,
            "on_demand_windows_pricing": 0.1928,
        },
        {
            "instance_type": "c6id.metal",
            "instance_family": "c6id",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 256.0,
            "storage_gb": 7600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.4512,
            "on_demand_windows_pricing": 12.3392,
        },
        {
            "instance_type": "c6id.xlarge",
            "instance_family": "c6id",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 8.0,
            "storage_gb": 237.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.2016,
            "on_demand_windows_pricing": 0.3856,
        },
        {
            "instance_type": "c7g.12xlarge",
            "instance_family": "c7g",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "arm64",
            "cores": 48,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.6,
            "memory_gb": 96.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "22.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.74,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c7g.16xlarge",
            "instance_family": "c7g",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
                49,
                50,
                51,
                52,
                53,
                54,
                55,
                56,
                57,
                58,
                59,
                60,
                61,
                62,
                63,
                64,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.6,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "30 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.32,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c7g.2xlarge",
            "instance_family": "c7g",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.6,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 15 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.29,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c7g.4xlarge",
            "instance_family": "c7g",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.6,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 15 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.58,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c7g.8xlarge",
            "instance_family": "c7g",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.6,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "15 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.16,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c7g.large",
            "instance_family": "c7g",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.6,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0725,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c7g.medium",
            "instance_family": "c7g",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 1,
            "architecture": "arm64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.6,
            "memory_gb": 2.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0363,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "c7g.xlarge",
            "instance_family": "c7g",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.6,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.145,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "cc2.8xlarge",
            "instance_family": "cc2",
            "instance_size": "8xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.6,
            "memory_gb": 60.5,
            "storage_gb": 3360.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "10 Gigabit",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 2.0,
            "on_demand_windows_pricing": 2.57,
        },
        {
            "instance_type": "d2.2xlarge",
            "instance_family": "d2",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.4,
            "memory_gb": 61.0,
            "storage_gb": 12288.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 6,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.38,
            "on_demand_windows_pricing": 1.601,
        },
        {
            "instance_type": "d2.4xlarge",
            "instance_family": "d2",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.4,
            "memory_gb": 122.0,
            "storage_gb": 24576.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 12,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.76,
            "on_demand_windows_pricing": 3.062,
        },
        {
            "instance_type": "d2.8xlarge",
            "instance_family": "d2",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 36,
            "architecture": "x86_64",
            "cores": 18,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.4,
            "memory_gb": 244.0,
            "storage_gb": 49152.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 24,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.52,
            "on_demand_windows_pricing": 6.198,
        },
        {
            "instance_type": "d2.xlarge",
            "instance_family": "d2",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.4,
            "memory_gb": 30.5,
            "storage_gb": 6144.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 3,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.69,
            "on_demand_windows_pricing": 0.821,
        },
        {
            "instance_type": "d3.2xlarge",
            "instance_family": "d3",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 11880.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 6,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 15 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 5,
            "ipv6_addresses_per_interface": 5,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.999,
            "on_demand_windows_pricing": 1.367,
        },
        {
            "instance_type": "d3.4xlarge",
            "instance_family": "d3",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 128.0,
            "storage_gb": 23760.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 12,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 15 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.998,
            "on_demand_windows_pricing": 2.734,
        },
        {
            "instance_type": "d3.8xlarge",
            "instance_family": "d3",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 256.0,
            "storage_gb": 47520.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 24,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 20,
            "ipv6_addresses_per_interface": 20,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.99552,
            "on_demand_windows_pricing": 5.46752,
        },
        {
            "instance_type": "d3.xlarge",
            "instance_family": "d3",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 5940.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 3,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 15 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 3,
            "ipv6_addresses_per_interface": 3,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.499,
            "on_demand_windows_pricing": 0.683,
        },
        {
            "instance_type": "d3en.12xlarge",
            "instance_family": "d3en",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 192.0,
            "storage_gb": 335520.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 24,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.30864,
            "on_demand_windows_pricing": 8.51664,
        },
        {
            "instance_type": "d3en.2xlarge",
            "instance_family": "d3en",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 55920.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 5,
            "ipv6_addresses_per_interface": 5,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.051,
            "on_demand_windows_pricing": 1.419,
        },
        {
            "instance_type": "d3en.4xlarge",
            "instance_family": "d3en",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 111840.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 8,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.103,
            "on_demand_windows_pricing": 2.839,
        },
        {
            "instance_type": "d3en.6xlarge",
            "instance_family": "d3en",
            "instance_size": "6xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 24,
            "architecture": "x86_64",
            "cores": 12,
            "valid_cores": [2, 4, 6, 8, 10, 12],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 96.0,
            "storage_gb": 167760.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 12,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "40 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.154,
            "on_demand_windows_pricing": 4.258,
        },
        {
            "instance_type": "d3en.8xlarge",
            "instance_family": "d3en",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 128.0,
            "storage_gb": 223680.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 16,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 20,
            "ipv6_addresses_per_interface": 20,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.20576,
            "on_demand_windows_pricing": 5.67776,
        },
        {
            "instance_type": "d3en.xlarge",
            "instance_family": "d3en",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 16.0,
            "storage_gb": 27960.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 3,
            "ipv6_addresses_per_interface": 3,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.526,
            "on_demand_windows_pricing": 0.71,
        },
        {
            "instance_type": "dl1.24xlarge",
            "instance_family": "dl1",
            "instance_size": "24xlarge",
            "availability_zones": ["us-east-1b"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.0,
            "memory_gb": 768.0,
            "storage_gb": 4000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "4x 100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 60,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 8,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 13.10904,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "f1.16xlarge",
            "instance_family": "f1",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 976.0,
            "storage_gb": 3760.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 8,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 13.2,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "f1.2xlarge",
            "instance_family": "f1",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 122.0,
            "storage_gb": 470.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 1,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.65,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "f1.4xlarge",
            "instance_family": "f1",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 244.0,
            "storage_gb": 940.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 2,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.3,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "g2.2xlarge",
            "instance_family": "g2",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.6,
            "memory_gb": 15.0,
            "storage_gb": 60.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.65,
            "on_demand_windows_pricing": 0.767,
        },
        {
            "instance_type": "g2.8xlarge",
            "instance_family": "g2",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.6,
            "memory_gb": 60.0,
            "storage_gb": 240.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 4,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 2.6,
            "on_demand_windows_pricing": 2.878,
        },
        {
            "instance_type": "g3.16xlarge",
            "instance_family": "g3",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 488.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 4,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.56,
            "on_demand_windows_pricing": 7.504,
        },
        {
            "instance_type": "g3.4xlarge",
            "instance_family": "g3",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.7,
            "memory_gb": 122.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.14,
            "on_demand_windows_pricing": 1.876,
        },
        {
            "instance_type": "g3.8xlarge",
            "instance_family": "g3",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.7,
            "memory_gb": 244.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 2,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.28,
            "on_demand_windows_pricing": 3.752,
        },
        {
            "instance_type": "g3s.xlarge",
            "instance_family": "g3s",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.7,
            "memory_gb": 30.5,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.75,
            "on_demand_windows_pricing": 0.934,
        },
        {
            "instance_type": "g4ad.16xlarge",
            "instance_family": "g4ad",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 8, 16, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.0,
            "memory_gb": 256.0,
            "storage_gb": 2400.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 4,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.468,
            "on_demand_windows_pricing": 6.412,
        },
        {
            "instance_type": "g4ad.2xlarge",
            "instance_family": "g4ad",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.0,
            "memory_gb": 32.0,
            "storage_gb": 300.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.54117,
            "on_demand_windows_pricing": 0.90917,
        },
        {
            "instance_type": "g4ad.4xlarge",
            "instance_family": "g4ad",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.0,
            "memory_gb": 64.0,
            "storage_gb": 600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.867,
            "on_demand_windows_pricing": 1.603,
        },
        {
            "instance_type": "g4ad.8xlarge",
            "instance_family": "g4ad",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 8, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.0,
            "memory_gb": 128.0,
            "storage_gb": 1200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "15 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 2,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.734,
            "on_demand_windows_pricing": 3.206,
        },
        {
            "instance_type": "g4ad.xlarge",
            "instance_family": "g4ad",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.0,
            "memory_gb": 16.0,
            "storage_gb": 150.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.37853,
            "on_demand_windows_pricing": 0.56253,
        },
        {
            "instance_type": "g4dn.12xlarge",
            "instance_family": "g4dn",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 192.0,
            "storage_gb": 900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 4,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.912,
            "on_demand_windows_pricing": 6.12,
        },
        {
            "instance_type": "g4dn.16xlarge",
            "instance_family": "g4dn",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.352,
            "on_demand_windows_pricing": 7.296,
        },
        {
            "instance_type": "g4dn.2xlarge",
            "instance_family": "g4dn",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 225.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.752,
            "on_demand_windows_pricing": 1.12,
        },
        {
            "instance_type": "g4dn.4xlarge",
            "instance_family": "g4dn",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 225.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.204,
            "on_demand_windows_pricing": 1.94,
        },
        {
            "instance_type": "g4dn.8xlarge",
            "instance_family": "g4dn",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.176,
            "on_demand_windows_pricing": 3.648,
        },
        {
            "instance_type": "g4dn.metal",
            "instance_family": "g4dn",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 384.0,
            "storage_gb": 1800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 8,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 7.824,
            "on_demand_windows_pricing": 12.24,
        },
        {
            "instance_type": "g4dn.xlarge",
            "instance_family": "g4dn",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 125.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.526,
            "on_demand_windows_pricing": 0.71,
        },
        {
            "instance_type": "g5.12xlarge",
            "instance_family": "g5",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 192.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "40 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 4,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.672,
            "on_demand_windows_pricing": 7.88,
        },
        {
            "instance_type": "g5.16xlarge",
            "instance_family": "g5",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 256.0,
            "storage_gb": 1900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.096,
            "on_demand_windows_pricing": 7.04,
        },
        {
            "instance_type": "g5.24xlarge",
            "instance_family": "g5",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 384.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 4,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 8.144,
            "on_demand_windows_pricing": 12.56,
        },
        {
            "instance_type": "g5.2xlarge",
            "instance_family": "g5",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 32.0,
            "storage_gb": 450.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.212,
            "on_demand_windows_pricing": 1.58,
        },
        {
            "instance_type": "g5.48xlarge",
            "instance_family": "g5",
            "instance_size": "48xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 192,
            "architecture": "x86_64",
            "cores": 96,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 768.0,
            "storage_gb": 7600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 8,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 16.288,
            "on_demand_windows_pricing": 25.12,
        },
        {
            "instance_type": "g5.4xlarge",
            "instance_family": "g5",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 64.0,
            "storage_gb": 600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.624,
            "on_demand_windows_pricing": 2.36,
        },
        {
            "instance_type": "g5.8xlarge",
            "instance_family": "g5",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 128.0,
            "storage_gb": 900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.448,
            "on_demand_windows_pricing": 3.92,
        },
        {
            "instance_type": "g5.xlarge",
            "instance_family": "g5",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.3,
            "memory_gb": 16.0,
            "storage_gb": 250.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.006,
            "on_demand_windows_pricing": 1.19,
        },
        {
            "instance_type": "g5g.16xlarge",
            "instance_family": "g5g",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
                49,
                50,
                51,
                52,
                53,
                54,
                55,
                56,
                57,
                58,
                59,
                60,
                61,
                62,
                63,
                64,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 2,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.744,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "g5g.2xlarge",
            "instance_family": "g5g",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.556,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "g5g.4xlarge",
            "instance_family": "g5g",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.828,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "g5g.8xlarge",
            "instance_family": "g5g",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.372,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "g5g.metal",
            "instance_family": "g5g",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 2,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.744,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "g5g.xlarge",
            "instance_family": "g5g",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.42,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "h1.16xlarge",
            "instance_family": "h1",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 256.0,
            "storage_gb": 16000.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 8,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.744,
            "on_demand_windows_pricing": 6.688,
        },
        {
            "instance_type": "h1.2xlarge",
            "instance_family": "h1",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 32.0,
            "storage_gb": 2000.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.468,
            "on_demand_windows_pricing": 0.836,
        },
        {
            "instance_type": "h1.4xlarge",
            "instance_family": "h1",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 64.0,
            "storage_gb": 4000.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.936,
            "on_demand_windows_pricing": 1.672,
        },
        {
            "instance_type": "h1.8xlarge",
            "instance_family": "h1",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 128.0,
            "storage_gb": 8000.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.872,
            "on_demand_windows_pricing": 3.344,
        },
        {
            "instance_type": "i2.2xlarge",
            "instance_family": "i2",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 61.0,
            "storage_gb": 1600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 1.705,
            "on_demand_windows_pricing": 1.946,
        },
        {
            "instance_type": "i2.4xlarge",
            "instance_family": "i2",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 122.0,
            "storage_gb": 3200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 3.41,
            "on_demand_windows_pricing": 3.891,
        },
        {
            "instance_type": "i2.8xlarge",
            "instance_family": "i2",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 244.0,
            "storage_gb": 6400.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 8,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "10 Gigabit",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 6.82,
            "on_demand_windows_pricing": 7.782,
        },
        {
            "instance_type": "i2.xlarge",
            "instance_family": "i2",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 30.5,
            "storage_gb": 800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.853,
            "on_demand_windows_pricing": 0.973,
        },
        {
            "instance_type": "i3.16xlarge",
            "instance_family": "i3",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 488.0,
            "storage_gb": 15200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 8,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.992,
            "on_demand_windows_pricing": 7.936,
        },
        {
            "instance_type": "i3.2xlarge",
            "instance_family": "i3",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 61.0,
            "storage_gb": 1900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.624,
            "on_demand_windows_pricing": 0.992,
        },
        {
            "instance_type": "i3.4xlarge",
            "instance_family": "i3",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 122.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.248,
            "on_demand_windows_pricing": 1.984,
        },
        {
            "instance_type": "i3.8xlarge",
            "instance_family": "i3",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 244.0,
            "storage_gb": 7600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.496,
            "on_demand_windows_pricing": 3.968,
        },
        {
            "instance_type": "i3.large",
            "instance_family": "i3",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 15.3,
            "storage_gb": 475.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.156,
            "on_demand_windows_pricing": 0.248,
        },
        {
            "instance_type": "i3.metal",
            "instance_family": "i3",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 72,
            "architecture": "x86_64",
            "cores": 36,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 512.0,
            "storage_gb": 15200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 8,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.992,
            "on_demand_windows_pricing": 7.936,
        },
        {
            "instance_type": "i3.xlarge",
            "instance_family": "i3",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 30.5,
            "storage_gb": 950.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.312,
            "on_demand_windows_pricing": 0.496,
        },
        {
            "instance_type": "i3en.12xlarge",
            "instance_family": "i3en",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 30000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.424,
            "on_demand_windows_pricing": 7.632,
        },
        {
            "instance_type": "i3en.24xlarge",
            "instance_family": "i3en",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 60000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 8,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 10.848,
            "on_demand_windows_pricing": 15.264,
        },
        {
            "instance_type": "i3en.2xlarge",
            "instance_family": "i3en",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 5000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.904,
            "on_demand_windows_pricing": 1.272,
        },
        {
            "instance_type": "i3en.3xlarge",
            "instance_family": "i3en",
            "instance_size": "3xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 12,
            "architecture": "x86_64",
            "cores": 6,
            "valid_cores": [2, 4, 6],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 96.0,
            "storage_gb": 7500.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.356,
            "on_demand_windows_pricing": 1.908,
        },
        {
            "instance_type": "i3en.6xlarge",
            "instance_family": "i3en",
            "instance_size": "6xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 24,
            "architecture": "x86_64",
            "cores": 12,
            "valid_cores": [2, 4, 6, 8, 10, 12],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 192.0,
            "storage_gb": 15000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.712,
            "on_demand_windows_pricing": 3.816,
        },
        {
            "instance_type": "i3en.large",
            "instance_family": "i3en",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 16.0,
            "storage_gb": 1250.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.226,
            "on_demand_windows_pricing": 0.318,
        },
        {
            "instance_type": "i3en.metal",
            "instance_family": "i3en",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 60000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 8,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 10.848,
            "on_demand_windows_pricing": 15.264,
        },
        {
            "instance_type": "i3en.xlarge",
            "instance_family": "i3en",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 2500.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.452,
            "on_demand_windows_pricing": 0.636,
        },
        {
            "instance_type": "i4i.16xlarge",
            "instance_family": "i4i",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 512.0,
            "storage_gb": 15000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "37.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.491,
            "on_demand_windows_pricing": 8.435,
        },
        {
            "instance_type": "i4i.2xlarge",
            "instance_family": "i4i",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 64.0,
            "storage_gb": 1875.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.686,
            "on_demand_windows_pricing": 1.054,
        },
        {
            "instance_type": "i4i.32xlarge",
            "instance_family": "i4i",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
                50,
                52,
                54,
                56,
                58,
                60,
                62,
                64,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 1024.0,
            "storage_gb": 30000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 8,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 10.9824,
            "on_demand_windows_pricing": 16.8704,
        },
        {
            "instance_type": "i4i.4xlarge",
            "instance_family": "i4i",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 128.0,
            "storage_gb": 3750.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.373,
            "on_demand_windows_pricing": 2.109,
        },
        {
            "instance_type": "i4i.8xlarge",
            "instance_family": "i4i",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 256.0,
            "storage_gb": 7500.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "18.75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.746,
            "on_demand_windows_pricing": 4.218,
        },
        {
            "instance_type": "i4i.large",
            "instance_family": "i4i",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 16.0,
            "storage_gb": 468.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.172,
            "on_demand_windows_pricing": 0.264,
        },
        {
            "instance_type": "i4i.metal",
            "instance_family": "i4i",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 1024.0,
            "storage_gb": 30000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 8,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 10.982,
            "on_demand_windows_pricing": 16.87,
        },
        {
            "instance_type": "i4i.xlarge",
            "instance_family": "i4i",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 32.0,
            "storage_gb": 937.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.343,
            "on_demand_windows_pricing": 0.527,
        },
        {
            "instance_type": "im4gn.16xlarge",
            "instance_family": "im4gn",
            "instance_size": "16xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
                49,
                50,
                51,
                52,
                53,
                54,
                55,
                56,
                57,
                58,
                59,
                60,
                61,
                62,
                63,
                64,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 30000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.82067,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "im4gn.2xlarge",
            "instance_family": "im4gn",
            "instance_size": "2xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 3750.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.72758,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "im4gn.4xlarge",
            "instance_family": "im4gn",
            "instance_size": "4xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 7500.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.45517,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "im4gn.8xlarge",
            "instance_family": "im4gn",
            "instance_size": "8xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 15000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.91034,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "im4gn.large",
            "instance_family": "im4gn",
            "instance_size": "large",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 937.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1819,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "im4gn.xlarge",
            "instance_family": "im4gn",
            "instance_size": "xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 1875.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.36379,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "inf1.24xlarge",
            "instance_family": "inf1",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 11,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.721,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "inf1.2xlarge",
            "instance_family": "inf1",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.362,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "inf1.6xlarge",
            "instance_family": "inf1",
            "instance_size": "6xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 24,
            "architecture": "x86_64",
            "cores": 12,
            "valid_cores": [2, 4, 6, 8, 10, 12],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 48.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.18,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "inf1.xlarge",
            "instance_family": "inf1",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.228,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "is4gen.2xlarge",
            "instance_family": "is4gen",
            "instance_size": "2xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 48.0,
            "storage_gb": 7500.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.1526,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "is4gen.4xlarge",
            "instance_family": "is4gen",
            "instance_size": "4xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 96.0,
            "storage_gb": 15000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.3052,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "is4gen.8xlarge",
            "instance_family": "is4gen",
            "instance_size": "8xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 192.0,
            "storage_gb": 30000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.6104,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "is4gen.large",
            "instance_family": "is4gen",
            "instance_size": "large",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 12.0,
            "storage_gb": 1875.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.28815,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "is4gen.medium",
            "instance_family": "is4gen",
            "instance_size": "medium",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 1,
            "architecture": "arm64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 6.0,
            "storage_gb": 937.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.14408,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "is4gen.xlarge",
            "instance_family": "is4gen",
            "instance_size": "xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 24.0,
            "storage_gb": 3750.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.5763,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m1.large",
            "instance_family": "m1",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": float("nan"),
            "memory_gb": 7.5,
            "storage_gb": 840.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.175,
            "on_demand_windows_pricing": 0.299,
        },
        {
            "instance_type": "m1.medium",
            "instance_family": "m1",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 1,
            "architecture": "i386, x86_64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": float("nan"),
            "memory_gb": 3.7,
            "storage_gb": 410.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 6,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.087,
            "on_demand_windows_pricing": 0.149,
        },
        {
            "instance_type": "m1.small",
            "instance_family": "m1",
            "instance_size": "small",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 1,
            "architecture": "i386, x86_64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": float("nan"),
            "memory_gb": 1.7,
            "storage_gb": 160.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Low",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.044,
            "on_demand_windows_pricing": 0.075,
        },
        {
            "instance_type": "m1.xlarge",
            "instance_family": "m1",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": float("nan"),
            "memory_gb": 15.0,
            "storage_gb": 1680.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.35,
            "on_demand_windows_pricing": 0.598,
        },
        {
            "instance_type": "m2.2xlarge",
            "instance_family": "m2",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": float("nan"),
            "memory_gb": 34.2,
            "storage_gb": 850.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.49,
            "on_demand_windows_pricing": 0.69,
        },
        {
            "instance_type": "m2.4xlarge",
            "instance_family": "m2",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": float("nan"),
            "memory_gb": 68.4,
            "storage_gb": 1680.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.98,
            "on_demand_windows_pricing": 1.38,
        },
        {
            "instance_type": "m2.xlarge",
            "instance_family": "m2",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": float("nan"),
            "memory_gb": 17.1,
            "storage_gb": 420.0,
            "local_instance_storage": True,
            "storage_type": "hdd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.245,
            "on_demand_windows_pricing": 0.345,
        },
        {
            "instance_type": "m3.2xlarge",
            "instance_family": "m3",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 30.0,
            "storage_gb": 160.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.532,
            "on_demand_windows_pricing": 1.036,
        },
        {
            "instance_type": "m3.large",
            "instance_family": "m3",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 7.5,
            "storage_gb": 32.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.133,
            "on_demand_windows_pricing": 0.259,
        },
        {
            "instance_type": "m3.medium",
            "instance_family": "m3",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 1,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 3.75,
            "storage_gb": 4.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 6,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.067,
            "on_demand_windows_pricing": 0.13,
        },
        {
            "instance_type": "m3.xlarge",
            "instance_family": "m3",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 15.0,
            "storage_gb": 80.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.266,
            "on_demand_windows_pricing": 0.518,
        },
        {
            "instance_type": "m4.10xlarge",
            "instance_family": "m4",
            "instance_size": "10xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 40,
            "architecture": "x86_64",
            "cores": 20,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.4,
            "memory_gb": 160.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.0,
            "on_demand_windows_pricing": 3.84,
        },
        {
            "instance_type": "m4.16xlarge",
            "instance_family": "m4",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.2,
            "on_demand_windows_pricing": 6.144,
        },
        {
            "instance_type": "m4.2xlarge",
            "instance_family": "m4",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.4,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.4,
            "on_demand_windows_pricing": 0.768,
        },
        {
            "instance_type": "m4.4xlarge",
            "instance_family": "m4",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.4,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.8,
            "on_demand_windows_pricing": 1.536,
        },
        {
            "instance_type": "m4.large",
            "instance_family": "m4",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.4,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1,
            "on_demand_windows_pricing": 0.192,
        },
        {
            "instance_type": "m4.xlarge",
            "instance_family": "m4",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.4,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.2,
            "on_demand_windows_pricing": 0.384,
        },
        {
            "instance_type": "m5.12xlarge",
            "instance_family": "m5",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.304,
            "on_demand_windows_pricing": 4.512,
        },
        {
            "instance_type": "m5.16xlarge",
            "instance_family": "m5",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.072,
            "on_demand_windows_pricing": 6.016,
        },
        {
            "instance_type": "m5.24xlarge",
            "instance_family": "m5",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.608,
            "on_demand_windows_pricing": 9.024,
        },
        {
            "instance_type": "m5.2xlarge",
            "instance_family": "m5",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.384,
            "on_demand_windows_pricing": 0.752,
        },
        {
            "instance_type": "m5.4xlarge",
            "instance_family": "m5",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.768,
            "on_demand_windows_pricing": 1.504,
        },
        {
            "instance_type": "m5.8xlarge",
            "instance_family": "m5",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.536,
            "on_demand_windows_pricing": 3.008,
        },
        {
            "instance_type": "m5.large",
            "instance_family": "m5",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.096,
            "on_demand_windows_pricing": 0.188,
        },
        {
            "instance_type": "m5.metal",
            "instance_family": "m5",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.608,
            "on_demand_windows_pricing": 9.024,
        },
        {
            "instance_type": "m5.xlarge",
            "instance_family": "m5",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.192,
            "on_demand_windows_pricing": 0.376,
        },
        {
            "instance_type": "m5a.12xlarge",
            "instance_family": "m5a",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [6, 12, 18, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.064,
            "on_demand_windows_pricing": 4.272,
        },
        {
            "instance_type": "m5a.16xlarge",
            "instance_family": "m5a",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.752,
            "on_demand_windows_pricing": 5.696,
        },
        {
            "instance_type": "m5a.24xlarge",
            "instance_family": "m5a",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [12, 18, 24, 36, 48],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.128,
            "on_demand_windows_pricing": 8.544,
        },
        {
            "instance_type": "m5a.2xlarge",
            "instance_family": "m5a",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.344,
            "on_demand_windows_pricing": 0.712,
        },
        {
            "instance_type": "m5a.4xlarge",
            "instance_family": "m5a",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.688,
            "on_demand_windows_pricing": 1.424,
        },
        {
            "instance_type": "m5a.8xlarge",
            "instance_family": "m5a",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.376,
            "on_demand_windows_pricing": 2.848,
        },
        {
            "instance_type": "m5a.large",
            "instance_family": "m5a",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.086,
            "on_demand_windows_pricing": 0.178,
        },
        {
            "instance_type": "m5a.xlarge",
            "instance_family": "m5a",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.172,
            "on_demand_windows_pricing": 0.356,
        },
        {
            "instance_type": "m5ad.12xlarge",
            "instance_family": "m5ad",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [6, 12, 18, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 192.0,
            "storage_gb": 1800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.472,
            "on_demand_windows_pricing": 4.68,
        },
        {
            "instance_type": "m5ad.16xlarge",
            "instance_family": "m5ad",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 2400.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.296,
            "on_demand_windows_pricing": 6.24,
        },
        {
            "instance_type": "m5ad.24xlarge",
            "instance_family": "m5ad",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [12, 18, 24, 36, 48],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 384.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.944,
            "on_demand_windows_pricing": 9.36,
        },
        {
            "instance_type": "m5ad.2xlarge",
            "instance_family": "m5ad",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 32.0,
            "storage_gb": 300.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.412,
            "on_demand_windows_pricing": 0.78,
        },
        {
            "instance_type": "m5ad.4xlarge",
            "instance_family": "m5ad",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 64.0,
            "storage_gb": 600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.824,
            "on_demand_windows_pricing": 1.56,
        },
        {
            "instance_type": "m5ad.8xlarge",
            "instance_family": "m5ad",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 1200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.648,
            "on_demand_windows_pricing": 3.12,
        },
        {
            "instance_type": "m5ad.large",
            "instance_family": "m5ad",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 8.0,
            "storage_gb": 75.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.103,
            "on_demand_windows_pricing": 0.195,
        },
        {
            "instance_type": "m5ad.xlarge",
            "instance_family": "m5ad",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 16.0,
            "storage_gb": 150.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.206,
            "on_demand_windows_pricing": 0.39,
        },
        {
            "instance_type": "m5d.12xlarge",
            "instance_family": "m5d",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 192.0,
            "storage_gb": 1800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.712,
            "on_demand_windows_pricing": 4.92,
        },
        {
            "instance_type": "m5d.16xlarge",
            "instance_family": "m5d",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 256.0,
            "storage_gb": 2400.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.616,
            "on_demand_windows_pricing": 6.56,
        },
        {
            "instance_type": "m5d.24xlarge",
            "instance_family": "m5d",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.424,
            "on_demand_windows_pricing": 9.84,
        },
        {
            "instance_type": "m5d.2xlarge",
            "instance_family": "m5d",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 300.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.452,
            "on_demand_windows_pricing": 0.82,
        },
        {
            "instance_type": "m5d.4xlarge",
            "instance_family": "m5d",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.904,
            "on_demand_windows_pricing": 1.64,
        },
        {
            "instance_type": "m5d.8xlarge",
            "instance_family": "m5d",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 128.0,
            "storage_gb": 1200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.808,
            "on_demand_windows_pricing": 3.28,
        },
        {
            "instance_type": "m5d.large",
            "instance_family": "m5d",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 8.0,
            "storage_gb": 75.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.113,
            "on_demand_windows_pricing": 0.205,
        },
        {
            "instance_type": "m5d.metal",
            "instance_family": "m5d",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.424,
            "on_demand_windows_pricing": 9.84,
        },
        {
            "instance_type": "m5d.xlarge",
            "instance_family": "m5d",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 16.0,
            "storage_gb": 150.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.226,
            "on_demand_windows_pricing": 0.41,
        },
        {
            "instance_type": "m5dn.12xlarge",
            "instance_family": "m5dn",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 192.0,
            "storage_gb": 1800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.264,
            "on_demand_windows_pricing": 5.472,
        },
        {
            "instance_type": "m5dn.16xlarge",
            "instance_family": "m5dn",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 256.0,
            "storage_gb": 2400.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.352,
            "on_demand_windows_pricing": 7.296,
        },
        {
            "instance_type": "m5dn.24xlarge",
            "instance_family": "m5dn",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.528,
            "on_demand_windows_pricing": 10.944,
        },
        {
            "instance_type": "m5dn.2xlarge",
            "instance_family": "m5dn",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 300.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.544,
            "on_demand_windows_pricing": 0.912,
        },
        {
            "instance_type": "m5dn.4xlarge",
            "instance_family": "m5dn",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.088,
            "on_demand_windows_pricing": 1.824,
        },
        {
            "instance_type": "m5dn.8xlarge",
            "instance_family": "m5dn",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 128.0,
            "storage_gb": 1200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.176,
            "on_demand_windows_pricing": 3.648,
        },
        {
            "instance_type": "m5dn.large",
            "instance_family": "m5dn",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 8.0,
            "storage_gb": 75.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.136,
            "on_demand_windows_pricing": 0.228,
        },
        {
            "instance_type": "m5dn.metal",
            "instance_family": "m5dn",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.528,
            "on_demand_windows_pricing": 10.944,
        },
        {
            "instance_type": "m5dn.xlarge",
            "instance_family": "m5dn",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 16.0,
            "storage_gb": 150.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.272,
            "on_demand_windows_pricing": 0.456,
        },
        {
            "instance_type": "m5n.12xlarge",
            "instance_family": "m5n",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.856,
            "on_demand_windows_pricing": 5.064,
        },
        {
            "instance_type": "m5n.16xlarge",
            "instance_family": "m5n",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.808,
            "on_demand_windows_pricing": 6.752,
        },
        {
            "instance_type": "m5n.24xlarge",
            "instance_family": "m5n",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.712,
            "on_demand_windows_pricing": 10.128,
        },
        {
            "instance_type": "m5n.2xlarge",
            "instance_family": "m5n",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.476,
            "on_demand_windows_pricing": 0.844,
        },
        {
            "instance_type": "m5n.4xlarge",
            "instance_family": "m5n",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.952,
            "on_demand_windows_pricing": 1.688,
        },
        {
            "instance_type": "m5n.8xlarge",
            "instance_family": "m5n",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.904,
            "on_demand_windows_pricing": 3.376,
        },
        {
            "instance_type": "m5n.large",
            "instance_family": "m5n",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.119,
            "on_demand_windows_pricing": 0.211,
        },
        {
            "instance_type": "m5n.metal",
            "instance_family": "m5n",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.712,
            "on_demand_windows_pricing": 10.128,
        },
        {
            "instance_type": "m5n.xlarge",
            "instance_family": "m5n",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.238,
            "on_demand_windows_pricing": 0.422,
        },
        {
            "instance_type": "m5zn.12xlarge",
            "instance_family": "m5zn",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 4.5,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.9641,
            "on_demand_windows_pricing": 6.1721,
        },
        {
            "instance_type": "m5zn.2xlarge",
            "instance_family": "m5zn",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 4.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.6607,
            "on_demand_windows_pricing": 1.0287,
        },
        {
            "instance_type": "m5zn.3xlarge",
            "instance_family": "m5zn",
            "instance_size": "3xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 12,
            "architecture": "x86_64",
            "cores": 6,
            "valid_cores": [2, 4, 6],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 4.5,
            "memory_gb": 48.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.991,
            "on_demand_windows_pricing": 1.543,
        },
        {
            "instance_type": "m5zn.6xlarge",
            "instance_family": "m5zn",
            "instance_size": "6xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 24,
            "architecture": "x86_64",
            "cores": 12,
            "valid_cores": [2, 4, 6, 8, 10, 12],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 4.5,
            "memory_gb": 96.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.982,
            "on_demand_windows_pricing": 3.086,
        },
        {
            "instance_type": "m5zn.large",
            "instance_family": "m5zn",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 4.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1652,
            "on_demand_windows_pricing": 0.2572,
        },
        {
            "instance_type": "m5zn.metal",
            "instance_family": "m5zn",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 4.5,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.9641,
            "on_demand_windows_pricing": 6.1721,
        },
        {
            "instance_type": "m5zn.xlarge",
            "instance_family": "m5zn",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 4.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.3303,
            "on_demand_windows_pricing": 0.5143,
        },
        {
            "instance_type": "m6a.12xlarge",
            "instance_family": "m6a",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 16, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "18.75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.0736,
            "on_demand_windows_pricing": 4.2816,
        },
        {
            "instance_type": "m6a.16xlarge",
            "instance_family": "m6a",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.7648,
            "on_demand_windows_pricing": 5.7088,
        },
        {
            "instance_type": "m6a.24xlarge",
            "instance_family": "m6a",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 32, 48],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "37.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.1472,
            "on_demand_windows_pricing": 8.5632,
        },
        {
            "instance_type": "m6a.2xlarge",
            "instance_family": "m6a",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.3456,
            "on_demand_windows_pricing": 0.7136,
        },
        {
            "instance_type": "m6a.32xlarge",
            "instance_family": "m6a",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [4, 8, 12, 16, 20, 24, 28, 32, 64],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 512.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.5296,
            "on_demand_windows_pricing": 11.4176,
        },
        {
            "instance_type": "m6a.48xlarge",
            "instance_family": "m6a",
            "instance_size": "48xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 192,
            "architecture": "x86_64",
            "cores": 96,
            "valid_cores": [4, 8, 12, 16, 20, 24, 28, 32, 64, 96],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 768.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 8.2944,
            "on_demand_windows_pricing": 17.1264,
        },
        {
            "instance_type": "m6a.4xlarge",
            "instance_family": "m6a",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.6912,
            "on_demand_windows_pricing": 1.4272,
        },
        {
            "instance_type": "m6a.8xlarge",
            "instance_family": "m6a",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.3824,
            "on_demand_windows_pricing": 2.8544,
        },
        {
            "instance_type": "m6a.large",
            "instance_family": "m6a",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0864,
            "on_demand_windows_pricing": 0.1784,
        },
        {
            "instance_type": "m6a.metal",
            "instance_family": "m6a",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 192,
            "architecture": "x86_64",
            "cores": 96,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 768.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 8.2944,
            "on_demand_windows_pricing": 17.1264,
        },
        {
            "instance_type": "m6a.xlarge",
            "instance_family": "m6a",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.6,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1728,
            "on_demand_windows_pricing": 0.3568,
        },
        {
            "instance_type": "m6g.12xlarge",
            "instance_family": "m6g",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "arm64",
            "cores": 48,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.848,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6g.16xlarge",
            "instance_family": "m6g",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
                49,
                50,
                51,
                52,
                53,
                54,
                55,
                56,
                57,
                58,
                59,
                60,
                61,
                62,
                63,
                64,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.464,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6g.2xlarge",
            "instance_family": "m6g",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.308,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6g.4xlarge",
            "instance_family": "m6g",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.616,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6g.8xlarge",
            "instance_family": "m6g",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.232,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6g.large",
            "instance_family": "m6g",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.077,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6g.medium",
            "instance_family": "m6g",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 1,
            "architecture": "arm64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0385,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6g.metal",
            "instance_family": "m6g",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.464,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6g.xlarge",
            "instance_family": "m6g",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.154,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6gd.12xlarge",
            "instance_family": "m6gd",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "arm64",
            "cores": 48,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 192.0,
            "storage_gb": 2850.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.1696,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6gd.16xlarge",
            "instance_family": "m6gd",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
                49,
                50,
                51,
                52,
                53,
                54,
                55,
                56,
                57,
                58,
                59,
                60,
                61,
                62,
                63,
                64,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.8928,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6gd.2xlarge",
            "instance_family": "m6gd",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 474.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.3616,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6gd.4xlarge",
            "instance_family": "m6gd",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 950.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.7232,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6gd.8xlarge",
            "instance_family": "m6gd",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 1900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.4464,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6gd.large",
            "instance_family": "m6gd",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 118.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0904,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6gd.medium",
            "instance_family": "m6gd",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 1,
            "architecture": "arm64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 4.0,
            "storage_gb": 59.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0452,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6gd.metal",
            "instance_family": "m6gd",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.8928,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6gd.xlarge",
            "instance_family": "m6gd",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 237.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1808,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "m6i.12xlarge",
            "instance_family": "m6i",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "18.75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.304,
            "on_demand_windows_pricing": 4.512,
        },
        {
            "instance_type": "m6i.16xlarge",
            "instance_family": "m6i",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.072,
            "on_demand_windows_pricing": 6.016,
        },
        {
            "instance_type": "m6i.24xlarge",
            "instance_family": "m6i",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "37.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.608,
            "on_demand_windows_pricing": 9.024,
        },
        {
            "instance_type": "m6i.2xlarge",
            "instance_family": "m6i",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.384,
            "on_demand_windows_pricing": 0.752,
        },
        {
            "instance_type": "m6i.32xlarge",
            "instance_family": "m6i",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
                50,
                52,
                54,
                56,
                58,
                60,
                62,
                64,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 512.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.144,
            "on_demand_windows_pricing": 12.032,
        },
        {
            "instance_type": "m6i.4xlarge",
            "instance_family": "m6i",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.768,
            "on_demand_windows_pricing": 1.504,
        },
        {
            "instance_type": "m6i.8xlarge",
            "instance_family": "m6i",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.536,
            "on_demand_windows_pricing": 3.008,
        },
        {
            "instance_type": "m6i.large",
            "instance_family": "m6i",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.096,
            "on_demand_windows_pricing": 0.188,
        },
        {
            "instance_type": "m6i.metal",
            "instance_family": "m6i",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 512.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.144,
            "on_demand_windows_pricing": 12.032,
        },
        {
            "instance_type": "m6i.xlarge",
            "instance_family": "m6i",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.192,
            "on_demand_windows_pricing": 0.376,
        },
        {
            "instance_type": "m6id.12xlarge",
            "instance_family": "m6id",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 192.0,
            "storage_gb": 2850.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "18.75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.8476,
            "on_demand_windows_pricing": 5.0556,
        },
        {
            "instance_type": "m6id.16xlarge",
            "instance_family": "m6id",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 256.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.7968,
            "on_demand_windows_pricing": 6.7408,
        },
        {
            "instance_type": "m6id.24xlarge",
            "instance_family": "m6id",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 384.0,
            "storage_gb": 5700.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "37.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.6952,
            "on_demand_windows_pricing": 10.1112,
        },
        {
            "instance_type": "m6id.2xlarge",
            "instance_family": "m6id",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 32.0,
            "storage_gb": 474.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.4746,
            "on_demand_windows_pricing": 0.8426,
        },
        {
            "instance_type": "m6id.32xlarge",
            "instance_family": "m6id",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
                50,
                52,
                54,
                56,
                58,
                60,
                62,
                64,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 512.0,
            "storage_gb": 7600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 7.5936,
            "on_demand_windows_pricing": 13.4816,
        },
        {
            "instance_type": "m6id.4xlarge",
            "instance_family": "m6id",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 64.0,
            "storage_gb": 950.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.9492,
            "on_demand_windows_pricing": 1.6852,
        },
        {
            "instance_type": "m6id.8xlarge",
            "instance_family": "m6id",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 128.0,
            "storage_gb": 1900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.8984,
            "on_demand_windows_pricing": 3.3704,
        },
        {
            "instance_type": "m6id.large",
            "instance_family": "m6id",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 8.0,
            "storage_gb": 118.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.11865,
            "on_demand_windows_pricing": 0.21065,
        },
        {
            "instance_type": "m6id.metal",
            "instance_family": "m6id",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 512.0,
            "storage_gb": 7600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 7.5936,
            "on_demand_windows_pricing": 13.4816,
        },
        {
            "instance_type": "m6id.xlarge",
            "instance_family": "m6id",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 16.0,
            "storage_gb": 237.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.2373,
            "on_demand_windows_pricing": 0.4213,
        },
        {
            "instance_type": "mac1.metal",
            "instance_family": "mac1",
            "instance_size": "metal",
            "availability_zones": ["us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 12,
            "architecture": "x86_64_mac",
            "cores": 6,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.2,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": float("nan"),
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "p2.16xlarge",
            "instance_family": "p2",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 732.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 16,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 14.4,
            "on_demand_windows_pricing": 17.344,
        },
        {
            "instance_type": "p2.8xlarge",
            "instance_family": "p2",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.7,
            "memory_gb": 488.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 8,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 7.2,
            "on_demand_windows_pricing": 8.672,
        },
        {
            "instance_type": "p2.xlarge",
            "instance_family": "p2",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.7,
            "memory_gb": 61.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "High",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.9,
            "on_demand_windows_pricing": 1.084,
        },
        {
            "instance_type": "p3.16xlarge",
            "instance_family": "p3",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.7,
            "memory_gb": 488.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 8,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 24.48,
            "on_demand_windows_pricing": 27.424,
        },
        {
            "instance_type": "p3.2xlarge",
            "instance_family": "p3",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.7,
            "memory_gb": 61.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 1,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.06,
            "on_demand_windows_pricing": 3.428,
        },
        {
            "instance_type": "p3.8xlarge",
            "instance_family": "p3",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.7,
            "memory_gb": 244.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 4,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 12.24,
            "on_demand_windows_pricing": 13.712,
        },
        {
            "instance_type": "p3dn.24xlarge",
            "instance_family": "p3dn",
            "instance_size": "24xlarge",
            "availability_zones": ["us-east-1a", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 768.0,
            "storage_gb": 1800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 8,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 31.212,
            "on_demand_windows_pricing": 35.628,
        },
        {
            "instance_type": "p4d.24xlarge",
            "instance_family": "p4d",
            "instance_size": "24xlarge",
            "availability_zones": ["us-east-1a", "us-east-1b", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.0,
            "memory_gb": 1152.0,
            "storage_gb": 8000.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 8,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "4x 100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 60,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 8,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 32.7726,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r3.2xlarge",
            "instance_family": "r3",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 61.0,
            "storage_gb": 160.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.665,
            "on_demand_windows_pricing": 1.045,
        },
        {
            "instance_type": "r3.4xlarge",
            "instance_family": "r3",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 122.0,
            "storage_gb": 320.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "High",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 1.33,
            "on_demand_windows_pricing": 1.944,
        },
        {
            "instance_type": "r3.8xlarge",
            "instance_family": "r3",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 244.0,
            "storage_gb": 640.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "10 Gigabit",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 2.66,
            "on_demand_windows_pricing": 3.5,
        },
        {
            "instance_type": "r3.large",
            "instance_family": "r3",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 15.0,
            "storage_gb": 32.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.166,
            "on_demand_windows_pricing": 0.291,
        },
        {
            "instance_type": "r3.xlarge",
            "instance_family": "r3",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 30.5,
            "storage_gb": 80.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "supported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.333,
            "on_demand_windows_pricing": 0.583,
        },
        {
            "instance_type": "r4.16xlarge",
            "instance_family": "r4",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 488.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.256,
            "on_demand_windows_pricing": 7.2,
        },
        {
            "instance_type": "r4.2xlarge",
            "instance_family": "r4",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 61.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.532,
            "on_demand_windows_pricing": 0.9,
        },
        {
            "instance_type": "r4.4xlarge",
            "instance_family": "r4",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 122.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.064,
            "on_demand_windows_pricing": 1.8,
        },
        {
            "instance_type": "r4.8xlarge",
            "instance_family": "r4",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 244.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.128,
            "on_demand_windows_pricing": 3.6,
        },
        {
            "instance_type": "r4.large",
            "instance_family": "r4",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 15.3,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.133,
            "on_demand_windows_pricing": 0.225,
        },
        {
            "instance_type": "r4.xlarge",
            "instance_family": "r4",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 30.5,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.266,
            "on_demand_windows_pricing": 0.45,
        },
        {
            "instance_type": "r5.12xlarge",
            "instance_family": "r5",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.024,
            "on_demand_windows_pricing": 5.232,
        },
        {
            "instance_type": "r5.16xlarge",
            "instance_family": "r5",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 512.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.032,
            "on_demand_windows_pricing": 6.976,
        },
        {
            "instance_type": "r5.24xlarge",
            "instance_family": "r5",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.048,
            "on_demand_windows_pricing": 10.464,
        },
        {
            "instance_type": "r5.2xlarge",
            "instance_family": "r5",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.504,
            "on_demand_windows_pricing": 0.872,
        },
        {
            "instance_type": "r5.4xlarge",
            "instance_family": "r5",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.008,
            "on_demand_windows_pricing": 1.744,
        },
        {
            "instance_type": "r5.8xlarge",
            "instance_family": "r5",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.016,
            "on_demand_windows_pricing": 3.488,
        },
        {
            "instance_type": "r5.large",
            "instance_family": "r5",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.126,
            "on_demand_windows_pricing": 0.218,
        },
        {
            "instance_type": "r5.metal",
            "instance_family": "r5",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.048,
            "on_demand_windows_pricing": 10.464,
        },
        {
            "instance_type": "r5.xlarge",
            "instance_family": "r5",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.252,
            "on_demand_windows_pricing": 0.436,
        },
        {
            "instance_type": "r5a.12xlarge",
            "instance_family": "r5a",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [6, 12, 18, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.712,
            "on_demand_windows_pricing": 4.92,
        },
        {
            "instance_type": "r5a.16xlarge",
            "instance_family": "r5a",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 512.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.616,
            "on_demand_windows_pricing": 6.56,
        },
        {
            "instance_type": "r5a.24xlarge",
            "instance_family": "r5a",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [12, 18, 24, 36, 48],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 768.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.424,
            "on_demand_windows_pricing": 9.84,
        },
        {
            "instance_type": "r5a.2xlarge",
            "instance_family": "r5a",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.452,
            "on_demand_windows_pricing": 0.82,
        },
        {
            "instance_type": "r5a.4xlarge",
            "instance_family": "r5a",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.904,
            "on_demand_windows_pricing": 1.64,
        },
        {
            "instance_type": "r5a.8xlarge",
            "instance_family": "r5a",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.808,
            "on_demand_windows_pricing": 3.28,
        },
        {
            "instance_type": "r5a.large",
            "instance_family": "r5a",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.113,
            "on_demand_windows_pricing": 0.205,
        },
        {
            "instance_type": "r5a.xlarge",
            "instance_family": "r5a",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.226,
            "on_demand_windows_pricing": 0.41,
        },
        {
            "instance_type": "r5ad.12xlarge",
            "instance_family": "r5ad",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [6, 12, 18, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 384.0,
            "storage_gb": 1800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.144,
            "on_demand_windows_pricing": 5.352,
        },
        {
            "instance_type": "r5ad.16xlarge",
            "instance_family": "r5ad",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 512.0,
            "storage_gb": 2400.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.192,
            "on_demand_windows_pricing": 7.136,
        },
        {
            "instance_type": "r5ad.24xlarge",
            "instance_family": "r5ad",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [12, 18, 24, 36, 48],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 768.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.288,
            "on_demand_windows_pricing": 10.704,
        },
        {
            "instance_type": "r5ad.2xlarge",
            "instance_family": "r5ad",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 64.0,
            "storage_gb": 300.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.524,
            "on_demand_windows_pricing": 0.892,
        },
        {
            "instance_type": "r5ad.4xlarge",
            "instance_family": "r5ad",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 128.0,
            "storage_gb": 600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.048,
            "on_demand_windows_pricing": 1.784,
        },
        {
            "instance_type": "r5ad.8xlarge",
            "instance_family": "r5ad",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 1200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.096,
            "on_demand_windows_pricing": 3.568,
        },
        {
            "instance_type": "r5ad.large",
            "instance_family": "r5ad",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 16.0,
            "storage_gb": 75.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.131,
            "on_demand_windows_pricing": 0.223,
        },
        {
            "instance_type": "r5ad.xlarge",
            "instance_family": "r5ad",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 32.0,
            "storage_gb": 150.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.262,
            "on_demand_windows_pricing": 0.446,
        },
        {
            "instance_type": "r5b.12xlarge",
            "instance_family": "r5b",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.576,
            "on_demand_windows_pricing": 5.784,
        },
        {
            "instance_type": "r5b.16xlarge",
            "instance_family": "r5b",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 512.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.768,
            "on_demand_windows_pricing": 7.712,
        },
        {
            "instance_type": "r5b.24xlarge",
            "instance_family": "r5b",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 7.152,
            "on_demand_windows_pricing": 11.568,
        },
        {
            "instance_type": "r5b.2xlarge",
            "instance_family": "r5b",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.596,
            "on_demand_windows_pricing": 0.964,
        },
        {
            "instance_type": "r5b.4xlarge",
            "instance_family": "r5b",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.192,
            "on_demand_windows_pricing": 1.928,
        },
        {
            "instance_type": "r5b.8xlarge",
            "instance_family": "r5b",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.384,
            "on_demand_windows_pricing": 3.856,
        },
        {
            "instance_type": "r5b.large",
            "instance_family": "r5b",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.149,
            "on_demand_windows_pricing": 0.241,
        },
        {
            "instance_type": "r5b.metal",
            "instance_family": "r5b",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 7.152,
            "on_demand_windows_pricing": 11.568,
        },
        {
            "instance_type": "r5b.xlarge",
            "instance_family": "r5b",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.298,
            "on_demand_windows_pricing": 0.482,
        },
        {
            "instance_type": "r5d.12xlarge",
            "instance_family": "r5d",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 1800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.456,
            "on_demand_windows_pricing": 5.664,
        },
        {
            "instance_type": "r5d.16xlarge",
            "instance_family": "r5d",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 512.0,
            "storage_gb": 2400.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.608,
            "on_demand_windows_pricing": 7.552,
        },
        {
            "instance_type": "r5d.24xlarge",
            "instance_family": "r5d",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.912,
            "on_demand_windows_pricing": 11.328,
        },
        {
            "instance_type": "r5d.2xlarge",
            "instance_family": "r5d",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 300.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.576,
            "on_demand_windows_pricing": 0.944,
        },
        {
            "instance_type": "r5d.4xlarge",
            "instance_family": "r5d",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 128.0,
            "storage_gb": 600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.152,
            "on_demand_windows_pricing": 1.888,
        },
        {
            "instance_type": "r5d.8xlarge",
            "instance_family": "r5d",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 256.0,
            "storage_gb": 1200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.304,
            "on_demand_windows_pricing": 3.776,
        },
        {
            "instance_type": "r5d.large",
            "instance_family": "r5d",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 16.0,
            "storage_gb": 75.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.144,
            "on_demand_windows_pricing": 0.236,
        },
        {
            "instance_type": "r5d.metal",
            "instance_family": "r5d",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.912,
            "on_demand_windows_pricing": 11.328,
        },
        {
            "instance_type": "r5d.xlarge",
            "instance_family": "r5d",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 150.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.288,
            "on_demand_windows_pricing": 0.472,
        },
        {
            "instance_type": "r5dn.12xlarge",
            "instance_family": "r5dn",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 1800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.008,
            "on_demand_windows_pricing": 6.216,
        },
        {
            "instance_type": "r5dn.16xlarge",
            "instance_family": "r5dn",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 512.0,
            "storage_gb": 2400.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.344,
            "on_demand_windows_pricing": 8.288,
        },
        {
            "instance_type": "r5dn.24xlarge",
            "instance_family": "r5dn",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 8.016,
            "on_demand_windows_pricing": 12.432,
        },
        {
            "instance_type": "r5dn.2xlarge",
            "instance_family": "r5dn",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 300.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.668,
            "on_demand_windows_pricing": 1.036,
        },
        {
            "instance_type": "r5dn.4xlarge",
            "instance_family": "r5dn",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 128.0,
            "storage_gb": 600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.336,
            "on_demand_windows_pricing": 2.072,
        },
        {
            "instance_type": "r5dn.8xlarge",
            "instance_family": "r5dn",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 256.0,
            "storage_gb": 1200.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.672,
            "on_demand_windows_pricing": 4.144,
        },
        {
            "instance_type": "r5dn.large",
            "instance_family": "r5dn",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 16.0,
            "storage_gb": 75.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.167,
            "on_demand_windows_pricing": 0.259,
        },
        {
            "instance_type": "r5dn.metal",
            "instance_family": "r5dn",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 3600.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 4,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 8.016,
            "on_demand_windows_pricing": 12.432,
        },
        {
            "instance_type": "r5dn.xlarge",
            "instance_family": "r5dn",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 150.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.334,
            "on_demand_windows_pricing": 0.518,
        },
        {
            "instance_type": "r5n.12xlarge",
            "instance_family": "r5n",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.576,
            "on_demand_windows_pricing": 5.784,
        },
        {
            "instance_type": "r5n.16xlarge",
            "instance_family": "r5n",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 512.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.768,
            "on_demand_windows_pricing": 7.712,
        },
        {
            "instance_type": "r5n.24xlarge",
            "instance_family": "r5n",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 7.152,
            "on_demand_windows_pricing": 11.568,
        },
        {
            "instance_type": "r5n.2xlarge",
            "instance_family": "r5n",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.596,
            "on_demand_windows_pricing": 0.964,
        },
        {
            "instance_type": "r5n.4xlarge",
            "instance_family": "r5n",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.192,
            "on_demand_windows_pricing": 1.928,
        },
        {
            "instance_type": "r5n.8xlarge",
            "instance_family": "r5n",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.384,
            "on_demand_windows_pricing": 3.856,
        },
        {
            "instance_type": "r5n.large",
            "instance_family": "r5n",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.149,
            "on_demand_windows_pricing": 0.241,
        },
        {
            "instance_type": "r5n.metal",
            "instance_family": "r5n",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 768.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 7.152,
            "on_demand_windows_pricing": 11.568,
        },
        {
            "instance_type": "r5n.xlarge",
            "instance_family": "r5n",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.1,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.298,
            "on_demand_windows_pricing": 0.482,
        },
        {
            "instance_type": "r6g.12xlarge",
            "instance_family": "r6g",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "arm64",
            "cores": 48,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.4192,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6g.16xlarge",
            "instance_family": "r6g",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
                49,
                50,
                51,
                52,
                53,
                54,
                55,
                56,
                57,
                58,
                59,
                60,
                61,
                62,
                63,
                64,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 512.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.2256,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6g.2xlarge",
            "instance_family": "r6g",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.4032,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6g.4xlarge",
            "instance_family": "r6g",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.8064,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6g.8xlarge",
            "instance_family": "r6g",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.6128,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6g.large",
            "instance_family": "r6g",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1008,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6g.medium",
            "instance_family": "r6g",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 1,
            "architecture": "arm64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0504,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6g.metal",
            "instance_family": "r6g",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 512.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.2256,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6g.xlarge",
            "instance_family": "r6g",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.2016,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6gd.12xlarge",
            "instance_family": "r6gd",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "arm64",
            "cores": 48,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 384.0,
            "storage_gb": 2850.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.7648,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6gd.16xlarge",
            "instance_family": "r6gd",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
                49,
                50,
                51,
                52,
                53,
                54,
                55,
                56,
                57,
                58,
                59,
                60,
                61,
                62,
                63,
                64,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 512.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.6864,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6gd.2xlarge",
            "instance_family": "r6gd",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 474.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.4608,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6gd.4xlarge",
            "instance_family": "r6gd",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 950.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.9216,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6gd.8xlarge",
            "instance_family": "r6gd",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 1900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.8432,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6gd.large",
            "instance_family": "r6gd",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 118.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1152,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6gd.medium",
            "instance_family": "r6gd",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 1,
            "architecture": "arm64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 59.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0576,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6gd.metal",
            "instance_family": "r6gd",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 512.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.6864,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6gd.xlarge",
            "instance_family": "r6gd",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 237.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.2304,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "r6i.12xlarge",
            "instance_family": "r6i",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 384.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "18.75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.024,
            "on_demand_windows_pricing": 5.232,
        },
        {
            "instance_type": "r6i.16xlarge",
            "instance_family": "r6i",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 512.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.032,
            "on_demand_windows_pricing": 6.976,
        },
        {
            "instance_type": "r6i.24xlarge",
            "instance_family": "r6i",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 768.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "37.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.048,
            "on_demand_windows_pricing": 10.464,
        },
        {
            "instance_type": "r6i.2xlarge",
            "instance_family": "r6i",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 64.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.504,
            "on_demand_windows_pricing": 0.872,
        },
        {
            "instance_type": "r6i.32xlarge",
            "instance_family": "r6i",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
                50,
                52,
                54,
                56,
                58,
                60,
                62,
                64,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 1024.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 8.064,
            "on_demand_windows_pricing": 13.952,
        },
        {
            "instance_type": "r6i.4xlarge",
            "instance_family": "r6i",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 128.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.008,
            "on_demand_windows_pricing": 1.744,
        },
        {
            "instance_type": "r6i.8xlarge",
            "instance_family": "r6i",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.016,
            "on_demand_windows_pricing": 3.488,
        },
        {
            "instance_type": "r6i.large",
            "instance_family": "r6i",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.126,
            "on_demand_windows_pricing": 0.218,
        },
        {
            "instance_type": "r6i.metal",
            "instance_family": "r6i",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 1024.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 8.064,
            "on_demand_windows_pricing": 13.952,
        },
        {
            "instance_type": "r6i.xlarge",
            "instance_family": "r6i",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 12.5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.252,
            "on_demand_windows_pricing": 0.436,
        },
        {
            "instance_type": "t1.micro",
            "instance_family": "t1",
            "instance_size": "micro",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": True,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 1,
            "architecture": "i386, x86_64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": float("nan"),
            "memory_gb": 0.612,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Very Low",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 2,
            "ipv6_addresses_per_interface": 0,
            "ipv6_support": False,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": False,
            "on_demand_linux_pricing": 0.02,
            "on_demand_windows_pricing": 0.02,
        },
        {
            "instance_type": "t2.2xlarge",
            "instance_family": "t2",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.3712,
            "on_demand_windows_pricing": 0.4332,
        },
        {
            "instance_type": "t2.large",
            "instance_family": "t2",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Low to Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 12,
            "ipv6_addresses_per_interface": 12,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0928,
            "on_demand_windows_pricing": 0.1208,
        },
        {
            "instance_type": "t2.medium",
            "instance_family": "t2",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 2,
            "architecture": "i386, x86_64",
            "cores": 2,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Low to Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 6,
            "ipv6_addresses_per_interface": 6,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0464,
            "on_demand_windows_pricing": 0.0644,
        },
        {
            "instance_type": "t2.micro",
            "instance_family": "t2",
            "instance_size": "micro",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": True,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 1,
            "architecture": "i386, x86_64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 1.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Low to Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 2,
            "ipv6_addresses_per_interface": 2,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0116,
            "on_demand_windows_pricing": 0.0162,
        },
        {
            "instance_type": "t2.nano",
            "instance_family": "t2",
            "instance_size": "nano",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 1,
            "architecture": "i386, x86_64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.4,
            "memory_gb": 0.5,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Low to Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 2,
            "ipv6_addresses_per_interface": 2,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0058,
            "on_demand_windows_pricing": 0.0081,
        },
        {
            "instance_type": "t2.small",
            "instance_family": "t2",
            "instance_size": "small",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 1,
            "architecture": "i386, x86_64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 2.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Low to Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.023,
            "on_demand_windows_pricing": 0.032,
        },
        {
            "instance_type": "t2.xlarge",
            "instance_family": "t2",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "unsupported",
            "network_performance": "Moderate",
            "ena_support": "unsupported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1856,
            "on_demand_windows_pricing": 0.2266,
        },
        {
            "instance_type": "t3.2xlarge",
            "instance_family": "t3",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.3328,
            "on_demand_windows_pricing": 0.48,
        },
        {
            "instance_type": "t3.large",
            "instance_family": "t3",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 12,
            "ipv6_addresses_per_interface": 12,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0832,
            "on_demand_windows_pricing": 0.1108,
        },
        {
            "instance_type": "t3.medium",
            "instance_family": "t3",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 6,
            "ipv6_addresses_per_interface": 6,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0416,
            "on_demand_windows_pricing": 0.06,
        },
        {
            "instance_type": "t3.micro",
            "instance_family": "t3",
            "instance_size": "micro",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 1.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 2,
            "ipv6_addresses_per_interface": 2,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0104,
            "on_demand_windows_pricing": 0.0196,
        },
        {
            "instance_type": "t3.nano",
            "instance_family": "t3",
            "instance_size": "nano",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 0.5,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 2,
            "ipv6_addresses_per_interface": 2,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0052,
            "on_demand_windows_pricing": 0.0098,
        },
        {
            "instance_type": "t3.small",
            "instance_family": "t3",
            "instance_size": "small",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 2.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0208,
            "on_demand_windows_pricing": 0.0392,
        },
        {
            "instance_type": "t3.xlarge",
            "instance_family": "t3",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1664,
            "on_demand_windows_pricing": 0.24,
        },
        {
            "instance_type": "t3a.2xlarge",
            "instance_family": "t3a",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.3008,
            "on_demand_windows_pricing": 0.448,
        },
        {
            "instance_type": "t3a.large",
            "instance_family": "t3a",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 12,
            "ipv6_addresses_per_interface": 12,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0752,
            "on_demand_windows_pricing": 0.1028,
        },
        {
            "instance_type": "t3a.medium",
            "instance_family": "t3a",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 6,
            "ipv6_addresses_per_interface": 6,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0376,
            "on_demand_windows_pricing": 0.056,
        },
        {
            "instance_type": "t3a.micro",
            "instance_family": "t3a",
            "instance_size": "micro",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 1.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 2,
            "ipv6_addresses_per_interface": 2,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0094,
            "on_demand_windows_pricing": 0.0186,
        },
        {
            "instance_type": "t3a.nano",
            "instance_family": "t3a",
            "instance_size": "nano",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 0.5,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 2,
            "ipv6_addresses_per_interface": 2,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0047,
            "on_demand_windows_pricing": 0.0093,
        },
        {
            "instance_type": "t3a.small",
            "instance_family": "t3a",
            "instance_size": "small",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "x86_64",
            "cores": 1,
            "valid_cores": [1],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 2.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0188,
            "on_demand_windows_pricing": 0.0372,
        },
        {
            "instance_type": "t3a.xlarge",
            "instance_family": "t3a",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.2,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": True,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1504,
            "on_demand_windows_pricing": 0.224,
        },
        {
            "instance_type": "t4g.2xlarge",
            "instance_family": "t4g",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.2688,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "t4g.large",
            "instance_family": "t4g",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 8.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 12,
            "ipv6_addresses_per_interface": 12,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0672,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "t4g.medium",
            "instance_family": "t4g",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 4.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 6,
            "ipv6_addresses_per_interface": 6,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0336,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "t4g.micro",
            "instance_family": "t4g",
            "instance_size": "micro",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 1.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 2,
            "ipv6_addresses_per_interface": 2,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0084,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "t4g.nano",
            "instance_family": "t4g",
            "instance_size": "nano",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 0.5,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 2,
            "ipv6_addresses_per_interface": 2,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0042,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "t4g.small",
            "instance_family": "t4g",
            "instance_size": "small",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": True,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 2.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0168,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "t4g.xlarge",
            "instance_family": "t4g",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 5 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": True,
            "current_generation": True,
            "on_demand_linux_pricing": 0.1344,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "u-12tb1.112xlarge",
            "instance_family": "u-12tb1",
            "instance_size": "112xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 448,
            "architecture": "x86_64",
            "cores": 224,
            "valid_cores": [
                8,
                16,
                24,
                32,
                40,
                48,
                56,
                64,
                72,
                80,
                88,
                96,
                104,
                112,
                120,
                128,
                136,
                144,
                152,
                160,
                168,
                176,
                184,
                192,
                200,
                208,
                216,
                224,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.1,
            "memory_gb": 12288.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 109.2,
            "on_demand_windows_pricing": 129.808,
        },
        {
            "instance_type": "u-3tb1.56xlarge",
            "instance_family": "u-3tb1",
            "instance_size": "56xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 224,
            "architecture": "x86_64",
            "cores": 112,
            "valid_cores": [
                4,
                8,
                12,
                16,
                20,
                24,
                28,
                32,
                36,
                40,
                44,
                48,
                52,
                56,
                60,
                64,
                68,
                72,
                76,
                80,
                84,
                88,
                92,
                96,
                100,
                104,
                108,
                112,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.1,
            "memory_gb": 3072.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 27.3,
            "on_demand_windows_pricing": 37.604,
        },
        {
            "instance_type": "u-6tb1.112xlarge",
            "instance_family": "u-6tb1",
            "instance_size": "112xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 448,
            "architecture": "x86_64",
            "cores": 224,
            "valid_cores": [
                8,
                16,
                24,
                32,
                40,
                48,
                56,
                64,
                72,
                80,
                88,
                96,
                104,
                112,
                120,
                128,
                136,
                144,
                152,
                160,
                168,
                176,
                184,
                192,
                200,
                208,
                216,
                224,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.1,
            "memory_gb": 6144.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 54.6,
            "on_demand_windows_pricing": 75.208,
        },
        {
            "instance_type": "u-6tb1.56xlarge",
            "instance_family": "u-6tb1",
            "instance_size": "56xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 224,
            "architecture": "x86_64",
            "cores": 224,
            "valid_cores": [
                8,
                16,
                24,
                32,
                40,
                48,
                56,
                64,
                72,
                80,
                88,
                96,
                104,
                112,
                120,
                128,
                136,
                144,
                152,
                160,
                168,
                176,
                184,
                192,
                200,
                208,
                216,
                224,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.1,
            "memory_gb": 6144.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 46.40391,
            "on_demand_windows_pricing": 56.70791,
        },
        {
            "instance_type": "u-9tb1.112xlarge",
            "instance_family": "u-9tb1",
            "instance_size": "112xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 448,
            "architecture": "x86_64",
            "cores": 224,
            "valid_cores": [
                8,
                16,
                24,
                32,
                40,
                48,
                56,
                64,
                72,
                80,
                88,
                96,
                104,
                112,
                120,
                128,
                136,
                144,
                152,
                160,
                168,
                176,
                184,
                192,
                200,
                208,
                216,
                224,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.1,
            "memory_gb": 9216.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 81.9,
            "on_demand_windows_pricing": 102.508,
        },
        {
            "instance_type": "vt1.24xlarge",
            "instance_family": "vt1",
            "instance_size": "24xlarge",
            "availability_zones": ["us-east-1a", "us-east-1b"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [6, 12, 48],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 192.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.2,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "vt1.3xlarge",
            "instance_family": "vt1",
            "instance_size": "3xlarge",
            "availability_zones": ["us-east-1a", "us-east-1b"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 12,
            "architecture": "x86_64",
            "cores": 6,
            "valid_cores": [6],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 24.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "3.12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.65,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "vt1.6xlarge",
            "instance_family": "vt1",
            "instance_size": "6xlarge",
            "availability_zones": ["us-east-1a", "us-east-1b"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 24,
            "architecture": "x86_64",
            "cores": 12,
            "valid_cores": [6, 12],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 48.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "6.25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": False,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.3,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "x1.16xlarge",
            "instance_family": "x1",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 976.0,
            "storage_gb": 1920.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.669,
            "on_demand_windows_pricing": 9.613,
        },
        {
            "instance_type": "x1.32xlarge",
            "instance_family": "x1",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1e",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [
                4,
                8,
                12,
                16,
                20,
                24,
                28,
                32,
                36,
                40,
                44,
                48,
                52,
                56,
                60,
                64,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 1952.0,
            "storage_gb": 3840.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs, instance-store",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 13.338,
            "on_demand_windows_pricing": 19.226,
        },
        {
            "instance_type": "x1e.16xlarge",
            "instance_family": "x1e",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 1952.0,
            "storage_gb": 1920.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 13.344,
            "on_demand_windows_pricing": 16.288,
        },
        {
            "instance_type": "x1e.2xlarge",
            "instance_family": "x1e",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 244.0,
            "storage_gb": 240.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.668,
            "on_demand_windows_pricing": 2.036,
        },
        {
            "instance_type": "x1e.32xlarge",
            "instance_family": "x1e",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [
                4,
                8,
                12,
                16,
                20,
                24,
                28,
                32,
                36,
                40,
                44,
                48,
                52,
                56,
                60,
                64,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 3904.0,
            "storage_gb": 3840.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 26.688,
            "on_demand_windows_pricing": 32.576,
        },
        {
            "instance_type": "x1e.4xlarge",
            "instance_family": "x1e",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 488.0,
            "storage_gb": 480.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.336,
            "on_demand_windows_pricing": 4.072,
        },
        {
            "instance_type": "x1e.8xlarge",
            "instance_family": "x1e",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 976.0,
            "storage_gb": 960.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.672,
            "on_demand_windows_pricing": 8.144,
        },
        {
            "instance_type": "x1e.xlarge",
            "instance_family": "x1e",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "xen",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 2.3,
            "memory_gb": 122.0,
            "storage_gb": 120.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "supported",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.834,
            "on_demand_windows_pricing": 1.018,
        },
        {
            "instance_type": "x2gd.12xlarge",
            "instance_family": "x2gd",
            "instance_size": "12xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "arm64",
            "cores": 48,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 768.0,
            "storage_gb": 2850.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "20 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 4.008,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "x2gd.16xlarge",
            "instance_family": "x2gd",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
                33,
                34,
                35,
                36,
                37,
                38,
                39,
                40,
                41,
                42,
                43,
                44,
                45,
                46,
                47,
                48,
                49,
                50,
                51,
                52,
                53,
                54,
                55,
                56,
                57,
                58,
                59,
                60,
                61,
                62,
                63,
                64,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 1024.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.344,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "x2gd.2xlarge",
            "instance_family": "x2gd",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "arm64",
            "cores": 8,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 128.0,
            "storage_gb": 475.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.668,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "x2gd.4xlarge",
            "instance_family": "x2gd",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "arm64",
            "cores": 16,
            "valid_cores": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 256.0,
            "storage_gb": 950.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.336,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "x2gd.8xlarge",
            "instance_family": "x2gd",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "arm64",
            "cores": 32,
            "valid_cores": [
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                10,
                11,
                12,
                13,
                14,
                15,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                25,
                26,
                27,
                28,
                29,
                30,
                31,
                32,
            ],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 512.0,
            "storage_gb": 1900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "12 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 2.672,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "x2gd.large",
            "instance_family": "x2gd",
            "instance_size": "large",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 2,
            "architecture": "arm64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 32.0,
            "storage_gb": 118.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 3,
            "ipv4_addresses_per_interface": 10,
            "ipv6_addresses_per_interface": 10,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.167,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "x2gd.medium",
            "instance_family": "x2gd",
            "instance_size": "medium",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 1,
            "architecture": "arm64",
            "cores": 1,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 16.0,
            "storage_gb": 59.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 2,
            "ipv4_addresses_per_interface": 4,
            "ipv6_addresses_per_interface": 4,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.0835,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "x2gd.metal",
            "instance_family": "x2gd",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 64,
            "architecture": "arm64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 1,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 1024.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 5.344,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "x2gd.xlarge",
            "instance_family": "x2gd",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "arm64",
            "cores": 4,
            "valid_cores": [1, 2, 3, 4],
            "threads_per_core": 1,
            "valid_threads_per_core": [1],
            "sustained_clock_speed_ghz": 2.5,
            "memory_gb": 64.0,
            "storage_gb": 237.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 10 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.334,
            "on_demand_windows_pricing": float("nan"),
        },
        {
            "instance_type": "x2idn.16xlarge",
            "instance_family": "x2idn",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 1024.0,
            "storage_gb": 1900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.669,
            "on_demand_windows_pricing": 9.613,
        },
        {
            "instance_type": "x2idn.24xlarge",
            "instance_family": "x2idn",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 1536.0,
            "storage_gb": 2850.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 10.0035,
            "on_demand_windows_pricing": 14.4195,
        },
        {
            "instance_type": "x2idn.32xlarge",
            "instance_family": "x2idn",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
                50,
                52,
                54,
                56,
                58,
                60,
                62,
                64,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 2048.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 13.338,
            "on_demand_windows_pricing": 19.226,
        },
        {
            "instance_type": "x2idn.metal",
            "instance_family": "x2idn",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 2048.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 13.338,
            "on_demand_windows_pricing": 19.226,
        },
        {
            "instance_type": "x2iedn.16xlarge",
            "instance_family": "x2iedn",
            "instance_size": "16xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 64,
            "architecture": "x86_64",
            "cores": 32,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 2048.0,
            "storage_gb": 1900.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "50 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 13.338,
            "on_demand_windows_pricing": 16.282,
        },
        {
            "instance_type": "x2iedn.24xlarge",
            "instance_family": "x2iedn",
            "instance_size": "24xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 96,
            "architecture": "x86_64",
            "cores": 48,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 3072.0,
            "storage_gb": 2850.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "75 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 20.007,
            "on_demand_windows_pricing": 24.423,
        },
        {
            "instance_type": "x2iedn.2xlarge",
            "instance_family": "x2iedn",
            "instance_size": "2xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 256.0,
            "storage_gb": 237.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 1.66725,
            "on_demand_windows_pricing": 2.03525,
        },
        {
            "instance_type": "x2iedn.32xlarge",
            "instance_family": "x2iedn",
            "instance_size": "32xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [
                2,
                4,
                6,
                8,
                10,
                12,
                14,
                16,
                18,
                20,
                22,
                24,
                26,
                28,
                30,
                32,
                34,
                36,
                38,
                40,
                42,
                44,
                46,
                48,
                50,
                52,
                54,
                56,
                58,
                60,
                62,
                64,
            ],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 4096.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 26.676,
            "on_demand_windows_pricing": 32.564,
        },
        {
            "instance_type": "x2iedn.4xlarge",
            "instance_family": "x2iedn",
            "instance_size": "4xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 16,
            "architecture": "x86_64",
            "cores": 8,
            "valid_cores": [2, 4, 6, 8],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 512.0,
            "storage_gb": 475.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 3.3345,
            "on_demand_windows_pricing": 4.0705,
        },
        {
            "instance_type": "x2iedn.8xlarge",
            "instance_family": "x2iedn",
            "instance_size": "8xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 32,
            "architecture": "x86_64",
            "cores": 16,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 1024.0,
            "storage_gb": 950.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 8,
            "ipv4_addresses_per_interface": 30,
            "ipv6_addresses_per_interface": 30,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 6.669,
            "on_demand_windows_pricing": 8.141,
        },
        {
            "instance_type": "x2iedn.metal",
            "instance_family": "x2iedn",
            "instance_size": "metal",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": True,
            "hypervisor": float("nan"),
            "vcpus": 128,
            "architecture": "x86_64",
            "cores": 64,
            "valid_cores": [],
            "threads_per_core": 2,
            "valid_threads_per_core": [],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 4096.0,
            "storage_gb": 3800.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 2,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 26.676,
            "on_demand_windows_pricing": 32.564,
        },
        {
            "instance_type": "x2iedn.xlarge",
            "instance_family": "x2iedn",
            "instance_size": "xlarge",
            "availability_zones": [
                "us-east-1a",
                "us-east-1b",
                "us-east-1c",
                "us-east-1d",
                "us-east-1f",
            ],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 4,
            "architecture": "x86_64",
            "cores": 2,
            "valid_cores": [1, 2],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 3.5,
            "memory_gb": 128.0,
            "storage_gb": 118.0,
            "local_instance_storage": True,
            "storage_type": "ssd",
            "storage_disk_count": 1,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up to 25 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 4,
            "ipv4_addresses_per_interface": 15,
            "ipv6_addresses_per_interface": 15,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": False,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 0.83363,
            "on_demand_windows_pricing": 1.01763,
        },
        {
            "instance_type": "x2iezn.12xlarge",
            "instance_family": "x2iezn",
            "instance_size": "12xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 48,
            "architecture": "x86_64",
            "cores": 24,
            "valid_cores": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 4.5,
            "memory_gb": 1536.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "100 Gigabit",
            "ena_support": "required",
            "maximum_number_of_network_interfaces": 15,
            "ipv4_addresses_per_interface": 50,
            "ipv6_addresses_per_interface": 50,
            "ipv6_support": True,
            "supported_placement_group_strategies": ["cluster", "partition", "spread"],
            "gpus": 0,
            "fpgas": 0,
            "auto_recovery_support": True,
            "supported_root_device_types": "ebs",
            "dedicated_host_support": True,
            "on_demand_hibernation_support": False,
            "burstable_performance_support": False,
            "current_generation": True,
            "on_demand_linux_pricing": 10.008,
            "on_demand_windows_pricing": 12.216,
        },
        {
            "instance_type": "x2iezn.2xlarge",
            "instance_family": "x2iezn",
            "instance_size": "2xlarge",
            "availability_zones": ["us-east-1b", "us-east-1c", "us-east-1d"],
            "free_tier_eligble": False,
            "free_trial_available": False,
            "bare_metal": False,
            "hypervisor": "nitro",
            "vcpus": 8,
            "architecture": "x86_64",
            "cores": 4,
            "valid_cores": [2, 4],
            "threads_per_core": 2,
            "valid_threads_per_core": [1, 2],
            "sustained_clock_speed_ghz": 4.5,
            "memory_gb": 256.0,
            "storage_gb": 0.0,
            "local_instance_storage": False,
            "storage_type": "",
            "storage_disk_count": 0,
            "ebs_encryption_support": "supported",
            "ebs_optimization_support": "default",
            "network_performance": "Up t