/*
 * Decompiled with CFR 0.152.
 */
package org.opendatakit.validate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IFunctionHandler;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.InstanceInitializationFactory;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.utils.IPreloadHandler;
import org.javarosa.core.reference.ReferenceManager;
import org.javarosa.core.services.PropertyManager;
import org.javarosa.core.services.PrototypeManager;
import org.javarosa.form.api.FormEntryModel;
import org.javarosa.form.api.FormEntryPrompt;
import org.javarosa.model.xform.XFormsModule;
import org.javarosa.xform.parse.XFormParseException;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xform.util.XFormUtils;
import org.opendatakit.validate.ErrorListener;
import org.opendatakit.validate.StubPropertyManager;
import org.opendatakit.validate.StubReferenceFactory;
import org.opendatakit.validate.StubSetGeopointActionHandler;

public class FormValidator
implements ActionListener {
    public static final String[] SERIALIABLE_CLASSES = new String[]{"org.javarosa.core.services.locale.ResourceFileDataSource", "org.javarosa.core.services.locale.TableLocaleSource", "org.javarosa.core.model.FormDef", "org.javarosa.core.model.SubmissionProfile", "org.javarosa.core.model.QuestionDef", "org.javarosa.core.model.GroupDef", "org.javarosa.core.model.instance.FormInstance", "org.javarosa.core.model.data.BooleanData", "org.javarosa.core.model.data.DateData", "org.javarosa.core.model.data.DateTimeData", "org.javarosa.core.model.data.DecimalData", "org.javarosa.core.model.data.GeoPointData", "org.javarosa.core.model.data.GeoShapeData", "org.javarosa.core.model.data.GeoTraceData", "org.javarosa.core.model.data.IntegerData", "org.javarosa.core.model.data.LongData", "org.javarosa.core.model.data.MultiPointerAnswerData", "org.javarosa.core.model.data.PointerAnswerData", "org.javarosa.core.model.data.SelectMultiData", "org.javarosa.core.model.data.SelectOneData", "org.javarosa.core.model.data.StringData", "org.javarosa.core.model.data.TimeData", "org.javarosa.core.model.data.UncastData", "org.javarosa.core.model.data.helper.BasicDataPointer", "org.javarosa.core.model.actions.SetValueAction"};
    private JFrame validatorFrame;
    private JTextField formPath;
    private JTextArea validatorOutput;
    private JButton chooseFileButton;
    private JButton validateButton;
    private JFileChooser fileChooser;
    private ErrorListener errors = ErrorListener.DEFAULT_ERROR_LISTENER;
    private boolean inError = false;

    public static void main(String[] args2) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (args2.length == 0) {
                new FormValidator().show();
            } else {
                ArrayList<String> paths = new ArrayList<String>();
                boolean failFast = false;
                for (String arg : args2) {
                    if (arg.equals("--failFast") || arg.equals("--fail-fast")) {
                        failFast = true;
                        continue;
                    }
                    paths.add(arg);
                }
                new FormValidator().validateAndExitWithErrorCode(paths, failFast);
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void setError(boolean outcome) {
        this.inError = outcome;
    }

    private FormValidator show() {
        this.validatorFrame = new JFrame("ODK Validate v1.18.0");
        JPanel validatorPanel = new JPanel();
        this.validatorFrame.setResizable(false);
        this.addWidgets(validatorPanel);
        System.setOut(new PrintStream(new JTextAreaOutputStream(this.validatorOutput)));
        System.setErr(new PrintStream(new JTextAreaOutputStream(this.validatorOutput)));
        this.validatorFrame.getContentPane().add((Component)validatorPanel, "Center");
        this.validatorFrame.setDefaultCloseOperation(3);
        this.validatorFrame.pack();
        this.validatorFrame.setVisible(true);
        return this;
    }

    private void addWidgets(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.formPath = new JTextField(40);
        this.fileChooser = new JFileChooser();
        this.chooseFileButton = new JButton("Choose File...");
        this.chooseFileButton.addActionListener(this);
        this.validatorOutput = new JTextArea();
        this.validatorOutput.setEditable(false);
        this.validatorOutput.setLineWrap(true);
        this.validatorOutput.setFont(new Font("Monospaced", 0, 14));
        this.validatorOutput.setForeground(Color.BLACK);
        JScrollPane validatorOutputScrollPane = new JScrollPane(this.validatorOutput);
        validatorOutputScrollPane.setPreferredSize(new Dimension(800, 600));
        this.validateButton = new JButton("Validate Again");
        this.validateButton.addActionListener(this);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 7, 0, 0);
        panel.add((Component)this.formPath, c);
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(10, 0, 10, 7);
        panel.add((Component)this.chooseFileButton, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.insets = new Insets(0, 10, 10, 10);
        panel.add((Component)validatorOutputScrollPane, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        panel.add((Component)this.validateButton, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.validateButton) {
            this.setError(false);
            this.validatorOutput.setText("");
            this.validatorOutput.setForeground(Color.BLUE);
            this.validate(this.formPath.getText());
            this.validatorOutput.setForeground(this.inError ? Color.red : Color.BLUE);
        }
        if (e.getSource() == this.chooseFileButton) {
            int returnVal = this.fileChooser.showOpenDialog(this.validatorFrame);
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.formPath.setText(file.getPath());
            }
            this.setError(false);
            this.validatorOutput.setText("");
            this.validatorOutput.setForeground(Color.BLUE);
            this.validate(this.formPath.getText());
            this.validatorOutput.setForeground(this.inError ? Color.red : Color.BLUE);
        }
    }

    boolean stepThroughEntireForm(FormEntryModel model) throws InvalidReferenceException {
        int event;
        boolean outcome = false;
        HashSet<String> loops = new HashSet<String>();
        FormIndex idx = FormIndex.createBeginningOfFormIndex();
        while ((event = model.getEvent(idx = model.incrementIndex(idx))) != 1) {
            FormEntryPrompt prompt;
            String elementPath;
            if (event == 2) {
                String elementPath2 = idx.getReference().toString().replaceAll("\\[\\d+\\]", "");
                if (loops.contains(elementPath2)) continue;
                loops.add(elementPath2);
                model.getForm().createNewRepeat(idx);
                idx = model.getFormIndex();
                continue;
            }
            if (event == 8) {
                GroupDef gd = (GroupDef)model.getForm().getChild(idx);
                if (gd.getChildren() != null && gd.getChildren().size() != 0) continue;
                outcome = true;
                this.setError(true);
                elementPath = idx.getReference().toString().replaceAll("\\[\\d+\\]", "");
                this.errors.error("Group has no children! Group: " + elementPath + ". The XML is invalid.\n");
                continue;
            }
            if (event != 4 || (prompt = model.getQuestionPrompt(idx)).getControlType() != 3 && prompt.getControlType() != 2) continue;
            elementPath = idx.getReference().toString().replaceAll("\\[\\d+\\]", "");
            List<SelectChoice> items = prompt.getSelectChoices();
            for (int i = 0; i < items.size(); ++i) {
                SelectChoice s = items.get(i);
                String text = prompt.getSelectChoiceText(s);
                String image = prompt.getSpecialFormSelectChoiceText(s, "image");
                if (!(text != null && text.trim().length() != 0 || image != null && image.trim().length() != 0)) {
                    this.errors.error("Selection choice label text and image uri are both missing for: " + elementPath + " choice: " + (i + 1) + ".\n");
                }
                if (s.getValue() != null && s.getValue().trim().length() != 0) continue;
                outcome = true;
                this.setError(true);
                this.errors.error("Selection value is missing for: " + elementPath + " choice: " + (i + 1) + ". The XML is invalid.\n");
            }
        }
        return outcome;
    }

    public void validateAndExitWithErrorCode(List<String> paths, boolean failFast) {
        ArrayList<String> failed = new ArrayList<String>();
        for (String path : paths) {
            try {
                this.validate(path);
            }
            catch (Exception e) {
                this.errors.error("\nException: ", e);
                this.setError(true);
            }
            if (!this.inError) continue;
            if (failFast) break;
            failed.add(path);
            this.setError(false);
        }
        if (this.inError || !failed.isEmpty()) {
            if (!failed.isEmpty()) {
                this.errors.error("\nThe following files failed validation:");
                for (String path : failed) {
                    this.errors.error(path);
                }
            }
            this.errors.error("\nResult: Invalid");
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(String path) {
        File src = new File(path);
        if (!src.exists()) {
            this.setError(true);
            this.errors.error("File: " + src.getAbsolutePath() + " does not exist.");
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(src);
            this.errors.info("Validating: " + path);
            this.validate(fis);
        }
        catch (FileNotFoundException e) {
            this.setError(true);
            this.errors.error("Please choose a file before attempting to validate.");
            return;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void validateText(String xml) {
        this.validate(xml.getBytes());
    }

    public void validate(InputStream xmlSource) {
        try {
            this.validate(this.copyToByteArray(xmlSource));
        }
        catch (IOException e) {
            this.errors.error("Failed to read XML Input Stream", e);
        }
    }

    public void validate(byte[] xformData) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            factory.newDocumentBuilder().parse(new ByteArrayInputStream(xformData));
        }
        catch (Exception e) {
            this.setError(true);
            this.errors.error("\n\n\n>> XML is invalid. See above for the errors.", e);
            return;
        }
        PrototypeManager.registerPrototypes(SERIALIABLE_CLASSES);
        new XFormsModule().registerModule();
        PropertyManager.setPropertyManager(new StubPropertyManager());
        ReferenceManager referenceManager = ReferenceManager.instance();
        referenceManager.addReferenceFactory(new StubReferenceFactory());
        PrototypeManager.registerPrototype("org.opendatakit.validate.StubSetGeopointAction");
        XFormParser.registerActionHandler("setgeopoint", new StubSetGeopointActionHandler());
        try {
            FormDef fd = XFormUtils.getFormFromInputStream(new ByteArrayInputStream(xformData));
            if (fd == null) {
                this.setError(true);
                this.errors.error("\n\n\n>> Something broke the parser. Try again.");
                return;
            }
            fd.getPreloader().addPreloadHandler(new FakePreloadHandler("property"));
            fd.getEvaluationContext().addFunctionHandler(new IFunctionHandler(){

                @Override
                public String getName() {
                    return "pulldata";
                }

                @Override
                public List<Class[]> getPrototypes() {
                    return new ArrayList<Class[]>();
                }

                @Override
                public boolean rawArgs() {
                    return true;
                }

                @Override
                public boolean realTime() {
                    return false;
                }

                @Override
                public Object eval(Object[] args2, EvaluationContext ec) {
                    return args2[0];
                }
            });
            fd.initialize(true, new InstanceInitializationFactory());
            this.errors.info("\n\n>> Xform parsing completed! See above for any warnings.\n");
            FormEntryModel fem = new FormEntryModel(fd);
            if (this.stepThroughEntireForm(fem)) {
                this.setError(true);
                this.errors.error("\n\n>> Xform is invalid! See above for errors and warnings.");
            } else {
                this.errors.info("\n\n>> Xform is valid! See above for any warnings.");
            }
        }
        catch (XFormParseException e) {
            this.setError(true);
            this.errors.error("\n\n>> XForm is invalid. See above for the errors.", e);
        }
        catch (Exception e) {
            this.setError(true);
            this.errors.error("\n\n>> Something broke the parser. See above for a hint.", e);
        }
    }

    private byte[] copyToByteArray(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos.toByteArray();
    }

    public FormValidator setErrorListener(ErrorListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot set a null error listener");
        }
        this.errors = listener;
        return this;
    }

    private class FakePreloadHandler
    implements IPreloadHandler {
        String preloadHandled;

        public FakePreloadHandler(String preloadHandled) {
            this.preloadHandled = preloadHandled;
        }

        @Override
        public boolean handlePostProcess(TreeElement arg0, String arg1) {
            return false;
        }

        @Override
        public IAnswerData handlePreload(String arg0) {
            return null;
        }

        @Override
        public String preloadHandled() {
            return this.preloadHandled;
        }
    }

    class JTextAreaOutputStream
    extends OutputStream {
        private final JTextArea textArea;

        public JTextAreaOutputStream(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void write(int b) {
            this.textArea.append(new String(new byte[]{(byte)(b % 256)}, 0, 1));
        }
    }
}

