/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.parser;

import java.util.Enumeration;
import java.util.Vector;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathQName;
import org.javarosa.xpath.parser.Token;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.javarosa.xpath.parser.ast.ASTNode;
import org.javarosa.xpath.parser.ast.ASTNodeAbstractExpr;
import org.javarosa.xpath.parser.ast.ASTNodeBinaryOp;
import org.javarosa.xpath.parser.ast.ASTNodeFilterExpr;
import org.javarosa.xpath.parser.ast.ASTNodeFunctionCall;
import org.javarosa.xpath.parser.ast.ASTNodeLocPath;
import org.javarosa.xpath.parser.ast.ASTNodePathStep;
import org.javarosa.xpath.parser.ast.ASTNodePredicate;
import org.javarosa.xpath.parser.ast.ASTNodeUnaryOp;

public class Parser {
    public static XPathExpression parse(Vector<Token> tokens) throws XPathSyntaxException {
        ASTNode tree = Parser.buildParseTree(tokens);
        return tree.build();
    }

    public static ASTNode buildParseTree(Vector<Token> tokens) throws XPathSyntaxException {
        ASTNodeAbstractExpr root = new ASTNodeAbstractExpr();
        for (int i = 0; i < tokens.size(); ++i) {
            root.content.addElement(tokens.elementAt(i));
        }
        Parser.parseFuncCalls(root);
        Parser.parseParens(root);
        Parser.parsePredicates(root);
        Parser.parseOperators(root);
        Parser.parsePathExpr(root);
        Parser.verifyBaseExpr(root);
        return root;
    }

    private static void parseOperators(ASTNode root) {
        int[] orOp = new int[]{22};
        int[] andOp = new int[]{1};
        int[] eqOps = new int[]{9, 19};
        int[] cmpOps = new int[]{14, 15, 10, 11};
        int[] addOps = new int[]{23, 16};
        int[] multOps = new int[]{18, 7, 17};
        int[] unionOp = new int[]{30};
        Parser.parseBinaryOp(root, orOp, 2);
        Parser.parseBinaryOp(root, andOp, 2);
        Parser.parseBinaryOp(root, eqOps, 1);
        Parser.parseBinaryOp(root, cmpOps, 1);
        Parser.parseBinaryOp(root, addOps, 1);
        Parser.parseBinaryOp(root, multOps, 1);
        Parser.parseUnaryOp(root, 29);
        Parser.parseBinaryOp(root, unionOp, 1);
    }

    private static void parseFuncCalls(ASTNode node) throws XPathSyntaxException {
        if (node instanceof ASTNodeAbstractExpr) {
            ASTNodeAbstractExpr absNode = (ASTNodeAbstractExpr)node;
            for (int i = 0; i < absNode.content.size() - 1; ++i) {
                if (absNode.getTokenType(i + 1) != 13 || absNode.getTokenType(i) != 24) continue;
                Parser.condenseFuncCall(absNode, i);
            }
        }
        Enumeration<ASTNode> e = node.getChildren().elements();
        while (e.hasMoreElements()) {
            Parser.parseFuncCalls(e.nextElement());
        }
    }

    private static void condenseFuncCall(ASTNodeAbstractExpr node, int funcStart) throws XPathSyntaxException {
        ASTNodeFunctionCall funcCall = new ASTNodeFunctionCall((XPathQName)node.getToken((int)funcStart).val);
        int funcEnd = node.indexOfBalanced(funcStart + 1, 26, 13, 26);
        if (funcEnd == -1) {
            throw new XPathSyntaxException("Mismatched brackets or parentheses");
        }
        ASTNodeAbstractExpr.Partition args2 = node.partitionBalanced(3, funcStart + 1, 13, 26);
        if (args2.pieces.size() != 1 || ((ASTNodeAbstractExpr)args2.pieces.elementAt((int)0)).content.size() != 0) {
            funcCall.args = args2.pieces;
        }
        node.condense(funcCall, funcStart, funcEnd + 1);
    }

    private static void parseParens(ASTNode node) throws XPathSyntaxException {
        Parser.parseBalanced(node, new SubNodeFactory(){

            @Override
            public ASTNode newNode(ASTNodeAbstractExpr node) {
                return node;
            }
        }, 13, 26);
    }

    private static void parsePredicates(ASTNode node) throws XPathSyntaxException {
        Parser.parseBalanced(node, new SubNodeFactory(){

            @Override
            public ASTNode newNode(ASTNodeAbstractExpr node) {
                ASTNodePredicate p = new ASTNodePredicate();
                p.expr = node;
                return p;
            }
        }, 12, 25);
    }

    private static void parseBalanced(ASTNode node, SubNodeFactory snf, int lToken, int rToken) throws XPathSyntaxException {
        if (node instanceof ASTNodeAbstractExpr) {
            ASTNodeAbstractExpr absNode = (ASTNodeAbstractExpr)node;
            for (int i = 0; i < absNode.content.size(); ++i) {
                int type = absNode.getTokenType(i);
                if (type == rToken) {
                    throw new XPathSyntaxException("Unbalanced brackets or parentheses!");
                }
                if (type != lToken) continue;
                int j = absNode.indexOfBalanced(i, rToken, lToken, rToken);
                if (j == -1) {
                    throw new XPathSyntaxException("mismatched brackets or parentheses!");
                }
                absNode.condense(snf.newNode(absNode.extract(i + 1, j)), i, j + 1);
            }
        }
        Enumeration<ASTNode> e = node.getChildren().elements();
        while (e.hasMoreElements()) {
            Parser.parseBalanced(e.nextElement(), snf, lToken, rToken);
        }
    }

    private static void parseBinaryOp(ASTNode node, int[] ops, int associativity) {
        if (node instanceof ASTNodeAbstractExpr) {
            ASTNodeAbstractExpr absNode = (ASTNodeAbstractExpr)node;
            ASTNodeAbstractExpr.Partition part = absNode.partition(ops, 0, absNode.content.size());
            if (part.separators.size() != 0) {
                ASTNodeBinaryOp binOp = new ASTNodeBinaryOp();
                binOp.associativity = associativity;
                binOp.exprs = part.pieces;
                binOp.ops = part.separators;
                absNode.condense(binOp, 0, absNode.content.size());
            }
        }
        Enumeration<ASTNode> e = node.getChildren().elements();
        while (e.hasMoreElements()) {
            Parser.parseBinaryOp(e.nextElement(), ops, associativity);
        }
    }

    private static void parseUnaryOp(ASTNode node, int op) {
        if (node instanceof ASTNodeAbstractExpr) {
            ASTNodeAbstractExpr absNode = (ASTNodeAbstractExpr)node;
            if (absNode.content.size() > 0 && absNode.getTokenType(0) == op) {
                ASTNodeUnaryOp unOp = new ASTNodeUnaryOp();
                unOp.op = op;
                unOp.expr = absNode.content.size() > 1 ? absNode.extract(1, absNode.content.size()) : new ASTNodeAbstractExpr();
                absNode.condense(unOp, 0, absNode.content.size());
            }
        }
        Enumeration<ASTNode> e = node.getChildren().elements();
        while (e.hasMoreElements()) {
            Parser.parseUnaryOp(e.nextElement(), op);
        }
    }

    private static void parsePathExpr(ASTNode node) throws XPathSyntaxException {
        if (node instanceof ASTNodeAbstractExpr) {
            ASTNodeAbstractExpr absNode = (ASTNodeAbstractExpr)node;
            int[] pathOps = new int[]{27, 6};
            ASTNodeAbstractExpr.Partition part = absNode.partition(pathOps, 0, absNode.content.size());
            if (part.separators.size() == 0) {
                if (Parser.isStep(absNode)) {
                    ASTNodePathStep step = Parser.parseStep(absNode);
                    ASTNodeLocPath path = new ASTNodeLocPath();
                    path.clauses.addElement(step);
                    absNode.condense(path, 0, absNode.content.size());
                } else {
                    ASTNodeFilterExpr filt = Parser.parseFilterExp(absNode);
                    if (filt != null) {
                        absNode.condense(filt, 0, absNode.content.size());
                    }
                }
            } else {
                ASTNodeLocPath path = new ASTNodeLocPath();
                path.separators = part.separators;
                if (part.separators.size() != 1 || absNode.content.size() != 1 || Parser.vectInt(part.separators, 0) != 27) {
                    for (int i = 0; i < part.pieces.size(); ++i) {
                        ASTNodeAbstractExpr x = (ASTNodeAbstractExpr)part.pieces.elementAt(i);
                        if (Parser.isStep(x)) {
                            ASTNodePathStep step = Parser.parseStep(x);
                            path.clauses.addElement(step);
                            continue;
                        }
                        if (i == 0) {
                            if (x.content.size() == 0) continue;
                            ASTNodeFilterExpr filt = Parser.parseFilterExp(x);
                            if (filt != null) {
                                path.clauses.addElement(filt);
                                continue;
                            }
                            path.clauses.addElement(x);
                            continue;
                        }
                        throw new XPathSyntaxException("Unexpected beginning of path");
                    }
                }
                absNode.condense(path, 0, absNode.content.size());
            }
        }
        Enumeration<ASTNode> e = node.getChildren().elements();
        while (e.hasMoreElements()) {
            Parser.parsePathExpr(e.nextElement());
        }
    }

    private static boolean isStep(ASTNodeAbstractExpr node) {
        if (node.content.size() > 0) {
            int type = node.getTokenType(0);
            if (type == 24 || type == 32 || type == 20 || type == 2 || type == 8 || type == 5) {
                return true;
            }
            if (node.content.elementAt(0) instanceof ASTNodeFunctionCall) {
                String name = ((ASTNodeFunctionCall)node.content.elementAt((int)0)).name.toString();
                return name.equals("node") || name.equals("text") || name.equals("comment") || name.equals("processing-instruction");
            }
            return false;
        }
        return false;
    }

    private static ASTNodePathStep parseStep(ASTNodeAbstractExpr node) throws XPathSyntaxException {
        ASTNodePathStep step = new ASTNodePathStep();
        if (node.content.size() == 1 && node.getTokenType(0) == 8) {
            step.axisType = 3;
            step.nodeTestType = 4;
        } else if (node.content.size() == 1 && node.getTokenType(0) == 5) {
            step.axisType = 3;
            step.nodeTestType = 5;
        } else {
            int i = 0;
            if (node.content.size() > 0 && node.getTokenType(0) == 2) {
                step.axisType = 1;
                ++i;
            } else if (node.content.size() > 1 && node.getTokenType(0) == 24 && node.getTokenType(1) == 4) {
                int axisVal = ASTNodePathStep.validateAxisName(((XPathQName)node.getToken((int)0).val).toString());
                if (axisVal == -1) {
                    throw new XPathSyntaxException("Invalid Axis: " + ((XPathQName)node.getToken((int)0).val).toString());
                }
                step.axisType = 2;
                step.axisVal = axisVal;
                i += 2;
            } else {
                step.axisType = 3;
            }
            if (node.content.size() > i && node.getTokenType(i) == 32) {
                step.nodeTestType = 2;
            } else if (node.content.size() > i && node.getTokenType(i) == 20) {
                step.nodeTestType = 3;
                step.nodeTestNamespace = (String)node.getToken((int)i).val;
            } else if (node.content.size() > i && node.getTokenType(i) == 24) {
                step.nodeTestType = 1;
                step.nodeTestQName = (XPathQName)node.getToken((int)i).val;
            } else if (node.content.size() > i && node.content.elementAt(i) instanceof ASTNodeFunctionCall) {
                if (!ASTNodePathStep.validateNodeTypeTest((ASTNodeFunctionCall)node.content.elementAt(i))) {
                    throw new XPathSyntaxException();
                }
                step.nodeTestType = 6;
                step.nodeTestFunc = (ASTNodeFunctionCall)node.content.elementAt(i);
            } else {
                throw new XPathSyntaxException();
            }
            ++i;
            while (i < node.content.size()) {
                if (!(node.content.elementAt(i) instanceof ASTNodePredicate)) {
                    throw new XPathSyntaxException();
                }
                step.predicates.addElement((ASTNode)node.content.elementAt(i));
                ++i;
            }
        }
        return step;
    }

    private static ASTNodeFilterExpr parseFilterExp(ASTNodeAbstractExpr node) throws XPathSyntaxException {
        int i;
        ASTNodeFilterExpr filt = new ASTNodeFilterExpr();
        for (i = node.content.size() - 1; i >= 0 && node.content.elementAt(i) instanceof ASTNodePredicate; --i) {
            filt.predicates.insertElementAt((ASTNode)node.content.elementAt(i), 0);
        }
        if (filt.predicates.size() == 0) {
            return null;
        }
        filt.expr = node.extract(0, i + 1);
        return filt;
    }

    public static void verifyBaseExpr(ASTNode node) throws XPathSyntaxException {
        ASTNodeAbstractExpr absNode;
        if (node instanceof ASTNodeAbstractExpr && !(absNode = (ASTNodeAbstractExpr)node).isNormalized()) {
            throw new XPathSyntaxException("Bad node: " + absNode.toString());
        }
        Enumeration<ASTNode> e = node.getChildren().elements();
        while (e.hasMoreElements()) {
            Parser.verifyBaseExpr(e.nextElement());
        }
    }

    public static int vectInt(Vector<Integer> v, int i) {
        return v.elementAt(i);
    }

    private static abstract class SubNodeFactory {
        private SubNodeFactory() {
        }

        public abstract ASTNode newNode(ASTNodeAbstractExpr var1);
    }
}

