/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.pivot.UnpivotableExpressionException;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.GeoShapeData;
import org.javarosa.core.model.data.GeoTraceData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.LongData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.TimeData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xform.util.XFormAnswerDataSerializer;
import org.javarosa.xpath.XPathNodeset;
import org.javarosa.xpath.XPathTypeMismatchException;
import org.javarosa.xpath.XPathUnsupportedException;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFilterExpr;
import org.javarosa.xpath.expr.XPathFuncExpr;
import org.javarosa.xpath.expr.XPathPathExprEval;
import org.javarosa.xpath.expr.XPathQName;
import org.javarosa.xpath.expr.XPathStep;
import org.javarosa.xpath.expr.XPathStringLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathPathExpr
extends XPathExpression {
    private static final Logger logger = LoggerFactory.getLogger(XPathPathExpr.class.getSimpleName());
    public static final int INIT_CONTEXT_ROOT = 0;
    public static final int INIT_CONTEXT_RELATIVE = 1;
    public static final int INIT_CONTEXT_EXPR = 2;
    public int init_context;
    public XPathStep[] steps;
    public XPathFilterExpr filtExpr;

    public XPathPathExpr() {
    }

    public XPathPathExpr(int init_context, XPathStep[] steps) {
        this.init_context = init_context;
        this.steps = steps;
    }

    public XPathPathExpr(XPathFilterExpr filtExpr, XPathStep[] steps) {
        this(2, steps);
        this.filtExpr = filtExpr;
    }

    public TreeReference getReference() throws XPathUnsupportedException {
        boolean parentsAllowed;
        TreeReference ref = new TreeReference();
        block0 : switch (this.init_context) {
            case 0: {
                ref.setRefLevel(-1);
                parentsAllowed = false;
                break;
            }
            case 1: {
                ref.setRefLevel(0);
                parentsAllowed = true;
                break;
            }
            case 2: {
                if (this.filtExpr.x instanceof XPathFuncExpr) {
                    XPathFuncExpr func = (XPathFuncExpr)this.filtExpr.x;
                    switch (func.id.toString()) {
                        case "instance": {
                            ref.setRefLevel(-1);
                            parentsAllowed = false;
                            if (func.args.length != 1) {
                                throw new XPathUnsupportedException("instance() function used with " + func.args.length + " arguments. Expecting 1 argument");
                            }
                            if (!(func.args[0] instanceof XPathStringLiteral)) {
                                throw new XPathUnsupportedException("instance() function expecting 1 string literal argument");
                            }
                            XPathStringLiteral strLit = (XPathStringLiteral)func.args[0];
                            if (strLit.s == null) {
                                ref.setContextType(0);
                                ref.setInstanceName(null);
                                break block0;
                            }
                            ref.setContextType(4);
                            ref.setInstanceName(strLit.s);
                            break block0;
                        }
                        case "current": {
                            parentsAllowed = true;
                            ref.setContextType(2);
                            break block0;
                        }
                    }
                    throw new XPathUnsupportedException("filter expression");
                }
                throw new XPathUnsupportedException("filter expression: " + this.toString());
            }
            default: {
                throw new XPathUnsupportedException("filter expression");
            }
        }
        for (int i = 0; i < this.steps.length; ++i) {
            XPathStep step = this.steps[i];
            switch (step.axis) {
                case 10: {
                    if (step.test == 3) break;
                    throw new XPathUnsupportedException("step other than 'child::name', '.', '..'");
                }
                case 2: {
                    if (!parentsAllowed || step.test != 3) {
                        throw new XPathUnsupportedException("step other than 'child::name', '.', '..'");
                    }
                    ref.incrementRefLevel();
                    break;
                }
                case 8: {
                    if (step.test == 0) {
                        ref.add(step.name.toString(), -4);
                        parentsAllowed = false;
                        break;
                    }
                    throw new XPathUnsupportedException("attribute step other than 'attribute::name");
                }
                case 0: {
                    if (step.test == 0) {
                        ref.add(step.name.toString(), -1);
                        parentsAllowed = true;
                        break;
                    }
                    if (step.test == 1) {
                        ref.add("*", -1);
                        parentsAllowed = true;
                        break;
                    }
                    throw new XPathUnsupportedException("step other than 'child::name', '.', '..'");
                }
                default: {
                    throw new XPathUnsupportedException("step other than 'child::name', '.', '..'");
                }
            }
            if (step.predicates.length <= 0) continue;
            ArrayList<XPathExpression> v = new ArrayList<XPathExpression>(step.predicates.length);
            Collections.addAll(v, step.predicates);
            int level = ref.getRefLevel() > 0 ? i - ref.getRefLevel() : i;
            ref.addPredicate(level, v);
        }
        return ref;
    }

    @Override
    public XPathNodeset eval(DataInstance unusedDataInstance, EvaluationContext ec) {
        return new XPathPathExprEval().eval(this.getReference(), ec);
    }

    public static Object getRefValue(DataInstance model, EvaluationContext ec, TreeReference ref) {
        if (ec.isConstraint && ref.equals(ec.getContextRef())) {
            Object result = XPathPathExpr.unpackValue(ec.candidateValue);
            logger.trace("getRefValue returning candidate value {} for {}", result, (Object)ref);
            return result;
        }
        Object node = model.resolveReference(ref);
        if (node == null) {
            throw new XPathTypeMismatchException("Node " + ref.toString() + " does not exist!");
        }
        IAnswerData maybeNodeValue = node.isRelevant() ? node.getValue() : null;
        Object result = XPathPathExpr.unpackValue(maybeNodeValue);
        if (maybeNodeValue == null) {
            logger.trace("getRefValue returning empty node value for {}", (Object)ref);
        } else {
            logger.trace("getRefValue returning node value {} for {}", result, (Object)ref);
        }
        return result;
    }

    public static Object unpackValue(IAnswerData val) {
        if (val == null) {
            return "";
        }
        if (val instanceof UncastData) {
            return val.getValue();
        }
        if (val instanceof IntegerData) {
            return ((Integer)val.getValue()).doubleValue();
        }
        if (val instanceof LongData) {
            return ((Long)val.getValue()).doubleValue();
        }
        if (val instanceof DecimalData) {
            return val.getValue();
        }
        if (val instanceof StringData) {
            return val.getValue();
        }
        if (val instanceof SelectOneData) {
            return ((Selection)val.getValue()).getValue();
        }
        if (val instanceof MultipleItemsData) {
            return new XFormAnswerDataSerializer().serializeAnswerData(val);
        }
        if (val instanceof DateData) {
            return val.getValue();
        }
        if (val instanceof DateTimeData) {
            return val.getValue();
        }
        if (val instanceof TimeData) {
            return val.getValue();
        }
        if (val instanceof BooleanData) {
            return val.getValue();
        }
        if (val instanceof GeoPointData) {
            return val.getDisplayText();
        }
        if (val instanceof GeoShapeData) {
            return val.getDisplayText();
        }
        if (val instanceof GeoTraceData) {
            return val.getDisplayText();
        }
        logger.warn("unrecognized data type in xpath expr: " + val.getClass().getName());
        return val.getValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{path-expr:");
        switch (this.init_context) {
            case 0: {
                sb.append("abs");
                break;
            }
            case 1: {
                sb.append("rel");
                break;
            }
            case 2: {
                sb.append(this.filtExpr.toString());
            }
        }
        sb.append(",{");
        for (int i = 0; i < this.steps.length; ++i) {
            sb.append(this.steps[i].toString());
            if (i >= this.steps.length - 1) continue;
            sb.append(",");
        }
        sb.append("}}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof XPathPathExpr) {
            XPathPathExpr x = (XPathPathExpr)o;
            if (this.init_context != x.init_context || this.steps.length != x.steps.length) {
                return false;
            }
            return ExtUtil.arrayEquals(this.steps, x.steps) && (this.init_context != 2 || this.filtExpr.equals(x.filtExpr));
        }
        return false;
    }

    public boolean matches(XPathExpression o) {
        if (o instanceof XPathPathExpr) {
            XPathPathExpr x = (XPathPathExpr)o;
            if (this.init_context != x.init_context || this.steps.length != x.steps.length) {
                return false;
            }
            if (this.steps.length != x.steps.length) {
                return false;
            }
            for (int i = 0; i < this.steps.length; ++i) {
                if (this.steps[i].matches(x.steps[i])) continue;
                return false;
            }
            return this.init_context == 2 ? this.filtExpr.equals(x.filtExpr) : true;
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.init_context = ExtUtil.readInt(in);
        if (this.init_context == 2) {
            this.filtExpr = (XPathFilterExpr)ExtUtil.read(in, XPathFilterExpr.class, pf);
        }
        List v = (List)ExtUtil.read(in, new ExtWrapList(XPathStep.class), pf);
        this.steps = new XPathStep[v.size()];
        for (int i = 0; i < this.steps.length; ++i) {
            this.steps[i] = ((XPathStep)v.get(i)).intern();
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.init_context);
        if (this.init_context == 2) {
            ExtUtil.write(out, this.filtExpr);
        }
        List<XPathStep> v = Arrays.asList(this.steps);
        ExtUtil.write(out, new ExtWrapList(v));
    }

    public static XPathPathExpr fromRef(TreeReference ref) {
        XPathPathExpr path = new XPathPathExpr();
        path.init_context = ref.isAbsolute() ? 0 : 1;
        path.steps = new XPathStep[ref.size()];
        for (int i = 0; i < path.steps.length; ++i) {
            path.steps[i] = ref.getName(i).equals("*") ? new XPathStep(0, 1).intern() : new XPathStep(0, new XPathQName(ref.getName(i))).intern();
        }
        return path;
    }

    @Override
    public Object pivot(DataInstance model, EvaluationContext evalContext, List<Object> pivots, Object sentinal) throws UnpivotableExpressionException {
        TreeReference ref = this.getReference();
        if (ref.equals(sentinal) || ref.getRefLevel() == 0) {
            return sentinal;
        }
        for (int i = 0; i < ref.size(); ++i) {
            if (ref.getPredicate(i) == null || ref.getPredicate(i).size() <= 0) continue;
            throw new UnpivotableExpressionException("Can't pivot filtered treereferences. Ref: " + ref.toString(true) + " has predicates.");
        }
        return this.eval(model, evalContext);
    }

    @Override
    public boolean isIdempotent() {
        return (this.filtExpr == null || this.filtExpr.isIdempotent()) && Arrays.stream(this.steps).allMatch(step -> Arrays.stream(step.predicates).allMatch(XPathExpression::isIdempotent));
    }
}

