/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathBinaryOpExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathEqExpr
extends XPathBinaryOpExpr {
    private static final Logger logger = LoggerFactory.getLogger(XPathEqExpr.class.getSimpleName());
    public boolean equal;

    public XPathEqExpr() {
        logger.debug("XPathEqExpr{}()", (Object)this.id());
    }

    public XPathEqExpr(boolean equal, XPathExpression a, XPathExpression b) {
        super(a, b);
        this.equal = equal;
        logger.debug("XPathEqExpr{}({}, {}, {})", this.id(), equal, a, b);
    }

    @Override
    public Object eval(DataInstance model, EvaluationContext evalContext) {
        boolean eq;
        logger.debug("XPathEqExpr{}.eval starting. model: {}, candidate: {}, expecting equal: {}", this.id(), model, evalContext.candidateValue == null ? "None" : evalContext.candidateValue.getDisplayText(), this.equal);
        Object aval = XPathFuncExpr.unpack(this.a.eval(model, evalContext));
        Object bval = XPathFuncExpr.unpack(this.b.eval(model, evalContext));
        if (aval instanceof Boolean || bval instanceof Boolean) {
            boolean a = aval instanceof Boolean ? (Boolean)aval : XPathFuncExpr.toBoolean(aval);
            boolean b = bval instanceof Boolean ? (Boolean)bval : XPathFuncExpr.toBoolean(bval);
            eq = a == b;
        } else if (aval instanceof Double || bval instanceof Double) {
            double a = aval instanceof Double ? (Double)aval : XPathFuncExpr.toNumeric(aval);
            double b = bval instanceof Double ? (Double)bval : XPathFuncExpr.toNumeric(bval);
            eq = Math.abs(a - b) < 1.0E-12;
        } else {
            eq = XPathFuncExpr.toString(aval).equals(XPathFuncExpr.toString(bval));
        }
        boolean result = this.equal == eq;
        logger.debug("XPathEqExpr{}.eval returning {}. a: {}, b: {}", this.id(), result, aval, bval);
        return result;
    }

    @Override
    public boolean isIdempotent() {
        return this.a.isIdempotent() && this.b.isIdempotent();
    }

    public String toString() {
        return super.toString(this.equal ? "==" : "!=");
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof XPathEqExpr && super.equals(o) && this.equal == ((XPathEqExpr)o).equal;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.equal = ExtUtil.readBool(in);
        super.readExternal(in, pf);
        logger.debug("XPathEqExpr{}.readExternal {}, {}, {}", this.id(), this.a, this.b, this.equal);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        logger.debug("XPathEqExpr{}.writeExternal", (Object)this.id());
        ExtUtil.writeBool(out, this.equal);
        super.writeExternal(out);
    }

    public boolean isEqual() {
        return this.equal;
    }

    private String id() {
        return "@" + Integer.toHexString(System.identityHashCode(this));
    }
}

