/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathBinaryOpExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;

public class XPathBoolExpr
extends XPathBinaryOpExpr {
    public static final int AND = 0;
    public static final int OR = 1;
    public int op;

    public XPathBoolExpr() {
    }

    public XPathBoolExpr(int op, XPathExpression a, XPathExpression b) {
        super(a, b);
        this.op = op;
    }

    @Override
    public Object eval(DataInstance model, EvaluationContext evalContext) {
        boolean aval = XPathFuncExpr.toBoolean(this.a.eval(model, evalContext));
        if (!aval && this.op == 0 || aval && this.op == 1) {
            return new Boolean(aval);
        }
        boolean bval = XPathFuncExpr.toBoolean(this.b.eval(model, evalContext));
        boolean result = false;
        switch (this.op) {
            case 0: {
                result = aval && bval;
                break;
            }
            case 1: {
                result = aval || bval;
            }
        }
        return new Boolean(result);
    }

    @Override
    public boolean isIdempotent() {
        return this.a.isIdempotent() && this.b.isIdempotent();
    }

    public String toString() {
        String sOp = null;
        switch (this.op) {
            case 0: {
                sOp = "and";
                break;
            }
            case 1: {
                sOp = "or";
            }
        }
        return super.toString(sOp);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof XPathBoolExpr) {
            XPathBoolExpr x = (XPathBoolExpr)o;
            return super.equals(o) && this.op == x.op;
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.op = ExtUtil.readInt(in);
        super.readExternal(in, pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.op);
        super.writeExternal(out);
    }
}

