/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath;

import java.util.List;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.xform.parse.RandomizeHelper;
import org.javarosa.xpath.XPathTypeMismatchException;
import org.javarosa.xpath.expr.XPathPathExpr;

public class XPathNodeset {
    private List<TreeReference> nodes;
    protected DataInstance instance;
    protected EvaluationContext ec;
    private String pathEvaluated;
    private String originalPath;

    private XPathNodeset() {
    }

    protected XPathNodeset(DataInstance instance, EvaluationContext ec) {
        this.instance = instance;
        this.ec = ec;
    }

    public XPathNodeset(List<TreeReference> nodes, DataInstance instance, EvaluationContext ec) {
        if (nodes == null) {
            throw new NullPointerException("Node list cannot be null when constructing a nodeset");
        }
        this.nodes = nodes;
        this.instance = instance;
        this.ec = ec;
    }

    public static XPathNodeset ConstructInvalidPathNodeset(String pathEvaluated, String originalPath) {
        XPathNodeset nodeset = new XPathNodeset();
        nodeset.nodes = null;
        nodeset.instance = null;
        nodeset.ec = null;
        nodeset.pathEvaluated = pathEvaluated;
        nodeset.originalPath = originalPath;
        return nodeset;
    }

    public static XPathNodeset shuffle(XPathNodeset input) {
        return new XPathNodeset(RandomizeHelper.shuffle(input.nodes), input.instance, input.ec);
    }

    public static XPathNodeset shuffle(XPathNodeset input, long seed) {
        return new XPathNodeset(RandomizeHelper.shuffle(input.nodes, seed), input.instance, input.ec);
    }

    protected void setReferences(List<TreeReference> nodes) {
        this.nodes = nodes;
    }

    public List<TreeReference> getReferences() {
        return this.nodes;
    }

    public Object unpack() {
        if (this.nodes == null) {
            throw this.getInvalidNodesetException();
        }
        if (this.size() == 0) {
            return XPathPathExpr.unpackValue(null);
        }
        if (this.size() > 1) {
            throw new XPathTypeMismatchException("This field is repeated: \n\n" + this.nodeContents() + "\n\nYou may need to use the indexed-repeat() function to specify which value you want.");
        }
        return this.getValAt(0);
    }

    public Object[] toArgList() {
        if (this.nodes == null) {
            throw this.getInvalidNodesetException();
        }
        Object[] args2 = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            Object val = this.getValAt(i);
            if (val == null) {
                throw new RuntimeException("retrived a null value out of a nodeset! shouldn't happen!");
            }
            args2[i] = val;
        }
        return args2;
    }

    public int size() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.size();
    }

    public int getNonEmptySize() {
        if (this.nodes == null) {
            return 0;
        }
        int count = 0;
        for (TreeReference node : this.nodes) {
            Object element = this.ec.getMainInstance().resolveReference(node);
            if (element.getNumChildren() <= 0 && element.getValue() == null) continue;
            ++count;
        }
        return count;
    }

    public TreeReference getRefAt(int i) {
        if (this.nodes == null) {
            throw this.getInvalidNodesetException();
        }
        return this.nodes.get(i);
    }

    public Object getValAt(int i) {
        return XPathPathExpr.getRefValue(this.instance, this.ec, this.getRefAt(i));
    }

    protected XPathTypeMismatchException getInvalidNodesetException() {
        if (!this.pathEvaluated.equals(this.originalPath)) {
            throw new XPathTypeMismatchException("The path " + this.originalPath + " refers to the location " + this.pathEvaluated + " which was not found");
        }
        throw new XPathTypeMismatchException("Location " + this.pathEvaluated + " was not found");
    }

    protected String nodeContents() {
        if (this.nodes == null) {
            return "Invalid Path: " + this.pathEvaluated;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nodes.size(); ++i) {
            sb.append(this.nodes.get(i).toString());
            if (i >= this.nodes.size() - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }
}

