/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.parse;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.javarosa.core.model.RangeQuestion;
import org.javarosa.xform.parse.XFormParseException;
import org.kxml2.kdom.Element;

public class RangeParser {
    static void populateQuestionWithRangeAttributes(RangeQuestion question, Element e) {
        Set<String> rangeAttributeNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("start", "end", "step")));
        block10: for (int i = 0; i < e.getAttributeCount(); ++i) {
            String attrName = e.getAttributeName(i);
            if (!rangeAttributeNames.contains(attrName)) continue;
            String attrStringValue = e.getAttributeValue(i);
            BigDecimal attrDecimalValue = RangeParser.getDecimalValue(attrStringValue);
            if (attrDecimalValue == null) {
                throw new XFormParseException(String.format("Value %s of range attribute %s can't be parsed as a decimal number", attrStringValue, attrName));
            }
            switch (attrName) {
                case "start": {
                    question.setRangeStart(attrDecimalValue);
                    continue block10;
                }
                case "end": {
                    question.setRangeEnd(attrDecimalValue);
                    continue block10;
                }
                case "step": {
                    question.setRangeStep(attrDecimalValue);
                }
            }
        }
    }

    public static BigDecimal getDecimalValue(String s) {
        try {
            return new BigDecimal(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

