/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.parse;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javarosa.xform.parse.FisherYates;

public final class RandomizeHelper {
    private static final Pattern CHOICE_FILTER_PATTERN = Pattern.compile("randomize\\((.+?),?([^,)\\]]+?)?\\)");

    static String cleanNodesetDefinition(String nodesetStr) {
        return RandomizeHelper.getArgs(nodesetStr)[0].trim();
    }

    static String cleanSeedDefinition(String nodesetStr) {
        String[] args2 = RandomizeHelper.getArgs(nodesetStr);
        return args2.length > 1 ? args2[1].trim() : null;
    }

    public static <T> List<T> shuffle(List<T> elements) {
        return FisherYates.shuffle(elements);
    }

    public static <T> List<T> shuffle(List<T> elements, Long seed) {
        return seed == null ? FisherYates.shuffle(elements) : FisherYates.shuffle(elements, seed);
    }

    private static String[] getArgs(String nodesetStr) {
        String[] stringArray;
        if (!(nodesetStr = nodesetStr.trim()).startsWith("randomize(") || !nodesetStr.endsWith(")")) {
            throw new IllegalArgumentException("Nodeset definition must use randomize(path, seed?) function");
        }
        if (!nodesetStr.contains("[")) {
            return nodesetStr.substring(10, nodesetStr.length() - 1).split(",");
        }
        Matcher matcher = CHOICE_FILTER_PATTERN.matcher(nodesetStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Can't parse the Nodeset definition");
        }
        String nodeset = matcher.group(1);
        String seed = matcher.group(2);
        if (seed != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = nodeset;
            stringArray = stringArray2;
            stringArray2[1] = seed;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = nodeset;
        }
        return stringArray;
    }
}

