/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.locale;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javarosa.core.services.locale.LocaleDataSource;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.util.NoLocalizedTextException;
import org.javarosa.core.util.OrderedMap;
import org.javarosa.core.util.StopWatch;
import org.javarosa.core.util.UnregisteredLocaleException;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Localizer
implements Externalizable {
    private static final Logger logger = LoggerFactory.getLogger(Localizer.class);
    private List<String> locales = new ArrayList<String>(0);
    private OrderedMap<String, List<LocaleDataSource>> localeResources = new OrderedMap();
    private OrderedMap<String, String> currentLocaleData = new OrderedMap();
    private String defaultLocale = null;
    private String currentLocale = null;
    private boolean fallbackDefaultLocale;
    private boolean fallbackDefaultForm;
    private List<Localizable> observers = new ArrayList<Localizable>(0);

    public Localizer() {
        this(false, false);
    }

    public Localizer(boolean fallbackDefaultLocale, boolean fallbackDefaultForm) {
        this.fallbackDefaultLocale = fallbackDefaultLocale;
        this.fallbackDefaultForm = fallbackDefaultForm;
    }

    public boolean equals(Object o) {
        if (o instanceof Localizer) {
            Localizer l = (Localizer)o;
            return ExtUtil.equals(this.locales, this.locales) && ExtUtil.equals(this.localeResources, l.localeResources) && ExtUtil.equals(this.defaultLocale, l.defaultLocale) && ExtUtil.equals(this.currentLocale, l.currentLocale) && this.fallbackDefaultLocale == l.fallbackDefaultLocale && this.fallbackDefaultForm == l.fallbackDefaultForm;
        }
        return false;
    }

    public boolean getFallbackLocale() {
        return this.fallbackDefaultLocale;
    }

    public boolean getFallbackForm() {
        return this.fallbackDefaultForm;
    }

    public boolean addAvailableLocale(String locale) {
        if (locale == null) {
            throw new NullPointerException("unexpected null locale");
        }
        if (this.hasLocale(locale)) {
            return false;
        }
        this.locales.add(locale);
        this.localeResources.put(locale, new ArrayList(1));
        return true;
    }

    public String[] getAvailableLocales() {
        String[] data = new String[this.locales.size()];
        return this.locales.toArray(data);
    }

    public boolean hasLocale(String locale) {
        return locale != null && this.locales.contains(locale);
    }

    public String getNextLocale() {
        return this.currentLocale == null ? this.defaultLocale : this.locales.get((this.locales.indexOf(this.currentLocale) + 1) % this.locales.size());
    }

    public String getLocale() {
        return this.currentLocale;
    }

    public void setLocale(String currentLocale) {
        if (!this.hasLocale(currentLocale)) {
            throw new UnregisteredLocaleException("Attempted to set to a locale that is not defined. Attempted Locale: " + currentLocale);
        }
        boolean alert = false;
        if (!currentLocale.equals(this.currentLocale)) {
            this.currentLocale = currentLocale;
            alert = true;
        }
        this.loadCurrentLocaleResources();
        if (alert) {
            this.alertLocalizables();
        }
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        if (defaultLocale != null && !this.hasLocale(defaultLocale)) {
            throw new UnregisteredLocaleException("Attempted to set default to a locale that is not defined");
        }
        this.defaultLocale = defaultLocale;
    }

    public void setToDefault() {
        if (this.defaultLocale == null) {
            throw new IllegalStateException("Attempted to set to default locale when default locale not set");
        }
        this.setLocale(this.defaultLocale);
    }

    private void loadCurrentLocaleResources() {
        this.currentLocaleData = this.getLocaleData(this.currentLocale);
    }

    private void loadTable(OrderedMap<String, String> destination, OrderedMap<String, String> source) {
        for (Map.Entry entry : source.entrySet()) {
            destination.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void registerLocaleResource(String locale, LocaleDataSource resource) {
        if (locale == null) {
            throw new NullPointerException("Attempt to register a data source to a null locale in the localizer");
        }
        if (resource == null) {
            throw new NullPointerException("Attempt to register a null data source in the localizer");
        }
        List resources = this.localeResources.containsKey(locale) ? (List)this.localeResources.get(locale) : new ArrayList(1);
        resources.add(resource);
        this.localeResources.put(locale, resources);
        if (locale.equals(this.currentLocale) || locale.equals(this.defaultLocale)) {
            this.loadCurrentLocaleResources();
        }
    }

    public OrderedMap<String, String> getLocaleData(String locale) {
        StopWatch codeTimer = StopWatch.start();
        if (locale == null || !this.locales.contains(locale)) {
            return null;
        }
        OrderedMap<String, Boolean> defaultLocaleKeys = new OrderedMap<String, Boolean>();
        OrderedMap<String, String> data = new OrderedMap<String, String>();
        if (this.fallbackDefaultLocale && this.defaultLocale != null) {
            for (LocaleDataSource defaultResource : (List)this.localeResources.get(this.defaultLocale)) {
                this.loadTable(data, defaultResource.getLocalizedText());
            }
            for (String key : data.keySet()) {
                defaultLocaleKeys.put(key, Boolean.TRUE);
            }
        }
        for (LocaleDataSource resource : (List)this.localeResources.get(locale)) {
            this.loadTable(data, resource.getLocalizedText());
        }
        if (this.fallbackDefaultLocale && this.defaultLocale != null) {
            StringBuilder missingKeys = new StringBuilder();
            int keysMissing = 0;
            for (String key : data.keySet()) {
                if (defaultLocaleKeys.containsKey(key)) continue;
                missingKeys.append(key).append(",");
                ++keysMissing;
            }
            if (keysMissing > 0) {
                throw new NoLocalizedTextException("Error loading locale " + locale + ". There were " + keysMissing + " keys which were contained in this locale, but were not properly registered in the default Locale. Any keys which are added to a locale should always be added to the default locale to ensure appropriate functioning.\nThe missing translations were for the keys: " + missingKeys, missingKeys.toString(), this.defaultLocale);
            }
        }
        logger.info(codeTimer.logLine("getLocaleData"));
        return data;
    }

    public OrderedMap<String, String> getLocaleMap(String locale) {
        OrderedMap<String, String> mapping = this.getLocaleData(locale);
        if (mapping == null) {
            throw new UnregisteredLocaleException("Attempted to access an undefined locale.");
        }
        return mapping;
    }

    public boolean hasMapping(String locale, String textID) {
        if (locale == null || !this.locales.contains(locale)) {
            throw new UnregisteredLocaleException("Attempted to access an undefined locale (" + locale + ") while checking for a mapping for  " + textID);
        }
        for (LocaleDataSource source : (List)this.localeResources.get(locale)) {
            if (!source.getLocalizedText().containsKey(textID)) continue;
            return true;
        }
        return false;
    }

    public boolean destroyLocale(String locale) {
        if (locale.equals(this.currentLocale)) {
            throw new IllegalArgumentException("Attempted to destroy the current locale");
        }
        boolean removed = this.hasLocale(locale);
        this.locales.remove(locale);
        this.localeResources.remove(locale);
        if (locale.equals(this.defaultLocale)) {
            this.defaultLocale = null;
        }
        return removed;
    }

    public String getText(String textID) {
        return this.getText(textID, this.currentLocale);
    }

    public String getText(String textID, String[] args2) {
        String text = this.getText(textID, this.currentLocale);
        if (text != null) {
            return Localizer.processArguments(text, args2);
        }
        throw this.newNoLocalizedTextException(textID);
    }

    public String getText(String textID, HashMap<String, String> args2) {
        String text = this.getText(textID, this.currentLocale);
        if (text != null) {
            return Localizer.processArguments(text, args2);
        }
        throw this.newNoLocalizedTextException(textID);
    }

    private NoLocalizedTextException newNoLocalizedTextException(String textID) {
        return new NoLocalizedTextException("The Localizer could not find a definition for ID: " + textID + " in the '" + this.currentLocale + "' locale.", textID, this.currentLocale);
    }

    public String getLocalizedText(String textID) {
        String text = this.getText(textID);
        if (text == null) {
            throw this.newNoLocalizedTextException(textID);
        }
        return text;
    }

    public String getText(String textID, String locale) {
        String text = this.getRawText(locale, textID);
        if (text == null && this.fallbackDefaultForm && textID.contains(";")) {
            text = this.getRawText(locale, textID.substring(0, textID.indexOf(";")));
        }
        if (text == null && this.fallbackDefaultLocale && !locale.equals(this.defaultLocale) && this.defaultLocale != null && this.fallbackDefaultForm) {
            text = this.getText(textID, this.defaultLocale);
        }
        return text;
    }

    public String getRawText(String locale, String textID) {
        if (locale == null) {
            throw new UnregisteredLocaleException("Null locale when attempting to fetch text id: " + textID);
        }
        if (textID == null) {
            throw new NullPointerException("Null textId passed to localizer");
        }
        return locale.equals(this.currentLocale) ? (String)this.currentLocaleData.get(textID) : (String)this.getLocaleMap(locale).get(textID);
    }

    public void registerLocalizable(Localizable l) {
        if (!this.observers.contains(l)) {
            this.observers.add(l);
            if (this.currentLocale != null) {
                l.localeChanged(this.currentLocale, this);
            }
        }
    }

    public void unregisterLocalizable(Localizable l) {
        this.observers.remove(l);
    }

    public void unregisterAll() {
        this.observers.clear();
    }

    private void alertLocalizables() {
        for (Localizable observer : this.observers) {
            observer.localeChanged(this.currentLocale, this);
        }
    }

    private static String arg(String in) {
        return "${" + in + "}";
    }

    public static List<String> getArgs(String text) {
        ArrayList<String> args2 = new ArrayList<String>();
        int i = text.indexOf("${");
        while (i != -1) {
            int j = text.indexOf("}", i);
            if (j == -1) {
                logger.warn("unterminated ${...} arg");
                break;
            }
            String arg = text.substring(i + 2, j);
            if (!args2.contains(arg)) {
                args2.add(arg);
            }
            i = text.indexOf("${", j + 1);
        }
        return args2;
    }

    public static String processArguments(String text, HashMap<String, String> args2) {
        int i = text.indexOf("${");
        while (i != -1) {
            int j = text.indexOf("}", i);
            if (j == -1) {
                logger.warn("unterminated ${...} arg");
                break;
            }
            String argName = text.substring(i + 2, j);
            String argVal = args2.get(argName);
            if (argVal != null) {
                text = text.substring(0, i) + argVal + text.substring(j + 1);
                j = i + argVal.length() - 1;
            }
            i = text.indexOf("${", j + 1);
        }
        return text;
    }

    public static String processArguments(String text, String[] args2) {
        return Localizer.processArguments(text, args2, 0);
    }

    public static String processArguments(String text, String[] args2, int currentArg) {
        if (text.contains("${") && args2.length > currentArg) {
            int index = Localizer.extractNextIndex(text, args2);
            if (index == -1) {
                index = currentArg++;
            }
            String value = args2[index];
            String[] replaced = Localizer.replaceFirstValue(text, value);
            return replaced[0] + Localizer.processArguments(replaced[1], args2, currentArg);
        }
        return text;
    }

    public static String clearArguments(String text) {
        List<String> v = Localizer.getArgs(text);
        String[] empty = new String[v.size()];
        for (int i = 0; i < empty.length; ++i) {
            empty[i] = "";
        }
        return Localizer.processArguments(text, empty);
    }

    private static int extractNextIndex(String text, String[] args2) {
        int start = text.indexOf("${");
        int end = text.indexOf("}", start);
        if (start != -1 && end != -1) {
            String val = text.substring(start + "${".length(), end);
            try {
                int index = Integer.parseInt(val);
                if (index >= 0 && index < args2.length) {
                    return index;
                }
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
        return -1;
    }

    private static String[] replaceFirstValue(String text, String value) {
        int start = text.indexOf("${");
        int end = text.indexOf("}", start);
        return new String[]{text.substring(0, start) + value, text.substring(end + 1, text.length())};
    }

    @Override
    public void readExternal(DataInputStream dis, PrototypeFactory pf) throws IOException, DeserializationException {
        this.fallbackDefaultLocale = ExtUtil.readBool(dis);
        this.fallbackDefaultForm = ExtUtil.readBool(dis);
        this.localeResources = (OrderedMap)ExtUtil.read(dis, new ExtWrapMap(String.class, (ExternalizableWrapper)new ExtWrapListPoly(), 1), pf);
        this.locales = (List)ExtUtil.read(dis, new ExtWrapList(String.class));
        this.setDefaultLocale((String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf));
        String currentLocale = (String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf);
        if (currentLocale != null) {
            this.setLocale(currentLocale);
        }
    }

    @Override
    public void writeExternal(DataOutputStream dos) throws IOException {
        ExtUtil.writeBool(dos, this.fallbackDefaultLocale);
        ExtUtil.writeBool(dos, this.fallbackDefaultForm);
        ExtUtil.write(dos, new ExtWrapMap(this.localeResources, (ExternalizableWrapper)new ExtWrapListPoly()));
        ExtUtil.write(dos, new ExtWrapList(this.locales));
        ExtUtil.write(dos, new ExtWrapNullable(this.defaultLocale));
        ExtUtil.write(dos, new ExtWrapNullable(this.currentLocale));
    }
}

