/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance.geojson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class GeojsonGeometry {
    private String type;
    private ArrayList<Object> coordinates;

    public String getOdkCoordinates() throws IOException {
        if (this.type.equals("Point")) {
            return this.coordinates.get(1) + " " + this.coordinates.get(0) + " 0 0";
        }
        if (this.type.equals("LineString")) {
            StringJoiner stringJoiner = new StringJoiner("; ");
            for (Object item : this.coordinates) {
                List point = (List)item;
                stringJoiner.add(point.get(1) + " " + point.get(0) + " 0 0");
            }
            return stringJoiner.toString();
        }
        if (this.type.equals("Polygon")) {
            if (!this.coordinates.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("; ");
                for (Object item : (List)this.coordinates.get(0)) {
                    List point = (List)item;
                    stringJoiner.add(point.get(1) + " " + point.get(0) + " 0 0");
                }
                return stringJoiner.toString();
            }
            return "";
        }
        throw new IOException("Only Points, LineStrings and Polygons are currently supported");
    }
}

