/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance.geojson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.util.Map;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.geojson.GeojsonGeometry;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GeojsonFeature {
    public static final String GEOMETRY_CHILD_NAME = "geometry";
    private String type;
    private GeojsonGeometry geometry;
    private Map<String, String> properties;
    private String id;

    public TreeElement toTreeElement(int multiplicity) throws IOException {
        if (!this.type.equals("Feature")) {
            throw new IOException("Item of type " + this.type + " found but expected item of type Feature");
        }
        TreeElement item = new TreeElement("item", multiplicity);
        TreeElement geoField = new TreeElement(GEOMETRY_CHILD_NAME, 0);
        geoField.setValue(new UncastData(this.geometry.getOdkCoordinates()));
        item.addChild(geoField);
        if (this.properties != null) {
            for (String property : this.properties.keySet()) {
                TreeElement field = new TreeElement(property, 0);
                if (this.properties.get(property) != null) {
                    field.setValue(new UncastData(this.properties.get(property)));
                } else {
                    field.setValue(new UncastData(""));
                }
                item.addChild(field);
            }
        }
        if (this.id != null) {
            if (!item.getChildrenWithName("id").isEmpty()) {
                item.getChildrenWithName("id").get(0).setValue(new UncastData(this.id));
            } else {
                TreeElement field = new TreeElement("id", 0);
                field.setValue(new UncastData(this.id));
                item.addChild(field);
            }
        }
        return item;
    }
}

