/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data.helper;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class BasicDataPointer
implements IDataPointer {
    private byte[] data;
    private String name;

    public BasicDataPointer() {
    }

    public BasicDataPointer(String name, byte[] data) {
        this.name = name;
        this.data = data;
    }

    @Override
    public boolean deleteData() {
        this.data = null;
        return true;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public String getDisplayText() {
        return this.name;
    }

    @Override
    public InputStream getDataStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        int size = in.readInt();
        if (size != -1) {
            this.data = new byte[size];
            in.read(this.data);
        }
        this.name = ExtUtil.readString(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        if (this.data == null || this.data.length < 0) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.data.length);
            out.write(this.data);
        }
        ExtUtil.writeString(out, this.name);
    }

    @Override
    public long getLength() {
        return this.data.length;
    }
}

