/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.jetbrains.annotations.NotNull;

public class LongData
implements IAnswerData {
    private long n;

    public LongData() {
    }

    public LongData(long n) {
        this.n = n;
    }

    public LongData(Long n) {
        this.setValue(n);
    }

    @Override
    public IAnswerData clone() {
        return new LongData(this.n);
    }

    @Override
    public String getDisplayText() {
        return String.valueOf(this.n);
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.n;
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.n = (Long)o;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        this.n = ExtUtil.readNumeric(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.n);
    }

    @Override
    public UncastData uncast() {
        return new UncastData(new Long(this.n).toString());
    }

    @Override
    public LongData cast(UncastData data) throws IllegalArgumentException {
        try {
            return new LongData(Long.parseLong(data.value));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid cast of data [" + data.value + "] to type Long");
        }
    }

    public String toString() {
        return "LongData{n=" + this.n + '}';
    }
}

