/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javarosa.core.model.QuickTriggerable;
import org.javarosa.core.model.condition.Condition;
import org.javarosa.core.model.condition.ConditionAction;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.condition.Recalculate;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.debug.EvaluationResult;
import org.javarosa.xpath.XPathConditional;

public abstract class Triggerable
implements Externalizable {
    protected XPathConditional expr;
    private Set<TreeReference> targets;
    private TreeReference contextRef;
    private TreeReference originalContextRef;
    private Set<QuickTriggerable> immediateCascades = null;

    Triggerable() {
    }

    Triggerable(XPathConditional expr, TreeReference contextRef, TreeReference originalContextRef, Set<TreeReference> targets, Set<QuickTriggerable> immediateCascades) {
        this.expr = expr;
        this.targets = targets;
        this.contextRef = contextRef;
        this.originalContextRef = originalContextRef;
        this.immediateCascades = immediateCascades;
    }

    public static Triggerable condition(XPathConditional expr, ConditionAction trueAction, ConditionAction falseAction, TreeReference contextRef) {
        return new Condition(expr, contextRef, contextRef, new HashSet<TreeReference>(), new HashSet<QuickTriggerable>(), trueAction, falseAction);
    }

    public static Triggerable recalculate(XPathConditional expr, TreeReference contextRef) {
        return new Recalculate(expr, contextRef, contextRef, new HashSet<TreeReference>(), new HashSet<QuickTriggerable>());
    }

    public abstract Object eval(FormInstance var1, EvaluationContext var2);

    protected abstract void apply(TreeReference var1, Object var2, FormInstance var3);

    public abstract boolean canCascade();

    public abstract boolean isCascadingToChildren();

    public Set<TreeReference> getTriggers() {
        return this.expr.getTriggers(this.originalContextRef);
    }

    public final List<EvaluationResult> apply(FormInstance mainInstance, EvaluationContext parentContext, TreeReference context) {
        TreeReference ungenericised = this.originalContextRef.contextualize(context);
        EvaluationContext ec = new EvaluationContext(parentContext, ungenericised);
        Object result = this.eval(mainInstance, ec);
        ArrayList<EvaluationResult> affectedNodes = new ArrayList<EvaluationResult>(0);
        for (TreeReference target : this.targets) {
            TreeReference targetRef = target.contextualize(ec.getContextRef());
            List<TreeReference> v = ec.expandReference(targetRef);
            for (TreeReference affectedRef : v) {
                this.apply(affectedRef, result, mainInstance);
                affectedNodes.add(new EvaluationResult(affectedRef, result));
            }
        }
        return affectedNodes;
    }

    public Set<TreeReference> getTargets() {
        return this.targets;
    }

    public void intersectContextWith(Triggerable other) {
        this.contextRef = this.contextRef.intersect(other.contextRef);
    }

    public TreeReference getContext() {
        return this.contextRef;
    }

    public TreeReference getOriginalContext() {
        return this.originalContextRef;
    }

    public void setImmediateCascades(Set<QuickTriggerable> cascades) {
        this.immediateCascades = new HashSet<QuickTriggerable>(cascades);
    }

    public Set<QuickTriggerable> getImmediateCascades() {
        return this.immediateCascades;
    }

    public IConditionExpr getExpr() {
        return this.expr;
    }

    public void addTarget(TreeReference target) {
        this.targets.add(target);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Triggerable)) {
            return false;
        }
        Triggerable other = (Triggerable)o;
        if (!this.expr.equals(other.expr)) {
            return false;
        }
        if (this.getTriggers().size() != other.getTriggers().size()) {
            return false;
        }
        return this.getTriggers().containsAll(other.getTriggers());
    }

    String buildHumanReadableTargetList() {
        StringBuilder targetsBuilder = new StringBuilder();
        for (TreeReference t : this.getTargets()) {
            targetsBuilder.append(t.toString(true, true)).append(", ");
        }
        String targetsString = targetsBuilder.toString();
        return targetsString.isEmpty() ? "unknown refs (no targets added yet)" : targetsString.substring(0, targetsString.length() - 2);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.expr = (XPathConditional)ExtUtil.read(in, new ExtWrapTagged(), pf);
        this.contextRef = (TreeReference)ExtUtil.read(in, TreeReference.class, pf);
        this.originalContextRef = (TreeReference)ExtUtil.read(in, TreeReference.class, pf);
        this.targets = new HashSet<TreeReference>((List)ExtUtil.read(in, new ExtWrapList(TreeReference.class), pf));
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapTagged(this.expr));
        ExtUtil.write(out, this.contextRef);
        ExtUtil.write(out, this.originalContextRef);
        ExtUtil.write(out, new ExtWrapList(new ArrayList<TreeReference>(this.targets)));
    }
}

