/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Pair;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xform.parse.XFormParseException;
import org.jetbrains.annotations.Nullable;

public class SelectChoice
implements Externalizable,
Localizable {
    private String value;
    private String labelInnerText;
    private String textID;
    private boolean isLocalizable;
    private int index = -1;
    @Deprecated
    public TreeElement copyNode;
    private TreeElement item;
    private String labelRefName;

    public SelectChoice() {
    }

    public SelectChoice(String labelID, String value) {
        this(labelID, null, value, true, null, null);
    }

    public SelectChoice(String labelID, String labelInnerText, boolean isLocalizable) {
        this(labelID, labelInnerText, isLocalizable, null, null);
    }

    public SelectChoice(String labelID, String labelInnerText, String value, boolean isLocalizable) {
        this(labelID, labelInnerText, value, isLocalizable, null, null);
    }

    public SelectChoice(String labelOrID, String Value2, boolean isLocalizable, TreeElement item, String labelRefName) {
        this(isLocalizable ? labelOrID : null, isLocalizable ? null : labelOrID, Value2, isLocalizable, item, labelRefName);
    }

    private SelectChoice(String labelID, String labelInnerText, String value, boolean isLocalizable, TreeElement item, String labelRefName) {
        if (value == null) {
            throw new XFormParseException("SelectChoice{id,innerText}:{" + labelID + "," + labelInnerText + "}, has null Value!");
        }
        this.value = value;
        this.isLocalizable = isLocalizable;
        this.textID = labelID;
        this.labelInnerText = labelInnerText;
        this.item = item;
        this.labelRefName = labelRefName;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getLabelInnerText() {
        return this.labelInnerText;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getChild(String childName) {
        if (this.item == null) {
            return null;
        }
        TreeElement child = this.item.getChild(childName, 0);
        if (child != null) {
            IAnswerData childValue = child.getValue();
            if (childValue == null) {
                return "";
            }
            return childValue.getDisplayText();
        }
        return null;
    }

    public List<Pair<String, String>> getAdditionalChildren() {
        if (this.item == null) {
            return new ArrayList<Pair<String, String>>();
        }
        ArrayList<Pair<String, String>> children = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < this.item.getNumChildren(); ++i) {
            TreeElement child = this.item.getChildAt(i);
            if (child.getRef().getNameLast().equals(this.labelRefName)) continue;
            children.add(new Pair<String, String>(child.getName(), child.getValue().getDisplayText()));
        }
        return children;
    }

    public int getIndex() {
        if (this.index == -1) {
            throw new RuntimeException("trying to access choice index before it has been set!");
        }
        return this.index;
    }

    @Override
    public void localeChanged(String locale, Localizer localizer) {
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.isLocalizable = ExtUtil.readBool(in);
        this.setLabelInnerText(ExtUtil.nullIfEmpty(ExtUtil.readString(in)));
        this.setTextID(ExtUtil.nullIfEmpty(ExtUtil.readString(in)));
        this.value = ExtUtil.readString(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeBool(out, this.isLocalizable);
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.labelInnerText));
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.textID));
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.value));
    }

    private void setLabelInnerText(String labelInnerText) {
        this.labelInnerText = labelInnerText;
    }

    public Selection selection() {
        return new Selection(this);
    }

    public boolean isLocalizable() {
        return this.isLocalizable;
    }

    public void setLocalizable(boolean localizable) {
        this.isLocalizable = localizable;
    }

    public String toString() {
        return (this.textID != null && this.textID.length() > 0 ? "{" + this.textID + "}" : "") + (this.labelInnerText != null ? this.labelInnerText : "") + " => " + this.value;
    }

    public String getTextID() {
        return this.textID;
    }

    public void setTextID(String textID) {
        this.textID = textID;
    }
}

